/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.ResourceShareArnListCopier;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceShareInvitationsRequest
extends RamRequest
implements ToCopyableBuilder<Builder, GetResourceShareInvitationsRequest> {
    private static final SdkField<List<String>> RESOURCE_SHARE_INVITATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceShareInvitationArns").getter(GetResourceShareInvitationsRequest.getter(GetResourceShareInvitationsRequest::resourceShareInvitationArns)).setter(GetResourceShareInvitationsRequest.setter(Builder::resourceShareInvitationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareInvitationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_SHARE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceShareArns").getter(GetResourceShareInvitationsRequest.getter(GetResourceShareInvitationsRequest::resourceShareArns)).setter(GetResourceShareInvitationsRequest.setter(Builder::resourceShareArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetResourceShareInvitationsRequest.getter(GetResourceShareInvitationsRequest::nextToken)).setter(GetResourceShareInvitationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetResourceShareInvitationsRequest.getter(GetResourceShareInvitationsRequest::maxResults)).setter(GetResourceShareInvitationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_INVITATION_ARNS_FIELD, RESOURCE_SHARE_ARNS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> resourceShareInvitationArns;
    private final List<String> resourceShareArns;
    private final String nextToken;
    private final Integer maxResults;

    private GetResourceShareInvitationsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareInvitationArns = builder.resourceShareInvitationArns;
        this.resourceShareArns = builder.resourceShareArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasResourceShareInvitationArns() {
        return this.resourceShareInvitationArns != null && !(this.resourceShareInvitationArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceShareInvitationArns() {
        return this.resourceShareInvitationArns;
    }

    public final boolean hasResourceShareArns() {
        return this.resourceShareArns != null && !(this.resourceShareArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceShareArns() {
        return this.resourceShareArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceShareInvitationArns() ? this.resourceShareInvitationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceShareArns() ? this.resourceShareArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceShareInvitationsRequest)) {
            return false;
        }
        GetResourceShareInvitationsRequest other = (GetResourceShareInvitationsRequest)((Object)obj);
        return this.hasResourceShareInvitationArns() == other.hasResourceShareInvitationArns() && Objects.equals(this.resourceShareInvitationArns(), other.resourceShareInvitationArns()) && this.hasResourceShareArns() == other.hasResourceShareArns() && Objects.equals(this.resourceShareArns(), other.resourceShareArns()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceShareInvitationsRequest").add("ResourceShareInvitationArns", this.hasResourceShareInvitationArns() ? this.resourceShareInvitationArns() : null).add("ResourceShareArns", this.hasResourceShareArns() ? this.resourceShareArns() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareInvitationArns": {
                return Optional.ofNullable(clazz.cast(this.resourceShareInvitationArns()));
            }
            case "resourceShareArns": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceShareInvitationsRequest, T> g) {
        return obj -> g.apply((GetResourceShareInvitationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private List<String> resourceShareInvitationArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceShareArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceShareInvitationsRequest model) {
            super(model);
            this.resourceShareInvitationArns(model.resourceShareInvitationArns);
            this.resourceShareArns(model.resourceShareArns);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getResourceShareInvitationArns() {
            if (this.resourceShareInvitationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceShareInvitationArns;
        }

        public final void setResourceShareInvitationArns(Collection<String> resourceShareInvitationArns) {
            this.resourceShareInvitationArns = ResourceShareInvitationArnListCopier.copy(resourceShareInvitationArns);
        }

        @Override
        @Transient
        public final Builder resourceShareInvitationArns(Collection<String> resourceShareInvitationArns) {
            this.resourceShareInvitationArns = ResourceShareInvitationArnListCopier.copy(resourceShareInvitationArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceShareInvitationArns(String ... resourceShareInvitationArns) {
            this.resourceShareInvitationArns(Arrays.asList(resourceShareInvitationArns));
            return this;
        }

        public final Collection<String> getResourceShareArns() {
            if (this.resourceShareArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceShareArns;
        }

        public final void setResourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
        }

        @Override
        @Transient
        public final Builder resourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceShareArns(String ... resourceShareArns) {
            this.resourceShareArns(Arrays.asList(resourceShareArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceShareInvitationsRequest build() {
            return new GetResourceShareInvitationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceShareInvitationsRequest> {
        public Builder resourceShareInvitationArns(Collection<String> var1);

        public Builder resourceShareInvitationArns(String ... var1);

        public Builder resourceShareArns(Collection<String> var1);

        public Builder resourceShareArns(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

