/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.Principal;
import software.amazon.awssdk.services.ram.model.PrincipalListCopier;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPrincipalsResponse
extends RamResponse
implements ToCopyableBuilder<Builder, ListPrincipalsResponse> {
    private static final SdkField<List<Principal>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("principals").getter(ListPrincipalsResponse.getter(ListPrincipalsResponse::principals)).setter(ListPrincipalsResponse.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Principal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPrincipalsResponse.getter(ListPrincipalsResponse::nextToken)).setter(ListPrincipalsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPALS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Principal> principals;
    private final String nextToken;

    private ListPrincipalsResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public final List<Principal> principals() {
        return this.principals;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipals() ? this.principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalsResponse)) {
            return false;
        }
        ListPrincipalsResponse other = (ListPrincipalsResponse)((Object)obj);
        return this.hasPrincipals() == other.hasPrincipals() && Objects.equals(this.principals(), other.principals()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPrincipalsResponse").add("Principals", this.hasPrincipals() ? this.principals() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPrincipalsResponse, T> g) {
        return obj -> g.apply((ListPrincipalsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private List<Principal> principals = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalsResponse model) {
            super(model);
            this.principals(model.principals);
            this.nextToken(model.nextToken);
        }

        public final List<Principal.Builder> getPrincipals() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.principals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipals(Collection<Principal.BuilderImpl> principals) {
            this.principals = PrincipalListCopier.copyFromBuilder(principals);
        }

        @Override
        @Transient
        public final Builder principals(Collection<Principal> principals) {
            this.principals = PrincipalListCopier.copy(principals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder principals(Principal ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder principals(Consumer<Principal.Builder> ... principals) {
            this.principals(Stream.of(principals).map(c -> (Principal)((Principal.Builder)Principal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPrincipalsResponse build() {
            return new ListPrincipalsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPrincipalsResponse> {
        public Builder principals(Collection<Principal> var1);

        public Builder principals(Principal ... var1);

        public Builder principals(Consumer<Principal.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

