/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceSharesRequest extends RamRequest implements
        ToCopyableBuilder<GetResourceSharesRequest.Builder, GetResourceSharesRequest> {
    private static final SdkField<List<String>> RESOURCE_SHARE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceShareArns")
            .getter(getter(GetResourceSharesRequest::resourceShareArns))
            .setter(setter(Builder::resourceShareArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_SHARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceShareStatus").getter(getter(GetResourceSharesRequest::resourceShareStatusAsString))
            .setter(setter(Builder::resourceShareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareStatus").build())
            .build();

    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOwner").getter(getter(GetResourceSharesRequest::resourceOwnerAsString))
            .setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetResourceSharesRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<TagFilter>> TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .memberName("tagFilters")
            .getter(getter(GetResourceSharesRequest::tagFilters))
            .setter(setter(Builder::tagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetResourceSharesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetResourceSharesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> PERMISSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionArn").getter(getter(GetResourceSharesRequest::permissionArn))
            .setter(setter(Builder::permissionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARNS_FIELD,
            RESOURCE_SHARE_STATUS_FIELD, RESOURCE_OWNER_FIELD, NAME_FIELD, TAG_FILTERS_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, PERMISSION_ARN_FIELD));

    private final List<String> resourceShareArns;

    private final String resourceShareStatus;

    private final String resourceOwner;

    private final String name;

    private final List<TagFilter> tagFilters;

    private final String nextToken;

    private final Integer maxResults;

    private final String permissionArn;

    private GetResourceSharesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArns = builder.resourceShareArns;
        this.resourceShareStatus = builder.resourceShareStatus;
        this.resourceOwner = builder.resourceOwner;
        this.name = builder.name;
        this.tagFilters = builder.tagFilters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.permissionArn = builder.permissionArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceShareArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceShareArns() {
        return resourceShareArns != null && !(resourceShareArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Names (ARNs)</a> of individual resource shares that you want information about.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceShareArns} method.
     * </p>
     * 
     * @return Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Names (ARNs)</a> of individual resource shares that you want information about.
     */
    public final List<String> resourceShareArns() {
        return resourceShareArns;
    }

    /**
     * <p>
     * Specifies that you want to retrieve details of only those resource shares that have this status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceShareStatus} will return {@link ResourceShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceShareStatusAsString}.
     * </p>
     * 
     * @return Specifies that you want to retrieve details of only those resource shares that have this status.
     * @see ResourceShareStatus
     */
    public final ResourceShareStatus resourceShareStatus() {
        return ResourceShareStatus.fromValue(resourceShareStatus);
    }

    /**
     * <p>
     * Specifies that you want to retrieve details of only those resource shares that have this status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceShareStatus} will return {@link ResourceShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceShareStatusAsString}.
     * </p>
     * 
     * @return Specifies that you want to retrieve details of only those resource shares that have this status.
     * @see ResourceShareStatus
     */
    public final String resourceShareStatusAsString() {
        return resourceShareStatus;
    }

    /**
     * <p>
     * Specifies that you want to retrieve details of only those resource shares that match the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>SELF</code> </b> – resource shares that your account shares with other accounts
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>OTHER-ACCOUNTS</code> </b> – resource shares that other accounts share with your account
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return Specifies that you want to retrieve details of only those resource shares that match the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>SELF</code> </b> – resource shares that your account shares with other accounts
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>OTHER-ACCOUNTS</code> </b> – resource shares that other accounts share with your account
     *         </p>
     *         </li>
     * @see ResourceOwner
     */
    public final ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(resourceOwner);
    }

    /**
     * <p>
     * Specifies that you want to retrieve details of only those resource shares that match the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>SELF</code> </b> – resource shares that your account shares with other accounts
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>OTHER-ACCOUNTS</code> </b> – resource shares that other accounts share with your account
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return Specifies that you want to retrieve details of only those resource shares that match the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>SELF</code> </b> – resource shares that your account shares with other accounts
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>OTHER-ACCOUNTS</code> </b> – resource shares that other accounts share with your account
     *         </p>
     *         </li>
     * @see ResourceOwner
     */
    public final String resourceOwnerAsString() {
        return resourceOwner;
    }

    /**
     * <p>
     * Specifies the name of an individual resource share that you want to retrieve details about.
     * </p>
     * 
     * @return Specifies the name of an individual resource share that you want to retrieve details about.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagFilters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagFilters() {
        return tagFilters != null && !(tagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies that you want to retrieve details of only those resource shares that match the specified tag keys and
     * values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagFilters} method.
     * </p>
     * 
     * @return Specifies that you want to retrieve details of only those resource shares that match the specified tag
     *         keys and values.
     */
    public final List<TagFilter> tagFilters() {
        return tagFilters;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>NextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the total number of results that you want included on each page of the response. If you do not include
     * this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the
     * number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the
     * specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next
     * part of the results. Note that the service might return fewer results than the maximum even when there are more
     * results available. You should check <code>NextToken</code> after every operation to ensure that you receive all
     * of the results.
     * </p>
     * 
     * @return Specifies the total number of results that you want included on each page of the response. If you do not
     *         include this parameter, it defaults to a value that is specific to the operation. If additional items
     *         exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value
     *         (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call
     *         to the operation to get the next part of the results. Note that the service might return fewer results
     *         than the maximum even when there are more results available. You should check <code>NextToken</code>
     *         after every operation to ensure that you receive all of the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies that you want to retrieve details of only those resource shares that use the RAM permission with this
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name
     * (ARN)</a>.
     * </p>
     * 
     * @return Specifies that you want to retrieve details of only those resource shares that use the RAM permission
     *         with this <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resoure Name (ARN)</a>.
     */
    public final String permissionArn() {
        return permissionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceShareArns() ? resourceShareArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagFilters() ? tagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(permissionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSharesRequest)) {
            return false;
        }
        GetResourceSharesRequest other = (GetResourceSharesRequest) obj;
        return hasResourceShareArns() == other.hasResourceShareArns()
                && Objects.equals(resourceShareArns(), other.resourceShareArns())
                && Objects.equals(resourceShareStatusAsString(), other.resourceShareStatusAsString())
                && Objects.equals(resourceOwnerAsString(), other.resourceOwnerAsString()) && Objects.equals(name(), other.name())
                && hasTagFilters() == other.hasTagFilters() && Objects.equals(tagFilters(), other.tagFilters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(permissionArn(), other.permissionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceSharesRequest")
                .add("ResourceShareArns", hasResourceShareArns() ? resourceShareArns() : null)
                .add("ResourceShareStatus", resourceShareStatusAsString()).add("ResourceOwner", resourceOwnerAsString())
                .add("Name", name()).add("TagFilters", hasTagFilters() ? tagFilters() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("PermissionArn", permissionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareArns":
            return Optional.ofNullable(clazz.cast(resourceShareArns()));
        case "resourceShareStatus":
            return Optional.ofNullable(clazz.cast(resourceShareStatusAsString()));
        case "resourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwnerAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tagFilters":
            return Optional.ofNullable(clazz.cast(tagFilters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "permissionArn":
            return Optional.ofNullable(clazz.cast(permissionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSharesRequest, T> g) {
        return obj -> g.apply((GetResourceSharesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceSharesRequest> {
        /**
         * <p>
         * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Names (ARNs)</a> of individual resource shares that you want information about.
         * </p>
         * 
         * @param resourceShareArns
         *        Specifies the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> of individual resource shares that you want information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArns(Collection<String> resourceShareArns);

        /**
         * <p>
         * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Names (ARNs)</a> of individual resource shares that you want information about.
         * </p>
         * 
         * @param resourceShareArns
         *        Specifies the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> of individual resource shares that you want information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArns(String... resourceShareArns);

        /**
         * <p>
         * Specifies that you want to retrieve details of only those resource shares that have this status.
         * </p>
         * 
         * @param resourceShareStatus
         *        Specifies that you want to retrieve details of only those resource shares that have this status.
         * @see ResourceShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareStatus
         */
        Builder resourceShareStatus(String resourceShareStatus);

        /**
         * <p>
         * Specifies that you want to retrieve details of only those resource shares that have this status.
         * </p>
         * 
         * @param resourceShareStatus
         *        Specifies that you want to retrieve details of only those resource shares that have this status.
         * @see ResourceShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareStatus
         */
        Builder resourceShareStatus(ResourceShareStatus resourceShareStatus);

        /**
         * <p>
         * Specifies that you want to retrieve details of only those resource shares that match the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>SELF</code> </b> – resource shares that your account shares with other accounts
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>OTHER-ACCOUNTS</code> </b> – resource shares that other accounts share with your account
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceOwner
         *        Specifies that you want to retrieve details of only those resource shares that match the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>SELF</code> </b> – resource shares that your account shares with other accounts
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>OTHER-ACCOUNTS</code> </b> – resource shares that other accounts share with your account
         *        </p>
         *        </li>
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(String resourceOwner);

        /**
         * <p>
         * Specifies that you want to retrieve details of only those resource shares that match the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>SELF</code> </b> – resource shares that your account shares with other accounts
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>OTHER-ACCOUNTS</code> </b> – resource shares that other accounts share with your account
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceOwner
         *        Specifies that you want to retrieve details of only those resource shares that match the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>SELF</code> </b> – resource shares that your account shares with other accounts
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>OTHER-ACCOUNTS</code> </b> – resource shares that other accounts share with your account
         *        </p>
         *        </li>
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(ResourceOwner resourceOwner);

        /**
         * <p>
         * Specifies the name of an individual resource share that you want to retrieve details about.
         * </p>
         * 
         * @param name
         *        Specifies the name of an individual resource share that you want to retrieve details about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies that you want to retrieve details of only those resource shares that match the specified tag keys
         * and values.
         * </p>
         * 
         * @param tagFilters
         *        Specifies that you want to retrieve details of only those resource shares that match the specified tag
         *        keys and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(Collection<TagFilter> tagFilters);

        /**
         * <p>
         * Specifies that you want to retrieve details of only those resource shares that match the specified tag keys
         * and values.
         * </p>
         * 
         * @param tagFilters
         *        Specifies that you want to retrieve details of only those resource shares that match the specified tag
         *        keys and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(TagFilter... tagFilters);

        /**
         * <p>
         * Specifies that you want to retrieve details of only those resource shares that match the specified tag keys
         * and values.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TagFilter>.Builder} avoiding the
         * need to create one manually via {@link List<TagFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #tagFilters(List<TagFilter>)}.
         * 
         * @param tagFilters
         *        a consumer that will call methods on {@link List<TagFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilters(List<TagFilter>)
         */
        Builder tagFilters(Consumer<TagFilter.Builder>... tagFilters);

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the total number of results that you want included on each page of the response. If you do not
         * include this parameter, it defaults to a value that is specific to the operation. If additional items exist
         * beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
         * null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the
         * operation to get the next part of the results. Note that the service might return fewer results than the
         * maximum even when there are more results available. You should check <code>NextToken</code> after every
         * operation to ensure that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        Specifies the total number of results that you want included on each page of the response. If you do
         *        not include this parameter, it defaults to a value that is specific to the operation. If additional
         *        items exist beyond the number you specify, the <code>NextToken</code> response element is returned
         *        with a value (not null). Include the specified value as the <code>NextToken</code> request parameter
         *        in the next call to the operation to get the next part of the results. Note that the service might
         *        return fewer results than the maximum even when there are more results available. You should check
         *        <code>NextToken</code> after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies that you want to retrieve details of only those resource shares that use the RAM permission with
         * this <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name
         * (ARN)</a>.
         * </p>
         * 
         * @param permissionArn
         *        Specifies that you want to retrieve details of only those resource shares that use the RAM permission
         *        with this <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resoure Name (ARN)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionArn(String permissionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private List<String> resourceShareArns = DefaultSdkAutoConstructList.getInstance();

        private String resourceShareStatus;

        private String resourceOwner;

        private String name;

        private List<TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private String permissionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSharesRequest model) {
            super(model);
            resourceShareArns(model.resourceShareArns);
            resourceShareStatus(model.resourceShareStatus);
            resourceOwner(model.resourceOwner);
            name(model.name);
            tagFilters(model.tagFilters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            permissionArn(model.permissionArn);
        }

        public final Collection<String> getResourceShareArns() {
            if (resourceShareArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceShareArns;
        }

        public final void setResourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
        }

        @Override
        public final Builder resourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareArns(String... resourceShareArns) {
            resourceShareArns(Arrays.asList(resourceShareArns));
            return this;
        }

        public final String getResourceShareStatus() {
            return resourceShareStatus;
        }

        public final void setResourceShareStatus(String resourceShareStatus) {
            this.resourceShareStatus = resourceShareStatus;
        }

        @Override
        public final Builder resourceShareStatus(String resourceShareStatus) {
            this.resourceShareStatus = resourceShareStatus;
            return this;
        }

        @Override
        public final Builder resourceShareStatus(ResourceShareStatus resourceShareStatus) {
            this.resourceShareStatus(resourceShareStatus == null ? null : resourceShareStatus.toString());
            return this;
        }

        public final String getResourceOwner() {
            return resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<TagFilter.Builder> getTagFilters() {
            List<TagFilter.Builder> result = TagFiltersCopier.copyToBuilder(this.tagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagFilters(Collection<TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = TagFiltersCopier.copyFromBuilder(tagFilters);
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFiltersCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter... tagFilters) {
            tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<TagFilter.Builder>... tagFilters) {
            tagFilters(Stream.of(tagFilters).map(c -> TagFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getPermissionArn() {
            return permissionArn;
        }

        public final void setPermissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
        }

        @Override
        public final Builder permissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceSharesRequest build() {
            return new GetResourceSharesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
