/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptResourceShareInvitationResponse extends RamResponse implements
        ToCopyableBuilder<AcceptResourceShareInvitationResponse.Builder, AcceptResourceShareInvitationResponse> {
    private static final SdkField<ResourceShareInvitation> RESOURCE_SHARE_INVITATION_FIELD = SdkField
            .<ResourceShareInvitation> builder(MarshallingType.SDK_POJO).memberName("resourceShareInvitation")
            .getter(getter(AcceptResourceShareInvitationResponse::resourceShareInvitation))
            .setter(setter(Builder::resourceShareInvitation)).constructor(ResourceShareInvitation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareInvitation").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(AcceptResourceShareInvitationResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_SHARE_INVITATION_FIELD, CLIENT_TOKEN_FIELD));

    private final ResourceShareInvitation resourceShareInvitation;

    private final String clientToken;

    private AcceptResourceShareInvitationResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShareInvitation = builder.resourceShareInvitation;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the invitation.
     * </p>
     * 
     * @return Information about the invitation.
     */
    public final ResourceShareInvitation resourceShareInvitation() {
        return resourceShareInvitation;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareInvitation());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptResourceShareInvitationResponse)) {
            return false;
        }
        AcceptResourceShareInvitationResponse other = (AcceptResourceShareInvitationResponse) obj;
        return Objects.equals(resourceShareInvitation(), other.resourceShareInvitation())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptResourceShareInvitationResponse")
                .add("ResourceShareInvitation", resourceShareInvitation()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareInvitation":
            return Optional.ofNullable(clazz.cast(resourceShareInvitation()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptResourceShareInvitationResponse, T> g) {
        return obj -> g.apply((AcceptResourceShareInvitationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptResourceShareInvitationResponse> {
        /**
         * <p>
         * Information about the invitation.
         * </p>
         * 
         * @param resourceShareInvitation
         *        Information about the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareInvitation(ResourceShareInvitation resourceShareInvitation);

        /**
         * <p>
         * Information about the invitation.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceShareInvitation.Builder} avoiding the
         * need to create one manually via {@link ResourceShareInvitation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceShareInvitation.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceShareInvitation(ResourceShareInvitation)}.
         * 
         * @param resourceShareInvitation
         *        a consumer that will call methods on {@link ResourceShareInvitation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceShareInvitation(ResourceShareInvitation)
         */
        default Builder resourceShareInvitation(Consumer<ResourceShareInvitation.Builder> resourceShareInvitation) {
            return resourceShareInvitation(ResourceShareInvitation.builder().applyMutation(resourceShareInvitation).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private ResourceShareInvitation resourceShareInvitation;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptResourceShareInvitationResponse model) {
            super(model);
            resourceShareInvitation(model.resourceShareInvitation);
            clientToken(model.clientToken);
        }

        public final ResourceShareInvitation.Builder getResourceShareInvitation() {
            return resourceShareInvitation != null ? resourceShareInvitation.toBuilder() : null;
        }

        public final void setResourceShareInvitation(ResourceShareInvitation.BuilderImpl resourceShareInvitation) {
            this.resourceShareInvitation = resourceShareInvitation != null ? resourceShareInvitation.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceShareInvitation(ResourceShareInvitation resourceShareInvitation) {
            this.resourceShareInvitation = resourceShareInvitation;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public AcceptResourceShareInvitationResponse build() {
            return new AcceptResourceShareInvitationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
