/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceTypesResponse extends RamResponse implements
        ToCopyableBuilder<ListResourceTypesResponse.Builder, ListResourceTypesResponse> {
    private static final SdkField<List<ServiceNameAndResourceType>> RESOURCE_TYPES_FIELD = SdkField
            .<List<ServiceNameAndResourceType>> builder(MarshallingType.LIST)
            .memberName("resourceTypes")
            .getter(getter(ListResourceTypesResponse::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceNameAndResourceType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceNameAndResourceType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListResourceTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ServiceNameAndResourceType> resourceTypes;

    private final String nextToken;

    private ListResourceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTypes = builder.resourceTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The shareable resource types supported by AWS RAM.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The shareable resource types supported by AWS RAM.
     */
    public final List<ServiceNameAndResourceType> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceTypesResponse)) {
            return false;
        }
        ListResourceTypesResponse other = (ListResourceTypesResponse) obj;
        return hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceTypesResponse").add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceTypesResponse, T> g) {
        return obj -> g.apply((ListResourceTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListResourceTypesResponse> {
        /**
         * <p>
         * The shareable resource types supported by AWS RAM.
         * </p>
         * 
         * @param resourceTypes
         *        The shareable resource types supported by AWS RAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ServiceNameAndResourceType> resourceTypes);

        /**
         * <p>
         * The shareable resource types supported by AWS RAM.
         * </p>
         * 
         * @param resourceTypes
         *        The shareable resource types supported by AWS RAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ServiceNameAndResourceType... resourceTypes);

        /**
         * <p>
         * The shareable resource types supported by AWS RAM.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceNameAndResourceType>.Builder}
         * avoiding the need to create one manually via {@link List<ServiceNameAndResourceType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceNameAndResourceType>.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceTypes(List<ServiceNameAndResourceType>)}.
         * 
         * @param resourceTypes
         *        a consumer that will call methods on {@link List<ServiceNameAndResourceType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTypes(List<ServiceNameAndResourceType>)
         */
        Builder resourceTypes(Consumer<ServiceNameAndResourceType.Builder>... resourceTypes);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private List<ServiceNameAndResourceType> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceTypesResponse model) {
            super(model);
            resourceTypes(model.resourceTypes);
            nextToken(model.nextToken);
        }

        public final List<ServiceNameAndResourceType.Builder> getResourceTypes() {
            List<ServiceNameAndResourceType.Builder> result = ServiceNameAndResourceTypeListCopier
                    .copyToBuilder(this.resourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTypes(Collection<ServiceNameAndResourceType.BuilderImpl> resourceTypes) {
            this.resourceTypes = ServiceNameAndResourceTypeListCopier.copyFromBuilder(resourceTypes);
        }

        @Override
        @Transient
        public final Builder resourceTypes(Collection<ServiceNameAndResourceType> resourceTypes) {
            this.resourceTypes = ServiceNameAndResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceTypes(ServiceNameAndResourceType... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceTypes(Consumer<ServiceNameAndResourceType.Builder>... resourceTypes) {
            resourceTypes(Stream.of(resourceTypes).map(c -> ServiceNameAndResourceType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceTypesResponse build() {
            return new ListResourceTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
