/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an invitation to join a resource share.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceShareInvitation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceShareInvitation.Builder, ResourceShareInvitation> {
    private static final SdkField<String> RESOURCE_SHARE_INVITATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceShareInvitationArn")
            .getter(getter(ResourceShareInvitation::resourceShareInvitationArn))
            .setter(setter(Builder::resourceShareInvitationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareInvitationArn").build())
            .build();

    private static final SdkField<String> RESOURCE_SHARE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceShareName").getter(getter(ResourceShareInvitation::resourceShareName))
            .setter(setter(Builder::resourceShareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareName").build()).build();

    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceShareArn").getter(getter(ResourceShareInvitation::resourceShareArn))
            .setter(setter(Builder::resourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()).build();

    private static final SdkField<String> SENDER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("senderAccountId").getter(getter(ResourceShareInvitation::senderAccountId))
            .setter(setter(Builder::senderAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderAccountId").build()).build();

    private static final SdkField<String> RECEIVER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("receiverAccountId").getter(getter(ResourceShareInvitation::receiverAccountId))
            .setter(setter(Builder::receiverAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverAccountId").build()).build();

    private static final SdkField<Instant> INVITATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("invitationTimestamp").getter(getter(ResourceShareInvitation::invitationTimestamp))
            .setter(setter(Builder::invitationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitationTimestamp").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ResourceShareInvitation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<ResourceShareAssociation>> RESOURCE_SHARE_ASSOCIATIONS_FIELD = SdkField
            .<List<ResourceShareAssociation>> builder(MarshallingType.LIST)
            .memberName("resourceShareAssociations")
            .getter(getter(ResourceShareInvitation::resourceShareAssociations))
            .setter(setter(Builder::resourceShareAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceShareAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceShareAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECEIVER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("receiverArn").getter(getter(ResourceShareInvitation::receiverArn)).setter(setter(Builder::receiverArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_SHARE_INVITATION_ARN_FIELD, RESOURCE_SHARE_NAME_FIELD, RESOURCE_SHARE_ARN_FIELD, SENDER_ACCOUNT_ID_FIELD,
            RECEIVER_ACCOUNT_ID_FIELD, INVITATION_TIMESTAMP_FIELD, STATUS_FIELD, RESOURCE_SHARE_ASSOCIATIONS_FIELD,
            RECEIVER_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceShareInvitationArn;

    private final String resourceShareName;

    private final String resourceShareArn;

    private final String senderAccountId;

    private final String receiverAccountId;

    private final Instant invitationTimestamp;

    private final String status;

    private final List<ResourceShareAssociation> resourceShareAssociations;

    private final String receiverArn;

    private ResourceShareInvitation(BuilderImpl builder) {
        this.resourceShareInvitationArn = builder.resourceShareInvitationArn;
        this.resourceShareName = builder.resourceShareName;
        this.resourceShareArn = builder.resourceShareArn;
        this.senderAccountId = builder.senderAccountId;
        this.receiverAccountId = builder.receiverAccountId;
        this.invitationTimestamp = builder.invitationTimestamp;
        this.status = builder.status;
        this.resourceShareAssociations = builder.resourceShareAssociations;
        this.receiverArn = builder.receiverArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the invitation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the invitation.
     */
    public final String resourceShareInvitationArn() {
        return resourceShareInvitationArn;
    }

    /**
     * <p>
     * The name of the resource share.
     * </p>
     * 
     * @return The name of the resource share.
     */
    public final String resourceShareName() {
        return resourceShareName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource share.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource share.
     */
    public final String resourceShareArn() {
        return resourceShareArn;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that sent the invitation.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that sent the invitation.
     */
    public final String senderAccountId() {
        return senderAccountId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that received the invitation.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that received the invitation.
     */
    public final String receiverAccountId() {
        return receiverAccountId;
    }

    /**
     * <p>
     * The date and time when the invitation was sent.
     * </p>
     * 
     * @return The date and time when the invitation was sent.
     */
    public final Instant invitationTimestamp() {
        return invitationTimestamp;
    }

    /**
     * <p>
     * The status of the invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceShareInvitationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the invitation.
     * @see ResourceShareInvitationStatus
     */
    public final ResourceShareInvitationStatus status() {
        return ResourceShareInvitationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceShareInvitationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the invitation.
     * @see ResourceShareInvitationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceShareAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     *
     * @deprecated This member has been deprecated. Use ListPendingInvitationResources.
     */
    @Deprecated
    public final boolean hasResourceShareAssociations() {
        return resourceShareAssociations != null && !(resourceShareAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * To view the resources associated with a pending resource share invitation, use <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
     * ListPendingInvitationResources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceShareAssociations} method.
     * </p>
     * 
     * @return To view the resources associated with a pending resource share invitation, use <a
     *         href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
     *         ListPendingInvitationResources</a>.
     * @deprecated This member has been deprecated. Use ListPendingInvitationResources.
     */
    @Deprecated
    public final List<ResourceShareAssociation> resourceShareAssociations() {
        return resourceShareAssociations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM user or IAM role that received the invitation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM user or IAM role that received the invitation.
     */
    public final String receiverArn() {
        return receiverArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareInvitationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(senderAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(receiverAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(invitationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceShareAssociations() ? resourceShareAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(receiverArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceShareInvitation)) {
            return false;
        }
        ResourceShareInvitation other = (ResourceShareInvitation) obj;
        return Objects.equals(resourceShareInvitationArn(), other.resourceShareInvitationArn())
                && Objects.equals(resourceShareName(), other.resourceShareName())
                && Objects.equals(resourceShareArn(), other.resourceShareArn())
                && Objects.equals(senderAccountId(), other.senderAccountId())
                && Objects.equals(receiverAccountId(), other.receiverAccountId())
                && Objects.equals(invitationTimestamp(), other.invitationTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasResourceShareAssociations() == other.hasResourceShareAssociations()
                && Objects.equals(resourceShareAssociations(), other.resourceShareAssociations())
                && Objects.equals(receiverArn(), other.receiverArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceShareInvitation").add("ResourceShareInvitationArn", resourceShareInvitationArn())
                .add("ResourceShareName", resourceShareName()).add("ResourceShareArn", resourceShareArn())
                .add("SenderAccountId", senderAccountId()).add("ReceiverAccountId", receiverAccountId())
                .add("InvitationTimestamp", invitationTimestamp()).add("Status", statusAsString())
                .add("ResourceShareAssociations", hasResourceShareAssociations() ? resourceShareAssociations() : null)
                .add("ReceiverArn", receiverArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareInvitationArn":
            return Optional.ofNullable(clazz.cast(resourceShareInvitationArn()));
        case "resourceShareName":
            return Optional.ofNullable(clazz.cast(resourceShareName()));
        case "resourceShareArn":
            return Optional.ofNullable(clazz.cast(resourceShareArn()));
        case "senderAccountId":
            return Optional.ofNullable(clazz.cast(senderAccountId()));
        case "receiverAccountId":
            return Optional.ofNullable(clazz.cast(receiverAccountId()));
        case "invitationTimestamp":
            return Optional.ofNullable(clazz.cast(invitationTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "resourceShareAssociations":
            return Optional.ofNullable(clazz.cast(resourceShareAssociations()));
        case "receiverArn":
            return Optional.ofNullable(clazz.cast(receiverArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceShareInvitation, T> g) {
        return obj -> g.apply((ResourceShareInvitation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceShareInvitation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the invitation.
         * </p>
         * 
         * @param resourceShareInvitationArn
         *        The Amazon Resource Name (ARN) of the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareInvitationArn(String resourceShareInvitationArn);

        /**
         * <p>
         * The name of the resource share.
         * </p>
         * 
         * @param resourceShareName
         *        The name of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareName(String resourceShareName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource share.
         * </p>
         * 
         * @param resourceShareArn
         *        The Amazon Resource Name (ARN) of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArn(String resourceShareArn);

        /**
         * <p>
         * The ID of the Amazon Web Services account that sent the invitation.
         * </p>
         * 
         * @param senderAccountId
         *        The ID of the Amazon Web Services account that sent the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderAccountId(String senderAccountId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that received the invitation.
         * </p>
         * 
         * @param receiverAccountId
         *        The ID of the Amazon Web Services account that received the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverAccountId(String receiverAccountId);

        /**
         * <p>
         * The date and time when the invitation was sent.
         * </p>
         * 
         * @param invitationTimestamp
         *        The date and time when the invitation was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationTimestamp(Instant invitationTimestamp);

        /**
         * <p>
         * The status of the invitation.
         * </p>
         * 
         * @param status
         *        The status of the invitation.
         * @see ResourceShareInvitationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareInvitationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the invitation.
         * </p>
         * 
         * @param status
         *        The status of the invitation.
         * @see ResourceShareInvitationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareInvitationStatus
         */
        Builder status(ResourceShareInvitationStatus status);

        /**
         * <p>
         * To view the resources associated with a pending resource share invitation, use <a
         * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
         * ListPendingInvitationResources</a>.
         * </p>
         * 
         * @param resourceShareAssociations
         *        To view the resources associated with a pending resource share invitation, use <a
         *        href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
         *        ListPendingInvitationResources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This member has been deprecated. Use ListPendingInvitationResources.
         */
        @Deprecated
        Builder resourceShareAssociations(Collection<ResourceShareAssociation> resourceShareAssociations);

        /**
         * <p>
         * To view the resources associated with a pending resource share invitation, use <a
         * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
         * ListPendingInvitationResources</a>.
         * </p>
         * 
         * @param resourceShareAssociations
         *        To view the resources associated with a pending resource share invitation, use <a
         *        href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
         *        ListPendingInvitationResources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This member has been deprecated. Use ListPendingInvitationResources.
         */
        @Deprecated
        Builder resourceShareAssociations(ResourceShareAssociation... resourceShareAssociations);

        /**
         * <p>
         * To view the resources associated with a pending resource share invitation, use <a
         * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
         * ListPendingInvitationResources</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceShareAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<ResourceShareAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceShareAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceShareAssociations(List<ResourceShareAssociation>)}.
         * 
         * @param resourceShareAssociations
         *        a consumer that will call methods on {@link List<ResourceShareAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceShareAssociations(List<ResourceShareAssociation>)
         * @deprecated This member has been deprecated. Use ListPendingInvitationResources.
         */
        @Deprecated
        Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder>... resourceShareAssociations);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM user or IAM role that received the invitation.
         * </p>
         * 
         * @param receiverArn
         *        The Amazon Resource Name (ARN) of the IAM user or IAM role that received the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverArn(String receiverArn);
    }

    static final class BuilderImpl implements Builder {
        private String resourceShareInvitationArn;

        private String resourceShareName;

        private String resourceShareArn;

        private String senderAccountId;

        private String receiverAccountId;

        private Instant invitationTimestamp;

        private String status;

        private List<ResourceShareAssociation> resourceShareAssociations = DefaultSdkAutoConstructList.getInstance();

        private String receiverArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceShareInvitation model) {
            resourceShareInvitationArn(model.resourceShareInvitationArn);
            resourceShareName(model.resourceShareName);
            resourceShareArn(model.resourceShareArn);
            senderAccountId(model.senderAccountId);
            receiverAccountId(model.receiverAccountId);
            invitationTimestamp(model.invitationTimestamp);
            status(model.status);
            resourceShareAssociations(model.resourceShareAssociations);
            receiverArn(model.receiverArn);
        }

        public final String getResourceShareInvitationArn() {
            return resourceShareInvitationArn;
        }

        public final void setResourceShareInvitationArn(String resourceShareInvitationArn) {
            this.resourceShareInvitationArn = resourceShareInvitationArn;
        }

        @Override
        @Transient
        public final Builder resourceShareInvitationArn(String resourceShareInvitationArn) {
            this.resourceShareInvitationArn = resourceShareInvitationArn;
            return this;
        }

        public final String getResourceShareName() {
            return resourceShareName;
        }

        public final void setResourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
        }

        @Override
        @Transient
        public final Builder resourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
            return this;
        }

        public final String getResourceShareArn() {
            return resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        @Transient
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final String getSenderAccountId() {
            return senderAccountId;
        }

        public final void setSenderAccountId(String senderAccountId) {
            this.senderAccountId = senderAccountId;
        }

        @Override
        @Transient
        public final Builder senderAccountId(String senderAccountId) {
            this.senderAccountId = senderAccountId;
            return this;
        }

        public final String getReceiverAccountId() {
            return receiverAccountId;
        }

        public final void setReceiverAccountId(String receiverAccountId) {
            this.receiverAccountId = receiverAccountId;
        }

        @Override
        @Transient
        public final Builder receiverAccountId(String receiverAccountId) {
            this.receiverAccountId = receiverAccountId;
            return this;
        }

        public final Instant getInvitationTimestamp() {
            return invitationTimestamp;
        }

        public final void setInvitationTimestamp(Instant invitationTimestamp) {
            this.invitationTimestamp = invitationTimestamp;
        }

        @Override
        @Transient
        public final Builder invitationTimestamp(Instant invitationTimestamp) {
            this.invitationTimestamp = invitationTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ResourceShareInvitationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Deprecated
        public final List<ResourceShareAssociation.Builder> getResourceShareAssociations() {
            List<ResourceShareAssociation.Builder> result = ResourceShareAssociationListCopier
                    .copyToBuilder(this.resourceShareAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setResourceShareAssociations(Collection<ResourceShareAssociation.BuilderImpl> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copyFromBuilder(resourceShareAssociations);
        }

        @Override
        @Transient
        @Deprecated
        public final Builder resourceShareAssociations(Collection<ResourceShareAssociation> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copy(resourceShareAssociations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        @Deprecated
        public final Builder resourceShareAssociations(ResourceShareAssociation... resourceShareAssociations) {
            resourceShareAssociations(Arrays.asList(resourceShareAssociations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        @Deprecated
        public final Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder>... resourceShareAssociations) {
            resourceShareAssociations(Stream.of(resourceShareAssociations)
                    .map(c -> ResourceShareAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReceiverArn() {
            return receiverArn;
        }

        public final void setReceiverArn(String receiverArn) {
            this.receiverArn = receiverArn;
        }

        @Override
        @Transient
        public final Builder receiverArn(String receiverArn) {
            this.receiverArn = receiverArn;
            return this;
        }

        @Override
        public ResourceShareInvitation build() {
            return new ResourceShareInvitation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
