/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.CreatePermissionRequest;
import software.amazon.awssdk.services.ram.model.CreatePermissionResponse;
import software.amazon.awssdk.services.ram.model.CreatePermissionVersionRequest;
import software.amazon.awssdk.services.ram.model.CreatePermissionVersionResponse;
import software.amazon.awssdk.services.ram.model.CreateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.CreateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DeletePermissionRequest;
import software.amazon.awssdk.services.ram.model.DeletePermissionResponse;
import software.amazon.awssdk.services.ram.model.DeletePermissionVersionRequest;
import software.amazon.awssdk.services.ram.model.DeletePermissionVersionResponse;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationRequest;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse;
import software.amazon.awssdk.services.ram.model.GetPermissionRequest;
import software.amazon.awssdk.services.ram.model.GetPermissionResponse;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceSharesRequest;
import software.amazon.awssdk.services.ram.model.GetResourceSharesResponse;
import software.amazon.awssdk.services.ram.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.ram.model.InvalidClientTokenException;
import software.amazon.awssdk.services.ram.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.ram.model.InvalidNextTokenException;
import software.amazon.awssdk.services.ram.model.InvalidParameterException;
import software.amazon.awssdk.services.ram.model.InvalidPolicyException;
import software.amazon.awssdk.services.ram.model.InvalidResourceTypeException;
import software.amazon.awssdk.services.ram.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionAssociationsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionAssociationsResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionsResponse;
import software.amazon.awssdk.services.ram.model.ListPrincipalsRequest;
import software.amazon.awssdk.services.ram.model.ListPrincipalsResponse;
import software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkRequest;
import software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkResponse;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse;
import software.amazon.awssdk.services.ram.model.ListResourceTypesRequest;
import software.amazon.awssdk.services.ram.model.ListResourceTypesResponse;
import software.amazon.awssdk.services.ram.model.ListResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListResourcesResponse;
import software.amazon.awssdk.services.ram.model.MalformedArnException;
import software.amazon.awssdk.services.ram.model.MalformedPolicyTemplateException;
import software.amazon.awssdk.services.ram.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.ram.model.OperationNotPermittedException;
import software.amazon.awssdk.services.ram.model.PermissionAlreadyExistsException;
import software.amazon.awssdk.services.ram.model.PermissionLimitExceededException;
import software.amazon.awssdk.services.ram.model.PermissionVersionsLimitExceededException;
import software.amazon.awssdk.services.ram.model.PromotePermissionCreatedFromPolicyRequest;
import software.amazon.awssdk.services.ram.model.PromotePermissionCreatedFromPolicyResponse;
import software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyRequest;
import software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyResponse;
import software.amazon.awssdk.services.ram.model.RamException;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.ReplacePermissionAssociationsRequest;
import software.amazon.awssdk.services.ram.model.ReplacePermissionAssociationsResponse;
import software.amazon.awssdk.services.ram.model.ResourceArnNotFoundException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationAlreadyAcceptedException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationAlreadyRejectedException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationArnNotFoundException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationExpiredException;
import software.amazon.awssdk.services.ram.model.ResourceShareLimitExceededException;
import software.amazon.awssdk.services.ram.model.ServerInternalException;
import software.amazon.awssdk.services.ram.model.ServiceUnavailableException;
import software.amazon.awssdk.services.ram.model.SetDefaultPermissionVersionRequest;
import software.amazon.awssdk.services.ram.model.SetDefaultPermissionVersionResponse;
import software.amazon.awssdk.services.ram.model.TagLimitExceededException;
import software.amazon.awssdk.services.ram.model.TagPolicyViolationException;
import software.amazon.awssdk.services.ram.model.TagResourceRequest;
import software.amazon.awssdk.services.ram.model.TagResourceResponse;
import software.amazon.awssdk.services.ram.model.ThrottlingException;
import software.amazon.awssdk.services.ram.model.UnknownResourceException;
import software.amazon.awssdk.services.ram.model.UnmatchedPolicyPermissionException;
import software.amazon.awssdk.services.ram.model.UntagResourceRequest;
import software.amazon.awssdk.services.ram.model.UntagResourceResponse;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse;
import software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesIterable;
import software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsIterable;
import software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable;
import software.amazon.awssdk.services.ram.paginators.GetResourceSharesIterable;
import software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesIterable;
import software.amazon.awssdk.services.ram.paginators.ListPermissionAssociationsIterable;
import software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsIterable;
import software.amazon.awssdk.services.ram.paginators.ListPermissionsIterable;
import software.amazon.awssdk.services.ram.paginators.ListPrincipalsIterable;
import software.amazon.awssdk.services.ram.paginators.ListReplacePermissionAssociationsWorkIterable;
import software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsIterable;
import software.amazon.awssdk.services.ram.paginators.ListResourceTypesIterable;
import software.amazon.awssdk.services.ram.paginators.ListResourcesIterable;

/**
 * Service client for accessing RAM. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is the <i>Resource Access Manager API Reference</i>. This documentation provides descriptions and syntax for
 * each of the actions and data types in RAM. RAM is a service that helps you securely share your Amazon Web Services
 * resources to other Amazon Web Services accounts. If you use Organizations to manage your accounts, then you can share
 * your resources with your entire organization or to organizational units (OUs). For supported resource types, you can
 * also share resources with individual Identity and Access Management (IAM) roles and users.
 * </p>
 * <p>
 * To learn more about RAM, see the following resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="http://aws.amazon.com/ram">Resource Access Manager product page</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/ram/latest/userguide/">Resource Access Manager User Guide</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RamClient extends AwsClient {
    String SERVICE_NAME = "ram";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ram";

    /**
     * <p>
     * Accepts an invitation to a resource share from another Amazon Web Services account. After you accept the
     * invitation, the resources included in the resource share are available to interact with in the relevant Amazon
     * Web Services Management Consoles and tools.
     * </p>
     *
     * @param acceptResourceShareInvitationRequest
     * @return Result of the AcceptResourceShareInvitation operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws ResourceShareInvitationAlreadyAcceptedException
     *         The operation failed because the specified invitation was already accepted.
     * @throws ResourceShareInvitationAlreadyRejectedException
     *         The operation failed because the specified invitation was already rejected.
     * @throws ResourceShareInvitationExpiredException
     *         The operation failed because the specified invitation is past its expiration date and time.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.AcceptResourceShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AcceptResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptResourceShareInvitationResponse acceptResourceShareInvitation(
            AcceptResourceShareInvitationRequest acceptResourceShareInvitationRequest) throws MalformedArnException,
            OperationNotPermittedException, ResourceShareInvitationArnNotFoundException,
            ResourceShareInvitationAlreadyAcceptedException, ResourceShareInvitationAlreadyRejectedException,
            ResourceShareInvitationExpiredException, ServerInternalException, ServiceUnavailableException,
            InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException,
            RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts an invitation to a resource share from another Amazon Web Services account. After you accept the
     * invitation, the resources included in the resource share are available to interact with in the relevant Amazon
     * Web Services Management Consoles and tools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptResourceShareInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptResourceShareInvitationRequest#builder()}
     * </p>
     *
     * @param acceptResourceShareInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptResourceShareInvitationRequest.Builder} to
     *        create a request.
     * @return Result of the AcceptResourceShareInvitation operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws ResourceShareInvitationAlreadyAcceptedException
     *         The operation failed because the specified invitation was already accepted.
     * @throws ResourceShareInvitationAlreadyRejectedException
     *         The operation failed because the specified invitation was already rejected.
     * @throws ResourceShareInvitationExpiredException
     *         The operation failed because the specified invitation is past its expiration date and time.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.AcceptResourceShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AcceptResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptResourceShareInvitationResponse acceptResourceShareInvitation(
            Consumer<AcceptResourceShareInvitationRequest.Builder> acceptResourceShareInvitationRequest)
            throws MalformedArnException, OperationNotPermittedException, ResourceShareInvitationArnNotFoundException,
            ResourceShareInvitationAlreadyAcceptedException, ResourceShareInvitationAlreadyRejectedException,
            ResourceShareInvitationExpiredException, ServerInternalException, ServiceUnavailableException,
            InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException,
            RamException {
        return acceptResourceShareInvitation(AcceptResourceShareInvitationRequest.builder()
                .applyMutation(acceptResourceShareInvitationRequest).build());
    }

    /**
     * <p>
     * Adds the specified list of principals and list of resources to a resource share. Principals that already have
     * access to this resource share immediately receive access to the added resources. Newly added principals
     * immediately receive access to the resources shared in this resource share.
     * </p>
     *
     * @param associateResourceShareRequest
     * @return Result of the AssociateResourceShare operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws ResourceShareLimitExceededException
     *         The operation failed because it would exceed the limit for resource shares for your account. To view the
     *         limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws ThrottlingException
     *         The operation failed because it exceeded the rate at which you are allowed to perform this operation.
     *         Please try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.AssociateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceShare" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateResourceShareResponse associateResourceShare(AssociateResourceShareRequest associateResourceShareRequest)
            throws IdempotentParameterMismatchException, UnknownResourceException, InvalidStateTransitionException,
            ResourceShareLimitExceededException, MalformedArnException, InvalidClientTokenException, InvalidParameterException,
            OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified list of principals and list of resources to a resource share. Principals that already have
     * access to this resource share immediately receive access to the added resources. Newly added principals
     * immediately receive access to the resources shared in this resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateResourceShareRequest#builder()}
     * </p>
     *
     * @param associateResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResourceShareRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateResourceShare operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws ResourceShareLimitExceededException
     *         The operation failed because it would exceed the limit for resource shares for your account. To view the
     *         limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws ThrottlingException
     *         The operation failed because it exceeded the rate at which you are allowed to perform this operation.
     *         Please try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.AssociateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceShare" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateResourceShareResponse associateResourceShare(
            Consumer<AssociateResourceShareRequest.Builder> associateResourceShareRequest)
            throws IdempotentParameterMismatchException, UnknownResourceException, InvalidStateTransitionException,
            ResourceShareLimitExceededException, MalformedArnException, InvalidClientTokenException, InvalidParameterException,
            OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, RamException {
        return associateResourceShare(AssociateResourceShareRequest.builder().applyMutation(associateResourceShareRequest)
                .build());
    }

    /**
     * <p>
     * Adds or replaces the RAM permission for a resource type included in a resource share. You can have exactly one
     * permission associated with each resource type in the resource share. You can add a new RAM permission only if
     * there are currently no resources of that resource type currently in the resource share.
     * </p>
     *
     * @param associateResourceSharePermissionRequest
     * @return Result of the AssociateResourceSharePermission operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.AssociateResourceSharePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceSharePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateResourceSharePermissionResponse associateResourceSharePermission(
            AssociateResourceSharePermissionRequest associateResourceSharePermissionRequest) throws MalformedArnException,
            UnknownResourceException, InvalidParameterException, InvalidClientTokenException, ServerInternalException,
            ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or replaces the RAM permission for a resource type included in a resource share. You can have exactly one
     * permission associated with each resource type in the resource share. You can add a new RAM permission only if
     * there are currently no resources of that resource type currently in the resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResourceSharePermissionRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateResourceSharePermissionRequest#builder()}
     * </p>
     *
     * @param associateResourceSharePermissionRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResourceSharePermissionRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateResourceSharePermission operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.AssociateResourceSharePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceSharePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateResourceSharePermissionResponse associateResourceSharePermission(
            Consumer<AssociateResourceSharePermissionRequest.Builder> associateResourceSharePermissionRequest)
            throws MalformedArnException, UnknownResourceException, InvalidParameterException, InvalidClientTokenException,
            ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, RamException {
        return associateResourceSharePermission(AssociateResourceSharePermissionRequest.builder()
                .applyMutation(associateResourceSharePermissionRequest).build());
    }

    /**
     * <p>
     * Creates a customer managed permission for a specified resource type that you can attach to resource shares. It is
     * created in the Amazon Web Services Region in which you call the operation.
     * </p>
     *
     * @param createPermissionRequest
     * @return Result of the CreatePermission operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidPolicyException
     *         The operation failed because a policy you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws PermissionAlreadyExistsException
     *         The operation failed because a permission with the specified name already exists in the requested Amazon
     *         Web Services Region. Choose a different name.
     * @throws MalformedPolicyTemplateException
     *         The operation failed because the policy template that you provided isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws PermissionLimitExceededException
     *         The operation failed because it would exceed the maximum number of permissions you can create in each
     *         Amazon Web Services Region. To view the limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.CreatePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreatePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePermissionResponse createPermission(CreatePermissionRequest createPermissionRequest)
            throws InvalidParameterException, InvalidPolicyException, OperationNotPermittedException, ServerInternalException,
            ServiceUnavailableException, PermissionAlreadyExistsException, MalformedPolicyTemplateException,
            InvalidClientTokenException, PermissionLimitExceededException, IdempotentParameterMismatchException,
            AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a customer managed permission for a specified resource type that you can attach to resource shares. It is
     * created in the Amazon Web Services Region in which you call the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePermissionRequest#builder()}
     * </p>
     *
     * @param createPermissionRequest
     *        A {@link Consumer} that will call methods on {@link CreatePermissionRequest.Builder} to create a request.
     * @return Result of the CreatePermission operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidPolicyException
     *         The operation failed because a policy you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws PermissionAlreadyExistsException
     *         The operation failed because a permission with the specified name already exists in the requested Amazon
     *         Web Services Region. Choose a different name.
     * @throws MalformedPolicyTemplateException
     *         The operation failed because the policy template that you provided isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws PermissionLimitExceededException
     *         The operation failed because it would exceed the maximum number of permissions you can create in each
     *         Amazon Web Services Region. To view the limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.CreatePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreatePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePermissionResponse createPermission(Consumer<CreatePermissionRequest.Builder> createPermissionRequest)
            throws InvalidParameterException, InvalidPolicyException, OperationNotPermittedException, ServerInternalException,
            ServiceUnavailableException, PermissionAlreadyExistsException, MalformedPolicyTemplateException,
            InvalidClientTokenException, PermissionLimitExceededException, IdempotentParameterMismatchException,
            AwsServiceException, SdkClientException, RamException {
        return createPermission(CreatePermissionRequest.builder().applyMutation(createPermissionRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the specified customer managed permission. The new version is automatically set as the
     * default version of the customer managed permission. New resource shares automatically use the default permission.
     * Existing resource shares continue to use their original permission versions, but you can use
     * <a>ReplacePermissionAssociations</a> to update them.
     * </p>
     * <p>
     * If the specified customer managed permission already has the maximum of 5 versions, then you must delete one of
     * the existing versions before you can create a new one.
     * </p>
     *
     * @param createPermissionVersionRequest
     * @return Result of the CreatePermissionVersion operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidPolicyException
     *         The operation failed because a policy you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedPolicyTemplateException
     *         The operation failed because the policy template that you provided isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws PermissionVersionsLimitExceededException
     *         The operation failed because it would exceed the limit for the number of versions you can have for a
     *         permission. To view the limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.CreatePermissionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreatePermissionVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePermissionVersionResponse createPermissionVersion(CreatePermissionVersionRequest createPermissionVersionRequest)
            throws InvalidParameterException, InvalidPolicyException, ServerInternalException, ServiceUnavailableException,
            UnknownResourceException, MalformedPolicyTemplateException, MalformedArnException, InvalidClientTokenException,
            IdempotentParameterMismatchException, PermissionVersionsLimitExceededException, AwsServiceException,
            SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the specified customer managed permission. The new version is automatically set as the
     * default version of the customer managed permission. New resource shares automatically use the default permission.
     * Existing resource shares continue to use their original permission versions, but you can use
     * <a>ReplacePermissionAssociations</a> to update them.
     * </p>
     * <p>
     * If the specified customer managed permission already has the maximum of 5 versions, then you must delete one of
     * the existing versions before you can create a new one.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePermissionVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePermissionVersionRequest#builder()}
     * </p>
     *
     * @param createPermissionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreatePermissionVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePermissionVersion operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidPolicyException
     *         The operation failed because a policy you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedPolicyTemplateException
     *         The operation failed because the policy template that you provided isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws PermissionVersionsLimitExceededException
     *         The operation failed because it would exceed the limit for the number of versions you can have for a
     *         permission. To view the limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.CreatePermissionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreatePermissionVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePermissionVersionResponse createPermissionVersion(
            Consumer<CreatePermissionVersionRequest.Builder> createPermissionVersionRequest) throws InvalidParameterException,
            InvalidPolicyException, ServerInternalException, ServiceUnavailableException, UnknownResourceException,
            MalformedPolicyTemplateException, MalformedArnException, InvalidClientTokenException,
            IdempotentParameterMismatchException, PermissionVersionsLimitExceededException, AwsServiceException,
            SdkClientException, RamException {
        return createPermissionVersion(CreatePermissionVersionRequest.builder().applyMutation(createPermissionVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a resource share. You can provide a list of the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> for the resources that you want to share, a list of principals you want to share the resources with,
     * and the permissions to grant those principals.
     * </p>
     * <note>
     * <p>
     * Sharing a resource makes it available for use by principals outside of the Amazon Web Services account that
     * created the resource. Sharing doesn't change any permissions or quotas that apply to the resource in the account
     * that created it.
     * </p>
     * </note>
     *
     * @param createResourceShareRequest
     * @return Result of the CreateResourceShare operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ResourceShareLimitExceededException
     *         The operation failed because it would exceed the limit for resource shares for your account. To view the
     *         limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws TagPolicyViolationException
     *         The operation failed because the specified tag key is a reserved word and can't be used.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.CreateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateResourceShareResponse createResourceShare(CreateResourceShareRequest createResourceShareRequest)
            throws IdempotentParameterMismatchException, InvalidStateTransitionException, UnknownResourceException,
            MalformedArnException, InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException,
            ResourceShareLimitExceededException, TagPolicyViolationException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource share. You can provide a list of the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> for the resources that you want to share, a list of principals you want to share the resources with,
     * and the permissions to grant those principals.
     * </p>
     * <note>
     * <p>
     * Sharing a resource makes it available for use by principals outside of the Amazon Web Services account that
     * created the resource. Sharing doesn't change any permissions or quotas that apply to the resource in the account
     * that created it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceShareRequest#builder()}
     * </p>
     *
     * @param createResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceShareRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResourceShare operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ResourceShareLimitExceededException
     *         The operation failed because it would exceed the limit for resource shares for your account. To view the
     *         limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws TagPolicyViolationException
     *         The operation failed because the specified tag key is a reserved word and can't be used.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.CreateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateResourceShareResponse createResourceShare(
            Consumer<CreateResourceShareRequest.Builder> createResourceShareRequest) throws IdempotentParameterMismatchException,
            InvalidStateTransitionException, UnknownResourceException, MalformedArnException, InvalidClientTokenException,
            InvalidParameterException, OperationNotPermittedException, ResourceShareLimitExceededException,
            TagPolicyViolationException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        return createResourceShare(CreateResourceShareRequest.builder().applyMutation(createResourceShareRequest).build());
    }

    /**
     * <p>
     * Deletes the specified customer managed permission in the Amazon Web Services Region in which you call this
     * operation. You can delete a customer managed permission only if it isn't attached to any resource share. The
     * operation deletes all versions associated with the customer managed permission.
     * </p>
     *
     * @param deletePermissionRequest
     * @return Result of the DeletePermission operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.DeletePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeletePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePermissionResponse deletePermission(DeletePermissionRequest deletePermissionRequest)
            throws MalformedArnException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException,
            UnknownResourceException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException,
            SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified customer managed permission in the Amazon Web Services Region in which you call this
     * operation. You can delete a customer managed permission only if it isn't attached to any resource share. The
     * operation deletes all versions associated with the customer managed permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePermissionRequest#builder()}
     * </p>
     *
     * @param deletePermissionRequest
     *        A {@link Consumer} that will call methods on {@link DeletePermissionRequest.Builder} to create a request.
     * @return Result of the DeletePermission operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.DeletePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeletePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePermissionResponse deletePermission(Consumer<DeletePermissionRequest.Builder> deletePermissionRequest)
            throws MalformedArnException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException,
            UnknownResourceException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException,
            SdkClientException, RamException {
        return deletePermission(DeletePermissionRequest.builder().applyMutation(deletePermissionRequest).build());
    }

    /**
     * <p>
     * Deletes one version of a customer managed permission. The version you specify must not be attached to any
     * resource share and must not be the default version for the permission.
     * </p>
     * <p>
     * If a customer managed permission has the maximum of 5 versions, then you must delete at least one version before
     * you can create another.
     * </p>
     *
     * @param deletePermissionVersionRequest
     * @return Result of the DeletePermissionVersion operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.DeletePermissionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeletePermissionVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePermissionVersionResponse deletePermissionVersion(DeletePermissionVersionRequest deletePermissionVersionRequest)
            throws MalformedArnException, InvalidParameterException, ServerInternalException, ServiceUnavailableException,
            OperationNotPermittedException, UnknownResourceException, InvalidClientTokenException,
            IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one version of a customer managed permission. The version you specify must not be attached to any
     * resource share and must not be the default version for the permission.
     * </p>
     * <p>
     * If a customer managed permission has the maximum of 5 versions, then you must delete at least one version before
     * you can create another.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePermissionVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePermissionVersionRequest#builder()}
     * </p>
     *
     * @param deletePermissionVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeletePermissionVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePermissionVersion operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.DeletePermissionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeletePermissionVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePermissionVersionResponse deletePermissionVersion(
            Consumer<DeletePermissionVersionRequest.Builder> deletePermissionVersionRequest) throws MalformedArnException,
            InvalidParameterException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException,
            UnknownResourceException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException,
            SdkClientException, RamException {
        return deletePermissionVersion(DeletePermissionVersionRequest.builder().applyMutation(deletePermissionVersionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified resource share.
     * </p>
     * <important>
     * <p>
     * This doesn't delete any of the resources that were associated with the resource share; it only stops the sharing
     * of those resources through this resource share.
     * </p>
     * </important>
     *
     * @param deleteResourceShareRequest
     * @return Result of the DeleteResourceShare operation returned by the service.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.DeleteResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResourceShareResponse deleteResourceShare(DeleteResourceShareRequest deleteResourceShareRequest)
            throws OperationNotPermittedException, IdempotentParameterMismatchException, InvalidStateTransitionException,
            UnknownResourceException, MalformedArnException, InvalidClientTokenException, InvalidParameterException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource share.
     * </p>
     * <important>
     * <p>
     * This doesn't delete any of the resources that were associated with the resource share; it only stops the sharing
     * of those resources through this resource share.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceShareRequest#builder()}
     * </p>
     *
     * @param deleteResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceShareRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourceShare operation returned by the service.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.DeleteResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResourceShareResponse deleteResourceShare(
            Consumer<DeleteResourceShareRequest.Builder> deleteResourceShareRequest) throws OperationNotPermittedException,
            IdempotentParameterMismatchException, InvalidStateTransitionException, UnknownResourceException,
            MalformedArnException, InvalidClientTokenException, InvalidParameterException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return deleteResourceShare(DeleteResourceShareRequest.builder().applyMutation(deleteResourceShareRequest).build());
    }

    /**
     * <p>
     * Removes the specified principals or resources from participating in the specified resource share.
     * </p>
     *
     * @param disassociateResourceShareRequest
     * @return Result of the DisassociateResourceShare operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws ResourceShareLimitExceededException
     *         The operation failed because it would exceed the limit for resource shares for your account. To view the
     *         limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.DisassociateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceShare" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateResourceShareResponse disassociateResourceShare(
            DisassociateResourceShareRequest disassociateResourceShareRequest) throws IdempotentParameterMismatchException,
            ResourceShareLimitExceededException, MalformedArnException, InvalidStateTransitionException,
            InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException, ServerInternalException,
            ServiceUnavailableException, UnknownResourceException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified principals or resources from participating in the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResourceShareRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateResourceShareRequest#builder()}
     * </p>
     *
     * @param disassociateResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResourceShareRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateResourceShare operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws ResourceShareLimitExceededException
     *         The operation failed because it would exceed the limit for resource shares for your account. To view the
     *         limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.DisassociateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceShare" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateResourceShareResponse disassociateResourceShare(
            Consumer<DisassociateResourceShareRequest.Builder> disassociateResourceShareRequest)
            throws IdempotentParameterMismatchException, ResourceShareLimitExceededException, MalformedArnException,
            InvalidStateTransitionException, InvalidClientTokenException, InvalidParameterException,
            OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, UnknownResourceException,
            AwsServiceException, SdkClientException, RamException {
        return disassociateResourceShare(DisassociateResourceShareRequest.builder()
                .applyMutation(disassociateResourceShareRequest).build());
    }

    /**
     * <p>
     * Removes a managed permission from a resource share. Permission changes take effect immediately. You can remove a
     * managed permission from a resource share only if there are currently no resources of the relevant resource type
     * currently attached to the resource share.
     * </p>
     *
     * @param disassociateResourceSharePermissionRequest
     * @return Result of the DisassociateResourceSharePermission operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.DisassociateResourceSharePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceSharePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateResourceSharePermissionResponse disassociateResourceSharePermission(
            DisassociateResourceSharePermissionRequest disassociateResourceSharePermissionRequest) throws MalformedArnException,
            UnknownResourceException, InvalidParameterException, InvalidClientTokenException, ServerInternalException,
            ServiceUnavailableException, OperationNotPermittedException, InvalidStateTransitionException, AwsServiceException,
            SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a managed permission from a resource share. Permission changes take effect immediately. You can remove a
     * managed permission from a resource share only if there are currently no resources of the relevant resource type
     * currently attached to the resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResourceSharePermissionRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateResourceSharePermissionRequest#builder()}
     * </p>
     *
     * @param disassociateResourceSharePermissionRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResourceSharePermissionRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateResourceSharePermission operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.DisassociateResourceSharePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceSharePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateResourceSharePermissionResponse disassociateResourceSharePermission(
            Consumer<DisassociateResourceSharePermissionRequest.Builder> disassociateResourceSharePermissionRequest)
            throws MalformedArnException, UnknownResourceException, InvalidParameterException, InvalidClientTokenException,
            ServerInternalException, ServiceUnavailableException, OperationNotPermittedException,
            InvalidStateTransitionException, AwsServiceException, SdkClientException, RamException {
        return disassociateResourceSharePermission(DisassociateResourceSharePermissionRequest.builder()
                .applyMutation(disassociateResourceSharePermissionRequest).build());
    }

    /**
     * <p>
     * Enables resource sharing within your organization in Organizations. This operation creates a service-linked role
     * called <code>AWSServiceRoleForResourceAccessManager</code> that has the IAM managed policy named
     * AWSResourceAccessManagerServiceRolePolicy attached. This role permits RAM to retrieve information about the
     * organization and its structure. This lets you share resources with all of the accounts in the calling account's
     * organization by specifying the organization ID, or all of the accounts in an organizational unit (OU) by
     * specifying the OU ID. Until you enable sharing within the organization, you can specify only individual Amazon
     * Web Services accounts, or for supported resource types, IAM roles and users.
     * </p>
     * <p>
     * You must call this operation from an IAM role or user in the organization's management account.
     * </p>
     * <p/>
     *
     * @param enableSharingWithAwsOrganizationRequest
     * @return Result of the EnableSharingWithAwsOrganization operation returned by the service.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.EnableSharingWithAwsOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableSharingWithAwsOrganizationResponse enableSharingWithAwsOrganization(
            EnableSharingWithAwsOrganizationRequest enableSharingWithAwsOrganizationRequest)
            throws OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables resource sharing within your organization in Organizations. This operation creates a service-linked role
     * called <code>AWSServiceRoleForResourceAccessManager</code> that has the IAM managed policy named
     * AWSResourceAccessManagerServiceRolePolicy attached. This role permits RAM to retrieve information about the
     * organization and its structure. This lets you share resources with all of the accounts in the calling account's
     * organization by specifying the organization ID, or all of the accounts in an organizational unit (OU) by
     * specifying the OU ID. Until you enable sharing within the organization, you can specify only individual Amazon
     * Web Services accounts, or for supported resource types, IAM roles and users.
     * </p>
     * <p>
     * You must call this operation from an IAM role or user in the organization's management account.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSharingWithAwsOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link EnableSharingWithAwsOrganizationRequest#builder()}
     * </p>
     *
     * @param enableSharingWithAwsOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link EnableSharingWithAwsOrganizationRequest.Builder} to
     *        create a request.
     * @return Result of the EnableSharingWithAwsOrganization operation returned by the service.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.EnableSharingWithAwsOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableSharingWithAwsOrganizationResponse enableSharingWithAwsOrganization(
            Consumer<EnableSharingWithAwsOrganizationRequest.Builder> enableSharingWithAwsOrganizationRequest)
            throws OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        return enableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest.builder()
                .applyMutation(enableSharingWithAwsOrganizationRequest).build());
    }

    /**
     * <p>
     * Enables resource sharing within your organization in Organizations. This operation creates a service-linked role
     * called <code>AWSServiceRoleForResourceAccessManager</code> that has the IAM managed policy named
     * AWSResourceAccessManagerServiceRolePolicy attached. This role permits RAM to retrieve information about the
     * organization and its structure. This lets you share resources with all of the accounts in the calling account's
     * organization by specifying the organization ID, or all of the accounts in an organizational unit (OU) by
     * specifying the OU ID. Until you enable sharing within the organization, you can specify only individual Amazon
     * Web Services accounts, or for supported resource types, IAM roles and users.
     * </p>
     * <p>
     * You must call this operation from an IAM role or user in the organization's management account.
     * </p>
     * <p/>
     *
     * @return Result of the EnableSharingWithAwsOrganization operation returned by the service.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.EnableSharingWithAwsOrganization
     * @see #enableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableSharingWithAwsOrganizationResponse enableSharingWithAwsOrganization() throws OperationNotPermittedException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return enableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the contents of a managed permission in JSON format.
     * </p>
     *
     * @param getPermissionRequest
     * @return Result of the GetPermission operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPermissionResponse getPermission(GetPermissionRequest getPermissionRequest) throws InvalidParameterException,
            MalformedArnException, UnknownResourceException, ServerInternalException, ServiceUnavailableException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the contents of a managed permission in JSON format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link GetPermissionRequest#builder()}
     * </p>
     *
     * @param getPermissionRequest
     *        A {@link Consumer} that will call methods on {@link GetPermissionRequest.Builder} to create a request.
     * @return Result of the GetPermission operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPermissionResponse getPermission(Consumer<GetPermissionRequest.Builder> getPermissionRequest)
            throws InvalidParameterException, MalformedArnException, UnknownResourceException, ServerInternalException,
            ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        return getPermission(GetPermissionRequest.builder().applyMutation(getPermissionRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource policies for the specified resources that you own and have shared.
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return Result of the GetResourcePolicies operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ResourceArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> was not found.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesResponse getResourcePolicies(GetResourcePoliciesRequest getResourcePoliciesRequest)
            throws MalformedArnException, InvalidNextTokenException, InvalidParameterException, ResourceArnNotFoundException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource policies for the specified resources that you own and have shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourcePolicies operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ResourceArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> was not found.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesResponse getResourcePolicies(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) throws MalformedArnException,
            InvalidNextTokenException, InvalidParameterException, ResourceArnNotFoundException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return getResourcePolicies(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource policies for the specified resources that you own and have shared.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesIterable responses = client
     *             .getResourcePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation.</b>
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ResourceArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> was not found.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesIterable getResourcePoliciesPaginator(GetResourcePoliciesRequest getResourcePoliciesRequest)
            throws MalformedArnException, InvalidNextTokenException, InvalidParameterException, ResourceArnNotFoundException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new GetResourcePoliciesIterable(this, getResourcePoliciesRequest);
    }

    /**
     * <p>
     * Retrieves the resource policies for the specified resources that you own and have shared.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesIterable responses = client
     *             .getResourcePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ResourceArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> was not found.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesIterable getResourcePoliciesPaginator(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) throws MalformedArnException,
            InvalidNextTokenException, InvalidParameterException, ResourceArnNotFoundException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return getResourcePoliciesPaginator(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the lists of resources and principals that associated for resource shares that you own.
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     * @return Result of the GetResourceShareAssociations operation returned by the service.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShareAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareAssociationsResponse getResourceShareAssociations(
            GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) throws UnknownResourceException,
            MalformedArnException, InvalidNextTokenException, InvalidParameterException, OperationNotPermittedException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the lists of resources and principals that associated for resource shares that you own.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareAssociationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareAssociationsRequest.Builder} to create
     *        a request.
     * @return Result of the GetResourceShareAssociations operation returned by the service.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShareAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareAssociationsResponse getResourceShareAssociations(
            Consumer<GetResourceShareAssociationsRequest.Builder> getResourceShareAssociationsRequest)
            throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException,
            OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        return getResourceShareAssociations(GetResourceShareAssociationsRequest.builder()
                .applyMutation(getResourceShareAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the lists of resources and principals that associated for resource shares that you own.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsIterable responses = client.getResourceShareAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsIterable responses = client
     *             .getResourceShareAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsIterable responses = client.getResourceShareAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShareAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareAssociationsIterable getResourceShareAssociationsPaginator(
            GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) throws UnknownResourceException,
            MalformedArnException, InvalidNextTokenException, InvalidParameterException, OperationNotPermittedException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new GetResourceShareAssociationsIterable(this, getResourceShareAssociationsRequest);
    }

    /**
     * <p>
     * Retrieves the lists of resources and principals that associated for resource shares that you own.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsIterable responses = client.getResourceShareAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsIterable responses = client
     *             .getResourceShareAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsIterable responses = client.getResourceShareAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareAssociationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShareAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareAssociationsIterable getResourceShareAssociationsPaginator(
            Consumer<GetResourceShareAssociationsRequest.Builder> getResourceShareAssociationsRequest)
            throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException,
            OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        return getResourceShareAssociationsPaginator(GetResourceShareAssociationsRequest.builder()
                .applyMutation(getResourceShareAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     * @return Result of the GetResourceShareInvitations operation returned by the service.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws InvalidMaxResultsException
     *         The operation failed because the specified value for <code>MaxResults</code> isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsResponse getResourceShareInvitations(
            GetResourceShareInvitationsRequest getResourceShareInvitationsRequest)
            throws ResourceShareInvitationArnNotFoundException, InvalidMaxResultsException, MalformedArnException,
            UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareInvitationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareInvitationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareInvitationsRequest.Builder} to create
     *        a request.
     * @return Result of the GetResourceShareInvitations operation returned by the service.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws InvalidMaxResultsException
     *         The operation failed because the specified value for <code>MaxResults</code> isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsResponse getResourceShareInvitations(
            Consumer<GetResourceShareInvitationsRequest.Builder> getResourceShareInvitationsRequest)
            throws ResourceShareInvitationArnNotFoundException, InvalidMaxResultsException, MalformedArnException,
            UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return getResourceShareInvitations(GetResourceShareInvitationsRequest.builder()
                .applyMutation(getResourceShareInvitationsRequest).build());
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     *
     * @return Result of the GetResourceShareInvitations operation returned by the service.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws InvalidMaxResultsException
     *         The operation failed because the specified value for <code>MaxResults</code> isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShareInvitations
     * @see #getResourceShareInvitations(GetResourceShareInvitationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsResponse getResourceShareInvitations() throws ResourceShareInvitationArnNotFoundException,
            InvalidMaxResultsException, MalformedArnException, UnknownResourceException, InvalidNextTokenException,
            InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        return getResourceShareInvitations(GetResourceShareInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable responses = client.getResourceShareInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable responses = client
     *             .getResourceShareInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable responses = client.getResourceShareInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws InvalidMaxResultsException
     *         The operation failed because the specified value for <code>MaxResults</code> isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShareInvitations
     * @see #getResourceShareInvitationsPaginator(GetResourceShareInvitationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsIterable getResourceShareInvitationsPaginator()
            throws ResourceShareInvitationArnNotFoundException, InvalidMaxResultsException, MalformedArnException,
            UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return getResourceShareInvitationsPaginator(GetResourceShareInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable responses = client.getResourceShareInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable responses = client
     *             .getResourceShareInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable responses = client.getResourceShareInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws InvalidMaxResultsException
     *         The operation failed because the specified value for <code>MaxResults</code> isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsIterable getResourceShareInvitationsPaginator(
            GetResourceShareInvitationsRequest getResourceShareInvitationsRequest)
            throws ResourceShareInvitationArnNotFoundException, InvalidMaxResultsException, MalformedArnException,
            UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new GetResourceShareInvitationsIterable(this, getResourceShareInvitationsRequest);
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable responses = client.getResourceShareInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable responses = client
     *             .getResourceShareInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable responses = client.getResourceShareInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareInvitationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareInvitationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareInvitationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws InvalidMaxResultsException
     *         The operation failed because the specified value for <code>MaxResults</code> isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsIterable getResourceShareInvitationsPaginator(
            Consumer<GetResourceShareInvitationsRequest.Builder> getResourceShareInvitationsRequest)
            throws ResourceShareInvitationArnNotFoundException, InvalidMaxResultsException, MalformedArnException,
            UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return getResourceShareInvitationsPaginator(GetResourceShareInvitationsRequest.builder()
                .applyMutation(getResourceShareInvitationsRequest).build());
    }

    /**
     * <p>
     * Retrieves details about the resource shares that you own or that are shared with you.
     * </p>
     *
     * @param getResourceSharesRequest
     * @return Result of the GetResourceShares operation returned by the service.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourceSharesResponse getResourceShares(GetResourceSharesRequest getResourceSharesRequest)
            throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about the resource shares that you own or that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSharesRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourceSharesRequest#builder()}
     * </p>
     *
     * @param getResourceSharesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceSharesRequest.Builder} to create a request.
     * @return Result of the GetResourceShares operation returned by the service.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourceSharesResponse getResourceShares(Consumer<GetResourceSharesRequest.Builder> getResourceSharesRequest)
            throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return getResourceShares(GetResourceSharesRequest.builder().applyMutation(getResourceSharesRequest).build());
    }

    /**
     * <p>
     * Retrieves details about the resource shares that you own or that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesIterable responses = client.getResourceSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.GetResourceSharesIterable responses = client
     *             .getResourceSharesPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.GetResourceSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesIterable responses = client.getResourceSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation.</b>
     * </p>
     *
     * @param getResourceSharesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourceSharesIterable getResourceSharesPaginator(GetResourceSharesRequest getResourceSharesRequest)
            throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new GetResourceSharesIterable(this, getResourceSharesRequest);
    }

    /**
     * <p>
     * Retrieves details about the resource shares that you own or that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesIterable responses = client.getResourceSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.GetResourceSharesIterable responses = client
     *             .getResourceSharesPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.GetResourceSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesIterable responses = client.getResourceSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSharesRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourceSharesRequest#builder()}
     * </p>
     *
     * @param getResourceSharesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceSharesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.GetResourceShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourceSharesIterable getResourceSharesPaginator(
            Consumer<GetResourceSharesRequest.Builder> getResourceSharesRequest) throws UnknownResourceException,
            MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return getResourceSharesPaginator(GetResourceSharesRequest.builder().applyMutation(getResourceSharesRequest).build());
    }

    /**
     * <p>
     * Lists the resources in a resource share that is shared with you but for which the invitation is still
     * <code>PENDING</code>. That means that you haven't accepted or rejected the invitation and the invitation hasn't
     * expired.
     * </p>
     *
     * @param listPendingInvitationResourcesRequest
     * @return Result of the ListPendingInvitationResources operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws MissingRequiredParameterException
     *         The operation failed because a required input parameter is missing.
     * @throws ResourceShareInvitationAlreadyRejectedException
     *         The operation failed because the specified invitation was already rejected.
     * @throws ResourceShareInvitationExpiredException
     *         The operation failed because the specified invitation is past its expiration date and time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPendingInvitationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPendingInvitationResourcesResponse listPendingInvitationResources(
            ListPendingInvitationResourcesRequest listPendingInvitationResourcesRequest) throws MalformedArnException,
            InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException,
            ResourceShareInvitationArnNotFoundException, MissingRequiredParameterException,
            ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, AwsServiceException,
            SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources in a resource share that is shared with you but for which the invitation is still
     * <code>PENDING</code>. That means that you haven't accepted or rejected the invitation and the invitation hasn't
     * expired.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPendingInvitationResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPendingInvitationResourcesRequest#builder()}
     * </p>
     *
     * @param listPendingInvitationResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListPendingInvitationResourcesRequest.Builder} to
     *        create a request.
     * @return Result of the ListPendingInvitationResources operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws MissingRequiredParameterException
     *         The operation failed because a required input parameter is missing.
     * @throws ResourceShareInvitationAlreadyRejectedException
     *         The operation failed because the specified invitation was already rejected.
     * @throws ResourceShareInvitationExpiredException
     *         The operation failed because the specified invitation is past its expiration date and time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPendingInvitationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPendingInvitationResourcesResponse listPendingInvitationResources(
            Consumer<ListPendingInvitationResourcesRequest.Builder> listPendingInvitationResourcesRequest)
            throws MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException,
            ServiceUnavailableException, ResourceShareInvitationArnNotFoundException, MissingRequiredParameterException,
            ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, AwsServiceException,
            SdkClientException, RamException {
        return listPendingInvitationResources(ListPendingInvitationResourcesRequest.builder()
                .applyMutation(listPendingInvitationResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the resources in a resource share that is shared with you but for which the invitation is still
     * <code>PENDING</code>. That means that you haven't accepted or rejected the invitation and the invitation hasn't
     * expired.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPendingInvitationResources(software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesIterable responses = client.listPendingInvitationResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesIterable responses = client
     *             .listPendingInvitationResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesIterable responses = client.listPendingInvitationResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPendingInvitationResources(software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPendingInvitationResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws MissingRequiredParameterException
     *         The operation failed because a required input parameter is missing.
     * @throws ResourceShareInvitationAlreadyRejectedException
     *         The operation failed because the specified invitation was already rejected.
     * @throws ResourceShareInvitationExpiredException
     *         The operation failed because the specified invitation is past its expiration date and time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPendingInvitationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPendingInvitationResourcesIterable listPendingInvitationResourcesPaginator(
            ListPendingInvitationResourcesRequest listPendingInvitationResourcesRequest) throws MalformedArnException,
            InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException,
            ResourceShareInvitationArnNotFoundException, MissingRequiredParameterException,
            ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, AwsServiceException,
            SdkClientException, RamException {
        return new ListPendingInvitationResourcesIterable(this, listPendingInvitationResourcesRequest);
    }

    /**
     * <p>
     * Lists the resources in a resource share that is shared with you but for which the invitation is still
     * <code>PENDING</code>. That means that you haven't accepted or rejected the invitation and the invitation hasn't
     * expired.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPendingInvitationResources(software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesIterable responses = client.listPendingInvitationResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesIterable responses = client
     *             .listPendingInvitationResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesIterable responses = client.listPendingInvitationResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPendingInvitationResources(software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPendingInvitationResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPendingInvitationResourcesRequest#builder()}
     * </p>
     *
     * @param listPendingInvitationResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListPendingInvitationResourcesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws MissingRequiredParameterException
     *         The operation failed because a required input parameter is missing.
     * @throws ResourceShareInvitationAlreadyRejectedException
     *         The operation failed because the specified invitation was already rejected.
     * @throws ResourceShareInvitationExpiredException
     *         The operation failed because the specified invitation is past its expiration date and time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPendingInvitationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPendingInvitationResourcesIterable listPendingInvitationResourcesPaginator(
            Consumer<ListPendingInvitationResourcesRequest.Builder> listPendingInvitationResourcesRequest)
            throws MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException,
            ServiceUnavailableException, ResourceShareInvitationArnNotFoundException, MissingRequiredParameterException,
            ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, AwsServiceException,
            SdkClientException, RamException {
        return listPendingInvitationResourcesPaginator(ListPendingInvitationResourcesRequest.builder()
                .applyMutation(listPendingInvitationResourcesRequest).build());
    }

    /**
     * <p>
     * Lists information about the managed permission and its associations to any resource shares that use this managed
     * permission. This lets you see which resource shares use which versions of the specified managed permission.
     * </p>
     *
     * @param listPermissionAssociationsRequest
     * @return Result of the ListPermissionAssociations operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissionAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionAssociationsResponse listPermissionAssociations(
            ListPermissionAssociationsRequest listPermissionAssociationsRequest) throws InvalidParameterException,
            MalformedArnException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the managed permission and its associations to any resource shares that use this managed
     * permission. This lets you see which resource shares use which versions of the specified managed permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPermissionAssociationsRequest#builder()}
     * </p>
     *
     * @param listPermissionAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionAssociationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPermissionAssociations operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissionAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionAssociationsResponse listPermissionAssociations(
            Consumer<ListPermissionAssociationsRequest.Builder> listPermissionAssociationsRequest)
            throws InvalidParameterException, MalformedArnException, InvalidNextTokenException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return listPermissionAssociations(ListPermissionAssociationsRequest.builder()
                .applyMutation(listPermissionAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists information about the managed permission and its associations to any resource shares that use this managed
     * permission. This lets you see which resource shares use which versions of the specified managed permission.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionAssociations(software.amazon.awssdk.services.ram.model.ListPermissionAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionAssociationsIterable responses = client.listPermissionAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListPermissionAssociationsIterable responses = client
     *             .listPermissionAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListPermissionAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionAssociationsIterable responses = client.listPermissionAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionAssociations(software.amazon.awssdk.services.ram.model.ListPermissionAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissionAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionAssociationsIterable listPermissionAssociationsPaginator(
            ListPermissionAssociationsRequest listPermissionAssociationsRequest) throws InvalidParameterException,
            MalformedArnException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, RamException {
        return new ListPermissionAssociationsIterable(this, listPermissionAssociationsRequest);
    }

    /**
     * <p>
     * Lists information about the managed permission and its associations to any resource shares that use this managed
     * permission. This lets you see which resource shares use which versions of the specified managed permission.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionAssociations(software.amazon.awssdk.services.ram.model.ListPermissionAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionAssociationsIterable responses = client.listPermissionAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListPermissionAssociationsIterable responses = client
     *             .listPermissionAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListPermissionAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionAssociationsIterable responses = client.listPermissionAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionAssociations(software.amazon.awssdk.services.ram.model.ListPermissionAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPermissionAssociationsRequest#builder()}
     * </p>
     *
     * @param listPermissionAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionAssociationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissionAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionAssociationsIterable listPermissionAssociationsPaginator(
            Consumer<ListPermissionAssociationsRequest.Builder> listPermissionAssociationsRequest)
            throws InvalidParameterException, MalformedArnException, InvalidNextTokenException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return listPermissionAssociationsPaginator(ListPermissionAssociationsRequest.builder()
                .applyMutation(listPermissionAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the available versions of the specified RAM permission.
     * </p>
     *
     * @param listPermissionVersionsRequest
     * @return Result of the ListPermissionVersions operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionVersionsResponse listPermissionVersions(ListPermissionVersionsRequest listPermissionVersionsRequest)
            throws MalformedArnException, UnknownResourceException, InvalidNextTokenException, ServerInternalException,
            ServiceUnavailableException, OperationNotPermittedException, InvalidParameterException, AwsServiceException,
            SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available versions of the specified RAM permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPermissionVersionsRequest#builder()}
     * </p>
     *
     * @param listPermissionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPermissionVersions operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionVersionsResponse listPermissionVersions(
            Consumer<ListPermissionVersionsRequest.Builder> listPermissionVersionsRequest) throws MalformedArnException,
            UnknownResourceException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException,
            OperationNotPermittedException, InvalidParameterException, AwsServiceException, SdkClientException, RamException {
        return listPermissionVersions(ListPermissionVersionsRequest.builder().applyMutation(listPermissionVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the available versions of the specified RAM permission.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionVersions(software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsIterable responses = client.listPermissionVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsIterable responses = client
     *             .listPermissionVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsIterable responses = client.listPermissionVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionVersions(software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionVersionsIterable listPermissionVersionsPaginator(
            ListPermissionVersionsRequest listPermissionVersionsRequest) throws MalformedArnException, UnknownResourceException,
            InvalidNextTokenException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException,
            InvalidParameterException, AwsServiceException, SdkClientException, RamException {
        return new ListPermissionVersionsIterable(this, listPermissionVersionsRequest);
    }

    /**
     * <p>
     * Lists the available versions of the specified RAM permission.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionVersions(software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsIterable responses = client.listPermissionVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsIterable responses = client
     *             .listPermissionVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsIterable responses = client.listPermissionVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionVersions(software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPermissionVersionsRequest#builder()}
     * </p>
     *
     * @param listPermissionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionVersionsIterable listPermissionVersionsPaginator(
            Consumer<ListPermissionVersionsRequest.Builder> listPermissionVersionsRequest) throws MalformedArnException,
            UnknownResourceException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException,
            OperationNotPermittedException, InvalidParameterException, AwsServiceException, SdkClientException, RamException {
        return listPermissionVersionsPaginator(ListPermissionVersionsRequest.builder()
                .applyMutation(listPermissionVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of available RAM permissions that you can use for the supported resource types.
     * </p>
     *
     * @param listPermissionsRequest
     * @return Result of the ListPermissions operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest)
            throws InvalidParameterException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of available RAM permissions that you can use for the supported resource types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return Result of the ListPermissions operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsResponse listPermissions(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest)
            throws InvalidParameterException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        return listPermissions(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of available RAM permissions that you can use for the supported resource types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPermissions(software.amazon.awssdk.services.ram.model.ListPermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.ram.model.ListPermissionsRequest)} operation.</b>
     * </p>
     *
     * @param listPermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsIterable listPermissionsPaginator(ListPermissionsRequest listPermissionsRequest)
            throws InvalidParameterException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        return new ListPermissionsIterable(this, listPermissionsRequest);
    }

    /**
     * <p>
     * Retrieves a list of available RAM permissions that you can use for the supported resource types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPermissions(software.amazon.awssdk.services.ram.model.ListPermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.ram.model.ListPermissionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsIterable listPermissionsPaginator(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest)
            throws InvalidParameterException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        return listPermissionsPaginator(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists the principals that you are sharing resources with or that are sharing resources with you.
     * </p>
     *
     * @param listPrincipalsRequest
     * @return Result of the ListPrincipals operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPrincipals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPrincipalsResponse listPrincipals(ListPrincipalsRequest listPrincipalsRequest) throws MalformedArnException,
            UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the principals that you are sharing resources with or that are sharing resources with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPrincipalsRequest#builder()}
     * </p>
     *
     * @param listPrincipalsRequest
     *        A {@link Consumer} that will call methods on {@link ListPrincipalsRequest.Builder} to create a request.
     * @return Result of the ListPrincipals operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPrincipals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPrincipalsResponse listPrincipals(Consumer<ListPrincipalsRequest.Builder> listPrincipalsRequest)
            throws MalformedArnException, UnknownResourceException, InvalidNextTokenException, InvalidParameterException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return listPrincipals(ListPrincipalsRequest.builder().applyMutation(listPrincipalsRequest).build());
    }

    /**
     * <p>
     * Lists the principals that you are sharing resources with or that are sharing resources with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsIterable responses = client.listPrincipalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListPrincipalsIterable responses = client.listPrincipalsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListPrincipalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsIterable responses = client.listPrincipalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)} operation.</b>
     * </p>
     *
     * @param listPrincipalsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPrincipals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPrincipalsIterable listPrincipalsPaginator(ListPrincipalsRequest listPrincipalsRequest)
            throws MalformedArnException, UnknownResourceException, InvalidNextTokenException, InvalidParameterException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new ListPrincipalsIterable(this, listPrincipalsRequest);
    }

    /**
     * <p>
     * Lists the principals that you are sharing resources with or that are sharing resources with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsIterable responses = client.listPrincipalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListPrincipalsIterable responses = client.listPrincipalsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListPrincipalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsIterable responses = client.listPrincipalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPrincipalsRequest#builder()}
     * </p>
     *
     * @param listPrincipalsRequest
     *        A {@link Consumer} that will call methods on {@link ListPrincipalsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListPrincipals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPrincipalsIterable listPrincipalsPaginator(Consumer<ListPrincipalsRequest.Builder> listPrincipalsRequest)
            throws MalformedArnException, UnknownResourceException, InvalidNextTokenException, InvalidParameterException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return listPrincipalsPaginator(ListPrincipalsRequest.builder().applyMutation(listPrincipalsRequest).build());
    }

    /**
     * <p>
     * Retrieves the current status of the asynchronous tasks performed by RAM when you perform the
     * <a>ReplacePermissionAssociationsWork</a> operation.
     * </p>
     *
     * @param listReplacePermissionAssociationsWorkRequest
     * @return Result of the ListReplacePermissionAssociationsWork operation returned by the service.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListReplacePermissionAssociationsWork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListReplacePermissionAssociationsWork"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReplacePermissionAssociationsWorkResponse listReplacePermissionAssociationsWork(
            ListReplacePermissionAssociationsWorkRequest listReplacePermissionAssociationsWorkRequest)
            throws ServerInternalException, ServiceUnavailableException, InvalidNextTokenException, InvalidParameterException,
            AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current status of the asynchronous tasks performed by RAM when you perform the
     * <a>ReplacePermissionAssociationsWork</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListReplacePermissionAssociationsWorkRequest.Builder} avoiding the need to create one manually via
     * {@link ListReplacePermissionAssociationsWorkRequest#builder()}
     * </p>
     *
     * @param listReplacePermissionAssociationsWorkRequest
     *        A {@link Consumer} that will call methods on {@link ListReplacePermissionAssociationsWorkRequest.Builder}
     *        to create a request.
     * @return Result of the ListReplacePermissionAssociationsWork operation returned by the service.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListReplacePermissionAssociationsWork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListReplacePermissionAssociationsWork"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReplacePermissionAssociationsWorkResponse listReplacePermissionAssociationsWork(
            Consumer<ListReplacePermissionAssociationsWorkRequest.Builder> listReplacePermissionAssociationsWorkRequest)
            throws ServerInternalException, ServiceUnavailableException, InvalidNextTokenException, InvalidParameterException,
            AwsServiceException, SdkClientException, RamException {
        return listReplacePermissionAssociationsWork(ListReplacePermissionAssociationsWorkRequest.builder()
                .applyMutation(listReplacePermissionAssociationsWorkRequest).build());
    }

    /**
     * <p>
     * Retrieves the current status of the asynchronous tasks performed by RAM when you perform the
     * <a>ReplacePermissionAssociationsWork</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReplacePermissionAssociationsWork(software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListReplacePermissionAssociationsWorkIterable responses = client.listReplacePermissionAssociationsWorkPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListReplacePermissionAssociationsWorkIterable responses = client
     *             .listReplacePermissionAssociationsWorkPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListReplacePermissionAssociationsWorkIterable responses = client.listReplacePermissionAssociationsWorkPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReplacePermissionAssociationsWork(software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReplacePermissionAssociationsWorkRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListReplacePermissionAssociationsWork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListReplacePermissionAssociationsWork"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReplacePermissionAssociationsWorkIterable listReplacePermissionAssociationsWorkPaginator(
            ListReplacePermissionAssociationsWorkRequest listReplacePermissionAssociationsWorkRequest)
            throws ServerInternalException, ServiceUnavailableException, InvalidNextTokenException, InvalidParameterException,
            AwsServiceException, SdkClientException, RamException {
        return new ListReplacePermissionAssociationsWorkIterable(this, listReplacePermissionAssociationsWorkRequest);
    }

    /**
     * <p>
     * Retrieves the current status of the asynchronous tasks performed by RAM when you perform the
     * <a>ReplacePermissionAssociationsWork</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReplacePermissionAssociationsWork(software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListReplacePermissionAssociationsWorkIterable responses = client.listReplacePermissionAssociationsWorkPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListReplacePermissionAssociationsWorkIterable responses = client
     *             .listReplacePermissionAssociationsWorkPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListReplacePermissionAssociationsWorkIterable responses = client.listReplacePermissionAssociationsWorkPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReplacePermissionAssociationsWork(software.amazon.awssdk.services.ram.model.ListReplacePermissionAssociationsWorkRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListReplacePermissionAssociationsWorkRequest.Builder} avoiding the need to create one manually via
     * {@link ListReplacePermissionAssociationsWorkRequest#builder()}
     * </p>
     *
     * @param listReplacePermissionAssociationsWorkRequest
     *        A {@link Consumer} that will call methods on {@link ListReplacePermissionAssociationsWorkRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListReplacePermissionAssociationsWork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListReplacePermissionAssociationsWork"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReplacePermissionAssociationsWorkIterable listReplacePermissionAssociationsWorkPaginator(
            Consumer<ListReplacePermissionAssociationsWorkRequest.Builder> listReplacePermissionAssociationsWorkRequest)
            throws ServerInternalException, ServiceUnavailableException, InvalidNextTokenException, InvalidParameterException,
            AwsServiceException, SdkClientException, RamException {
        return listReplacePermissionAssociationsWorkPaginator(ListReplacePermissionAssociationsWorkRequest.builder()
                .applyMutation(listReplacePermissionAssociationsWorkRequest).build());
    }

    /**
     * <p>
     * Lists the RAM permissions that are associated with a resource share.
     * </p>
     *
     * @param listResourceSharePermissionsRequest
     * @return Result of the ListResourceSharePermissions operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResourceSharePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSharePermissionsResponse listResourceSharePermissions(
            ListResourceSharePermissionsRequest listResourceSharePermissionsRequest) throws InvalidParameterException,
            MalformedArnException, UnknownResourceException, InvalidNextTokenException, ServerInternalException,
            ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the RAM permissions that are associated with a resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceSharePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceSharePermissionsRequest#builder()}
     * </p>
     *
     * @param listResourceSharePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceSharePermissionsRequest.Builder} to create
     *        a request.
     * @return Result of the ListResourceSharePermissions operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResourceSharePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSharePermissionsResponse listResourceSharePermissions(
            Consumer<ListResourceSharePermissionsRequest.Builder> listResourceSharePermissionsRequest)
            throws InvalidParameterException, MalformedArnException, UnknownResourceException, InvalidNextTokenException,
            ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, RamException {
        return listResourceSharePermissions(ListResourceSharePermissionsRequest.builder()
                .applyMutation(listResourceSharePermissionsRequest).build());
    }

    /**
     * <p>
     * Lists the RAM permissions that are associated with a resource share.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceSharePermissions(software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsIterable responses = client.listResourceSharePermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsIterable responses = client
     *             .listResourceSharePermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsIterable responses = client.listResourceSharePermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceSharePermissions(software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceSharePermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResourceSharePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSharePermissionsIterable listResourceSharePermissionsPaginator(
            ListResourceSharePermissionsRequest listResourceSharePermissionsRequest) throws InvalidParameterException,
            MalformedArnException, UnknownResourceException, InvalidNextTokenException, ServerInternalException,
            ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        return new ListResourceSharePermissionsIterable(this, listResourceSharePermissionsRequest);
    }

    /**
     * <p>
     * Lists the RAM permissions that are associated with a resource share.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceSharePermissions(software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsIterable responses = client.listResourceSharePermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsIterable responses = client
     *             .listResourceSharePermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsIterable responses = client.listResourceSharePermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceSharePermissions(software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceSharePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceSharePermissionsRequest#builder()}
     * </p>
     *
     * @param listResourceSharePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceSharePermissionsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResourceSharePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSharePermissionsIterable listResourceSharePermissionsPaginator(
            Consumer<ListResourceSharePermissionsRequest.Builder> listResourceSharePermissionsRequest)
            throws InvalidParameterException, MalformedArnException, UnknownResourceException, InvalidNextTokenException,
            ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, RamException {
        return listResourceSharePermissionsPaginator(ListResourceSharePermissionsRequest.builder()
                .applyMutation(listResourceSharePermissionsRequest).build());
    }

    /**
     * <p>
     * Lists the resource types that can be shared by RAM.
     * </p>
     *
     * @param listResourceTypesRequest
     * @return Result of the ListResourceTypes operation returned by the service.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceTypesResponse listResourceTypes(ListResourceTypesRequest listResourceTypesRequest)
            throws InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource types that can be shared by RAM.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListResourceTypesRequest#builder()}
     * </p>
     *
     * @param listResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceTypesRequest.Builder} to create a request.
     * @return Result of the ListResourceTypes operation returned by the service.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceTypesResponse listResourceTypes(Consumer<ListResourceTypesRequest.Builder> listResourceTypesRequest)
            throws InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, RamException {
        return listResourceTypes(ListResourceTypesRequest.builder().applyMutation(listResourceTypesRequest).build());
    }

    /**
     * <p>
     * Lists the resource types that can be shared by RAM.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceTypes(software.amazon.awssdk.services.ram.model.ListResourceTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceTypesIterable responses = client.listResourceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListResourceTypesIterable responses = client
     *             .listResourceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListResourceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceTypesIterable responses = client.listResourceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceTypes(software.amazon.awssdk.services.ram.model.ListResourceTypesRequest)} operation.</b>
     * </p>
     *
     * @param listResourceTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceTypesIterable listResourceTypesPaginator(ListResourceTypesRequest listResourceTypesRequest)
            throws InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, RamException {
        return new ListResourceTypesIterable(this, listResourceTypesRequest);
    }

    /**
     * <p>
     * Lists the resource types that can be shared by RAM.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceTypes(software.amazon.awssdk.services.ram.model.ListResourceTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceTypesIterable responses = client.listResourceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListResourceTypesIterable responses = client
     *             .listResourceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListResourceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceTypesIterable responses = client.listResourceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceTypes(software.amazon.awssdk.services.ram.model.ListResourceTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListResourceTypesRequest#builder()}
     * </p>
     *
     * @param listResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceTypesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceTypesIterable listResourceTypesPaginator(
            Consumer<ListResourceTypesRequest.Builder> listResourceTypesRequest) throws InvalidNextTokenException,
            InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        return listResourceTypesPaginator(ListResourceTypesRequest.builder().applyMutation(listResourceTypesRequest).build());
    }

    /**
     * <p>
     * Lists the resources that you added to a resource share or the resources that are shared with you.
     * </p>
     *
     * @param listResourcesRequest
     * @return Result of the ListResources operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The operation failed because the specified resource type isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidResourceTypeException,
            UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources that you added to a resource share or the resources that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return Result of the ListResources operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The operation failed because the specified resource type isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesResponse listResources(Consumer<ListResourcesRequest.Builder> listResourcesRequest)
            throws InvalidResourceTypeException, UnknownResourceException, MalformedArnException, InvalidNextTokenException,
            InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        return listResources(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the resources that you added to a resource share or the resources that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceTypeException
     *         The operation failed because the specified resource type isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest)
            throws InvalidResourceTypeException, UnknownResourceException, MalformedArnException, InvalidNextTokenException,
            InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        return new ListResourcesIterable(this, listResourcesRequest);
    }

    /**
     * <p>
     * Lists the resources that you added to a resource share or the resources that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ram.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.ram.model.ListResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceTypeException
     *         The operation failed because the specified resource type isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidNextTokenException
     *         The operation failed because the specified value for <code>NextToken</code> isn't valid. You must specify
     *         a value you received in the <code>NextToken</code> response of a previous call to this operation.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesIterable listResourcesPaginator(Consumer<ListResourcesRequest.Builder> listResourcesRequest)
            throws InvalidResourceTypeException, UnknownResourceException, MalformedArnException, InvalidNextTokenException,
            InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        return listResourcesPaginator(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * When you attach a resource-based policy to a resource, RAM automatically creates a resource share of
     * <code>featureSet</code>=<code>CREATED_FROM_POLICY</code> with a managed permission that has the same IAM
     * permissions as the original resource-based policy. However, this type of managed permission is visible to only
     * the resource share owner, and the associated resource share can't be modified by using RAM.
     * </p>
     * <p>
     * This operation creates a separate, fully manageable customer managed permission that has the same IAM permissions
     * as the original resource-based policy. You can associate this customer managed permission to any resource shares.
     * </p>
     * <p>
     * Before you use <a>PromoteResourceShareCreatedFromPolicy</a>, you should first run this operation to ensure that
     * you have an appropriate customer managed permission that can be associated with the promoted resource share.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The original <code>CREATED_FROM_POLICY</code> policy isn't deleted, and resource shares using that original
     * policy aren't automatically updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't modify a <code>CREATED_FROM_POLICY</code> resource share so you can't associate the new customer
     * managed permission by using <code>ReplacePermsissionAssociations</code>. However, if you use
     * <a>PromoteResourceShareCreatedFromPolicy</a>, that operation automatically associates the fully manageable
     * customer managed permission to the newly promoted <code>STANDARD</code> resource share.
     * </p>
     * </li>
     * <li>
     * <p>
     * After you promote a resource share, if the original <code>CREATED_FROM_POLICY</code> managed permission has no
     * other associations to A resource share, then RAM automatically deletes it.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param promotePermissionCreatedFromPolicyRequest
     * @return Result of the PromotePermissionCreatedFromPolicy operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MissingRequiredParameterException
     *         The operation failed because a required input parameter is missing.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.PromotePermissionCreatedFromPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromotePermissionCreatedFromPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PromotePermissionCreatedFromPolicyResponse promotePermissionCreatedFromPolicy(
            PromotePermissionCreatedFromPolicyRequest promotePermissionCreatedFromPolicyRequest) throws MalformedArnException,
            OperationNotPermittedException, InvalidParameterException, MissingRequiredParameterException,
            ServerInternalException, ServiceUnavailableException, UnknownResourceException, AwsServiceException,
            SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When you attach a resource-based policy to a resource, RAM automatically creates a resource share of
     * <code>featureSet</code>=<code>CREATED_FROM_POLICY</code> with a managed permission that has the same IAM
     * permissions as the original resource-based policy. However, this type of managed permission is visible to only
     * the resource share owner, and the associated resource share can't be modified by using RAM.
     * </p>
     * <p>
     * This operation creates a separate, fully manageable customer managed permission that has the same IAM permissions
     * as the original resource-based policy. You can associate this customer managed permission to any resource shares.
     * </p>
     * <p>
     * Before you use <a>PromoteResourceShareCreatedFromPolicy</a>, you should first run this operation to ensure that
     * you have an appropriate customer managed permission that can be associated with the promoted resource share.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The original <code>CREATED_FROM_POLICY</code> policy isn't deleted, and resource shares using that original
     * policy aren't automatically updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't modify a <code>CREATED_FROM_POLICY</code> resource share so you can't associate the new customer
     * managed permission by using <code>ReplacePermsissionAssociations</code>. However, if you use
     * <a>PromoteResourceShareCreatedFromPolicy</a>, that operation automatically associates the fully manageable
     * customer managed permission to the newly promoted <code>STANDARD</code> resource share.
     * </p>
     * </li>
     * <li>
     * <p>
     * After you promote a resource share, if the original <code>CREATED_FROM_POLICY</code> managed permission has no
     * other associations to A resource share, then RAM automatically deletes it.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PromotePermissionCreatedFromPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link PromotePermissionCreatedFromPolicyRequest#builder()}
     * </p>
     *
     * @param promotePermissionCreatedFromPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PromotePermissionCreatedFromPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the PromotePermissionCreatedFromPolicy operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MissingRequiredParameterException
     *         The operation failed because a required input parameter is missing.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.PromotePermissionCreatedFromPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromotePermissionCreatedFromPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PromotePermissionCreatedFromPolicyResponse promotePermissionCreatedFromPolicy(
            Consumer<PromotePermissionCreatedFromPolicyRequest.Builder> promotePermissionCreatedFromPolicyRequest)
            throws MalformedArnException, OperationNotPermittedException, InvalidParameterException,
            MissingRequiredParameterException, ServerInternalException, ServiceUnavailableException, UnknownResourceException,
            AwsServiceException, SdkClientException, RamException {
        return promotePermissionCreatedFromPolicy(PromotePermissionCreatedFromPolicyRequest.builder()
                .applyMutation(promotePermissionCreatedFromPolicyRequest).build());
    }

    /**
     * <p>
     * When you attach a resource-based policy to a resource, RAM automatically creates a resource share of
     * <code>featureSet</code>=<code>CREATED_FROM_POLICY</code> with a managed permission that has the same IAM
     * permissions as the original resource-based policy. However, this type of managed permission is visible to only
     * the resource share owner, and the associated resource share can't be modified by using RAM.
     * </p>
     * <p>
     * This operation promotes the resource share to a <code>STANDARD</code> resource share that is fully manageable in
     * RAM. When you promote a resource share, you can then manage the resource share in RAM and it becomes visible to
     * all of the principals you shared it with.
     * </p>
     * <important>
     * <p>
     * Before you perform this operation, you should first run <a>PromotePermissionCreatedFromPolicy</a>to ensure that
     * you have an appropriate customer managed permission that can be associated with this resource share after its is
     * promoted. If this operation can't find a managed permission that exactly matches the existing
     * <code>CREATED_FROM_POLICY</code> permission, then this operation fails.
     * </p>
     * </important>
     *
     * @param promoteResourceShareCreatedFromPolicyRequest
     * @return Result of the PromoteResourceShareCreatedFromPolicy operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws ResourceShareLimitExceededException
     *         The operation failed because it would exceed the limit for resource shares for your account. To view the
     *         limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MissingRequiredParameterException
     *         The operation failed because a required input parameter is missing.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws UnmatchedPolicyPermissionException
     *         There isn't an existing managed permission defined in RAM that has the same IAM permissions as the
     *         resource-based policy attached to the resource. You should first run
     *         <a>PromotePermissionCreatedFromPolicy</a> to create that managed permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.PromoteResourceShareCreatedFromPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromoteResourceShareCreatedFromPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PromoteResourceShareCreatedFromPolicyResponse promoteResourceShareCreatedFromPolicy(
            PromoteResourceShareCreatedFromPolicyRequest promoteResourceShareCreatedFromPolicyRequest)
            throws MalformedArnException, ResourceShareLimitExceededException, OperationNotPermittedException,
            InvalidParameterException, MissingRequiredParameterException, ServerInternalException, ServiceUnavailableException,
            UnknownResourceException, InvalidStateTransitionException, UnmatchedPolicyPermissionException, AwsServiceException,
            SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When you attach a resource-based policy to a resource, RAM automatically creates a resource share of
     * <code>featureSet</code>=<code>CREATED_FROM_POLICY</code> with a managed permission that has the same IAM
     * permissions as the original resource-based policy. However, this type of managed permission is visible to only
     * the resource share owner, and the associated resource share can't be modified by using RAM.
     * </p>
     * <p>
     * This operation promotes the resource share to a <code>STANDARD</code> resource share that is fully manageable in
     * RAM. When you promote a resource share, you can then manage the resource share in RAM and it becomes visible to
     * all of the principals you shared it with.
     * </p>
     * <important>
     * <p>
     * Before you perform this operation, you should first run <a>PromotePermissionCreatedFromPolicy</a>to ensure that
     * you have an appropriate customer managed permission that can be associated with this resource share after its is
     * promoted. If this operation can't find a managed permission that exactly matches the existing
     * <code>CREATED_FROM_POLICY</code> permission, then this operation fails.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PromoteResourceShareCreatedFromPolicyRequest.Builder} avoiding the need to create one manually via
     * {@link PromoteResourceShareCreatedFromPolicyRequest#builder()}
     * </p>
     *
     * @param promoteResourceShareCreatedFromPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PromoteResourceShareCreatedFromPolicyRequest.Builder}
     *        to create a request.
     * @return Result of the PromoteResourceShareCreatedFromPolicy operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws ResourceShareLimitExceededException
     *         The operation failed because it would exceed the limit for resource shares for your account. To view the
     *         limits for your Amazon Web Services account, see the <a
     *         href="https://console.aws.amazon.com/servicequotas/home/services/ram/quotas">RAM page in the Service
     *         Quotas console</a>.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MissingRequiredParameterException
     *         The operation failed because a required input parameter is missing.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidStateTransitionException
     *         The operation failed because the requested operation isn't valid for the resource share in its current
     *         state.
     * @throws UnmatchedPolicyPermissionException
     *         There isn't an existing managed permission defined in RAM that has the same IAM permissions as the
     *         resource-based policy attached to the resource. You should first run
     *         <a>PromotePermissionCreatedFromPolicy</a> to create that managed permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.PromoteResourceShareCreatedFromPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromoteResourceShareCreatedFromPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PromoteResourceShareCreatedFromPolicyResponse promoteResourceShareCreatedFromPolicy(
            Consumer<PromoteResourceShareCreatedFromPolicyRequest.Builder> promoteResourceShareCreatedFromPolicyRequest)
            throws MalformedArnException, ResourceShareLimitExceededException, OperationNotPermittedException,
            InvalidParameterException, MissingRequiredParameterException, ServerInternalException, ServiceUnavailableException,
            UnknownResourceException, InvalidStateTransitionException, UnmatchedPolicyPermissionException, AwsServiceException,
            SdkClientException, RamException {
        return promoteResourceShareCreatedFromPolicy(PromoteResourceShareCreatedFromPolicyRequest.builder()
                .applyMutation(promoteResourceShareCreatedFromPolicyRequest).build());
    }

    /**
     * <p>
     * Rejects an invitation to a resource share from another Amazon Web Services account.
     * </p>
     *
     * @param rejectResourceShareInvitationRequest
     * @return Result of the RejectResourceShareInvitation operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws ResourceShareInvitationAlreadyAcceptedException
     *         The operation failed because the specified invitation was already accepted.
     * @throws ResourceShareInvitationAlreadyRejectedException
     *         The operation failed because the specified invitation was already rejected.
     * @throws ResourceShareInvitationExpiredException
     *         The operation failed because the specified invitation is past its expiration date and time.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.RejectResourceShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/RejectResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectResourceShareInvitationResponse rejectResourceShareInvitation(
            RejectResourceShareInvitationRequest rejectResourceShareInvitationRequest) throws MalformedArnException,
            OperationNotPermittedException, ResourceShareInvitationArnNotFoundException,
            ResourceShareInvitationAlreadyAcceptedException, ResourceShareInvitationAlreadyRejectedException,
            ResourceShareInvitationExpiredException, ServerInternalException, ServiceUnavailableException,
            InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException,
            RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects an invitation to a resource share from another Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectResourceShareInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link RejectResourceShareInvitationRequest#builder()}
     * </p>
     *
     * @param rejectResourceShareInvitationRequest
     *        A {@link Consumer} that will call methods on {@link RejectResourceShareInvitationRequest.Builder} to
     *        create a request.
     * @return Result of the RejectResourceShareInvitation operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ResourceShareInvitationArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> for an invitation was not found.
     * @throws ResourceShareInvitationAlreadyAcceptedException
     *         The operation failed because the specified invitation was already accepted.
     * @throws ResourceShareInvitationAlreadyRejectedException
     *         The operation failed because the specified invitation was already rejected.
     * @throws ResourceShareInvitationExpiredException
     *         The operation failed because the specified invitation is past its expiration date and time.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.RejectResourceShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/RejectResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectResourceShareInvitationResponse rejectResourceShareInvitation(
            Consumer<RejectResourceShareInvitationRequest.Builder> rejectResourceShareInvitationRequest)
            throws MalformedArnException, OperationNotPermittedException, ResourceShareInvitationArnNotFoundException,
            ResourceShareInvitationAlreadyAcceptedException, ResourceShareInvitationAlreadyRejectedException,
            ResourceShareInvitationExpiredException, ServerInternalException, ServiceUnavailableException,
            InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException,
            RamException {
        return rejectResourceShareInvitation(RejectResourceShareInvitationRequest.builder()
                .applyMutation(rejectResourceShareInvitationRequest).build());
    }

    /**
     * <p>
     * Updates all resource shares that use a managed permission to a different managed permission. This operation
     * always applies the default version of the target managed permission. You can optionally specify that the update
     * applies to only resource shares that currently use a specified version. This enables you to update to the latest
     * version, without changing the which managed permission is used.
     * </p>
     * <p>
     * You can use this operation to update all of your resource shares to use the current default version of the
     * permission by specifying the same value for the <code>fromPermissionArn</code> and <code>toPermissionArn</code>
     * parameters.
     * </p>
     * <p>
     * You can use the optional <code>fromPermissionVersion</code> parameter to update only those resources that use a
     * specified version of the managed permission to the new managed permission.
     * </p>
     * <important>
     * <p>
     * To successfully perform this operation, you must have permission to update the resource-based policy on all
     * affected resource types.
     * </p>
     * </important>
     *
     * @param replacePermissionAssociationsRequest
     * @return Result of the ReplacePermissionAssociations operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ReplacePermissionAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ReplacePermissionAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ReplacePermissionAssociationsResponse replacePermissionAssociations(
            ReplacePermissionAssociationsRequest replacePermissionAssociationsRequest) throws MalformedArnException,
            InvalidParameterException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException,
            UnknownResourceException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException,
            SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates all resource shares that use a managed permission to a different managed permission. This operation
     * always applies the default version of the target managed permission. You can optionally specify that the update
     * applies to only resource shares that currently use a specified version. This enables you to update to the latest
     * version, without changing the which managed permission is used.
     * </p>
     * <p>
     * You can use this operation to update all of your resource shares to use the current default version of the
     * permission by specifying the same value for the <code>fromPermissionArn</code> and <code>toPermissionArn</code>
     * parameters.
     * </p>
     * <p>
     * You can use the optional <code>fromPermissionVersion</code> parameter to update only those resources that use a
     * specified version of the managed permission to the new managed permission.
     * </p>
     * <important>
     * <p>
     * To successfully perform this operation, you must have permission to update the resource-based policy on all
     * affected resource types.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReplacePermissionAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ReplacePermissionAssociationsRequest#builder()}
     * </p>
     *
     * @param replacePermissionAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ReplacePermissionAssociationsRequest.Builder} to
     *        create a request.
     * @return Result of the ReplacePermissionAssociations operation returned by the service.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.ReplacePermissionAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ReplacePermissionAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ReplacePermissionAssociationsResponse replacePermissionAssociations(
            Consumer<ReplacePermissionAssociationsRequest.Builder> replacePermissionAssociationsRequest)
            throws MalformedArnException, InvalidParameterException, ServerInternalException, ServiceUnavailableException,
            OperationNotPermittedException, UnknownResourceException, InvalidClientTokenException,
            IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        return replacePermissionAssociations(ReplacePermissionAssociationsRequest.builder()
                .applyMutation(replacePermissionAssociationsRequest).build());
    }

    /**
     * <p>
     * Designates the specified version number as the default version for the specified customer managed permission. New
     * resource shares automatically use this new default permission. Existing resource shares continue to use their
     * original permission version, but you can use <a>ReplacePermissionAssociations</a> to update them.
     * </p>
     *
     * @param setDefaultPermissionVersionRequest
     * @return Result of the SetDefaultPermissionVersion operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.SetDefaultPermissionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/SetDefaultPermissionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default SetDefaultPermissionVersionResponse setDefaultPermissionVersion(
            SetDefaultPermissionVersionRequest setDefaultPermissionVersionRequest) throws InvalidParameterException,
            MalformedArnException, ServerInternalException, ServiceUnavailableException, UnknownResourceException,
            InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException,
            RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Designates the specified version number as the default version for the specified customer managed permission. New
     * resource shares automatically use this new default permission. Existing resource shares continue to use their
     * original permission version, but you can use <a>ReplacePermissionAssociations</a> to update them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetDefaultPermissionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link SetDefaultPermissionVersionRequest#builder()}
     * </p>
     *
     * @param setDefaultPermissionVersionRequest
     *        A {@link Consumer} that will call methods on {@link SetDefaultPermissionVersionRequest.Builder} to create
     *        a request.
     * @return Result of the SetDefaultPermissionVersion operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.SetDefaultPermissionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/SetDefaultPermissionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default SetDefaultPermissionVersionResponse setDefaultPermissionVersion(
            Consumer<SetDefaultPermissionVersionRequest.Builder> setDefaultPermissionVersionRequest)
            throws InvalidParameterException, MalformedArnException, ServerInternalException, ServiceUnavailableException,
            UnknownResourceException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException,
            SdkClientException, RamException {
        return setDefaultPermissionVersion(SetDefaultPermissionVersionRequest.builder()
                .applyMutation(setDefaultPermissionVersionRequest).build());
    }

    /**
     * <p>
     * Adds the specified tag keys and values to a resource share or managed permission. If you choose a resource share,
     * the tags are attached to only the resource share, not to the resources that are in the resource share.
     * </p>
     * <p>
     * The tags on a managed permission are the same for all versions of the managed permission.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws TagLimitExceededException
     *         The operation failed because it would exceed the limit for tags for your Amazon Web Services account.
     * @throws ResourceArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> was not found.
     * @throws TagPolicyViolationException
     *         The operation failed because the specified tag key is a reserved word and can't be used.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException,
            MalformedArnException, UnknownResourceException, TagLimitExceededException, ResourceArnNotFoundException,
            TagPolicyViolationException, ServerInternalException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tag keys and values to a resource share or managed permission. If you choose a resource share,
     * the tags are attached to only the resource share, not to the resources that are in the resource share.
     * </p>
     * <p>
     * The tags on a managed permission are the same for all versions of the managed permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws TagLimitExceededException
     *         The operation failed because it would exceed the limit for tags for your Amazon Web Services account.
     * @throws ResourceArnNotFoundException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> was not found.
     * @throws TagPolicyViolationException
     *         The operation failed because the specified tag key is a reserved word and can't be used.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidParameterException, MalformedArnException, UnknownResourceException, TagLimitExceededException,
            ResourceArnNotFoundException, TagPolicyViolationException, ServerInternalException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, RamException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tag key and value pairs from the specified resource share or managed permission.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws UnknownResourceException,
            InvalidParameterException, MalformedArnException, ServerInternalException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tag key and value pairs from the specified resource share or managed permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws UnknownResourceException, InvalidParameterException, MalformedArnException, ServerInternalException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies some of the properties of the specified resource share.
     * </p>
     *
     * @param updateResourceShareRequest
     * @return Result of the UpdateResourceShare operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws MissingRequiredParameterException
     *         The operation failed because a required input parameter is missing.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.UpdateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UpdateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateResourceShareResponse updateResourceShare(UpdateResourceShareRequest updateResourceShareRequest)
            throws IdempotentParameterMismatchException, MissingRequiredParameterException, UnknownResourceException,
            MalformedArnException, InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException,
            ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies some of the properties of the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourceShareRequest#builder()}
     * </p>
     *
     * @param updateResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceShareRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResourceShare operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         The operation failed because the client token input parameter matched one that was used with a previous
     *         call to the operation, but at least one of the other input parameters is different from the previous
     *         call.
     * @throws MissingRequiredParameterException
     *         The operation failed because a required input parameter is missing.
     * @throws UnknownResourceException
     *         The operation failed because a specified resource couldn't be found.
     * @throws MalformedArnException
     *         The operation failed because the specified <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> has a format that isn't valid.
     * @throws InvalidClientTokenException
     *         The operation failed because the specified client token isn't valid.
     * @throws InvalidParameterException
     *         The operation failed because a parameter you specified isn't valid.
     * @throws OperationNotPermittedException
     *         The operation failed because the requested operation isn't permitted.
     * @throws ServerInternalException
     *         The operation failed because the service could not respond to the request due to an internal problem. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The operation failed because the service isn't available. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RamClient.UpdateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UpdateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateResourceShareResponse updateResourceShare(
            Consumer<UpdateResourceShareRequest.Builder> updateResourceShareRequest) throws IdempotentParameterMismatchException,
            MissingRequiredParameterException, UnknownResourceException, MalformedArnException, InvalidClientTokenException,
            InvalidParameterException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, RamException {
        return updateResourceShare(UpdateResourceShareRequest.builder().applyMutation(updateResourceShareRequest).build());
    }

    /**
     * Create a {@link RamClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RamClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RamClient}.
     */
    static RamClientBuilder builder() {
        return new DefaultRamClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default RamServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
