/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.CreateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.CreateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationRequest;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse;
import software.amazon.awssdk.services.ram.model.GetPermissionRequest;
import software.amazon.awssdk.services.ram.model.GetPermissionResponse;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceSharesRequest;
import software.amazon.awssdk.services.ram.model.GetResourceSharesResponse;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionsResponse;
import software.amazon.awssdk.services.ram.model.ListPrincipalsRequest;
import software.amazon.awssdk.services.ram.model.ListPrincipalsResponse;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse;
import software.amazon.awssdk.services.ram.model.ListResourceTypesRequest;
import software.amazon.awssdk.services.ram.model.ListResourceTypesResponse;
import software.amazon.awssdk.services.ram.model.ListResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListResourcesResponse;
import software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyRequest;
import software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyResponse;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.TagResourceRequest;
import software.amazon.awssdk.services.ram.model.TagResourceResponse;
import software.amazon.awssdk.services.ram.model.UntagResourceRequest;
import software.amazon.awssdk.services.ram.model.UntagResourceResponse;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse;
import software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesPublisher;
import software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsPublisher;
import software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher;
import software.amazon.awssdk.services.ram.paginators.GetResourceSharesPublisher;
import software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesPublisher;
import software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsPublisher;
import software.amazon.awssdk.services.ram.paginators.ListPermissionsPublisher;
import software.amazon.awssdk.services.ram.paginators.ListPrincipalsPublisher;
import software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsPublisher;
import software.amazon.awssdk.services.ram.paginators.ListResourceTypesPublisher;
import software.amazon.awssdk.services.ram.paginators.ListResourcesPublisher;

/**
 * Service client for accessing RAM asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is the <i>Resource Access Manager API Reference</i>. This documentation provides descriptions and syntax for
 * each of the actions and data types in RAM. RAM is a service that helps you securely share your Amazon Web Services
 * resources across Amazon Web Services accounts. If you have multiple Amazon Web Services accounts, you can use RAM to
 * share those resources with other accounts. If you use Organizations to manage your accounts, then you share your
 * resources with your organization or organizational units (OUs). For supported resource types, you can also share
 * resources with individual Identity and Access Management (IAM) roles an users.
 * </p>
 * <p>
 * To learn more about RAM, see the following resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="http://aws.amazon.com/ram">Resource Access Manager product page</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/ram/latest/userguide/">Resource Access Manager User Guide</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RamAsyncClient extends AwsClient {
    String SERVICE_NAME = "ram";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ram";

    /**
     * <p>
     * Accepts an invitation to a resource share from another Amazon Web Services account. After you accept the
     * invitation, the resources included in the resource share are available to interact with in the relevant Amazon
     * Web Services Management Consoles and tools.
     * </p>
     *
     * @param acceptResourceShareInvitationRequest
     * @return A Java Future containing the result of the AcceptResourceShareInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>ResourceShareInvitationAlreadyAcceptedException The specified invitation was already accepted.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The specified invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The specified invitation is expired.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.AcceptResourceShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AcceptResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptResourceShareInvitationResponse> acceptResourceShareInvitation(
            AcceptResourceShareInvitationRequest acceptResourceShareInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts an invitation to a resource share from another Amazon Web Services account. After you accept the
     * invitation, the resources included in the resource share are available to interact with in the relevant Amazon
     * Web Services Management Consoles and tools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptResourceShareInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptResourceShareInvitationRequest#builder()}
     * </p>
     *
     * @param acceptResourceShareInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptResourceShareInvitationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AcceptResourceShareInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>ResourceShareInvitationAlreadyAcceptedException The specified invitation was already accepted.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The specified invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The specified invitation is expired.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.AcceptResourceShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AcceptResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptResourceShareInvitationResponse> acceptResourceShareInvitation(
            Consumer<AcceptResourceShareInvitationRequest.Builder> acceptResourceShareInvitationRequest) {
        return acceptResourceShareInvitation(AcceptResourceShareInvitationRequest.builder()
                .applyMutation(acceptResourceShareInvitationRequest).build());
    }

    /**
     * <p>
     * Adds the specified list of principals and list of resources to a resource share. Principals that already have
     * access to this resource share immediately receive access to the added resources. Newly added principals
     * immediately receive access to the resources shared in this resource share.
     * </p>
     *
     * @param associateResourceShareRequest
     * @return A Java Future containing the result of the AssociateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>ResourceShareLimitExceededException This request would exceed the limit for resource shares for your
     *         account.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>ThrottlingException You exceeded the rate at which you are allowed to perform this operation. Please
     *         try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.AssociateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceShare" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateResourceShareResponse> associateResourceShare(
            AssociateResourceShareRequest associateResourceShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified list of principals and list of resources to a resource share. Principals that already have
     * access to this resource share immediately receive access to the added resources. Newly added principals
     * immediately receive access to the resources shared in this resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateResourceShareRequest#builder()}
     * </p>
     *
     * @param associateResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResourceShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>ResourceShareLimitExceededException This request would exceed the limit for resource shares for your
     *         account.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>ThrottlingException You exceeded the rate at which you are allowed to perform this operation. Please
     *         try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.AssociateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceShare" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateResourceShareResponse> associateResourceShare(
            Consumer<AssociateResourceShareRequest.Builder> associateResourceShareRequest) {
        return associateResourceShare(AssociateResourceShareRequest.builder().applyMutation(associateResourceShareRequest)
                .build());
    }

    /**
     * <p>
     * Adds or replaces the RAM permission for a resource type included in a resource share. You can have exactly one
     * permission associated with each resource type in the resource share. You can add a new RAM permission only if
     * there are currently no resources of that resource type currently in the resource share.
     * </p>
     *
     * @param associateResourceSharePermissionRequest
     * @return A Java Future containing the result of the AssociateResourceSharePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.AssociateResourceSharePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceSharePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateResourceSharePermissionResponse> associateResourceSharePermission(
            AssociateResourceSharePermissionRequest associateResourceSharePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or replaces the RAM permission for a resource type included in a resource share. You can have exactly one
     * permission associated with each resource type in the resource share. You can add a new RAM permission only if
     * there are currently no resources of that resource type currently in the resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResourceSharePermissionRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateResourceSharePermissionRequest#builder()}
     * </p>
     *
     * @param associateResourceSharePermissionRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResourceSharePermissionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateResourceSharePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.AssociateResourceSharePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceSharePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateResourceSharePermissionResponse> associateResourceSharePermission(
            Consumer<AssociateResourceSharePermissionRequest.Builder> associateResourceSharePermissionRequest) {
        return associateResourceSharePermission(AssociateResourceSharePermissionRequest.builder()
                .applyMutation(associateResourceSharePermissionRequest).build());
    }

    /**
     * <p>
     * Creates a resource share. You can provide a list of the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> for the resources that you want to share, a list of principals you want to share the resources with,
     * and the permissions to grant those principals.
     * </p>
     * <note>
     * <p>
     * Sharing a resource makes it available for use by principals outside of the Amazon Web Services account that
     * created the resource. Sharing doesn't change any permissions or quotas that apply to the resource in the account
     * that created it.
     * </p>
     * </note>
     *
     * @param createResourceShareRequest
     * @return A Java Future containing the result of the CreateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareLimitExceededException This request would exceed the limit for resource shares for your
     *         account.</li>
     *         <li>TagPolicyViolationException The specified tag key is a reserved word and can't be used.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.CreateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateResourceShareResponse> createResourceShare(
            CreateResourceShareRequest createResourceShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource share. You can provide a list of the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> for the resources that you want to share, a list of principals you want to share the resources with,
     * and the permissions to grant those principals.
     * </p>
     * <note>
     * <p>
     * Sharing a resource makes it available for use by principals outside of the Amazon Web Services account that
     * created the resource. Sharing doesn't change any permissions or quotas that apply to the resource in the account
     * that created it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceShareRequest#builder()}
     * </p>
     *
     * @param createResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareLimitExceededException This request would exceed the limit for resource shares for your
     *         account.</li>
     *         <li>TagPolicyViolationException The specified tag key is a reserved word and can't be used.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.CreateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateResourceShareResponse> createResourceShare(
            Consumer<CreateResourceShareRequest.Builder> createResourceShareRequest) {
        return createResourceShare(CreateResourceShareRequest.builder().applyMutation(createResourceShareRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource share. This doesn't delete any of the resources that were associated with the
     * resource share; it only stops the sharing of those resources outside of the Amazon Web Services account that
     * created them.
     * </p>
     *
     * @param deleteResourceShareRequest
     * @return A Java Future containing the result of the DeleteResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.DeleteResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourceShareResponse> deleteResourceShare(
            DeleteResourceShareRequest deleteResourceShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource share. This doesn't delete any of the resources that were associated with the
     * resource share; it only stops the sharing of those resources outside of the Amazon Web Services account that
     * created them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceShareRequest#builder()}
     * </p>
     *
     * @param deleteResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.DeleteResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourceShareResponse> deleteResourceShare(
            Consumer<DeleteResourceShareRequest.Builder> deleteResourceShareRequest) {
        return deleteResourceShare(DeleteResourceShareRequest.builder().applyMutation(deleteResourceShareRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified principals or resources from the specified resource share.
     * </p>
     *
     * @param disassociateResourceShareRequest
     * @return A Java Future containing the result of the DisassociateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>ResourceShareLimitExceededException This request would exceed the limit for resource shares for your
     *         account.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.DisassociateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceShare" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateResourceShareResponse> disassociateResourceShare(
            DisassociateResourceShareRequest disassociateResourceShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified principals or resources from the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResourceShareRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateResourceShareRequest#builder()}
     * </p>
     *
     * @param disassociateResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResourceShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>ResourceShareLimitExceededException This request would exceed the limit for resource shares for your
     *         account.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.DisassociateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceShare" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateResourceShareResponse> disassociateResourceShare(
            Consumer<DisassociateResourceShareRequest.Builder> disassociateResourceShareRequest) {
        return disassociateResourceShare(DisassociateResourceShareRequest.builder()
                .applyMutation(disassociateResourceShareRequest).build());
    }

    /**
     * <p>
     * Disassociates an RAM permission from a resource share. Permission changes take effect immediately. You can remove
     * a RAM permission from a resource share only if there are currently no resources of the relevant resource type
     * currently attached to the resource share.
     * </p>
     *
     * @param disassociateResourceSharePermissionRequest
     * @return A Java Future containing the result of the DisassociateResourceSharePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.DisassociateResourceSharePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceSharePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResourceSharePermissionResponse> disassociateResourceSharePermission(
            DisassociateResourceSharePermissionRequest disassociateResourceSharePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an RAM permission from a resource share. Permission changes take effect immediately. You can remove
     * a RAM permission from a resource share only if there are currently no resources of the relevant resource type
     * currently attached to the resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResourceSharePermissionRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateResourceSharePermissionRequest#builder()}
     * </p>
     *
     * @param disassociateResourceSharePermissionRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResourceSharePermissionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateResourceSharePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.DisassociateResourceSharePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceSharePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResourceSharePermissionResponse> disassociateResourceSharePermission(
            Consumer<DisassociateResourceSharePermissionRequest.Builder> disassociateResourceSharePermissionRequest) {
        return disassociateResourceSharePermission(DisassociateResourceSharePermissionRequest.builder()
                .applyMutation(disassociateResourceSharePermissionRequest).build());
    }

    /**
     * <p>
     * Enables resource sharing within your organization in Organizations. Calling this operation enables RAM to
     * retrieve information about the organization and its structure. This lets you share resources with all of the
     * accounts in an organization by specifying the organization's ID, or all of the accounts in an organizational unit
     * (OU) by specifying the OU's ID. Until you enable sharing within the organization, you can specify only individual
     * Amazon Web Services accounts, or for supported resource types, IAM users and roles.
     * </p>
     * <p>
     * You must call this operation from an IAM user or role in the organization's management account.
     * </p>
     *
     * @param enableSharingWithAwsOrganizationRequest
     * @return A Java Future containing the result of the EnableSharingWithAwsOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.EnableSharingWithAwsOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableSharingWithAwsOrganizationResponse> enableSharingWithAwsOrganization(
            EnableSharingWithAwsOrganizationRequest enableSharingWithAwsOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables resource sharing within your organization in Organizations. Calling this operation enables RAM to
     * retrieve information about the organization and its structure. This lets you share resources with all of the
     * accounts in an organization by specifying the organization's ID, or all of the accounts in an organizational unit
     * (OU) by specifying the OU's ID. Until you enable sharing within the organization, you can specify only individual
     * Amazon Web Services accounts, or for supported resource types, IAM users and roles.
     * </p>
     * <p>
     * You must call this operation from an IAM user or role in the organization's management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSharingWithAwsOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link EnableSharingWithAwsOrganizationRequest#builder()}
     * </p>
     *
     * @param enableSharingWithAwsOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link EnableSharingWithAwsOrganizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EnableSharingWithAwsOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.EnableSharingWithAwsOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableSharingWithAwsOrganizationResponse> enableSharingWithAwsOrganization(
            Consumer<EnableSharingWithAwsOrganizationRequest.Builder> enableSharingWithAwsOrganizationRequest) {
        return enableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest.builder()
                .applyMutation(enableSharingWithAwsOrganizationRequest).build());
    }

    /**
     * <p>
     * Enables resource sharing within your organization in Organizations. Calling this operation enables RAM to
     * retrieve information about the organization and its structure. This lets you share resources with all of the
     * accounts in an organization by specifying the organization's ID, or all of the accounts in an organizational unit
     * (OU) by specifying the OU's ID. Until you enable sharing within the organization, you can specify only individual
     * Amazon Web Services accounts, or for supported resource types, IAM users and roles.
     * </p>
     * <p>
     * You must call this operation from an IAM user or role in the organization's management account.
     * </p>
     *
     * @return A Java Future containing the result of the EnableSharingWithAwsOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.EnableSharingWithAwsOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableSharingWithAwsOrganizationResponse> enableSharingWithAwsOrganization() {
        return enableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest.builder().build());
    }

    /**
     * <p>
     * Gets the contents of an RAM permission in JSON format.
     * </p>
     *
     * @param getPermissionRequest
     * @return A Java Future containing the result of the GetPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPermissionResponse> getPermission(GetPermissionRequest getPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the contents of an RAM permission in JSON format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link GetPermissionRequest#builder()}
     * </p>
     *
     * @param getPermissionRequest
     *        A {@link Consumer} that will call methods on {@link GetPermissionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPermissionResponse> getPermission(Consumer<GetPermissionRequest.Builder> getPermissionRequest) {
        return getPermission(GetPermissionRequest.builder().applyMutation(getPermissionRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource policies for the specified resources that you own and have shared.
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return A Java Future containing the result of the GetResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ResourceArnNotFoundException The specified Amazon Resource Name (ARN) was not found.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePoliciesResponse> getResourcePolicies(
            GetResourcePoliciesRequest getResourcePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource policies for the specified resources that you own and have shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ResourceArnNotFoundException The specified Amazon Resource Name (ARN) was not found.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePoliciesResponse> getResourcePolicies(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) {
        return getResourcePolicies(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource policies for the specified resources that you own and have shared.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation.</b>
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ResourceArnNotFoundException The specified Amazon Resource Name (ARN) was not found.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesPublisher getResourcePoliciesPaginator(GetResourcePoliciesRequest getResourcePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource policies for the specified resources that you own and have shared.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ResourceArnNotFoundException The specified Amazon Resource Name (ARN) was not found.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesPublisher getResourcePoliciesPaginator(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) {
        return getResourcePoliciesPaginator(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the resource and principal associations for resource shares that you own.
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     * @return A Java Future containing the result of the GetResourceShareAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceShareAssociationsResponse> getResourceShareAssociations(
            GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource and principal associations for resource shares that you own.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareAssociationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareAssociationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetResourceShareAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceShareAssociationsResponse> getResourceShareAssociations(
            Consumer<GetResourceShareAssociationsRequest.Builder> getResourceShareAssociationsRequest) {
        return getResourceShareAssociations(GetResourceShareAssociationsRequest.builder()
                .applyMutation(getResourceShareAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource and principal associations for resource shares that you own.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsPublisher publisher = client.getResourceShareAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsPublisher publisher = client.getResourceShareAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareAssociationsPublisher getResourceShareAssociationsPaginator(
            GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource and principal associations for resource shares that you own.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsPublisher publisher = client.getResourceShareAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsPublisher publisher = client.getResourceShareAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareAssociationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareAssociationsPublisher getResourceShareAssociationsPaginator(
            Consumer<GetResourceShareAssociationsRequest.Builder> getResourceShareAssociationsRequest) {
        return getResourceShareAssociationsPaginator(GetResourceShareAssociationsRequest.builder()
                .applyMutation(getResourceShareAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     * @return A Java Future containing the result of the GetResourceShareInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>InvalidMaxResultsException The specified value for <code>MaxResults</code> is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceShareInvitationsResponse> getResourceShareInvitations(
            GetResourceShareInvitationsRequest getResourceShareInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareInvitationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareInvitationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareInvitationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetResourceShareInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>InvalidMaxResultsException The specified value for <code>MaxResults</code> is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceShareInvitationsResponse> getResourceShareInvitations(
            Consumer<GetResourceShareInvitationsRequest.Builder> getResourceShareInvitationsRequest) {
        return getResourceShareInvitations(GetResourceShareInvitationsRequest.builder()
                .applyMutation(getResourceShareInvitationsRequest).build());
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     *
     * @return A Java Future containing the result of the GetResourceShareInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>InvalidMaxResultsException The specified value for <code>MaxResults</code> is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceShareInvitationsResponse> getResourceShareInvitations() {
        return getResourceShareInvitations(GetResourceShareInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>InvalidMaxResultsException The specified value for <code>MaxResults</code> is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsPublisher getResourceShareInvitationsPaginator() {
        return getResourceShareInvitationsPaginator(GetResourceShareInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>InvalidMaxResultsException The specified value for <code>MaxResults</code> is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsPublisher getResourceShareInvitationsPaginator(
            GetResourceShareInvitationsRequest getResourceShareInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about invitations that you have received for resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareInvitationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareInvitationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareInvitationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>InvalidMaxResultsException The specified value for <code>MaxResults</code> is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsPublisher getResourceShareInvitationsPaginator(
            Consumer<GetResourceShareInvitationsRequest.Builder> getResourceShareInvitationsRequest) {
        return getResourceShareInvitationsPaginator(GetResourceShareInvitationsRequest.builder()
                .applyMutation(getResourceShareInvitationsRequest).build());
    }

    /**
     * <p>
     * Retrieves details about the resource shares that you own or that are shared with you.
     * </p>
     *
     * @param getResourceSharesRequest
     * @return A Java Future containing the result of the GetResourceShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourceSharesResponse> getResourceShares(GetResourceSharesRequest getResourceSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about the resource shares that you own or that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSharesRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourceSharesRequest#builder()}
     * </p>
     *
     * @param getResourceSharesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceSharesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourceShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourceSharesResponse> getResourceShares(
            Consumer<GetResourceSharesRequest.Builder> getResourceSharesRequest) {
        return getResourceShares(GetResourceSharesRequest.builder().applyMutation(getResourceSharesRequest).build());
    }

    /**
     * <p>
     * Retrieves details about the resource shares that you own or that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesPublisher publisher = client.getResourceSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesPublisher publisher = client.getResourceSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation.</b>
     * </p>
     *
     * @param getResourceSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourceSharesPublisher getResourceSharesPaginator(GetResourceSharesRequest getResourceSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about the resource shares that you own or that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesPublisher publisher = client.getResourceSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesPublisher publisher = client.getResourceSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSharesRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourceSharesRequest#builder()}
     * </p>
     *
     * @param getResourceSharesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceSharesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourceSharesPublisher getResourceSharesPaginator(
            Consumer<GetResourceSharesRequest.Builder> getResourceSharesRequest) {
        return getResourceSharesPaginator(GetResourceSharesRequest.builder().applyMutation(getResourceSharesRequest).build());
    }

    /**
     * <p>
     * Lists the resources in a resource share that is shared with you but for which the invitation is still
     * <code>PENDING</code>. That means that you haven't accepted or rejected the invitation and the invitation hasn't
     * expired.
     * </p>
     *
     * @param listPendingInvitationResourcesRequest
     * @return A Java Future containing the result of the ListPendingInvitationResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>MissingRequiredParameterException A required input parameter is missing.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The specified invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The specified invitation is expired.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPendingInvitationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPendingInvitationResourcesResponse> listPendingInvitationResources(
            ListPendingInvitationResourcesRequest listPendingInvitationResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources in a resource share that is shared with you but for which the invitation is still
     * <code>PENDING</code>. That means that you haven't accepted or rejected the invitation and the invitation hasn't
     * expired.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPendingInvitationResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPendingInvitationResourcesRequest#builder()}
     * </p>
     *
     * @param listPendingInvitationResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListPendingInvitationResourcesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPendingInvitationResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>MissingRequiredParameterException A required input parameter is missing.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The specified invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The specified invitation is expired.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPendingInvitationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPendingInvitationResourcesResponse> listPendingInvitationResources(
            Consumer<ListPendingInvitationResourcesRequest.Builder> listPendingInvitationResourcesRequest) {
        return listPendingInvitationResources(ListPendingInvitationResourcesRequest.builder()
                .applyMutation(listPendingInvitationResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the resources in a resource share that is shared with you but for which the invitation is still
     * <code>PENDING</code>. That means that you haven't accepted or rejected the invitation and the invitation hasn't
     * expired.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPendingInvitationResources(software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesPublisher publisher = client.listPendingInvitationResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesPublisher publisher = client.listPendingInvitationResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPendingInvitationResources(software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPendingInvitationResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>MissingRequiredParameterException A required input parameter is missing.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The specified invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The specified invitation is expired.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPendingInvitationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPendingInvitationResourcesPublisher listPendingInvitationResourcesPaginator(
            ListPendingInvitationResourcesRequest listPendingInvitationResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources in a resource share that is shared with you but for which the invitation is still
     * <code>PENDING</code>. That means that you haven't accepted or rejected the invitation and the invitation hasn't
     * expired.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPendingInvitationResources(software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesPublisher publisher = client.listPendingInvitationResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesPublisher publisher = client.listPendingInvitationResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPendingInvitationResources(software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPendingInvitationResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPendingInvitationResourcesRequest#builder()}
     * </p>
     *
     * @param listPendingInvitationResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListPendingInvitationResourcesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>MissingRequiredParameterException A required input parameter is missing.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The specified invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The specified invitation is expired.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPendingInvitationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPendingInvitationResourcesPublisher listPendingInvitationResourcesPaginator(
            Consumer<ListPendingInvitationResourcesRequest.Builder> listPendingInvitationResourcesRequest) {
        return listPendingInvitationResourcesPaginator(ListPendingInvitationResourcesRequest.builder()
                .applyMutation(listPendingInvitationResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the available versions of the specified RAM permission.
     * </p>
     *
     * @param listPermissionVersionsRequest
     * @return A Java Future containing the result of the ListPermissionVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPermissionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPermissionVersionsResponse> listPermissionVersions(
            ListPermissionVersionsRequest listPermissionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available versions of the specified RAM permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPermissionVersionsRequest#builder()}
     * </p>
     *
     * @param listPermissionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPermissionVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPermissionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPermissionVersionsResponse> listPermissionVersions(
            Consumer<ListPermissionVersionsRequest.Builder> listPermissionVersionsRequest) {
        return listPermissionVersions(ListPermissionVersionsRequest.builder().applyMutation(listPermissionVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the available versions of the specified RAM permission.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionVersions(software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsPublisher publisher = client.listPermissionVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsPublisher publisher = client.listPermissionVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionVersions(software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPermissionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionVersionsPublisher listPermissionVersionsPaginator(
            ListPermissionVersionsRequest listPermissionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available versions of the specified RAM permission.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionVersions(software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsPublisher publisher = client.listPermissionVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionVersionsPublisher publisher = client.listPermissionVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionVersions(software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPermissionVersionsRequest#builder()}
     * </p>
     *
     * @param listPermissionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPermissionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionVersionsPublisher listPermissionVersionsPaginator(
            Consumer<ListPermissionVersionsRequest.Builder> listPermissionVersionsRequest) {
        return listPermissionVersionsPaginator(ListPermissionVersionsRequest.builder()
                .applyMutation(listPermissionVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of available RAM permissions that you can use for the supported resource types.
     * </p>
     *
     * @param listPermissionsRequest
     * @return A Java Future containing the result of the ListPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPermissionsResponse> listPermissions(ListPermissionsRequest listPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of available RAM permissions that you can use for the supported resource types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPermissionsResponse> listPermissions(
            Consumer<ListPermissionsRequest.Builder> listPermissionsRequest) {
        return listPermissions(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of available RAM permissions that you can use for the supported resource types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPermissions(software.amazon.awssdk.services.ram.model.ListPermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionsPublisher publisher = client.listPermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionsPublisher publisher = client.listPermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListPermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListPermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.ram.model.ListPermissionsRequest)} operation.</b>
     * </p>
     *
     * @param listPermissionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsPublisher listPermissionsPaginator(ListPermissionsRequest listPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of available RAM permissions that you can use for the supported resource types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPermissions(software.amazon.awssdk.services.ram.model.ListPermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionsPublisher publisher = client.listPermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPermissionsPublisher publisher = client.listPermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListPermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListPermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.ram.model.ListPermissionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsPublisher listPermissionsPaginator(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest) {
        return listPermissionsPaginator(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists the principals that you are sharing resources with or that are sharing resources with you.
     * </p>
     *
     * @param listPrincipalsRequest
     * @return A Java Future containing the result of the ListPrincipals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPrincipals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPrincipalsResponse> listPrincipals(ListPrincipalsRequest listPrincipalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the principals that you are sharing resources with or that are sharing resources with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPrincipalsRequest#builder()}
     * </p>
     *
     * @param listPrincipalsRequest
     *        A {@link Consumer} that will call methods on {@link ListPrincipalsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPrincipals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPrincipals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPrincipalsResponse> listPrincipals(Consumer<ListPrincipalsRequest.Builder> listPrincipalsRequest) {
        return listPrincipals(ListPrincipalsRequest.builder().applyMutation(listPrincipalsRequest).build());
    }

    /**
     * <p>
     * Lists the principals that you are sharing resources with or that are sharing resources with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsPublisher publisher = client.listPrincipalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsPublisher publisher = client.listPrincipalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListPrincipalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListPrincipalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)} operation.</b>
     * </p>
     *
     * @param listPrincipalsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPrincipals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPrincipalsPublisher listPrincipalsPaginator(ListPrincipalsRequest listPrincipalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the principals that you are sharing resources with or that are sharing resources with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsPublisher publisher = client.listPrincipalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsPublisher publisher = client.listPrincipalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListPrincipalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListPrincipalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPrincipalsRequest#builder()}
     * </p>
     *
     * @param listPrincipalsRequest
     *        A {@link Consumer} that will call methods on {@link ListPrincipalsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPrincipals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPrincipalsPublisher listPrincipalsPaginator(Consumer<ListPrincipalsRequest.Builder> listPrincipalsRequest) {
        return listPrincipalsPaginator(ListPrincipalsRequest.builder().applyMutation(listPrincipalsRequest).build());
    }

    /**
     * <p>
     * Lists the RAM permissions that are associated with a resource share.
     * </p>
     *
     * @param listResourceSharePermissionsRequest
     * @return A Java Future containing the result of the ListResourceSharePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResourceSharePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceSharePermissionsResponse> listResourceSharePermissions(
            ListResourceSharePermissionsRequest listResourceSharePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the RAM permissions that are associated with a resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceSharePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceSharePermissionsRequest#builder()}
     * </p>
     *
     * @param listResourceSharePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceSharePermissionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListResourceSharePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResourceSharePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceSharePermissionsResponse> listResourceSharePermissions(
            Consumer<ListResourceSharePermissionsRequest.Builder> listResourceSharePermissionsRequest) {
        return listResourceSharePermissions(ListResourceSharePermissionsRequest.builder()
                .applyMutation(listResourceSharePermissionsRequest).build());
    }

    /**
     * <p>
     * Lists the RAM permissions that are associated with a resource share.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceSharePermissions(software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsPublisher publisher = client.listResourceSharePermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsPublisher publisher = client.listResourceSharePermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceSharePermissions(software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceSharePermissionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResourceSharePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSharePermissionsPublisher listResourceSharePermissionsPaginator(
            ListResourceSharePermissionsRequest listResourceSharePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the RAM permissions that are associated with a resource share.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceSharePermissions(software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsPublisher publisher = client.listResourceSharePermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceSharePermissionsPublisher publisher = client.listResourceSharePermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceSharePermissions(software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceSharePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceSharePermissionsRequest#builder()}
     * </p>
     *
     * @param listResourceSharePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceSharePermissionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResourceSharePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSharePermissionsPublisher listResourceSharePermissionsPaginator(
            Consumer<ListResourceSharePermissionsRequest.Builder> listResourceSharePermissionsRequest) {
        return listResourceSharePermissionsPaginator(ListResourceSharePermissionsRequest.builder()
                .applyMutation(listResourceSharePermissionsRequest).build());
    }

    /**
     * <p>
     * Lists the resource types that can be shared by RAM.
     * </p>
     *
     * @param listResourceTypesRequest
     * @return A Java Future containing the result of the ListResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourceTypesResponse> listResourceTypes(ListResourceTypesRequest listResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource types that can be shared by RAM.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListResourceTypesRequest#builder()}
     * </p>
     *
     * @param listResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceTypesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourceTypesResponse> listResourceTypes(
            Consumer<ListResourceTypesRequest.Builder> listResourceTypesRequest) {
        return listResourceTypes(ListResourceTypesRequest.builder().applyMutation(listResourceTypesRequest).build());
    }

    /**
     * <p>
     * Lists the resource types that can be shared by RAM.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceTypes(software.amazon.awssdk.services.ram.model.ListResourceTypesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceTypesPublisher publisher = client.listResourceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceTypesPublisher publisher = client.listResourceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListResourceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListResourceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceTypes(software.amazon.awssdk.services.ram.model.ListResourceTypesRequest)} operation.</b>
     * </p>
     *
     * @param listResourceTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceTypesPublisher listResourceTypesPaginator(ListResourceTypesRequest listResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource types that can be shared by RAM.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceTypes(software.amazon.awssdk.services.ram.model.ListResourceTypesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceTypesPublisher publisher = client.listResourceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourceTypesPublisher publisher = client.listResourceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListResourceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListResourceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceTypes(software.amazon.awssdk.services.ram.model.ListResourceTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListResourceTypesRequest#builder()}
     * </p>
     *
     * @param listResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceTypesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceTypesPublisher listResourceTypesPaginator(
            Consumer<ListResourceTypesRequest.Builder> listResourceTypesRequest) {
        return listResourceTypesPaginator(ListResourceTypesRequest.builder().applyMutation(listResourceTypesRequest).build());
    }

    /**
     * <p>
     * Lists the resources that you added to a resource share or the resources that are shared with you.
     * </p>
     *
     * @param listResourcesRequest
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The specified resource type is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourcesResponse> listResources(ListResourcesRequest listResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources that you added to a resource share or the resources that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The specified resource type is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourcesResponse> listResources(Consumer<ListResourcesRequest.Builder> listResourcesRequest) {
        return listResources(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the resources that you added to a resource share or the resources that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The specified resource type is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesPublisher listResourcesPaginator(ListResourcesRequest listResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources that you added to a resource share or the resources that are shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The specified resource type is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for <code>NextToken</code> is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesPublisher listResourcesPaginator(Consumer<ListResourcesRequest.Builder> listResourcesRequest) {
        return listResourcesPaginator(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * When you attach a resource-based permission policy to a resource, it automatically creates a resource share.
     * However, resource shares created this way are visible only to the resource share owner, and the resource share
     * can't be modified in RAM.
     * </p>
     * <p>
     * You can use this operation to promote the resource share to a full RAM resource share. When you promote a
     * resource share, you can then manage the resource share in RAM and it becomes visible to all of the principals you
     * shared it with.
     * </p>
     *
     * @param promoteResourceShareCreatedFromPolicyRequest
     * @return A Java Future containing the result of the PromoteResourceShareCreatedFromPolicy operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceShareLimitExceededException This request would exceed the limit for resource shares for your
     *         account.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required input parameter is missing.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.PromoteResourceShareCreatedFromPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromoteResourceShareCreatedFromPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PromoteResourceShareCreatedFromPolicyResponse> promoteResourceShareCreatedFromPolicy(
            PromoteResourceShareCreatedFromPolicyRequest promoteResourceShareCreatedFromPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When you attach a resource-based permission policy to a resource, it automatically creates a resource share.
     * However, resource shares created this way are visible only to the resource share owner, and the resource share
     * can't be modified in RAM.
     * </p>
     * <p>
     * You can use this operation to promote the resource share to a full RAM resource share. When you promote a
     * resource share, you can then manage the resource share in RAM and it becomes visible to all of the principals you
     * shared it with.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PromoteResourceShareCreatedFromPolicyRequest.Builder} avoiding the need to create one manually via
     * {@link PromoteResourceShareCreatedFromPolicyRequest#builder()}
     * </p>
     *
     * @param promoteResourceShareCreatedFromPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PromoteResourceShareCreatedFromPolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PromoteResourceShareCreatedFromPolicy operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceShareLimitExceededException This request would exceed the limit for resource shares for your
     *         account.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required input parameter is missing.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.PromoteResourceShareCreatedFromPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromoteResourceShareCreatedFromPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PromoteResourceShareCreatedFromPolicyResponse> promoteResourceShareCreatedFromPolicy(
            Consumer<PromoteResourceShareCreatedFromPolicyRequest.Builder> promoteResourceShareCreatedFromPolicyRequest) {
        return promoteResourceShareCreatedFromPolicy(PromoteResourceShareCreatedFromPolicyRequest.builder()
                .applyMutation(promoteResourceShareCreatedFromPolicyRequest).build());
    }

    /**
     * <p>
     * Rejects an invitation to a resource share from another Amazon Web Services account.
     * </p>
     *
     * @param rejectResourceShareInvitationRequest
     * @return A Java Future containing the result of the RejectResourceShareInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>ResourceShareInvitationAlreadyAcceptedException The specified invitation was already accepted.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The specified invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The specified invitation is expired.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.RejectResourceShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/RejectResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectResourceShareInvitationResponse> rejectResourceShareInvitation(
            RejectResourceShareInvitationRequest rejectResourceShareInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects an invitation to a resource share from another Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectResourceShareInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link RejectResourceShareInvitationRequest#builder()}
     * </p>
     *
     * @param rejectResourceShareInvitationRequest
     *        A {@link Consumer} that will call methods on {@link RejectResourceShareInvitationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RejectResourceShareInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The specified Amazon Resource Name (ARN) for an
     *         invitation was not found.</li>
     *         <li>ResourceShareInvitationAlreadyAcceptedException The specified invitation was already accepted.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The specified invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The specified invitation is expired.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.RejectResourceShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/RejectResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectResourceShareInvitationResponse> rejectResourceShareInvitation(
            Consumer<RejectResourceShareInvitationRequest.Builder> rejectResourceShareInvitationRequest) {
        return rejectResourceShareInvitation(RejectResourceShareInvitationRequest.builder()
                .applyMutation(rejectResourceShareInvitationRequest).build());
    }

    /**
     * <p>
     * Adds the specified tag keys and values to the specified resource share. The tags are attached only to the
     * resource share, not to the resources that are in the resource share.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>TagLimitExceededException This request would exceed the limit for tags for your account.</li>
     *         <li>ResourceArnNotFoundException The specified Amazon Resource Name (ARN) was not found.</li>
     *         <li>TagPolicyViolationException The specified tag key is a reserved word and can't be used.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tag keys and values to the specified resource share. The tags are attached only to the
     * resource share, not to the resources that are in the resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>TagLimitExceededException This request would exceed the limit for tags for your account.</li>
     *         <li>ResourceArnNotFoundException The specified Amazon Resource Name (ARN) was not found.</li>
     *         <li>TagPolicyViolationException The specified tag key is a reserved word and can't be used.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tag key and value pairs from the specified resource share.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tag key and value pairs from the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies some of the properties of the specified resource share.
     * </p>
     *
     * @param updateResourceShareRequest
     * @return A Java Future containing the result of the UpdateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>MissingRequiredParameterException A required input parameter is missing.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.UpdateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UpdateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateResourceShareResponse> updateResourceShare(
            UpdateResourceShareRequest updateResourceShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies some of the properties of the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourceShareRequest#builder()}
     * </p>
     *
     * @param updateResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException The client token input parameter was matched one used with a
     *         previous call to the operation, but at least one of the other input parameters is different from the
     *         previous call.</li>
     *         <li>MissingRequiredParameterException A required input parameter is missing.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException The client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.UpdateResourceShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UpdateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateResourceShareResponse> updateResourceShare(
            Consumer<UpdateResourceShareRequest.Builder> updateResourceShareRequest) {
        return updateResourceShare(UpdateResourceShareRequest.builder().applyMutation(updateResourceShareRequest).build());
    }

    @Override
    default RamServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link RamAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RamAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RamAsyncClient}.
     */
    static RamAsyncClientBuilder builder() {
        return new DefaultRamAsyncClientBuilder();
    }
}
