/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPermissionAssociationsRequest extends RamRequest implements
        ToCopyableBuilder<ListPermissionAssociationsRequest.Builder, ListPermissionAssociationsRequest> {
    private static final SdkField<String> PERMISSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionArn").getter(getter(ListPermissionAssociationsRequest::permissionArn))
            .setter(setter(Builder::permissionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArn").build()).build();

    private static final SdkField<Integer> PERMISSION_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("permissionVersion").getter(getter(ListPermissionAssociationsRequest::permissionVersion))
            .setter(setter(Builder::permissionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionVersion").build()).build();

    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationStatus").getter(getter(ListPermissionAssociationsRequest::associationStatusAsString))
            .setter(setter(Builder::associationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationStatus").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ListPermissionAssociationsRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> FEATURE_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("featureSet").getter(getter(ListPermissionAssociationsRequest::featureSetAsString))
            .setter(setter(Builder::featureSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureSet").build()).build();

    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("defaultVersion").getter(getter(ListPermissionAssociationsRequest::defaultVersion))
            .setter(setter(Builder::defaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersion").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPermissionAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListPermissionAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_ARN_FIELD,
            PERMISSION_VERSION_FIELD, ASSOCIATION_STATUS_FIELD, RESOURCE_TYPE_FIELD, FEATURE_SET_FIELD, DEFAULT_VERSION_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String permissionArn;

    private final Integer permissionVersion;

    private final String associationStatus;

    private final String resourceType;

    private final String featureSet;

    private final Boolean defaultVersion;

    private final String nextToken;

    private final Integer maxResults;

    private ListPermissionAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.permissionArn = builder.permissionArn;
        this.permissionVersion = builder.permissionVersion;
        this.associationStatus = builder.associationStatus;
        this.resourceType = builder.resourceType;
        this.featureSet = builder.featureSet;
        this.defaultVersion = builder.defaultVersion;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Name (ARN)</a> of the managed permission.
     * </p>
     * 
     * @return Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Name (ARN)</a> of the managed permission.
     */
    public final String permissionArn() {
        return permissionArn;
    }

    /**
     * <p>
     * Specifies that you want to list only those associations with resource shares that use this version of the managed
     * permission. If you don't provide a value for this parameter, then the operation returns information about
     * associations with resource shares that use any version of the managed permission.
     * </p>
     * 
     * @return Specifies that you want to list only those associations with resource shares that use this version of the
     *         managed permission. If you don't provide a value for this parameter, then the operation returns
     *         information about associations with resource shares that use any version of the managed permission.
     */
    public final Integer permissionVersion() {
        return permissionVersion;
    }

    /**
     * <p>
     * Specifies that you want to list only those associations with resource shares that match this status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link ResourceShareAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return Specifies that you want to list only those associations with resource shares that match this status.
     * @see ResourceShareAssociationStatus
     */
    public final ResourceShareAssociationStatus associationStatus() {
        return ResourceShareAssociationStatus.fromValue(associationStatus);
    }

    /**
     * <p>
     * Specifies that you want to list only those associations with resource shares that match this status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link ResourceShareAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return Specifies that you want to list only those associations with resource shares that match this status.
     * @see ResourceShareAssociationStatus
     */
    public final String associationStatusAsString() {
        return associationStatus;
    }

    /**
     * <p>
     * Specifies that you want to list only those associations with resource shares that include at least one resource
     * of this resource type.
     * </p>
     * 
     * @return Specifies that you want to list only those associations with resource shares that include at least one
     *         resource of this resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Specifies that you want to list only those associations with resource shares that have a <code>featureSet</code>
     * with this value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureSet} will
     * return {@link PermissionFeatureSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureSetAsString}.
     * </p>
     * 
     * @return Specifies that you want to list only those associations with resource shares that have a
     *         <code>featureSet</code> with this value.
     * @see PermissionFeatureSet
     */
    public final PermissionFeatureSet featureSet() {
        return PermissionFeatureSet.fromValue(featureSet);
    }

    /**
     * <p>
     * Specifies that you want to list only those associations with resource shares that have a <code>featureSet</code>
     * with this value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureSet} will
     * return {@link PermissionFeatureSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureSetAsString}.
     * </p>
     * 
     * @return Specifies that you want to list only those associations with resource shares that have a
     *         <code>featureSet</code> with this value.
     * @see PermissionFeatureSet
     */
    public final String featureSetAsString() {
        return featureSet;
    }

    /**
     * <p>
     * When <code>true</code>, specifies that you want to list only those associations with resource shares that use the
     * default version of the specified managed permission.
     * </p>
     * <p>
     * When <code>false</code> (the default value), lists associations with resource shares that use any version of the
     * specified managed permission.
     * </p>
     * 
     * @return When <code>true</code>, specifies that you want to list only those associations with resource shares that
     *         use the default version of the specified managed permission.</p>
     *         <p>
     *         When <code>false</code> (the default value), lists associations with resource shares that use any version
     *         of the specified managed permission.
     */
    public final Boolean defaultVersion() {
        return defaultVersion;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>NextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the total number of results that you want included on each page of the response. If you do not include
     * this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the
     * number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the
     * specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next
     * part of the results. Note that the service might return fewer results than the maximum even when there are more
     * results available. You should check <code>NextToken</code> after every operation to ensure that you receive all
     * of the results.
     * </p>
     * 
     * @return Specifies the total number of results that you want included on each page of the response. If you do not
     *         include this parameter, it defaults to a value that is specific to the operation. If additional items
     *         exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value
     *         (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call
     *         to the operation to get the next part of the results. Note that the service might return fewer results
     *         than the maximum even when there are more results available. You should check <code>NextToken</code>
     *         after every operation to ensure that you receive all of the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(permissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(featureSetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionAssociationsRequest)) {
            return false;
        }
        ListPermissionAssociationsRequest other = (ListPermissionAssociationsRequest) obj;
        return Objects.equals(permissionArn(), other.permissionArn())
                && Objects.equals(permissionVersion(), other.permissionVersion())
                && Objects.equals(associationStatusAsString(), other.associationStatusAsString())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(featureSetAsString(), other.featureSetAsString())
                && Objects.equals(defaultVersion(), other.defaultVersion()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPermissionAssociationsRequest").add("PermissionArn", permissionArn())
                .add("PermissionVersion", permissionVersion()).add("AssociationStatus", associationStatusAsString())
                .add("ResourceType", resourceType()).add("FeatureSet", featureSetAsString())
                .add("DefaultVersion", defaultVersion()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permissionArn":
            return Optional.ofNullable(clazz.cast(permissionArn()));
        case "permissionVersion":
            return Optional.ofNullable(clazz.cast(permissionVersion()));
        case "associationStatus":
            return Optional.ofNullable(clazz.cast(associationStatusAsString()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "featureSet":
            return Optional.ofNullable(clazz.cast(featureSetAsString()));
        case "defaultVersion":
            return Optional.ofNullable(clazz.cast(defaultVersion()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionAssociationsRequest, T> g) {
        return obj -> g.apply((ListPermissionAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPermissionAssociationsRequest> {
        /**
         * <p>
         * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Name (ARN)</a> of the managed permission.
         * </p>
         * 
         * @param permissionArn
         *        Specifies the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of the managed permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionArn(String permissionArn);

        /**
         * <p>
         * Specifies that you want to list only those associations with resource shares that use this version of the
         * managed permission. If you don't provide a value for this parameter, then the operation returns information
         * about associations with resource shares that use any version of the managed permission.
         * </p>
         * 
         * @param permissionVersion
         *        Specifies that you want to list only those associations with resource shares that use this version of
         *        the managed permission. If you don't provide a value for this parameter, then the operation returns
         *        information about associations with resource shares that use any version of the managed permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionVersion(Integer permissionVersion);

        /**
         * <p>
         * Specifies that you want to list only those associations with resource shares that match this status.
         * </p>
         * 
         * @param associationStatus
         *        Specifies that you want to list only those associations with resource shares that match this status.
         * @see ResourceShareAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationStatus
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * Specifies that you want to list only those associations with resource shares that match this status.
         * </p>
         * 
         * @param associationStatus
         *        Specifies that you want to list only those associations with resource shares that match this status.
         * @see ResourceShareAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationStatus
         */
        Builder associationStatus(ResourceShareAssociationStatus associationStatus);

        /**
         * <p>
         * Specifies that you want to list only those associations with resource shares that include at least one
         * resource of this resource type.
         * </p>
         * 
         * @param resourceType
         *        Specifies that you want to list only those associations with resource shares that include at least one
         *        resource of this resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies that you want to list only those associations with resource shares that have a
         * <code>featureSet</code> with this value.
         * </p>
         * 
         * @param featureSet
         *        Specifies that you want to list only those associations with resource shares that have a
         *        <code>featureSet</code> with this value.
         * @see PermissionFeatureSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionFeatureSet
         */
        Builder featureSet(String featureSet);

        /**
         * <p>
         * Specifies that you want to list only those associations with resource shares that have a
         * <code>featureSet</code> with this value.
         * </p>
         * 
         * @param featureSet
         *        Specifies that you want to list only those associations with resource shares that have a
         *        <code>featureSet</code> with this value.
         * @see PermissionFeatureSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionFeatureSet
         */
        Builder featureSet(PermissionFeatureSet featureSet);

        /**
         * <p>
         * When <code>true</code>, specifies that you want to list only those associations with resource shares that use
         * the default version of the specified managed permission.
         * </p>
         * <p>
         * When <code>false</code> (the default value), lists associations with resource shares that use any version of
         * the specified managed permission.
         * </p>
         * 
         * @param defaultVersion
         *        When <code>true</code>, specifies that you want to list only those associations with resource shares
         *        that use the default version of the specified managed permission.</p>
         *        <p>
         *        When <code>false</code> (the default value), lists associations with resource shares that use any
         *        version of the specified managed permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersion(Boolean defaultVersion);

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the total number of results that you want included on each page of the response. If you do not
         * include this parameter, it defaults to a value that is specific to the operation. If additional items exist
         * beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
         * null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the
         * operation to get the next part of the results. Note that the service might return fewer results than the
         * maximum even when there are more results available. You should check <code>NextToken</code> after every
         * operation to ensure that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        Specifies the total number of results that you want included on each page of the response. If you do
         *        not include this parameter, it defaults to a value that is specific to the operation. If additional
         *        items exist beyond the number you specify, the <code>NextToken</code> response element is returned
         *        with a value (not null). Include the specified value as the <code>NextToken</code> request parameter
         *        in the next call to the operation to get the next part of the results. Note that the service might
         *        return fewer results than the maximum even when there are more results available. You should check
         *        <code>NextToken</code> after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String permissionArn;

        private Integer permissionVersion;

        private String associationStatus;

        private String resourceType;

        private String featureSet;

        private Boolean defaultVersion;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionAssociationsRequest model) {
            super(model);
            permissionArn(model.permissionArn);
            permissionVersion(model.permissionVersion);
            associationStatus(model.associationStatus);
            resourceType(model.resourceType);
            featureSet(model.featureSet);
            defaultVersion(model.defaultVersion);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getPermissionArn() {
            return permissionArn;
        }

        public final void setPermissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
        }

        @Override
        public final Builder permissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
            return this;
        }

        public final Integer getPermissionVersion() {
            return permissionVersion;
        }

        public final void setPermissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
        }

        @Override
        public final Builder permissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
            return this;
        }

        public final String getAssociationStatus() {
            return associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(ResourceShareAssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getFeatureSet() {
            return featureSet;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(PermissionFeatureSet featureSet) {
            this.featureSet(featureSet == null ? null : featureSet.toString());
            return this;
        }

        public final Boolean getDefaultVersion() {
            return defaultVersion;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPermissionAssociationsRequest build() {
            return new ListPermissionAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
