/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateResourceShareResponse extends RamResponse implements
        ToCopyableBuilder<DisassociateResourceShareResponse.Builder, DisassociateResourceShareResponse> {
    private static final SdkField<List<ResourceShareAssociation>> RESOURCE_SHARE_ASSOCIATIONS_FIELD = SdkField
            .<List<ResourceShareAssociation>> builder(MarshallingType.LIST)
            .getter(getter(DisassociateResourceShareResponse::resourceShareAssociations))
            .setter(setter(Builder::resourceShareAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceShareAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceShareAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DisassociateResourceShareResponse::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_SHARE_ASSOCIATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private final List<ResourceShareAssociation> resourceShareAssociations;

    private final String clientToken;

    private DisassociateResourceShareResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShareAssociations = builder.resourceShareAssociations;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the associations.
     */
    public List<ResourceShareAssociation> resourceShareAssociations() {
        return resourceShareAssociations;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResourceShareResponse)) {
            return false;
        }
        DisassociateResourceShareResponse other = (DisassociateResourceShareResponse) obj;
        return Objects.equals(resourceShareAssociations(), other.resourceShareAssociations())
                && Objects.equals(clientToken(), other.clientToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DisassociateResourceShareResponse")
                .add("ResourceShareAssociations", resourceShareAssociations()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareAssociations":
            return Optional.ofNullable(clazz.cast(resourceShareAssociations()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResourceShareResponse, T> g) {
        return obj -> g.apply((DisassociateResourceShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateResourceShareResponse> {
        /**
         * <p>
         * Information about the associations.
         * </p>
         * 
         * @param resourceShareAssociations
         *        Information about the associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareAssociations(Collection<ResourceShareAssociation> resourceShareAssociations);

        /**
         * <p>
         * Information about the associations.
         * </p>
         * 
         * @param resourceShareAssociations
         *        Information about the associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareAssociations(ResourceShareAssociation... resourceShareAssociations);

        /**
         * <p>
         * Information about the associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceShareAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<ResourceShareAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceShareAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceShareAssociations(List<ResourceShareAssociation>)}.
         * 
         * @param resourceShareAssociations
         *        a consumer that will call methods on {@link List<ResourceShareAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceShareAssociations(List<ResourceShareAssociation>)
         */
        Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder>... resourceShareAssociations);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private List<ResourceShareAssociation> resourceShareAssociations = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResourceShareResponse model) {
            super(model);
            resourceShareAssociations(model.resourceShareAssociations);
            clientToken(model.clientToken);
        }

        public final Collection<ResourceShareAssociation.Builder> getResourceShareAssociations() {
            return resourceShareAssociations != null ? resourceShareAssociations.stream()
                    .map(ResourceShareAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceShareAssociations(Collection<ResourceShareAssociation> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copy(resourceShareAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareAssociations(ResourceShareAssociation... resourceShareAssociations) {
            resourceShareAssociations(Arrays.asList(resourceShareAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder>... resourceShareAssociations) {
            resourceShareAssociations(Stream.of(resourceShareAssociations)
                    .map(c -> ResourceShareAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceShareAssociations(Collection<ResourceShareAssociation.BuilderImpl> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copyFromBuilder(resourceShareAssociations);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public DisassociateResourceShareResponse build() {
            return new DisassociateResourceShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
