/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceShareAssociationsRequest extends RamRequest implements
        ToCopyableBuilder<GetResourceShareAssociationsRequest.Builder, GetResourceShareAssociationsRequest> {
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourceShareAssociationsRequest::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()).build();

    private static final SdkField<List<String>> RESOURCE_SHARE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetResourceShareAssociationsRequest::resourceShareArns))
            .setter(setter(Builder::resourceShareArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourceShareAssociationsRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourceShareAssociationsRequest::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourceShareAssociationsRequest::associationStatusAsString))
            .setter(setter(Builder::associationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationStatus").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourceShareAssociationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetResourceShareAssociationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_TYPE_FIELD,
            RESOURCE_SHARE_ARNS_FIELD, RESOURCE_ARN_FIELD, PRINCIPAL_FIELD, ASSOCIATION_STATUS_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private final String associationType;

    private final List<String> resourceShareArns;

    private final String resourceArn;

    private final String principal;

    private final String associationStatus;

    private final String nextToken;

    private final Integer maxResults;

    private GetResourceShareAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.associationType = builder.associationType;
        this.resourceShareArns = builder.resourceShareArns;
        this.resourceArn = builder.resourceArn;
        this.principal = builder.principal;
        this.associationStatus = builder.associationStatus;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The association type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link ResourceShareAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The association type.
     * @see ResourceShareAssociationType
     */
    public ResourceShareAssociationType associationType() {
        return ResourceShareAssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * The association type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link ResourceShareAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The association type.
     * @see ResourceShareAssociationType
     */
    public String associationTypeAsString() {
        return associationType;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the resource shares.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the resource shares.
     */
    public List<String> resourceShareArns() {
        return resourceShareArns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The principal.
     * </p>
     * 
     * @return The principal.
     */
    public String principal() {
        return principal;
    }

    /**
     * <p>
     * The status of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link ResourceShareAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return The status of the association.
     * @see ResourceShareAssociationStatus
     */
    public ResourceShareAssociationStatus associationStatus() {
        return ResourceShareAssociationStatus.fromValue(associationStatus);
    }

    /**
     * <p>
     * The status of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link ResourceShareAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return The status of the association.
     * @see ResourceShareAssociationStatus
     */
    public String associationStatusAsString() {
        return associationStatus;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArns());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceShareAssociationsRequest)) {
            return false;
        }
        GetResourceShareAssociationsRequest other = (GetResourceShareAssociationsRequest) obj;
        return Objects.equals(associationTypeAsString(), other.associationTypeAsString())
                && Objects.equals(resourceShareArns(), other.resourceShareArns())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(principal(), other.principal())
                && Objects.equals(associationStatusAsString(), other.associationStatusAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("GetResourceShareAssociationsRequest").add("AssociationType", associationTypeAsString())
                .add("ResourceShareArns", resourceShareArns()).add("ResourceArn", resourceArn()).add("Principal", principal())
                .add("AssociationStatus", associationStatusAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        case "resourceShareArns":
            return Optional.ofNullable(clazz.cast(resourceShareArns()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "associationStatus":
            return Optional.ofNullable(clazz.cast(associationStatusAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceShareAssociationsRequest, T> g) {
        return obj -> g.apply((GetResourceShareAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceShareAssociationsRequest> {
        /**
         * <p>
         * The association type.
         * </p>
         * 
         * @param associationType
         *        The association type.
         * @see ResourceShareAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The association type.
         * </p>
         * 
         * @param associationType
         *        The association type.
         * @see ResourceShareAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationType
         */
        Builder associationType(ResourceShareAssociationType associationType);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resource shares.
         * </p>
         * 
         * @param resourceShareArns
         *        The Amazon Resource Names (ARN) of the resource shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArns(Collection<String> resourceShareArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resource shares.
         * </p>
         * 
         * @param resourceShareArns
         *        The Amazon Resource Names (ARN) of the resource shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArns(String... resourceShareArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The principal.
         * </p>
         * 
         * @param principal
         *        The principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * The status of the association.
         * </p>
         * 
         * @param associationStatus
         *        The status of the association.
         * @see ResourceShareAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationStatus
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * The status of the association.
         * </p>
         * 
         * @param associationStatus
         *        The status of the association.
         * @see ResourceShareAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationStatus
         */
        Builder associationStatus(ResourceShareAssociationStatus associationStatus);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String associationType;

        private List<String> resourceShareArns = DefaultSdkAutoConstructList.getInstance();

        private String resourceArn;

        private String principal;

        private String associationStatus;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceShareAssociationsRequest model) {
            super(model);
            associationType(model.associationType);
            resourceShareArns(model.resourceShareArns);
            resourceArn(model.resourceArn);
            principal(model.principal);
            associationStatus(model.associationStatus);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getAssociationTypeAsString() {
            return associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(ResourceShareAssociationType associationType) {
            this.associationType(associationType.toString());
            return this;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        public final Collection<String> getResourceShareArns() {
            return resourceShareArns;
        }

        @Override
        public final Builder resourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareArns(String... resourceShareArns) {
            resourceShareArns(Arrays.asList(resourceShareArns));
            return this;
        }

        public final void setResourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getAssociationStatusAsString() {
            return associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(ResourceShareAssociationStatus associationStatus) {
            this.associationStatus(associationStatus.toString());
            return this;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceShareAssociationsRequest build() {
            return new GetResourceShareAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
