/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourcesRequest extends RamRequest implements
        ToCopyableBuilder<ListResourcesRequest.Builder, ListResourcesRequest> {
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListResourcesRequest::resourceOwnerAsString)).setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListResourcesRequest::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListResourcesRequest::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListResourcesRequest::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_SHARE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListResourcesRequest::resourceShareArns))
            .setter(setter(Builder::resourceShareArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListResourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_OWNER_FIELD,
            PRINCIPAL_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ARNS_FIELD, RESOURCE_SHARE_ARNS_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private final String resourceOwner;

    private final String principal;

    private final String resourceType;

    private final List<String> resourceArns;

    private final List<String> resourceShareArns;

    private final String nextToken;

    private final Integer maxResults;

    private ListResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceOwner = builder.resourceOwner;
        this.principal = builder.principal;
        this.resourceType = builder.resourceType;
        this.resourceArns = builder.resourceArns;
        this.resourceShareArns = builder.resourceShareArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The type of owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return The type of owner.
     * @see ResourceOwner
     */
    public ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(resourceOwner);
    }

    /**
     * <p>
     * The type of owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return The type of owner.
     * @see ResourceOwner
     */
    public String resourceOwnerAsString() {
        return resourceOwner;
    }

    /**
     * <p>
     * The principal.
     * </p>
     * 
     * @return The principal.
     */
    public String principal() {
        return principal;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * 
     * @return The resource type.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the resources.
     */
    public List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the resource shares.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the resource shares.
     */
    public List<String> resourceShareArns() {
        return resourceShareArns;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArns());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArns());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesRequest)) {
            return false;
        }
        ListResourcesRequest other = (ListResourcesRequest) obj;
        return Objects.equals(resourceOwnerAsString(), other.resourceOwnerAsString())
                && Objects.equals(principal(), other.principal()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(resourceArns(), other.resourceArns())
                && Objects.equals(resourceShareArns(), other.resourceShareArns())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("ListResourcesRequest").add("ResourceOwner", resourceOwnerAsString())
                .add("Principal", principal()).add("ResourceType", resourceType()).add("ResourceArns", resourceArns())
                .add("ResourceShareArns", resourceShareArns()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwnerAsString()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "resourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "resourceShareArns":
            return Optional.ofNullable(clazz.cast(resourceShareArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesRequest, T> g) {
        return obj -> g.apply((ListResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListResourcesRequest> {
        /**
         * <p>
         * The type of owner.
         * </p>
         * 
         * @param resourceOwner
         *        The type of owner.
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(String resourceOwner);

        /**
         * <p>
         * The type of owner.
         * </p>
         * 
         * @param resourceOwner
         *        The type of owner.
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(ResourceOwner resourceOwner);

        /**
         * <p>
         * The principal.
         * </p>
         * 
         * @param principal
         *        The principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resources.
         * </p>
         * 
         * @param resourceArns
         *        The Amazon Resource Names (ARN) of the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resources.
         * </p>
         * 
         * @param resourceArns
         *        The Amazon Resource Names (ARN) of the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resource shares.
         * </p>
         * 
         * @param resourceShareArns
         *        The Amazon Resource Names (ARN) of the resource shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArns(Collection<String> resourceShareArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resource shares.
         * </p>
         * 
         * @param resourceShareArns
         *        The Amazon Resource Names (ARN) of the resource shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArns(String... resourceShareArns);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String resourceOwner;

        private String principal;

        private String resourceType;

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceShareArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesRequest model) {
            super(model);
            resourceOwner(model.resourceOwner);
            principal(model.principal);
            resourceType(model.resourceType);
            resourceArns(model.resourceArns);
            resourceShareArns(model.resourceShareArns);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getResourceOwnerAsString() {
            return resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner.toString());
            return this;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getResourceArns() {
            return resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        public final Collection<String> getResourceShareArns() {
            return resourceShareArns;
        }

        @Override
        public final Builder resourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareArns(String... resourceShareArns) {
            resourceShareArns(Arrays.asList(resourceShareArns));
            return this;
        }

        public final void setResourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourcesRequest build() {
            return new ListResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
