/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse;

public class GetResourceShareAssociationsIterable
implements SdkIterable<GetResourceShareAssociationsResponse> {
    private final RamClient client;
    private final GetResourceShareAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourceShareAssociationsIterable(RamClient client, GetResourceShareAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetResourceShareAssociationsResponseFetcher();
    }

    public Iterator<GetResourceShareAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetResourceShareAssociationsIterable resume(GetResourceShareAssociationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetResourceShareAssociationsIterable(this.client, (GetResourceShareAssociationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetResourceShareAssociationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetResourceShareAssociationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetResourceShareAssociationsResponseFetcher
    implements SyncPageFetcher<GetResourceShareAssociationsResponse> {
        private GetResourceShareAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceShareAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourceShareAssociationsResponse nextPage(GetResourceShareAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetResourceShareAssociationsIterable.this.client.getResourceShareAssociations(GetResourceShareAssociationsIterable.this.firstRequest);
            }
            return GetResourceShareAssociationsIterable.this.client.getResourceShareAssociations((GetResourceShareAssociationsRequest)((Object)GetResourceShareAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

