/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePermissionResponse extends RamResponse implements
        ToCopyableBuilder<DeletePermissionResponse.Builder, DeletePermissionResponse> {
    private static final SdkField<Boolean> RETURN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("returnValue").getter(getter(DeletePermissionResponse::returnValue)).setter(setter(Builder::returnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnValue").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(DeletePermissionResponse::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> PERMISSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionStatus").getter(getter(DeletePermissionResponse::permissionStatusAsString))
            .setter(setter(Builder::permissionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_VALUE_FIELD,
            CLIENT_TOKEN_FIELD, PERMISSION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean returnValue;

    private final String clientToken;

    private final String permissionStatus;

    private DeletePermissionResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.clientToken = builder.clientToken;
        this.permissionStatus = builder.permissionStatus;
    }

    /**
     * <p>
     * A boolean that indicates whether the delete operations succeeded.
     * </p>
     * 
     * @return A boolean that indicates whether the delete operations succeeded.
     */
    public final Boolean returnValue() {
        return returnValue;
    }

    /**
     * <p>
     * The idempotency identifier associated with this request. If you want to repeat the same operation in an
     * idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that
     * later call. All other parameters must also have the same values that you used in the first call.
     * </p>
     * 
     * @return The idempotency identifier associated with this request. If you want to repeat the same operation in an
     *         idempotent manner then you must include this value in the <code>clientToken</code> request parameter of
     *         that later call. All other parameters must also have the same values that you used in the first call.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * This operation is performed asynchronously, and this response parameter indicates the current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionStatus}
     * will return {@link PermissionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionStatusAsString}.
     * </p>
     * 
     * @return This operation is performed asynchronously, and this response parameter indicates the current status.
     * @see PermissionStatus
     */
    public final PermissionStatus permissionStatus() {
        return PermissionStatus.fromValue(permissionStatus);
    }

    /**
     * <p>
     * This operation is performed asynchronously, and this response parameter indicates the current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionStatus}
     * will return {@link PermissionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionStatusAsString}.
     * </p>
     * 
     * @return This operation is performed asynchronously, and this response parameter indicates the current status.
     * @see PermissionStatus
     */
    public final String permissionStatusAsString() {
        return permissionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(permissionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePermissionResponse)) {
            return false;
        }
        DeletePermissionResponse other = (DeletePermissionResponse) obj;
        return Objects.equals(returnValue(), other.returnValue()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(permissionStatusAsString(), other.permissionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePermissionResponse").add("ReturnValue", returnValue()).add("ClientToken", clientToken())
                .add("PermissionStatus", permissionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "returnValue":
            return Optional.ofNullable(clazz.cast(returnValue()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "permissionStatus":
            return Optional.ofNullable(clazz.cast(permissionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("returnValue", RETURN_VALUE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("permissionStatus", PERMISSION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletePermissionResponse, T> g) {
        return obj -> g.apply((DeletePermissionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeletePermissionResponse> {
        /**
         * <p>
         * A boolean that indicates whether the delete operations succeeded.
         * </p>
         * 
         * @param returnValue
         *        A boolean that indicates whether the delete operations succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnValue(Boolean returnValue);

        /**
         * <p>
         * The idempotency identifier associated with this request. If you want to repeat the same operation in an
         * idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that
         * later call. All other parameters must also have the same values that you used in the first call.
         * </p>
         * 
         * @param clientToken
         *        The idempotency identifier associated with this request. If you want to repeat the same operation in
         *        an idempotent manner then you must include this value in the <code>clientToken</code> request
         *        parameter of that later call. All other parameters must also have the same values that you used in the
         *        first call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * This operation is performed asynchronously, and this response parameter indicates the current status.
         * </p>
         * 
         * @param permissionStatus
         *        This operation is performed asynchronously, and this response parameter indicates the current status.
         * @see PermissionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionStatus
         */
        Builder permissionStatus(String permissionStatus);

        /**
         * <p>
         * This operation is performed asynchronously, and this response parameter indicates the current status.
         * </p>
         * 
         * @param permissionStatus
         *        This operation is performed asynchronously, and this response parameter indicates the current status.
         * @see PermissionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionStatus
         */
        Builder permissionStatus(PermissionStatus permissionStatus);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private Boolean returnValue;

        private String clientToken;

        private String permissionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePermissionResponse model) {
            super(model);
            returnValue(model.returnValue);
            clientToken(model.clientToken);
            permissionStatus(model.permissionStatus);
        }

        public final Boolean getReturnValue() {
            return returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getPermissionStatus() {
            return permissionStatus;
        }

        public final void setPermissionStatus(String permissionStatus) {
            this.permissionStatus = permissionStatus;
        }

        @Override
        public final Builder permissionStatus(String permissionStatus) {
            this.permissionStatus = permissionStatus;
            return this;
        }

        @Override
        public final Builder permissionStatus(PermissionStatus permissionStatus) {
            this.permissionStatus(permissionStatus == null ? null : permissionStatus.toString());
            return this;
        }

        @Override
        public DeletePermissionResponse build() {
            return new DeletePermissionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
