/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateResourceShareRequest extends RamRequest implements
        ToCopyableBuilder<DisassociateResourceShareRequest.Builder, DisassociateResourceShareRequest> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceShareArn").getter(getter(DisassociateResourceShareRequest::resourceShareArn))
            .setter(setter(Builder::resourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()).build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceArns")
            .getter(getter(DisassociateResourceShareRequest::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("principals")
            .getter(getter(DisassociateResourceShareRequest::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(DisassociateResourceShareRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<List<String>> SOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(DisassociateResourceShareRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD,
            RESOURCE_ARNS_FIELD, PRINCIPALS_FIELD, CLIENT_TOKEN_FIELD, SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceShareArn;

    private final List<String> resourceArns;

    private final List<String> principals;

    private final String clientToken;

    private final List<String> sources;

    private DisassociateResourceShareRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArn = builder.resourceShareArn;
        this.resourceArns = builder.resourceArns;
        this.principals = builder.principals;
        this.clientToken = builder.clientToken;
        this.sources = builder.sources;
    }

    /**
     * <p>
     * Specifies <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     * Name (ARN)</a> of the resource share that you want to remove resources or principals from.
     * </p>
     * 
     * @return Specifies <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Name (ARN)</a> of the resource share that you want to remove resources or principals from.
     */
    public final String resourceShareArn() {
        return resourceShareArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Names (ARNs)</a> for one or more resources that you want to remove from the resource share. After the
     * operation runs, these resources are no longer shared with principals associated with the resource share.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return Specifies a list of <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> for one or more resources that you want to remove from the resource share. After the operation
     *         runs, these resources are no longer shared with principals associated with the resource share.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Principals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrincipals() {
        return principals != null && !(principals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of one or more principals that no longer are to have access to the resources in this resource
     * share.
     * </p>
     * <p>
     * You can include the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Web Services account ID, for example: <code>123456789012</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of an organization in Organizations, for example:
     * <code>organizations::123456789012:organization/o-exampleorgid</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * An ARN of an organizational unit (OU) in Organizations, for example:
     * <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * An ARN of an IAM user, for example: <code>iam::123456789012user/username</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Not all resource types can be shared with IAM roles and users. For more information, see <a href=
     * "https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types"
     * >Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipals} method.
     * </p>
     * 
     * @return Specifies a list of one or more principals that no longer are to have access to the resources in this
     *         resource share.</p>
     *         <p>
     *         You can include the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         An Amazon Web Services account ID, for example: <code>123456789012</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Name (ARN)</a> of an organization in Organizations, for example:
     *         <code>organizations::123456789012:organization/o-exampleorgid</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An ARN of an organizational unit (OU) in Organizations, for example:
     *         <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An ARN of an IAM user, for example: <code>iam::123456789012user/username</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Not all resource types can be shared with IAM roles and users. For more information, see <a href=
     *         "https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types"
     *         >Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.
     *         </p>
     */
    public final List<String> principals() {
        return principals;
    }

    /**
     * <p>
     * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
     * lets you safely retry the request without accidentally performing the same operation a second time. Passing the
     * same value to a later call to an operation requires that you also pass the same value for all other parameters.
     * We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of
     * value.</a>.
     * </p>
     * <p>
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     * </p>
     * <p>
     * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails
     * with an <code>IdempotentParameterMismatch</code> error.
     * </p>
     * 
     * @return Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         This lets you safely retry the request without accidentally performing the same operation a second time.
     *         Passing the same value to a later call to an operation requires that you also pass the same value for all
     *         other parameters. We recommend that you use a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
     *         <p>
     *         If you don't provide this value, then Amazon Web Services generates a random one for you.
     *         </p>
     *         <p>
     *         If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
     *         retry fails with an <code>IdempotentParameterMismatch</code> error.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies from which source accounts the service principal no longer has access to the resources in this resource
     * share.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return Specifies from which source accounts the service principal no longer has access to the resources in this
     *         resource share.
     */
    public final List<String> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipals() ? principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResourceShareRequest)) {
            return false;
        }
        DisassociateResourceShareRequest other = (DisassociateResourceShareRequest) obj;
        return Objects.equals(resourceShareArn(), other.resourceShareArn()) && hasResourceArns() == other.hasResourceArns()
                && Objects.equals(resourceArns(), other.resourceArns()) && hasPrincipals() == other.hasPrincipals()
                && Objects.equals(principals(), other.principals()) && Objects.equals(clientToken(), other.clientToken())
                && hasSources() == other.hasSources() && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateResourceShareRequest").add("ResourceShareArn", resourceShareArn())
                .add("ResourceArns", hasResourceArns() ? resourceArns() : null)
                .add("Principals", hasPrincipals() ? principals() : null).add("ClientToken", clientToken())
                .add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareArn":
            return Optional.ofNullable(clazz.cast(resourceShareArn()));
        case "resourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceShareArn", RESOURCE_SHARE_ARN_FIELD);
        map.put("resourceArns", RESOURCE_ARNS_FIELD);
        map.put("principals", PRINCIPALS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("sources", SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResourceShareRequest, T> g) {
        return obj -> g.apply((DisassociateResourceShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateResourceShareRequest> {
        /**
         * <p>
         * Specifies <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Name (ARN)</a> of the resource share that you want to remove resources or principals from.
         * </p>
         * 
         * @param resourceShareArn
         *        Specifies <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of the resource share that you want to remove resources or principals from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArn(String resourceShareArn);

        /**
         * <p>
         * Specifies a list of <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> for one or more resources that you want to remove from the resource share. After the operation
         * runs, these resources are no longer shared with principals associated with the resource share.
         * </p>
         * 
         * @param resourceArns
         *        Specifies a list of <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> for one or more resources that you want to remove from the resource share. After the
         *        operation runs, these resources are no longer shared with principals associated with the resource
         *        share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * Specifies a list of <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> for one or more resources that you want to remove from the resource share. After the operation
         * runs, these resources are no longer shared with principals associated with the resource share.
         * </p>
         * 
         * @param resourceArns
         *        Specifies a list of <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> for one or more resources that you want to remove from the resource share. After the
         *        operation runs, these resources are no longer shared with principals associated with the resource
         *        share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * Specifies a list of one or more principals that no longer are to have access to the resources in this
         * resource share.
         * </p>
         * <p>
         * You can include the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An Amazon Web Services account ID, for example: <code>123456789012</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of an organization in Organizations, for example:
         * <code>organizations::123456789012:organization/o-exampleorgid</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * An ARN of an organizational unit (OU) in Organizations, for example:
         * <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * An ARN of an IAM user, for example: <code>iam::123456789012user/username</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Not all resource types can be shared with IAM roles and users. For more information, see <a href=
         * "https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types"
         * >Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.
         * </p>
         * </note>
         * 
         * @param principals
         *        Specifies a list of one or more principals that no longer are to have access to the resources in this
         *        resource share.</p>
         *        <p>
         *        You can include the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        An Amazon Web Services account ID, for example: <code>123456789012</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of an organization in Organizations, for example:
         *        <code>organizations::123456789012:organization/o-exampleorgid</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An ARN of an organizational unit (OU) in Organizations, for example:
         *        <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An ARN of an IAM user, for example: <code>iam::123456789012user/username</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Not all resource types can be shared with IAM roles and users. For more information, see <a href=
         *        "https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types"
         *        >Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<String> principals);

        /**
         * <p>
         * Specifies a list of one or more principals that no longer are to have access to the resources in this
         * resource share.
         * </p>
         * <p>
         * You can include the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An Amazon Web Services account ID, for example: <code>123456789012</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of an organization in Organizations, for example:
         * <code>organizations::123456789012:organization/o-exampleorgid</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * An ARN of an organizational unit (OU) in Organizations, for example:
         * <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * An ARN of an IAM user, for example: <code>iam::123456789012user/username</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Not all resource types can be shared with IAM roles and users. For more information, see <a href=
         * "https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types"
         * >Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.
         * </p>
         * </note>
         * 
         * @param principals
         *        Specifies a list of one or more principals that no longer are to have access to the resources in this
         *        resource share.</p>
         *        <p>
         *        You can include the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        An Amazon Web Services account ID, for example: <code>123456789012</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of an organization in Organizations, for example:
         *        <code>organizations::123456789012:organization/o-exampleorgid</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An ARN of an organizational unit (OU) in Organizations, for example:
         *        <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An ARN of an IAM user, for example: <code>iam::123456789012user/username</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Not all resource types can be shared with IAM roles and users. For more information, see <a href=
         *        "https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types"
         *        >Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(String... principals);

        /**
         * <p>
         * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
         * lets you safely retry the request without accidentally performing the same operation a second time. Passing
         * the same value to a later call to an operation requires that you also pass the same value for all other
         * parameters. We recommend that you use a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
         * </p>
         * <p>
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         * </p>
         * <p>
         * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry
         * fails with an <code>IdempotentParameterMismatch</code> error.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the
         *        request. This lets you safely retry the request without accidentally performing the same operation a
         *        second time. Passing the same value to a later call to an operation requires that you also pass the
         *        same value for all other parameters. We recommend that you use a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
         *        <p>
         *        If you don't provide this value, then Amazon Web Services generates a random one for you.
         *        </p>
         *        <p>
         *        If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
         *        retry fails with an <code>IdempotentParameterMismatch</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies from which source accounts the service principal no longer has access to the resources in this
         * resource share.
         * </p>
         * 
         * @param sources
         *        Specifies from which source accounts the service principal no longer has access to the resources in
         *        this resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<String> sources);

        /**
         * <p>
         * Specifies from which source accounts the service principal no longer has access to the resources in this
         * resource share.
         * </p>
         * 
         * @param sources
         *        Specifies from which source accounts the service principal no longer has access to the resources in
         *        this resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(String... sources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String resourceShareArn;

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> principals = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private List<String> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResourceShareRequest model) {
            super(model);
            resourceShareArn(model.resourceShareArn);
            resourceArns(model.resourceArns);
            principals(model.principals);
            clientToken(model.clientToken);
            sources(model.sources);
        }

        public final String getResourceShareArn() {
            return resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Collection<String> getPrincipals() {
            if (principals instanceof SdkAutoConstructList) {
                return null;
            }
            return principals;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalArnOrIdListCopier.copy(principals);
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalArnOrIdListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Collection<String> getSources() {
            if (sources instanceof SdkAutoConstructList) {
                return null;
            }
            return sources;
        }

        public final void setSources(Collection<String> sources) {
            this.sources = SourceArnOrAccountListCopier.copy(sources);
        }

        @Override
        public final Builder sources(Collection<String> sources) {
            this.sources = SourceArnOrAccountListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(String... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateResourceShareRequest build() {
            return new DisassociateResourceShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
