/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPermissionResponse extends RamResponse implements
        ToCopyableBuilder<GetPermissionResponse.Builder, GetPermissionResponse> {
    private static final SdkField<ResourceSharePermissionDetail> PERMISSION_FIELD = SdkField
            .<ResourceSharePermissionDetail> builder(MarshallingType.SDK_POJO).memberName("permission")
            .getter(getter(GetPermissionResponse::permission)).setter(setter(Builder::permission))
            .constructor(ResourceSharePermissionDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResourceSharePermissionDetail permission;

    private GetPermissionResponse(BuilderImpl builder) {
        super(builder);
        this.permission = builder.permission;
    }

    /**
     * <p>
     * An object with details about the permission.
     * </p>
     * 
     * @return An object with details about the permission.
     */
    public final ResourceSharePermissionDetail permission() {
        return permission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(permission());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPermissionResponse)) {
            return false;
        }
        GetPermissionResponse other = (GetPermissionResponse) obj;
        return Objects.equals(permission(), other.permission());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPermissionResponse").add("Permission", permission()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permission":
            return Optional.ofNullable(clazz.cast(permission()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("permission", PERMISSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPermissionResponse, T> g) {
        return obj -> g.apply((GetPermissionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPermissionResponse> {
        /**
         * <p>
         * An object with details about the permission.
         * </p>
         * 
         * @param permission
         *        An object with details about the permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permission(ResourceSharePermissionDetail permission);

        /**
         * <p>
         * An object with details about the permission.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceSharePermissionDetail.Builder}
         * avoiding the need to create one manually via {@link ResourceSharePermissionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSharePermissionDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #permission(ResourceSharePermissionDetail)}.
         * 
         * @param permission
         *        a consumer that will call methods on {@link ResourceSharePermissionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permission(ResourceSharePermissionDetail)
         */
        default Builder permission(Consumer<ResourceSharePermissionDetail.Builder> permission) {
            return permission(ResourceSharePermissionDetail.builder().applyMutation(permission).build());
        }
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private ResourceSharePermissionDetail permission;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPermissionResponse model) {
            super(model);
            permission(model.permission);
        }

        public final ResourceSharePermissionDetail.Builder getPermission() {
            return permission != null ? permission.toBuilder() : null;
        }

        public final void setPermission(ResourceSharePermissionDetail.BuilderImpl permission) {
            this.permission = permission != null ? permission.build() : null;
        }

        @Override
        public final Builder permission(ResourceSharePermissionDetail permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public GetPermissionResponse build() {
            return new GetPermissionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
