/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReplacePermissionAssociationsWorkRequest extends RamRequest implements
        ToCopyableBuilder<ListReplacePermissionAssociationsWorkRequest.Builder, ListReplacePermissionAssociationsWorkRequest> {
    private static final SdkField<List<String>> WORK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("workIds")
            .getter(getter(ListReplacePermissionAssociationsWorkRequest::workIds))
            .setter(setter(Builder::workIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListReplacePermissionAssociationsWorkRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReplacePermissionAssociationsWorkRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListReplacePermissionAssociationsWorkRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_IDS_FIELD, STATUS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> workIds;

    private final String status;

    private final String nextToken;

    private final Integer maxResults;

    private ListReplacePermissionAssociationsWorkRequest(BuilderImpl builder) {
        super(builder);
        this.workIds = builder.workIds;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkIds() {
        return workIds != null && !(workIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IDs. These values come from the <code>id</code>field of the
     * <code>replacePermissionAssociationsWork</code>structure returned by the <a>ReplacePermissionAssociations</a>
     * operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkIds} method.
     * </p>
     * 
     * @return A list of IDs. These values come from the <code>id</code>field of the
     *         <code>replacePermissionAssociationsWork</code>structure returned by the
     *         <a>ReplacePermissionAssociations</a> operation.
     */
    public final List<String> workIds() {
        return workIds;
    }

    /**
     * <p>
     * Specifies that you want to see only the details about requests with a status that matches this value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplacePermissionAssociationsWorkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies that you want to see only the details about requests with a status that matches this value.
     * @see ReplacePermissionAssociationsWorkStatus
     */
    public final ReplacePermissionAssociationsWorkStatus status() {
        return ReplacePermissionAssociationsWorkStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies that you want to see only the details about requests with a status that matches this value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplacePermissionAssociationsWorkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies that you want to see only the details about requests with a status that matches this value.
     * @see ReplacePermissionAssociationsWorkStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>NextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the total number of results that you want included on each page of the response. If you do not include
     * this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the
     * number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the
     * specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next
     * part of the results. Note that the service might return fewer results than the maximum even when there are more
     * results available. You should check <code>NextToken</code> after every operation to ensure that you receive all
     * of the results.
     * </p>
     * 
     * @return Specifies the total number of results that you want included on each page of the response. If you do not
     *         include this parameter, it defaults to a value that is specific to the operation. If additional items
     *         exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value
     *         (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call
     *         to the operation to get the next part of the results. Note that the service might return fewer results
     *         than the maximum even when there are more results available. You should check <code>NextToken</code>
     *         after every operation to ensure that you receive all of the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkIds() ? workIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReplacePermissionAssociationsWorkRequest)) {
            return false;
        }
        ListReplacePermissionAssociationsWorkRequest other = (ListReplacePermissionAssociationsWorkRequest) obj;
        return hasWorkIds() == other.hasWorkIds() && Objects.equals(workIds(), other.workIds())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReplacePermissionAssociationsWorkRequest").add("WorkIds", hasWorkIds() ? workIds() : null)
                .add("Status", statusAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workIds":
            return Optional.ofNullable(clazz.cast(workIds()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workIds", WORK_IDS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReplacePermissionAssociationsWorkRequest, T> g) {
        return obj -> g.apply((ListReplacePermissionAssociationsWorkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListReplacePermissionAssociationsWorkRequest> {
        /**
         * <p>
         * A list of IDs. These values come from the <code>id</code>field of the
         * <code>replacePermissionAssociationsWork</code>structure returned by the <a>ReplacePermissionAssociations</a>
         * operation.
         * </p>
         * 
         * @param workIds
         *        A list of IDs. These values come from the <code>id</code>field of the
         *        <code>replacePermissionAssociationsWork</code>structure returned by the
         *        <a>ReplacePermissionAssociations</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workIds(Collection<String> workIds);

        /**
         * <p>
         * A list of IDs. These values come from the <code>id</code>field of the
         * <code>replacePermissionAssociationsWork</code>structure returned by the <a>ReplacePermissionAssociations</a>
         * operation.
         * </p>
         * 
         * @param workIds
         *        A list of IDs. These values come from the <code>id</code>field of the
         *        <code>replacePermissionAssociationsWork</code>structure returned by the
         *        <a>ReplacePermissionAssociations</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workIds(String... workIds);

        /**
         * <p>
         * Specifies that you want to see only the details about requests with a status that matches this value.
         * </p>
         * 
         * @param status
         *        Specifies that you want to see only the details about requests with a status that matches this value.
         * @see ReplacePermissionAssociationsWorkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplacePermissionAssociationsWorkStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies that you want to see only the details about requests with a status that matches this value.
         * </p>
         * 
         * @param status
         *        Specifies that you want to see only the details about requests with a status that matches this value.
         * @see ReplacePermissionAssociationsWorkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplacePermissionAssociationsWorkStatus
         */
        Builder status(ReplacePermissionAssociationsWorkStatus status);

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the total number of results that you want included on each page of the response. If you do not
         * include this parameter, it defaults to a value that is specific to the operation. If additional items exist
         * beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
         * null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the
         * operation to get the next part of the results. Note that the service might return fewer results than the
         * maximum even when there are more results available. You should check <code>NextToken</code> after every
         * operation to ensure that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        Specifies the total number of results that you want included on each page of the response. If you do
         *        not include this parameter, it defaults to a value that is specific to the operation. If additional
         *        items exist beyond the number you specify, the <code>NextToken</code> response element is returned
         *        with a value (not null). Include the specified value as the <code>NextToken</code> request parameter
         *        in the next call to the operation to get the next part of the results. Note that the service might
         *        return fewer results than the maximum even when there are more results available. You should check
         *        <code>NextToken</code> after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private List<String> workIds = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReplacePermissionAssociationsWorkRequest model) {
            super(model);
            workIds(model.workIds);
            status(model.status);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getWorkIds() {
            if (workIds instanceof SdkAutoConstructList) {
                return null;
            }
            return workIds;
        }

        public final void setWorkIds(Collection<String> workIds) {
            this.workIds = ReplacePermissionAssociationsWorkIdListCopier.copy(workIds);
        }

        @Override
        public final Builder workIds(Collection<String> workIds) {
            this.workIds = ReplacePermissionAssociationsWorkIdListCopier.copy(workIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workIds(String... workIds) {
            workIds(Arrays.asList(workIds));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReplacePermissionAssociationsWorkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReplacePermissionAssociationsWorkRequest build() {
            return new ListReplacePermissionAssociationsWorkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
