/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReplacePermissionAssociationsWorkResponse extends RamResponse implements
        ToCopyableBuilder<ListReplacePermissionAssociationsWorkResponse.Builder, ListReplacePermissionAssociationsWorkResponse> {
    private static final SdkField<List<ReplacePermissionAssociationsWork>> REPLACE_PERMISSION_ASSOCIATIONS_WORKS_FIELD = SdkField
            .<List<ReplacePermissionAssociationsWork>> builder(MarshallingType.LIST)
            .memberName("replacePermissionAssociationsWorks")
            .getter(getter(ListReplacePermissionAssociationsWorkResponse::replacePermissionAssociationsWorks))
            .setter(setter(Builder::replacePermissionAssociationsWorks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replacePermissionAssociationsWorks")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplacePermissionAssociationsWork> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplacePermissionAssociationsWork::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReplacePermissionAssociationsWorkResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLACE_PERMISSION_ASSOCIATIONS_WORKS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ReplacePermissionAssociationsWork> replacePermissionAssociationsWorks;

    private final String nextToken;

    private ListReplacePermissionAssociationsWorkResponse(BuilderImpl builder) {
        super(builder);
        this.replacePermissionAssociationsWorks = builder.replacePermissionAssociationsWorks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplacePermissionAssociationsWorks
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReplacePermissionAssociationsWorks() {
        return replacePermissionAssociationsWorks != null
                && !(replacePermissionAssociationsWorks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of data structures that provide details of the matching work IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplacePermissionAssociationsWorks}
     * method.
     * </p>
     * 
     * @return An array of data structures that provide details of the matching work IDs.
     */
    public final List<ReplacePermissionAssociationsWork> replacePermissionAssociationsWorks() {
        return replacePermissionAssociationsWorks;
    }

    /**
     * <p>
     * If present, this value indicates that more output is available than is included in the current response. Use this
     * value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part
     * of the output. You should repeat this until the <code>NextToken</code> response element comes back as
     * <code>null</code>. This indicates that this is the last page of results.
     * </p>
     * 
     * @return If present, this value indicates that more output is available than is included in the current response.
     *         Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to
     *         get the next part of the output. You should repeat this until the <code>NextToken</code> response element
     *         comes back as <code>null</code>. This indicates that this is the last page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplacePermissionAssociationsWorks() ? replacePermissionAssociationsWorks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReplacePermissionAssociationsWorkResponse)) {
            return false;
        }
        ListReplacePermissionAssociationsWorkResponse other = (ListReplacePermissionAssociationsWorkResponse) obj;
        return hasReplacePermissionAssociationsWorks() == other.hasReplacePermissionAssociationsWorks()
                && Objects.equals(replacePermissionAssociationsWorks(), other.replacePermissionAssociationsWorks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListReplacePermissionAssociationsWorkResponse")
                .add("ReplacePermissionAssociationsWorks",
                        hasReplacePermissionAssociationsWorks() ? replacePermissionAssociationsWorks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replacePermissionAssociationsWorks":
            return Optional.ofNullable(clazz.cast(replacePermissionAssociationsWorks()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("replacePermissionAssociationsWorks", REPLACE_PERMISSION_ASSOCIATIONS_WORKS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReplacePermissionAssociationsWorkResponse, T> g) {
        return obj -> g.apply((ListReplacePermissionAssociationsWorkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListReplacePermissionAssociationsWorkResponse> {
        /**
         * <p>
         * An array of data structures that provide details of the matching work IDs.
         * </p>
         * 
         * @param replacePermissionAssociationsWorks
         *        An array of data structures that provide details of the matching work IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacePermissionAssociationsWorks(
                Collection<ReplacePermissionAssociationsWork> replacePermissionAssociationsWorks);

        /**
         * <p>
         * An array of data structures that provide details of the matching work IDs.
         * </p>
         * 
         * @param replacePermissionAssociationsWorks
         *        An array of data structures that provide details of the matching work IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacePermissionAssociationsWorks(ReplacePermissionAssociationsWork... replacePermissionAssociationsWorks);

        /**
         * <p>
         * An array of data structures that provide details of the matching work IDs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ram.model.ReplacePermissionAssociationsWork.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ram.model.ReplacePermissionAssociationsWork#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ram.model.ReplacePermissionAssociationsWork.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #replacePermissionAssociationsWorks(List<ReplacePermissionAssociationsWork>)}.
         * 
         * @param replacePermissionAssociationsWorks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ram.model.ReplacePermissionAssociationsWork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replacePermissionAssociationsWorks(java.util.Collection<ReplacePermissionAssociationsWork>)
         */
        Builder replacePermissionAssociationsWorks(
                Consumer<ReplacePermissionAssociationsWork.Builder>... replacePermissionAssociationsWorks);

        /**
         * <p>
         * If present, this value indicates that more output is available than is included in the current response. Use
         * this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         * next part of the output. You should repeat this until the <code>NextToken</code> response element comes back
         * as <code>null</code>. This indicates that this is the last page of results.
         * </p>
         * 
         * @param nextToken
         *        If present, this value indicates that more output is available than is included in the current
         *        response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         *        operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         *        response element comes back as <code>null</code>. This indicates that this is the last page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private List<ReplacePermissionAssociationsWork> replacePermissionAssociationsWorks = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReplacePermissionAssociationsWorkResponse model) {
            super(model);
            replacePermissionAssociationsWorks(model.replacePermissionAssociationsWorks);
            nextToken(model.nextToken);
        }

        public final List<ReplacePermissionAssociationsWork.Builder> getReplacePermissionAssociationsWorks() {
            List<ReplacePermissionAssociationsWork.Builder> result = ReplacePermissionAssociationsWorkListCopier
                    .copyToBuilder(this.replacePermissionAssociationsWorks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplacePermissionAssociationsWorks(
                Collection<ReplacePermissionAssociationsWork.BuilderImpl> replacePermissionAssociationsWorks) {
            this.replacePermissionAssociationsWorks = ReplacePermissionAssociationsWorkListCopier
                    .copyFromBuilder(replacePermissionAssociationsWorks);
        }

        @Override
        public final Builder replacePermissionAssociationsWorks(
                Collection<ReplacePermissionAssociationsWork> replacePermissionAssociationsWorks) {
            this.replacePermissionAssociationsWorks = ReplacePermissionAssociationsWorkListCopier
                    .copy(replacePermissionAssociationsWorks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacePermissionAssociationsWorks(
                ReplacePermissionAssociationsWork... replacePermissionAssociationsWorks) {
            replacePermissionAssociationsWorks(Arrays.asList(replacePermissionAssociationsWorks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacePermissionAssociationsWorks(
                Consumer<ReplacePermissionAssociationsWork.Builder>... replacePermissionAssociationsWorks) {
            replacePermissionAssociationsWorks(Stream.of(replacePermissionAssociationsWorks)
                    .map(c -> ReplacePermissionAssociationsWork.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReplacePermissionAssociationsWorkResponse build() {
            return new ListReplacePermissionAssociationsWorkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
