/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents the background work that RAM performs when you invoke the
 * <a>ReplacePermissionAssociations</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplacePermissionAssociationsWork implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplacePermissionAssociationsWork.Builder, ReplacePermissionAssociationsWork> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ReplacePermissionAssociationsWork::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> FROM_PERMISSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromPermissionArn").getter(getter(ReplacePermissionAssociationsWork::fromPermissionArn))
            .setter(setter(Builder::fromPermissionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromPermissionArn").build()).build();

    private static final SdkField<String> FROM_PERMISSION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromPermissionVersion").getter(getter(ReplacePermissionAssociationsWork::fromPermissionVersion))
            .setter(setter(Builder::fromPermissionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromPermissionVersion").build())
            .build();

    private static final SdkField<String> TO_PERMISSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toPermissionArn").getter(getter(ReplacePermissionAssociationsWork::toPermissionArn))
            .setter(setter(Builder::toPermissionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toPermissionArn").build()).build();

    private static final SdkField<String> TO_PERMISSION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toPermissionVersion").getter(getter(ReplacePermissionAssociationsWork::toPermissionVersion))
            .setter(setter(Builder::toPermissionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toPermissionVersion").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ReplacePermissionAssociationsWork::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ReplacePermissionAssociationsWork::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(ReplacePermissionAssociationsWork::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(ReplacePermissionAssociationsWork::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            FROM_PERMISSION_ARN_FIELD, FROM_PERMISSION_VERSION_FIELD, TO_PERMISSION_ARN_FIELD, TO_PERMISSION_VERSION_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String fromPermissionArn;

    private final String fromPermissionVersion;

    private final String toPermissionArn;

    private final String toPermissionVersion;

    private final String status;

    private final String statusMessage;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private ReplacePermissionAssociationsWork(BuilderImpl builder) {
        this.id = builder.id;
        this.fromPermissionArn = builder.fromPermissionArn;
        this.fromPermissionVersion = builder.fromPermissionVersion;
        this.toPermissionArn = builder.toPermissionArn;
        this.toPermissionVersion = builder.toPermissionVersion;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The unique identifier for the background task associated with one <a>ReplacePermissionAssociations</a> request.
     * </p>
     * 
     * @return The unique identifier for the background task associated with one <a>ReplacePermissionAssociations</a>
     *         request.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of the managed permission that this background task is replacing.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Name (ARN)</a> of the managed permission that this background task is replacing.
     */
    public final String fromPermissionArn() {
        return fromPermissionArn;
    }

    /**
     * <p>
     * The version of the managed permission that this background task is replacing.
     * </p>
     * 
     * @return The version of the managed permission that this background task is replacing.
     */
    public final String fromPermissionVersion() {
        return fromPermissionVersion;
    }

    /**
     * <p>
     * The ARN of the managed permission that this background task is associating with the resource shares in place of
     * the managed permission and version specified in <code>fromPermissionArn</code> and
     * <code>fromPermissionVersion</code>.
     * </p>
     * 
     * @return The ARN of the managed permission that this background task is associating with the resource shares in
     *         place of the managed permission and version specified in <code>fromPermissionArn</code> and
     *         <code>fromPermissionVersion</code>.
     */
    public final String toPermissionArn() {
        return toPermissionArn;
    }

    /**
     * <p>
     * The version of the managed permission that this background task is associating with the resource shares. This is
     * always the version that is currently the default for this managed permission.
     * </p>
     * 
     * @return The version of the managed permission that this background task is associating with the resource shares.
     *         This is always the version that is currently the default for this managed permission.
     */
    public final String toPermissionVersion() {
        return toPermissionVersion;
    }

    /**
     * <p>
     * Specifies the current status of the background tasks for the specified ID. The output is one of the following
     * strings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplacePermissionAssociationsWorkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the current status of the background tasks for the specified ID. The output is one of the
     *         following strings:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     * @see ReplacePermissionAssociationsWorkStatus
     */
    public final ReplacePermissionAssociationsWorkStatus status() {
        return ReplacePermissionAssociationsWorkStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the current status of the background tasks for the specified ID. The output is one of the following
     * strings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplacePermissionAssociationsWorkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the current status of the background tasks for the specified ID. The output is one of the
     *         following strings:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     * @see ReplacePermissionAssociationsWorkStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies the reason for a <code>FAILED</code> status. This field is present only when there <code>status</code>
     * is <code>FAILED</code>.
     * </p>
     * 
     * @return Specifies the reason for a <code>FAILED</code> status. This field is present only when there
     *         <code>status</code> is <code>FAILED</code>.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The date and time when this asynchronous background task was created.
     * </p>
     * 
     * @return The date and time when this asynchronous background task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time when the status of this background task was last updated.
     * </p>
     * 
     * @return The date and time when the status of this background task was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(fromPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(fromPermissionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(toPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(toPermissionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplacePermissionAssociationsWork)) {
            return false;
        }
        ReplacePermissionAssociationsWork other = (ReplacePermissionAssociationsWork) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(fromPermissionArn(), other.fromPermissionArn())
                && Objects.equals(fromPermissionVersion(), other.fromPermissionVersion())
                && Objects.equals(toPermissionArn(), other.toPermissionArn())
                && Objects.equals(toPermissionVersion(), other.toPermissionVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplacePermissionAssociationsWork").add("Id", id())
                .add("FromPermissionArn", fromPermissionArn()).add("FromPermissionVersion", fromPermissionVersion())
                .add("ToPermissionArn", toPermissionArn()).add("ToPermissionVersion", toPermissionVersion())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).add("CreationTime", creationTime())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "fromPermissionArn":
            return Optional.ofNullable(clazz.cast(fromPermissionArn()));
        case "fromPermissionVersion":
            return Optional.ofNullable(clazz.cast(fromPermissionVersion()));
        case "toPermissionArn":
            return Optional.ofNullable(clazz.cast(toPermissionArn()));
        case "toPermissionVersion":
            return Optional.ofNullable(clazz.cast(toPermissionVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("fromPermissionArn", FROM_PERMISSION_ARN_FIELD);
        map.put("fromPermissionVersion", FROM_PERMISSION_VERSION_FIELD);
        map.put("toPermissionArn", TO_PERMISSION_ARN_FIELD);
        map.put("toPermissionVersion", TO_PERMISSION_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplacePermissionAssociationsWork, T> g) {
        return obj -> g.apply((ReplacePermissionAssociationsWork) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplacePermissionAssociationsWork> {
        /**
         * <p>
         * The unique identifier for the background task associated with one <a>ReplacePermissionAssociations</a>
         * request.
         * </p>
         * 
         * @param id
         *        The unique identifier for the background task associated with one <a>ReplacePermissionAssociations</a>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of the managed permission that this background task is replacing.
         * </p>
         * 
         * @param fromPermissionArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of the managed permission that this background task is replacing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPermissionArn(String fromPermissionArn);

        /**
         * <p>
         * The version of the managed permission that this background task is replacing.
         * </p>
         * 
         * @param fromPermissionVersion
         *        The version of the managed permission that this background task is replacing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPermissionVersion(String fromPermissionVersion);

        /**
         * <p>
         * The ARN of the managed permission that this background task is associating with the resource shares in place
         * of the managed permission and version specified in <code>fromPermissionArn</code> and
         * <code>fromPermissionVersion</code>.
         * </p>
         * 
         * @param toPermissionArn
         *        The ARN of the managed permission that this background task is associating with the resource shares in
         *        place of the managed permission and version specified in <code>fromPermissionArn</code> and
         *        <code>fromPermissionVersion</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPermissionArn(String toPermissionArn);

        /**
         * <p>
         * The version of the managed permission that this background task is associating with the resource shares. This
         * is always the version that is currently the default for this managed permission.
         * </p>
         * 
         * @param toPermissionVersion
         *        The version of the managed permission that this background task is associating with the resource
         *        shares. This is always the version that is currently the default for this managed permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPermissionVersion(String toPermissionVersion);

        /**
         * <p>
         * Specifies the current status of the background tasks for the specified ID. The output is one of the following
         * strings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Specifies the current status of the background tasks for the specified ID. The output is one of the
         *        following strings:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         * @see ReplacePermissionAssociationsWorkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplacePermissionAssociationsWorkStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the current status of the background tasks for the specified ID. The output is one of the following
         * strings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Specifies the current status of the background tasks for the specified ID. The output is one of the
         *        following strings:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         * @see ReplacePermissionAssociationsWorkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplacePermissionAssociationsWorkStatus
         */
        Builder status(ReplacePermissionAssociationsWorkStatus status);

        /**
         * <p>
         * Specifies the reason for a <code>FAILED</code> status. This field is present only when there
         * <code>status</code> is <code>FAILED</code>.
         * </p>
         * 
         * @param statusMessage
         *        Specifies the reason for a <code>FAILED</code> status. This field is present only when there
         *        <code>status</code> is <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The date and time when this asynchronous background task was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time when this asynchronous background task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time when the status of this background task was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time when the status of this background task was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String fromPermissionArn;

        private String fromPermissionVersion;

        private String toPermissionArn;

        private String toPermissionVersion;

        private String status;

        private String statusMessage;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplacePermissionAssociationsWork model) {
            id(model.id);
            fromPermissionArn(model.fromPermissionArn);
            fromPermissionVersion(model.fromPermissionVersion);
            toPermissionArn(model.toPermissionArn);
            toPermissionVersion(model.toPermissionVersion);
            status(model.status);
            statusMessage(model.statusMessage);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getFromPermissionArn() {
            return fromPermissionArn;
        }

        public final void setFromPermissionArn(String fromPermissionArn) {
            this.fromPermissionArn = fromPermissionArn;
        }

        @Override
        public final Builder fromPermissionArn(String fromPermissionArn) {
            this.fromPermissionArn = fromPermissionArn;
            return this;
        }

        public final String getFromPermissionVersion() {
            return fromPermissionVersion;
        }

        public final void setFromPermissionVersion(String fromPermissionVersion) {
            this.fromPermissionVersion = fromPermissionVersion;
        }

        @Override
        public final Builder fromPermissionVersion(String fromPermissionVersion) {
            this.fromPermissionVersion = fromPermissionVersion;
            return this;
        }

        public final String getToPermissionArn() {
            return toPermissionArn;
        }

        public final void setToPermissionArn(String toPermissionArn) {
            this.toPermissionArn = toPermissionArn;
        }

        @Override
        public final Builder toPermissionArn(String toPermissionArn) {
            this.toPermissionArn = toPermissionArn;
            return this;
        }

        public final String getToPermissionVersion() {
            return toPermissionVersion;
        }

        public final void setToPermissionVersion(String toPermissionVersion) {
            this.toPermissionVersion = toPermissionVersion;
        }

        @Override
        public final Builder toPermissionVersion(String toPermissionVersion) {
            this.toPermissionVersion = toPermissionVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReplacePermissionAssociationsWorkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public ReplacePermissionAssociationsWork build() {
            return new ReplacePermissionAssociationsWork(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
