/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a RAM managed permission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSharePermissionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceSharePermissionDetail.Builder, ResourceSharePermissionDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ResourceSharePermissionDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ResourceSharePermissionDetail::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("defaultVersion").getter(getter(ResourceSharePermissionDetail::defaultVersion))
            .setter(setter(Builder::defaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ResourceSharePermissionDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ResourceSharePermissionDetail::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permission").getter(getter(ResourceSharePermissionDetail::permission))
            .setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(ResourceSharePermissionDetail::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(ResourceSharePermissionDetail::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<Boolean> IS_RESOURCE_TYPE_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isResourceTypeDefault").getter(getter(ResourceSharePermissionDetail::isResourceTypeDefault))
            .setter(setter(Builder::isResourceTypeDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isResourceTypeDefault").build())
            .build();

    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionType").getter(getter(ResourceSharePermissionDetail::permissionTypeAsString))
            .setter(setter(Builder::permissionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionType").build()).build();

    private static final SdkField<String> FEATURE_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("featureSet").getter(getter(ResourceSharePermissionDetail::featureSetAsString))
            .setter(setter(Builder::featureSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureSet").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ResourceSharePermissionDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(ResourceSharePermissionDetail::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, VERSION_FIELD,
            DEFAULT_VERSION_FIELD, NAME_FIELD, RESOURCE_TYPE_FIELD, PERMISSION_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, IS_RESOURCE_TYPE_DEFAULT_FIELD, PERMISSION_TYPE_FIELD, FEATURE_SET_FIELD, STATUS_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String version;

    private final Boolean defaultVersion;

    private final String name;

    private final String resourceType;

    private final String permission;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final Boolean isResourceTypeDefault;

    private final String permissionType;

    private final String featureSet;

    private final String status;

    private final List<Tag> tags;

    private ResourceSharePermissionDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.version = builder.version;
        this.defaultVersion = builder.defaultVersion;
        this.name = builder.name;
        this.resourceType = builder.resourceType;
        this.permission = builder.permission;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.isResourceTypeDefault = builder.isResourceTypeDefault;
        this.permissionType = builder.permissionType;
        this.featureSet = builder.featureSet;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of this RAM managed permission.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Name (ARN)</a> of this RAM managed permission.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The version of the permission described in this response.
     * </p>
     * 
     * @return The version of the permission described in this response.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * Specifies whether the version of the permission represented in this response is the default version for this
     * permission.
     * </p>
     * 
     * @return Specifies whether the version of the permission represented in this response is the default version for
     *         this permission.
     */
    public final Boolean defaultVersion() {
        return defaultVersion;
    }

    /**
     * <p>
     * The name of this permission.
     * </p>
     * 
     * @return The name of this permission.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The resource type to which this permission applies.
     * </p>
     * 
     * @return The resource type to which this permission applies.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The permission's effect and actions in JSON format. The <code>effect</code> indicates whether the specified
     * actions are allowed or denied. The <code>actions</code> list the operations to which the principal is granted or
     * denied access.
     * </p>
     * 
     * @return The permission's effect and actions in JSON format. The <code>effect</code> indicates whether the
     *         specified actions are allowed or denied. The <code>actions</code> list the operations to which the
     *         principal is granted or denied access.
     */
    public final String permission() {
        return permission;
    }

    /**
     * <p>
     * The date and time when the permission was created.
     * </p>
     * 
     * @return The date and time when the permission was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time when the permission was last updated.
     * </p>
     * 
     * @return The date and time when the permission was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Specifies whether the version of the permission represented in this response is the default version for all
     * resources of this resource type.
     * </p>
     * 
     * @return Specifies whether the version of the permission represented in this response is the default version for
     *         all resources of this resource type.
     */
    public final Boolean isResourceTypeDefault() {
        return isResourceTypeDefault;
    }

    /**
     * <p>
     * The type of managed permission. This can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_MANAGED</code> – Amazon Web Services created and manages this managed permission. You can associate it
     * with your resource shares, but you can't modify it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOMER_MANAGED</code> – You, or another principal in your account created this managed permission. You
     * can associate it with your resource shares and create new versions that have different permissions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return The type of managed permission. This can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_MANAGED</code> – Amazon Web Services created and manages this managed permission. You can
     *         associate it with your resource shares, but you can't modify it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOMER_MANAGED</code> – You, or another principal in your account created this managed
     *         permission. You can associate it with your resource shares and create new versions that have different
     *         permissions.
     *         </p>
     *         </li>
     * @see PermissionType
     */
    public final PermissionType permissionType() {
        return PermissionType.fromValue(permissionType);
    }

    /**
     * <p>
     * The type of managed permission. This can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_MANAGED</code> – Amazon Web Services created and manages this managed permission. You can associate it
     * with your resource shares, but you can't modify it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOMER_MANAGED</code> – You, or another principal in your account created this managed permission. You
     * can associate it with your resource shares and create new versions that have different permissions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return The type of managed permission. This can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_MANAGED</code> – Amazon Web Services created and manages this managed permission. You can
     *         associate it with your resource shares, but you can't modify it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOMER_MANAGED</code> – You, or another principal in your account created this managed
     *         permission. You can associate it with your resource shares and create new versions that have different
     *         permissions.
     *         </p>
     *         </li>
     * @see PermissionType
     */
    public final String permissionTypeAsString() {
        return permissionType;
    }

    /**
     * <p>
     * Indicates what features are available for this resource share. This parameter can have one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
     * principals you share the resource share with. You can modify these resource shares in RAM using the console or
     * APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b> and
     * then promoted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy. That
     * policy did not match any existing managed permissions, so RAM created this customer managed permission
     * automatically on the customer's behalf based on the attached policy document. This type of resource share is
     * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you promote
     * it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
     * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This value
     * changes to <code>STANDARD</code> when complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureSet} will
     * return {@link PermissionFeatureSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureSetAsString}.
     * </p>
     * 
     * @return Indicates what features are available for this resource share. This parameter can have one of the
     *         following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to
     *         all principals you share the resource share with. You can modify these resource shares in RAM using the
     *         console or APIs. This resource share might have been created by RAM, or it might have been
     *         <b>CREATED_FROM_POLICY</b> and then promoted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based
     *         policy. That policy did not match any existing managed permissions, so RAM created this customer managed
     *         permission automatically on the customer's behalf based on the attached policy document. This type of
     *         resource share is visible only to the Amazon Web Services account that created it. You can't modify it in
     *         RAM unless you promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but
     *         the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in
     *         progress. This value changes to <code>STANDARD</code> when complete.
     *         </p>
     *         </li>
     * @see PermissionFeatureSet
     */
    public final PermissionFeatureSet featureSet() {
        return PermissionFeatureSet.fromValue(featureSet);
    }

    /**
     * <p>
     * Indicates what features are available for this resource share. This parameter can have one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
     * principals you share the resource share with. You can modify these resource shares in RAM using the console or
     * APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b> and
     * then promoted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy. That
     * policy did not match any existing managed permissions, so RAM created this customer managed permission
     * automatically on the customer's behalf based on the attached policy document. This type of resource share is
     * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you promote
     * it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
     * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This value
     * changes to <code>STANDARD</code> when complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureSet} will
     * return {@link PermissionFeatureSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureSetAsString}.
     * </p>
     * 
     * @return Indicates what features are available for this resource share. This parameter can have one of the
     *         following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to
     *         all principals you share the resource share with. You can modify these resource shares in RAM using the
     *         console or APIs. This resource share might have been created by RAM, or it might have been
     *         <b>CREATED_FROM_POLICY</b> and then promoted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based
     *         policy. That policy did not match any existing managed permissions, so RAM created this customer managed
     *         permission automatically on the customer's behalf based on the attached policy document. This type of
     *         resource share is visible only to the Amazon Web Services account that created it. You can't modify it in
     *         RAM unless you promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but
     *         the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in
     *         progress. This value changes to <code>STANDARD</code> when complete.
     *         </p>
     *         </li>
     * @see PermissionFeatureSet
     */
    public final String featureSetAsString() {
        return featureSet;
    }

    /**
     * <p>
     * The current status of the association between the permission and the resource share. The following are the
     * possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource shares.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> – This permission or version is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> – This permission or version is deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PermissionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the association between the permission and the resource share. The following are
     *         the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource
     *         shares.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> – This permission or version is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> – This permission or version is deleted.
     *         </p>
     *         </li>
     * @see PermissionStatus
     */
    public final PermissionStatus status() {
        return PermissionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the association between the permission and the resource share. The following are the
     * possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource shares.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> – This permission or version is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> – This permission or version is deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PermissionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the association between the permission and the resource share. The following are
     *         the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource
     *         shares.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> – This permission or version is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> – This permission or version is deleted.
     *         </p>
     *         </li>
     * @see PermissionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag key and value pairs attached to the resource share.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag key and value pairs attached to the resource share.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(permission());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(isResourceTypeDefault());
        hashCode = 31 * hashCode + Objects.hashCode(permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(featureSetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSharePermissionDetail)) {
            return false;
        }
        ResourceSharePermissionDetail other = (ResourceSharePermissionDetail) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(version(), other.version())
                && Objects.equals(defaultVersion(), other.defaultVersion()) && Objects.equals(name(), other.name())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(permission(), other.permission())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(isResourceTypeDefault(), other.isResourceTypeDefault())
                && Objects.equals(permissionTypeAsString(), other.permissionTypeAsString())
                && Objects.equals(featureSetAsString(), other.featureSetAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceSharePermissionDetail").add("Arn", arn()).add("Version", version())
                .add("DefaultVersion", defaultVersion()).add("Name", name()).add("ResourceType", resourceType())
                .add("Permission", permission()).add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("IsResourceTypeDefault", isResourceTypeDefault()).add("PermissionType", permissionTypeAsString())
                .add("FeatureSet", featureSetAsString()).add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "defaultVersion":
            return Optional.ofNullable(clazz.cast(defaultVersion()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "permission":
            return Optional.ofNullable(clazz.cast(permission()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "isResourceTypeDefault":
            return Optional.ofNullable(clazz.cast(isResourceTypeDefault()));
        case "permissionType":
            return Optional.ofNullable(clazz.cast(permissionTypeAsString()));
        case "featureSet":
            return Optional.ofNullable(clazz.cast(featureSetAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("defaultVersion", DEFAULT_VERSION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("permission", PERMISSION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("isResourceTypeDefault", IS_RESOURCE_TYPE_DEFAULT_FIELD);
        map.put("permissionType", PERMISSION_TYPE_FIELD);
        map.put("featureSet", FEATURE_SET_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceSharePermissionDetail, T> g) {
        return obj -> g.apply((ResourceSharePermissionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSharePermissionDetail> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of this RAM managed permission.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of this RAM managed permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The version of the permission described in this response.
         * </p>
         * 
         * @param version
         *        The version of the permission described in this response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Specifies whether the version of the permission represented in this response is the default version for this
         * permission.
         * </p>
         * 
         * @param defaultVersion
         *        Specifies whether the version of the permission represented in this response is the default version
         *        for this permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersion(Boolean defaultVersion);

        /**
         * <p>
         * The name of this permission.
         * </p>
         * 
         * @param name
         *        The name of this permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The resource type to which this permission applies.
         * </p>
         * 
         * @param resourceType
         *        The resource type to which this permission applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The permission's effect and actions in JSON format. The <code>effect</code> indicates whether the specified
         * actions are allowed or denied. The <code>actions</code> list the operations to which the principal is granted
         * or denied access.
         * </p>
         * 
         * @param permission
         *        The permission's effect and actions in JSON format. The <code>effect</code> indicates whether the
         *        specified actions are allowed or denied. The <code>actions</code> list the operations to which the
         *        principal is granted or denied access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permission(String permission);

        /**
         * <p>
         * The date and time when the permission was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time when the permission was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time when the permission was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time when the permission was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Specifies whether the version of the permission represented in this response is the default version for all
         * resources of this resource type.
         * </p>
         * 
         * @param isResourceTypeDefault
         *        Specifies whether the version of the permission represented in this response is the default version
         *        for all resources of this resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isResourceTypeDefault(Boolean isResourceTypeDefault);

        /**
         * <p>
         * The type of managed permission. This can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_MANAGED</code> – Amazon Web Services created and manages this managed permission. You can associate
         * it with your resource shares, but you can't modify it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOMER_MANAGED</code> – You, or another principal in your account created this managed permission.
         * You can associate it with your resource shares and create new versions that have different permissions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissionType
         *        The type of managed permission. This can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_MANAGED</code> – Amazon Web Services created and manages this managed permission. You can
         *        associate it with your resource shares, but you can't modify it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOMER_MANAGED</code> – You, or another principal in your account created this managed
         *        permission. You can associate it with your resource shares and create new versions that have different
         *        permissions.
         *        </p>
         *        </li>
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(String permissionType);

        /**
         * <p>
         * The type of managed permission. This can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_MANAGED</code> – Amazon Web Services created and manages this managed permission. You can associate
         * it with your resource shares, but you can't modify it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOMER_MANAGED</code> – You, or another principal in your account created this managed permission.
         * You can associate it with your resource shares and create new versions that have different permissions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissionType
         *        The type of managed permission. This can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_MANAGED</code> – Amazon Web Services created and manages this managed permission. You can
         *        associate it with your resource shares, but you can't modify it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOMER_MANAGED</code> – You, or another principal in your account created this managed
         *        permission. You can associate it with your resource shares and create new versions that have different
         *        permissions.
         *        </p>
         *        </li>
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(PermissionType permissionType);

        /**
         * <p>
         * Indicates what features are available for this resource share. This parameter can have one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
         * principals you share the resource share with. You can modify these resource shares in RAM using the console
         * or APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b>
         * and then promoted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy.
         * That policy did not match any existing managed permissions, so RAM created this customer managed permission
         * automatically on the customer's behalf based on the attached policy document. This type of resource share is
         * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you
         * promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
         * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This
         * value changes to <code>STANDARD</code> when complete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param featureSet
         *        Indicates what features are available for this resource share. This parameter can have one of the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible
         *        to all principals you share the resource share with. You can modify these resource shares in RAM using
         *        the console or APIs. This resource share might have been created by RAM, or it might have been
         *        <b>CREATED_FROM_POLICY</b> and then promoted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based
         *        policy. That policy did not match any existing managed permissions, so RAM created this customer
         *        managed permission automatically on the customer's behalf based on the attached policy document. This
         *        type of resource share is visible only to the Amazon Web Services account that created it. You can't
         *        modify it in RAM unless you promote it. For more information, see
         *        <a>PromoteResourceShareCreatedFromPolicy</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>,
         *        but the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in
         *        progress. This value changes to <code>STANDARD</code> when complete.
         *        </p>
         *        </li>
         * @see PermissionFeatureSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionFeatureSet
         */
        Builder featureSet(String featureSet);

        /**
         * <p>
         * Indicates what features are available for this resource share. This parameter can have one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
         * principals you share the resource share with. You can modify these resource shares in RAM using the console
         * or APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b>
         * and then promoted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy.
         * That policy did not match any existing managed permissions, so RAM created this customer managed permission
         * automatically on the customer's behalf based on the attached policy document. This type of resource share is
         * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you
         * promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
         * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This
         * value changes to <code>STANDARD</code> when complete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param featureSet
         *        Indicates what features are available for this resource share. This parameter can have one of the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible
         *        to all principals you share the resource share with. You can modify these resource shares in RAM using
         *        the console or APIs. This resource share might have been created by RAM, or it might have been
         *        <b>CREATED_FROM_POLICY</b> and then promoted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based
         *        policy. That policy did not match any existing managed permissions, so RAM created this customer
         *        managed permission automatically on the customer's behalf based on the attached policy document. This
         *        type of resource share is visible only to the Amazon Web Services account that created it. You can't
         *        modify it in RAM unless you promote it. For more information, see
         *        <a>PromoteResourceShareCreatedFromPolicy</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>,
         *        but the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in
         *        progress. This value changes to <code>STANDARD</code> when complete.
         *        </p>
         *        </li>
         * @see PermissionFeatureSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionFeatureSet
         */
        Builder featureSet(PermissionFeatureSet featureSet);

        /**
         * <p>
         * The current status of the association between the permission and the resource share. The following are the
         * possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource shares.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> – This permission or version is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> – This permission or version is deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the association between the permission and the resource share. The following are
         *        the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource
         *        shares.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> – This permission or version is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> – This permission or version is deleted.
         *        </p>
         *        </li>
         * @see PermissionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the association between the permission and the resource share. The following are the
         * possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource shares.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> – This permission or version is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> – This permission or version is deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the association between the permission and the resource share. The following are
         *        the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource
         *        shares.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> – This permission or version is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> – This permission or version is deleted.
         *        </p>
         *        </li>
         * @see PermissionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionStatus
         */
        Builder status(PermissionStatus status);

        /**
         * <p>
         * The tag key and value pairs attached to the resource share.
         * </p>
         * 
         * @param tags
         *        The tag key and value pairs attached to the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag key and value pairs attached to the resource share.
         * </p>
         * 
         * @param tags
         *        The tag key and value pairs attached to the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag key and value pairs attached to the resource share.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ram.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ram.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ram.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ram.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String version;

        private Boolean defaultVersion;

        private String name;

        private String resourceType;

        private String permission;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private Boolean isResourceTypeDefault;

        private String permissionType;

        private String featureSet;

        private String status;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSharePermissionDetail model) {
            arn(model.arn);
            version(model.version);
            defaultVersion(model.defaultVersion);
            name(model.name);
            resourceType(model.resourceType);
            permission(model.permission);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            isResourceTypeDefault(model.isResourceTypeDefault);
            permissionType(model.permissionType);
            featureSet(model.featureSet);
            status(model.status);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Boolean getDefaultVersion() {
            return defaultVersion;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Boolean getIsResourceTypeDefault() {
            return isResourceTypeDefault;
        }

        public final void setIsResourceTypeDefault(Boolean isResourceTypeDefault) {
            this.isResourceTypeDefault = isResourceTypeDefault;
        }

        @Override
        public final Builder isResourceTypeDefault(Boolean isResourceTypeDefault) {
            this.isResourceTypeDefault = isResourceTypeDefault;
            return this;
        }

        public final String getPermissionType() {
            return permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getFeatureSet() {
            return featureSet;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(PermissionFeatureSet featureSet) {
            this.featureSet(featureSet == null ? null : featureSet.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PermissionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResourceSharePermissionDetail build() {
            return new ResourceSharePermissionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
