/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes a managed permission associated with a resource share.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedPermission implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociatedPermission.Builder, AssociatedPermission> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AssociatedPermission::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> PERMISSION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionVersion").getter(getter(AssociatedPermission::permissionVersion))
            .setter(setter(Builder::permissionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionVersion").build()).build();

    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("defaultVersion").getter(getter(AssociatedPermission::defaultVersion))
            .setter(setter(Builder::defaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersion").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(AssociatedPermission::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AssociatedPermission::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FEATURE_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("featureSet").getter(getter(AssociatedPermission::featureSetAsString))
            .setter(setter(Builder::featureSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureSet").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(AssociatedPermission::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceShareArn").getter(getter(AssociatedPermission::resourceShareArn))
            .setter(setter(Builder::resourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            PERMISSION_VERSION_FIELD, DEFAULT_VERSION_FIELD, RESOURCE_TYPE_FIELD, STATUS_FIELD, FEATURE_SET_FIELD,
            LAST_UPDATED_TIME_FIELD, RESOURCE_SHARE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String permissionVersion;

    private final Boolean defaultVersion;

    private final String resourceType;

    private final String status;

    private final String featureSet;

    private final Instant lastUpdatedTime;

    private final String resourceShareArn;

    private AssociatedPermission(BuilderImpl builder) {
        this.arn = builder.arn;
        this.permissionVersion = builder.permissionVersion;
        this.defaultVersion = builder.defaultVersion;
        this.resourceType = builder.resourceType;
        this.status = builder.status;
        this.featureSet = builder.featureSet;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.resourceShareArn = builder.resourceShareArn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of the associated managed permission.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Name (ARN)</a> of the associated managed permission.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The version of the permission currently associated with the resource share.
     * </p>
     * 
     * @return The version of the permission currently associated with the resource share.
     */
    public final String permissionVersion() {
        return permissionVersion;
    }

    /**
     * <p>
     * Indicates whether the associated resource share is using the default version of the permission.
     * </p>
     * 
     * @return Indicates whether the associated resource share is using the default version of the permission.
     */
    public final Boolean defaultVersion() {
        return defaultVersion;
    }

    /**
     * <p>
     * The resource type to which this permission applies.
     * </p>
     * 
     * @return The resource type to which this permission applies.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The current status of the association between the permission and the resource share. The following are the
     * possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource shares.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> – This permission or version is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> – This permission or version is deleted.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current status of the association between the permission and the resource share. The following are
     *         the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource
     *         shares.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> – This permission or version is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> – This permission or version is deleted.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Indicates what features are available for this resource share. This parameter can have one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
     * principals you share the resource share with. You can modify these resource shares in RAM using the console or
     * APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b> and
     * then promoted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy. That
     * policy did not match any existing managed permissions, so RAM created this customer managed permission
     * automatically on the customer's behalf based on the attached policy document. This type of resource share is
     * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you promote
     * it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
     * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This value
     * changes to <code>STANDARD</code> when complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureSet} will
     * return {@link PermissionFeatureSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureSetAsString}.
     * </p>
     * 
     * @return Indicates what features are available for this resource share. This parameter can have one of the
     *         following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to
     *         all principals you share the resource share with. You can modify these resource shares in RAM using the
     *         console or APIs. This resource share might have been created by RAM, or it might have been
     *         <b>CREATED_FROM_POLICY</b> and then promoted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based
     *         policy. That policy did not match any existing managed permissions, so RAM created this customer managed
     *         permission automatically on the customer's behalf based on the attached policy document. This type of
     *         resource share is visible only to the Amazon Web Services account that created it. You can't modify it in
     *         RAM unless you promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but
     *         the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in
     *         progress. This value changes to <code>STANDARD</code> when complete.
     *         </p>
     *         </li>
     * @see PermissionFeatureSet
     */
    public final PermissionFeatureSet featureSet() {
        return PermissionFeatureSet.fromValue(featureSet);
    }

    /**
     * <p>
     * Indicates what features are available for this resource share. This parameter can have one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
     * principals you share the resource share with. You can modify these resource shares in RAM using the console or
     * APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b> and
     * then promoted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy. That
     * policy did not match any existing managed permissions, so RAM created this customer managed permission
     * automatically on the customer's behalf based on the attached policy document. This type of resource share is
     * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you promote
     * it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
     * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This value
     * changes to <code>STANDARD</code> when complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureSet} will
     * return {@link PermissionFeatureSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureSetAsString}.
     * </p>
     * 
     * @return Indicates what features are available for this resource share. This parameter can have one of the
     *         following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to
     *         all principals you share the resource share with. You can modify these resource shares in RAM using the
     *         console or APIs. This resource share might have been created by RAM, or it might have been
     *         <b>CREATED_FROM_POLICY</b> and then promoted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based
     *         policy. That policy did not match any existing managed permissions, so RAM created this customer managed
     *         permission automatically on the customer's behalf based on the attached policy document. This type of
     *         resource share is visible only to the Amazon Web Services account that created it. You can't modify it in
     *         RAM unless you promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but
     *         the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in
     *         progress. This value changes to <code>STANDARD</code> when complete.
     *         </p>
     *         </li>
     * @see PermissionFeatureSet
     */
    public final String featureSetAsString() {
        return featureSet;
    }

    /**
     * <p>
     * The date and time when the association between the permission and the resource share was last updated.
     * </p>
     * 
     * @return The date and time when the association between the permission and the resource share was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of a resource share associated with this permission.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Name (ARN)</a> of a resource share associated with this permission.
     */
    public final String resourceShareArn() {
        return resourceShareArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(featureSetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedPermission)) {
            return false;
        }
        AssociatedPermission other = (AssociatedPermission) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(permissionVersion(), other.permissionVersion())
                && Objects.equals(defaultVersion(), other.defaultVersion())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(status(), other.status())
                && Objects.equals(featureSetAsString(), other.featureSetAsString())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(resourceShareArn(), other.resourceShareArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatedPermission").add("Arn", arn()).add("PermissionVersion", permissionVersion())
                .add("DefaultVersion", defaultVersion()).add("ResourceType", resourceType()).add("Status", status())
                .add("FeatureSet", featureSetAsString()).add("LastUpdatedTime", lastUpdatedTime())
                .add("ResourceShareArn", resourceShareArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "permissionVersion":
            return Optional.ofNullable(clazz.cast(permissionVersion()));
        case "defaultVersion":
            return Optional.ofNullable(clazz.cast(defaultVersion()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "featureSet":
            return Optional.ofNullable(clazz.cast(featureSetAsString()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "resourceShareArn":
            return Optional.ofNullable(clazz.cast(resourceShareArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("permissionVersion", PERMISSION_VERSION_FIELD);
        map.put("defaultVersion", DEFAULT_VERSION_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("featureSet", FEATURE_SET_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("resourceShareArn", RESOURCE_SHARE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatedPermission, T> g) {
        return obj -> g.apply((AssociatedPermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedPermission> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of the associated managed permission.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of the associated managed permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The version of the permission currently associated with the resource share.
         * </p>
         * 
         * @param permissionVersion
         *        The version of the permission currently associated with the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionVersion(String permissionVersion);

        /**
         * <p>
         * Indicates whether the associated resource share is using the default version of the permission.
         * </p>
         * 
         * @param defaultVersion
         *        Indicates whether the associated resource share is using the default version of the permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersion(Boolean defaultVersion);

        /**
         * <p>
         * The resource type to which this permission applies.
         * </p>
         * 
         * @param resourceType
         *        The resource type to which this permission applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The current status of the association between the permission and the resource share. The following are the
         * possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource shares.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> – This permission or version is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> – This permission or version is deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the association between the permission and the resource share. The following are
         *        the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ATTACHABLE</code> – This permission or version can be associated with resource shares.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNATTACHABLE</code> – This permission or version can't currently be associated with resource
         *        shares.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> – This permission or version is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> – This permission or version is deleted.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates what features are available for this resource share. This parameter can have one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
         * principals you share the resource share with. You can modify these resource shares in RAM using the console
         * or APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b>
         * and then promoted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy.
         * That policy did not match any existing managed permissions, so RAM created this customer managed permission
         * automatically on the customer's behalf based on the attached policy document. This type of resource share is
         * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you
         * promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
         * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This
         * value changes to <code>STANDARD</code> when complete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param featureSet
         *        Indicates what features are available for this resource share. This parameter can have one of the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible
         *        to all principals you share the resource share with. You can modify these resource shares in RAM using
         *        the console or APIs. This resource share might have been created by RAM, or it might have been
         *        <b>CREATED_FROM_POLICY</b> and then promoted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based
         *        policy. That policy did not match any existing managed permissions, so RAM created this customer
         *        managed permission automatically on the customer's behalf based on the attached policy document. This
         *        type of resource share is visible only to the Amazon Web Services account that created it. You can't
         *        modify it in RAM unless you promote it. For more information, see
         *        <a>PromoteResourceShareCreatedFromPolicy</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>,
         *        but the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in
         *        progress. This value changes to <code>STANDARD</code> when complete.
         *        </p>
         *        </li>
         * @see PermissionFeatureSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionFeatureSet
         */
        Builder featureSet(String featureSet);

        /**
         * <p>
         * Indicates what features are available for this resource share. This parameter can have one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
         * principals you share the resource share with. You can modify these resource shares in RAM using the console
         * or APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b>
         * and then promoted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy.
         * That policy did not match any existing managed permissions, so RAM created this customer managed permission
         * automatically on the customer's behalf based on the attached policy document. This type of resource share is
         * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you
         * promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
         * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This
         * value changes to <code>STANDARD</code> when complete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param featureSet
         *        Indicates what features are available for this resource share. This parameter can have one of the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible
         *        to all principals you share the resource share with. You can modify these resource shares in RAM using
         *        the console or APIs. This resource share might have been created by RAM, or it might have been
         *        <b>CREATED_FROM_POLICY</b> and then promoted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based
         *        policy. That policy did not match any existing managed permissions, so RAM created this customer
         *        managed permission automatically on the customer's behalf based on the attached policy document. This
         *        type of resource share is visible only to the Amazon Web Services account that created it. You can't
         *        modify it in RAM unless you promote it. For more information, see
         *        <a>PromoteResourceShareCreatedFromPolicy</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>,
         *        but the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in
         *        progress. This value changes to <code>STANDARD</code> when complete.
         *        </p>
         *        </li>
         * @see PermissionFeatureSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionFeatureSet
         */
        Builder featureSet(PermissionFeatureSet featureSet);

        /**
         * <p>
         * The date and time when the association between the permission and the resource share was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time when the association between the permission and the resource share was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of a resource share associated with this permission.
         * </p>
         * 
         * @param resourceShareArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of a resource share associated with this permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArn(String resourceShareArn);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String permissionVersion;

        private Boolean defaultVersion;

        private String resourceType;

        private String status;

        private String featureSet;

        private Instant lastUpdatedTime;

        private String resourceShareArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedPermission model) {
            arn(model.arn);
            permissionVersion(model.permissionVersion);
            defaultVersion(model.defaultVersion);
            resourceType(model.resourceType);
            status(model.status);
            featureSet(model.featureSet);
            lastUpdatedTime(model.lastUpdatedTime);
            resourceShareArn(model.resourceShareArn);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPermissionVersion() {
            return permissionVersion;
        }

        public final void setPermissionVersion(String permissionVersion) {
            this.permissionVersion = permissionVersion;
        }

        @Override
        public final Builder permissionVersion(String permissionVersion) {
            this.permissionVersion = permissionVersion;
            return this;
        }

        public final Boolean getDefaultVersion() {
            return defaultVersion;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFeatureSet() {
            return featureSet;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(PermissionFeatureSet featureSet) {
            this.featureSet(featureSet == null ? null : featureSet.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getResourceShareArn() {
            return resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        @Override
        public AssociatedPermission build() {
            return new AssociatedPermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
