/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePermissionVersionResponse extends RamResponse implements
        ToCopyableBuilder<CreatePermissionVersionResponse.Builder, CreatePermissionVersionResponse> {
    private static final SdkField<ResourceSharePermissionDetail> PERMISSION_FIELD = SdkField
            .<ResourceSharePermissionDetail> builder(MarshallingType.SDK_POJO).memberName("permission")
            .getter(getter(CreatePermissionVersionResponse::permission)).setter(setter(Builder::permission))
            .constructor(ResourceSharePermissionDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(CreatePermissionVersionResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResourceSharePermissionDetail permission;

    private final String clientToken;

    private CreatePermissionVersionResponse(BuilderImpl builder) {
        super(builder);
        this.permission = builder.permission;
        this.clientToken = builder.clientToken;
    }

    /**
     * Returns the value of the Permission property for this object.
     * 
     * @return The value of the Permission property for this object.
     */
    public final ResourceSharePermissionDetail permission() {
        return permission;
    }

    /**
     * <p>
     * The idempotency identifier associated with this request. If you want to repeat the same operation in an
     * idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that
     * later call. All other parameters must also have the same values that you used in the first call.
     * </p>
     * 
     * @return The idempotency identifier associated with this request. If you want to repeat the same operation in an
     *         idempotent manner then you must include this value in the <code>clientToken</code> request parameter of
     *         that later call. All other parameters must also have the same values that you used in the first call.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(permission());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePermissionVersionResponse)) {
            return false;
        }
        CreatePermissionVersionResponse other = (CreatePermissionVersionResponse) obj;
        return Objects.equals(permission(), other.permission()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePermissionVersionResponse").add("Permission", permission())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permission":
            return Optional.ofNullable(clazz.cast(permission()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("permission", PERMISSION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePermissionVersionResponse, T> g) {
        return obj -> g.apply((CreatePermissionVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RamResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePermissionVersionResponse> {
        /**
         * Sets the value of the Permission property for this object.
         *
         * @param permission
         *        The new value for the Permission property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permission(ResourceSharePermissionDetail permission);

        /**
         * Sets the value of the Permission property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceSharePermissionDetail.Builder}
         * avoiding the need to create one manually via {@link ResourceSharePermissionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSharePermissionDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #permission(ResourceSharePermissionDetail)}.
         * 
         * @param permission
         *        a consumer that will call methods on {@link ResourceSharePermissionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permission(ResourceSharePermissionDetail)
         */
        default Builder permission(Consumer<ResourceSharePermissionDetail.Builder> permission) {
            return permission(ResourceSharePermissionDetail.builder().applyMutation(permission).build());
        }

        /**
         * <p>
         * The idempotency identifier associated with this request. If you want to repeat the same operation in an
         * idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that
         * later call. All other parameters must also have the same values that you used in the first call.
         * </p>
         * 
         * @param clientToken
         *        The idempotency identifier associated with this request. If you want to repeat the same operation in
         *        an idempotent manner then you must include this value in the <code>clientToken</code> request
         *        parameter of that later call. All other parameters must also have the same values that you used in the
         *        first call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private ResourceSharePermissionDetail permission;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePermissionVersionResponse model) {
            super(model);
            permission(model.permission);
            clientToken(model.clientToken);
        }

        public final ResourceSharePermissionDetail.Builder getPermission() {
            return permission != null ? permission.toBuilder() : null;
        }

        public final void setPermission(ResourceSharePermissionDetail.BuilderImpl permission) {
            this.permission = permission != null ? permission.build() : null;
        }

        @Override
        public final Builder permission(ResourceSharePermissionDetail permission) {
            this.permission = permission;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public CreatePermissionVersionResponse build() {
            return new CreatePermissionVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
