/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceShareAssociationsRequest extends RamRequest implements
        ToCopyableBuilder<GetResourceShareAssociationsRequest.Builder, GetResourceShareAssociationsRequest> {
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationType").getter(getter(GetResourceShareAssociationsRequest::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()).build();

    private static final SdkField<List<String>> RESOURCE_SHARE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceShareArns")
            .getter(getter(GetResourceShareAssociationsRequest::resourceShareArns))
            .setter(setter(Builder::resourceShareArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(GetResourceShareAssociationsRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principal").getter(getter(GetResourceShareAssociationsRequest::principal))
            .setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationStatus").getter(getter(GetResourceShareAssociationsRequest::associationStatusAsString))
            .setter(setter(Builder::associationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationStatus").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetResourceShareAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetResourceShareAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_TYPE_FIELD,
            RESOURCE_SHARE_ARNS_FIELD, RESOURCE_ARN_FIELD, PRINCIPAL_FIELD, ASSOCIATION_STATUS_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String associationType;

    private final List<String> resourceShareArns;

    private final String resourceArn;

    private final String principal;

    private final String associationStatus;

    private final String nextToken;

    private final Integer maxResults;

    private GetResourceShareAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.associationType = builder.associationType;
        this.resourceShareArns = builder.resourceShareArns;
        this.resourceArn = builder.resourceArn;
        this.principal = builder.principal;
        this.associationStatus = builder.associationStatus;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Specifies whether you want to retrieve the associations that involve a specified resource or principal.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PRINCIPAL</code> – list the principals whose associations you want to see.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESOURCE</code> – list the resources whose associations you want to see.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link ResourceShareAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return Specifies whether you want to retrieve the associations that involve a specified resource or
     *         principal.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PRINCIPAL</code> – list the principals whose associations you want to see.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESOURCE</code> – list the resources whose associations you want to see.
     *         </p>
     *         </li>
     * @see ResourceShareAssociationType
     */
    public final ResourceShareAssociationType associationType() {
        return ResourceShareAssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * Specifies whether you want to retrieve the associations that involve a specified resource or principal.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PRINCIPAL</code> – list the principals whose associations you want to see.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESOURCE</code> – list the resources whose associations you want to see.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link ResourceShareAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return Specifies whether you want to retrieve the associations that involve a specified resource or
     *         principal.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PRINCIPAL</code> – list the principals whose associations you want to see.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESOURCE</code> – list the resources whose associations you want to see.
     *         </p>
     *         </li>
     * @see ResourceShareAssociationType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceShareArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceShareArns() {
        return resourceShareArns != null && !(resourceShareArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Names (ARNs)</a> of the resource share whose associations you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceShareArns} method.
     * </p>
     * 
     * @return Specifies a list of <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> of the resource share whose associations you want to retrieve.
     */
    public final List<String> resourceShareArns() {
        return resourceShareArns;
    }

    /**
     * <p>
     * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Name (ARN)</a> of a resource whose resource shares you want to retrieve.
     * </p>
     * <p>
     * You cannot specify this parameter if the association type is <code>PRINCIPAL</code>.
     * </p>
     * 
     * @return Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Name (ARN)</a> of a resource whose resource shares you want to retrieve.</p>
     *         <p>
     *         You cannot specify this parameter if the association type is <code>PRINCIPAL</code>.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Specifies the ID of the principal whose resource shares you want to retrieve. This can be an Amazon Web Services
     * account ID, an organization ID, an organizational unit ID, or the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a>
     * of an individual IAM role or user.
     * </p>
     * <p>
     * You cannot specify this parameter if the association type is <code>RESOURCE</code>.
     * </p>
     * 
     * @return Specifies the ID of the principal whose resource shares you want to retrieve. This can be an Amazon Web
     *         Services account ID, an organization ID, an organizational unit ID, or the <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> of an individual IAM role or user.</p>
     *         <p>
     *         You cannot specify this parameter if the association type is <code>RESOURCE</code>.
     */
    public final String principal() {
        return principal;
    }

    /**
     * <p>
     * Specifies that you want to retrieve only associations that have this status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link ResourceShareAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return Specifies that you want to retrieve only associations that have this status.
     * @see ResourceShareAssociationStatus
     */
    public final ResourceShareAssociationStatus associationStatus() {
        return ResourceShareAssociationStatus.fromValue(associationStatus);
    }

    /**
     * <p>
     * Specifies that you want to retrieve only associations that have this status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link ResourceShareAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return Specifies that you want to retrieve only associations that have this status.
     * @see ResourceShareAssociationStatus
     */
    public final String associationStatusAsString() {
        return associationStatus;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>NextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the total number of results that you want included on each page of the response. If you do not include
     * this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the
     * number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the
     * specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next
     * part of the results. Note that the service might return fewer results than the maximum even when there are more
     * results available. You should check <code>NextToken</code> after every operation to ensure that you receive all
     * of the results.
     * </p>
     * 
     * @return Specifies the total number of results that you want included on each page of the response. If you do not
     *         include this parameter, it defaults to a value that is specific to the operation. If additional items
     *         exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value
     *         (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call
     *         to the operation to get the next part of the results. Note that the service might return fewer results
     *         than the maximum even when there are more results available. You should check <code>NextToken</code>
     *         after every operation to ensure that you receive all of the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceShareArns() ? resourceShareArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceShareAssociationsRequest)) {
            return false;
        }
        GetResourceShareAssociationsRequest other = (GetResourceShareAssociationsRequest) obj;
        return Objects.equals(associationTypeAsString(), other.associationTypeAsString())
                && hasResourceShareArns() == other.hasResourceShareArns()
                && Objects.equals(resourceShareArns(), other.resourceShareArns())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(principal(), other.principal())
                && Objects.equals(associationStatusAsString(), other.associationStatusAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceShareAssociationsRequest").add("AssociationType", associationTypeAsString())
                .add("ResourceShareArns", hasResourceShareArns() ? resourceShareArns() : null).add("ResourceArn", resourceArn())
                .add("Principal", principal()).add("AssociationStatus", associationStatusAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        case "resourceShareArns":
            return Optional.ofNullable(clazz.cast(resourceShareArns()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "associationStatus":
            return Optional.ofNullable(clazz.cast(associationStatusAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associationType", ASSOCIATION_TYPE_FIELD);
        map.put("resourceShareArns", RESOURCE_SHARE_ARNS_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("associationStatus", ASSOCIATION_STATUS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceShareAssociationsRequest, T> g) {
        return obj -> g.apply((GetResourceShareAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceShareAssociationsRequest> {
        /**
         * <p>
         * Specifies whether you want to retrieve the associations that involve a specified resource or principal.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PRINCIPAL</code> – list the principals whose associations you want to see.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESOURCE</code> – list the resources whose associations you want to see.
         * </p>
         * </li>
         * </ul>
         * 
         * @param associationType
         *        Specifies whether you want to retrieve the associations that involve a specified resource or
         *        principal.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PRINCIPAL</code> – list the principals whose associations you want to see.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESOURCE</code> – list the resources whose associations you want to see.
         *        </p>
         *        </li>
         * @see ResourceShareAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * Specifies whether you want to retrieve the associations that involve a specified resource or principal.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PRINCIPAL</code> – list the principals whose associations you want to see.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESOURCE</code> – list the resources whose associations you want to see.
         * </p>
         * </li>
         * </ul>
         * 
         * @param associationType
         *        Specifies whether you want to retrieve the associations that involve a specified resource or
         *        principal.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PRINCIPAL</code> – list the principals whose associations you want to see.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESOURCE</code> – list the resources whose associations you want to see.
         *        </p>
         *        </li>
         * @see ResourceShareAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationType
         */
        Builder associationType(ResourceShareAssociationType associationType);

        /**
         * <p>
         * Specifies a list of <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> of the resource share whose associations you want to retrieve.
         * </p>
         * 
         * @param resourceShareArns
         *        Specifies a list of <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> of the resource share whose associations you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArns(Collection<String> resourceShareArns);

        /**
         * <p>
         * Specifies a list of <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> of the resource share whose associations you want to retrieve.
         * </p>
         * 
         * @param resourceShareArns
         *        Specifies a list of <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> of the resource share whose associations you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArns(String... resourceShareArns);

        /**
         * <p>
         * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Name (ARN)</a> of a resource whose resource shares you want to retrieve.
         * </p>
         * <p>
         * You cannot specify this parameter if the association type is <code>PRINCIPAL</code>.
         * </p>
         * 
         * @param resourceArn
         *        Specifies the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of a resource whose resource shares you want to retrieve.</p>
         *        <p>
         *        You cannot specify this parameter if the association type is <code>PRINCIPAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Specifies the ID of the principal whose resource shares you want to retrieve. This can be an Amazon Web
         * Services account ID, an organization ID, an organizational unit ID, or the <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of an individual IAM role or user.
         * </p>
         * <p>
         * You cannot specify this parameter if the association type is <code>RESOURCE</code>.
         * </p>
         * 
         * @param principal
         *        Specifies the ID of the principal whose resource shares you want to retrieve. This can be an Amazon
         *        Web Services account ID, an organization ID, an organizational unit ID, or the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of an individual IAM role or user.</p>
         *        <p>
         *        You cannot specify this parameter if the association type is <code>RESOURCE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * Specifies that you want to retrieve only associations that have this status.
         * </p>
         * 
         * @param associationStatus
         *        Specifies that you want to retrieve only associations that have this status.
         * @see ResourceShareAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationStatus
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * Specifies that you want to retrieve only associations that have this status.
         * </p>
         * 
         * @param associationStatus
         *        Specifies that you want to retrieve only associations that have this status.
         * @see ResourceShareAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationStatus
         */
        Builder associationStatus(ResourceShareAssociationStatus associationStatus);

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the total number of results that you want included on each page of the response. If you do not
         * include this parameter, it defaults to a value that is specific to the operation. If additional items exist
         * beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
         * null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the
         * operation to get the next part of the results. Note that the service might return fewer results than the
         * maximum even when there are more results available. You should check <code>NextToken</code> after every
         * operation to ensure that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        Specifies the total number of results that you want included on each page of the response. If you do
         *        not include this parameter, it defaults to a value that is specific to the operation. If additional
         *        items exist beyond the number you specify, the <code>NextToken</code> response element is returned
         *        with a value (not null). Include the specified value as the <code>NextToken</code> request parameter
         *        in the next call to the operation to get the next part of the results. Note that the service might
         *        return fewer results than the maximum even when there are more results available. You should check
         *        <code>NextToken</code> after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String associationType;

        private List<String> resourceShareArns = DefaultSdkAutoConstructList.getInstance();

        private String resourceArn;

        private String principal;

        private String associationStatus;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceShareAssociationsRequest model) {
            super(model);
            associationType(model.associationType);
            resourceShareArns(model.resourceShareArns);
            resourceArn(model.resourceArn);
            principal(model.principal);
            associationStatus(model.associationStatus);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(ResourceShareAssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final Collection<String> getResourceShareArns() {
            if (resourceShareArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceShareArns;
        }

        public final void setResourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
        }

        @Override
        public final Builder resourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareArns(String... resourceShareArns) {
            resourceShareArns(Arrays.asList(resourceShareArns));
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getAssociationStatus() {
            return associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(ResourceShareAssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceShareAssociationsRequest build() {
            return new GetResourceShareAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
