/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceTypesRequest extends RamRequest implements
        ToCopyableBuilder<ListResourceTypesRequest.Builder, ListResourceTypesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListResourceTypesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListResourceTypesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> RESOURCE_REGION_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceRegionScope").getter(getter(ListResourceTypesRequest::resourceRegionScopeAsString))
            .setter(setter(Builder::resourceRegionScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRegionScope").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, RESOURCE_REGION_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String resourceRegionScope;

    private ListResourceTypesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resourceRegionScope = builder.resourceRegionScope;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>NextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the total number of results that you want included on each page of the response. If you do not include
     * this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the
     * number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the
     * specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next
     * part of the results. Note that the service might return fewer results than the maximum even when there are more
     * results available. You should check <code>NextToken</code> after every operation to ensure that you receive all
     * of the results.
     * </p>
     * 
     * @return Specifies the total number of results that you want included on each page of the response. If you do not
     *         include this parameter, it defaults to a value that is specific to the operation. If additional items
     *         exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value
     *         (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call
     *         to the operation to get the next part of the results. Note that the service might return fewer results
     *         than the maximum even when there are more results available. You should check <code>NextToken</code>
     *         after every operation to ensure that you receive all of the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies that you want the results to include only resources that have the specified scope.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code> – the results include both global and regional resources or resource types.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GLOBAL</code> – the results include only global resources or resource types.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGIONAL</code> – the results include only regional resources or resource types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default value is <code>ALL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceRegionScope} will return {@link ResourceRegionScopeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceRegionScopeAsString}.
     * </p>
     * 
     * @return Specifies that you want the results to include only resources that have the specified scope.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code> – the results include both global and regional resources or resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GLOBAL</code> – the results include only global resources or resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGIONAL</code> – the results include only regional resources or resource types.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default value is <code>ALL</code>.
     * @see ResourceRegionScopeFilter
     */
    public final ResourceRegionScopeFilter resourceRegionScope() {
        return ResourceRegionScopeFilter.fromValue(resourceRegionScope);
    }

    /**
     * <p>
     * Specifies that you want the results to include only resources that have the specified scope.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code> – the results include both global and regional resources or resource types.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GLOBAL</code> – the results include only global resources or resource types.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGIONAL</code> – the results include only regional resources or resource types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default value is <code>ALL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceRegionScope} will return {@link ResourceRegionScopeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceRegionScopeAsString}.
     * </p>
     * 
     * @return Specifies that you want the results to include only resources that have the specified scope.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code> – the results include both global and regional resources or resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GLOBAL</code> – the results include only global resources or resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGIONAL</code> – the results include only regional resources or resource types.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default value is <code>ALL</code>.
     * @see ResourceRegionScopeFilter
     */
    public final String resourceRegionScopeAsString() {
        return resourceRegionScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRegionScopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceTypesRequest)) {
            return false;
        }
        ListResourceTypesRequest other = (ListResourceTypesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(resourceRegionScopeAsString(), other.resourceRegionScopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceTypesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ResourceRegionScope", resourceRegionScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "resourceRegionScope":
            return Optional.ofNullable(clazz.cast(resourceRegionScopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("resourceRegionScope", RESOURCE_REGION_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceTypesRequest, T> g) {
        return obj -> g.apply((ListResourceTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListResourceTypesRequest> {
        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the total number of results that you want included on each page of the response. If you do not
         * include this parameter, it defaults to a value that is specific to the operation. If additional items exist
         * beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
         * null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the
         * operation to get the next part of the results. Note that the service might return fewer results than the
         * maximum even when there are more results available. You should check <code>NextToken</code> after every
         * operation to ensure that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        Specifies the total number of results that you want included on each page of the response. If you do
         *        not include this parameter, it defaults to a value that is specific to the operation. If additional
         *        items exist beyond the number you specify, the <code>NextToken</code> response element is returned
         *        with a value (not null). Include the specified value as the <code>NextToken</code> request parameter
         *        in the next call to the operation to get the next part of the results. Note that the service might
         *        return fewer results than the maximum even when there are more results available. You should check
         *        <code>NextToken</code> after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies that you want the results to include only resources that have the specified scope.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code> – the results include both global and regional resources or resource types.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GLOBAL</code> – the results include only global resources or resource types.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGIONAL</code> – the results include only regional resources or resource types.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default value is <code>ALL</code>.
         * </p>
         * 
         * @param resourceRegionScope
         *        Specifies that you want the results to include only resources that have the specified scope.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code> – the results include both global and regional resources or resource types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GLOBAL</code> – the results include only global resources or resource types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGIONAL</code> – the results include only regional resources or resource types.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default value is <code>ALL</code>.
         * @see ResourceRegionScopeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceRegionScopeFilter
         */
        Builder resourceRegionScope(String resourceRegionScope);

        /**
         * <p>
         * Specifies that you want the results to include only resources that have the specified scope.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code> – the results include both global and regional resources or resource types.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GLOBAL</code> – the results include only global resources or resource types.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGIONAL</code> – the results include only regional resources or resource types.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default value is <code>ALL</code>.
         * </p>
         * 
         * @param resourceRegionScope
         *        Specifies that you want the results to include only resources that have the specified scope.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code> – the results include both global and regional resources or resource types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GLOBAL</code> – the results include only global resources or resource types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGIONAL</code> – the results include only regional resources or resource types.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default value is <code>ALL</code>.
         * @see ResourceRegionScopeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceRegionScopeFilter
         */
        Builder resourceRegionScope(ResourceRegionScopeFilter resourceRegionScope);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String resourceRegionScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceTypesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            resourceRegionScope(model.resourceRegionScope);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getResourceRegionScope() {
            return resourceRegionScope;
        }

        public final void setResourceRegionScope(String resourceRegionScope) {
            this.resourceRegionScope = resourceRegionScope;
        }

        @Override
        public final Builder resourceRegionScope(String resourceRegionScope) {
            this.resourceRegionScope = resourceRegionScope;
            return this;
        }

        @Override
        public final Builder resourceRegionScope(ResourceRegionScopeFilter resourceRegionScope) {
            this.resourceRegionScope(resourceRegionScope == null ? null : resourceRegionScope.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceTypesRequest build() {
            return new ListResourceTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
