/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplacePermissionAssociationsResponse extends RamResponse implements
        ToCopyableBuilder<ReplacePermissionAssociationsResponse.Builder, ReplacePermissionAssociationsResponse> {
    private static final SdkField<ReplacePermissionAssociationsWork> REPLACE_PERMISSION_ASSOCIATIONS_WORK_FIELD = SdkField
            .<ReplacePermissionAssociationsWork> builder(MarshallingType.SDK_POJO)
            .memberName("replacePermissionAssociationsWork")
            .getter(getter(ReplacePermissionAssociationsResponse::replacePermissionAssociationsWork))
            .setter(setter(Builder::replacePermissionAssociationsWork))
            .constructor(ReplacePermissionAssociationsWork::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replacePermissionAssociationsWork")
                    .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(ReplacePermissionAssociationsResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLACE_PERMISSION_ASSOCIATIONS_WORK_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ReplacePermissionAssociationsWork replacePermissionAssociationsWork;

    private final String clientToken;

    private ReplacePermissionAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.replacePermissionAssociationsWork = builder.replacePermissionAssociationsWork;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Specifies a data structure that you can use to track the asynchronous tasks that RAM performs to complete this
     * operation. You can use the <a>ListReplacePermissionAssociationsWork</a> operation and pass the <code>id</code>
     * value returned in this structure.
     * </p>
     * 
     * @return Specifies a data structure that you can use to track the asynchronous tasks that RAM performs to complete
     *         this operation. You can use the <a>ListReplacePermissionAssociationsWork</a> operation and pass the
     *         <code>id</code> value returned in this structure.
     */
    public final ReplacePermissionAssociationsWork replacePermissionAssociationsWork() {
        return replacePermissionAssociationsWork;
    }

    /**
     * <p>
     * The idempotency identifier associated with this request. If you want to repeat the same operation in an
     * idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that
     * later call. All other parameters must also have the same values that you used in the first call.
     * </p>
     * 
     * @return The idempotency identifier associated with this request. If you want to repeat the same operation in an
     *         idempotent manner then you must include this value in the <code>clientToken</code> request parameter of
     *         that later call. All other parameters must also have the same values that you used in the first call.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replacePermissionAssociationsWork());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplacePermissionAssociationsResponse)) {
            return false;
        }
        ReplacePermissionAssociationsResponse other = (ReplacePermissionAssociationsResponse) obj;
        return Objects.equals(replacePermissionAssociationsWork(), other.replacePermissionAssociationsWork())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplacePermissionAssociationsResponse")
                .add("ReplacePermissionAssociationsWork", replacePermissionAssociationsWork()).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replacePermissionAssociationsWork":
            return Optional.ofNullable(clazz.cast(replacePermissionAssociationsWork()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("replacePermissionAssociationsWork", REPLACE_PERMISSION_ASSOCIATIONS_WORK_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplacePermissionAssociationsResponse, T> g) {
        return obj -> g.apply((ReplacePermissionAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ReplacePermissionAssociationsResponse> {
        /**
         * <p>
         * Specifies a data structure that you can use to track the asynchronous tasks that RAM performs to complete
         * this operation. You can use the <a>ListReplacePermissionAssociationsWork</a> operation and pass the
         * <code>id</code> value returned in this structure.
         * </p>
         * 
         * @param replacePermissionAssociationsWork
         *        Specifies a data structure that you can use to track the asynchronous tasks that RAM performs to
         *        complete this operation. You can use the <a>ListReplacePermissionAssociationsWork</a> operation and
         *        pass the <code>id</code> value returned in this structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacePermissionAssociationsWork(ReplacePermissionAssociationsWork replacePermissionAssociationsWork);

        /**
         * <p>
         * Specifies a data structure that you can use to track the asynchronous tasks that RAM performs to complete
         * this operation. You can use the <a>ListReplacePermissionAssociationsWork</a> operation and pass the
         * <code>id</code> value returned in this structure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReplacePermissionAssociationsWork.Builder} avoiding the need to create one manually via
         * {@link ReplacePermissionAssociationsWork#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplacePermissionAssociationsWork.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #replacePermissionAssociationsWork(ReplacePermissionAssociationsWork)}.
         * 
         * @param replacePermissionAssociationsWork
         *        a consumer that will call methods on {@link ReplacePermissionAssociationsWork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replacePermissionAssociationsWork(ReplacePermissionAssociationsWork)
         */
        default Builder replacePermissionAssociationsWork(
                Consumer<ReplacePermissionAssociationsWork.Builder> replacePermissionAssociationsWork) {
            return replacePermissionAssociationsWork(ReplacePermissionAssociationsWork.builder()
                    .applyMutation(replacePermissionAssociationsWork).build());
        }

        /**
         * <p>
         * The idempotency identifier associated with this request. If you want to repeat the same operation in an
         * idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that
         * later call. All other parameters must also have the same values that you used in the first call.
         * </p>
         * 
         * @param clientToken
         *        The idempotency identifier associated with this request. If you want to repeat the same operation in
         *        an idempotent manner then you must include this value in the <code>clientToken</code> request
         *        parameter of that later call. All other parameters must also have the same values that you used in the
         *        first call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private ReplacePermissionAssociationsWork replacePermissionAssociationsWork;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplacePermissionAssociationsResponse model) {
            super(model);
            replacePermissionAssociationsWork(model.replacePermissionAssociationsWork);
            clientToken(model.clientToken);
        }

        public final ReplacePermissionAssociationsWork.Builder getReplacePermissionAssociationsWork() {
            return replacePermissionAssociationsWork != null ? replacePermissionAssociationsWork.toBuilder() : null;
        }

        public final void setReplacePermissionAssociationsWork(
                ReplacePermissionAssociationsWork.BuilderImpl replacePermissionAssociationsWork) {
            this.replacePermissionAssociationsWork = replacePermissionAssociationsWork != null ? replacePermissionAssociationsWork
                    .build() : null;
        }

        @Override
        public final Builder replacePermissionAssociationsWork(ReplacePermissionAssociationsWork replacePermissionAssociationsWork) {
            this.replacePermissionAssociationsWork = replacePermissionAssociationsWork;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public ReplacePermissionAssociationsResponse build() {
            return new ReplacePermissionAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
