/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A tag key and optional list of possible values that you can use to filter results for tagged resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagFilter implements SdkPojo, Serializable, ToCopyableBuilder<TagFilter.Builder, TagFilter> {
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tagKey")
            .getter(getter(TagFilter::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKey").build()).build();

    private static final SdkField<List<String>> TAG_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("tagValues")
            .getter(getter(TagFilter::tagValues))
            .setter(setter(Builder::tagValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_KEY_FIELD,
            TAG_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tagKey;

    private final List<String> tagValues;

    private TagFilter(BuilderImpl builder) {
        this.tagKey = builder.tagKey;
        this.tagValues = builder.tagValues;
    }

    /**
     * <p>
     * The tag key. This must have a valid string value and can't be empty.
     * </p>
     * 
     * @return The tag key. This must have a valid string value and can't be empty.
     */
    public final String tagKey() {
        return tagKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagValues() {
        return tagValues != null && !(tagValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of zero or more tag values. If no values are provided, then the filter matches any tag with the specified
     * key, regardless of its value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagValues} method.
     * </p>
     * 
     * @return A list of zero or more tag values. If no values are provided, then the filter matches any tag with the
     *         specified key, regardless of its value.
     */
    public final List<String> tagValues() {
        return tagValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagValues() ? tagValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagFilter)) {
            return false;
        }
        TagFilter other = (TagFilter) obj;
        return Objects.equals(tagKey(), other.tagKey()) && hasTagValues() == other.hasTagValues()
                && Objects.equals(tagValues(), other.tagValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagFilter").add("TagKey", tagKey()).add("TagValues", hasTagValues() ? tagValues() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "tagValues":
            return Optional.ofNullable(clazz.cast(tagValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tagKey", TAG_KEY_FIELD);
        map.put("tagValues", TAG_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TagFilter, T> g) {
        return obj -> g.apply((TagFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagFilter> {
        /**
         * <p>
         * The tag key. This must have a valid string value and can't be empty.
         * </p>
         * 
         * @param tagKey
         *        The tag key. This must have a valid string value and can't be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * A list of zero or more tag values. If no values are provided, then the filter matches any tag with the
         * specified key, regardless of its value.
         * </p>
         * 
         * @param tagValues
         *        A list of zero or more tag values. If no values are provided, then the filter matches any tag with the
         *        specified key, regardless of its value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(Collection<String> tagValues);

        /**
         * <p>
         * A list of zero or more tag values. If no values are provided, then the filter matches any tag with the
         * specified key, regardless of its value.
         * </p>
         * 
         * @param tagValues
         *        A list of zero or more tag values. If no values are provided, then the filter matches any tag with the
         *        specified key, regardless of its value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(String... tagValues);
    }

    static final class BuilderImpl implements Builder {
        private String tagKey;

        private List<String> tagValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagFilter model) {
            tagKey(model.tagKey);
            tagValues(model.tagValues);
        }

        public final String getTagKey() {
            return tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final Collection<String> getTagValues() {
            if (tagValues instanceof SdkAutoConstructList) {
                return null;
            }
            return tagValues;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String... tagValues) {
            tagValues(Arrays.asList(tagValues));
            return this;
        }

        @Override
        public TagFilter build() {
            return new TagFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
