/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UntagResourceRequest extends RamRequest implements
        ToCopyableBuilder<UntagResourceRequest.Builder, UntagResourceRequest> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceShareArn").getter(getter(UntagResourceRequest::resourceShareArn))
            .setter(setter(Builder::resourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()).build();

    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("tagKeys")
            .getter(getter(UntagResourceRequest::tagKeys))
            .setter(setter(Builder::tagKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(UntagResourceRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD,
            TAG_KEYS_FIELD, RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceShareArn;

    private final List<String> tagKeys;

    private final String resourceArn;

    private UntagResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArn = builder.resourceShareArn;
        this.tagKeys = builder.tagKeys;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Name (ARN)</a> of the resource share that you want to remove tags from. The tags are removed from the
     * resource share, not the resources in the resource share. You must specify either <code>resourceShareArn</code>,
     * or <code>resourceArn</code>, but not both.
     * </p>
     * 
     * @return Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Name (ARN)</a> of the resource share that you want to remove tags from. The tags are removed
     *         from the resource share, not the resources in the resource share. You must specify either
     *         <code>resourceShareArn</code>, or <code>resourceArn</code>, but not both.
     */
    public final String resourceShareArn() {
        return resourceShareArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagKeys() {
        return tagKeys != null && !(tagKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of one or more tag keys that you want to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagKeys} method.
     * </p>
     * 
     * @return Specifies a list of one or more tag keys that you want to remove.
     */
    public final List<String> tagKeys() {
        return tagKeys;
    }

    /**
     * <p>
     * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Name (ARN)</a> of the managed permission that you want to remove tags from. You must specify either
     * <code>resourceArn</code>, or <code>resourceShareArn</code>, but not both.
     * </p>
     * 
     * @return Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Name (ARN)</a> of the managed permission that you want to remove tags from. You must specify
     *         either <code>resourceArn</code>, or <code>resourceShareArn</code>, but not both.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagKeys() ? tagKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest) obj;
        return Objects.equals(resourceShareArn(), other.resourceShareArn()) && hasTagKeys() == other.hasTagKeys()
                && Objects.equals(tagKeys(), other.tagKeys()) && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UntagResourceRequest").add("ResourceShareArn", resourceShareArn())
                .add("TagKeys", hasTagKeys() ? tagKeys() : null).add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareArn":
            return Optional.ofNullable(clazz.cast(resourceShareArn()));
        case "tagKeys":
            return Optional.ofNullable(clazz.cast(tagKeys()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceShareArn", RESOURCE_SHARE_ARN_FIELD);
        map.put("tagKeys", TAG_KEYS_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UntagResourceRequest, T> g) {
        return obj -> g.apply((UntagResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UntagResourceRequest> {
        /**
         * <p>
         * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Name (ARN)</a> of the resource share that you want to remove tags from. The tags are removed from
         * the resource share, not the resources in the resource share. You must specify either
         * <code>resourceShareArn</code>, or <code>resourceArn</code>, but not both.
         * </p>
         * 
         * @param resourceShareArn
         *        Specifies the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of the resource share that you want to remove tags from. The tags are removed from the
         *        resource share, not the resources in the resource share. You must specify either
         *        <code>resourceShareArn</code>, or <code>resourceArn</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArn(String resourceShareArn);

        /**
         * <p>
         * Specifies a list of one or more tag keys that you want to remove.
         * </p>
         * 
         * @param tagKeys
         *        Specifies a list of one or more tag keys that you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(Collection<String> tagKeys);

        /**
         * <p>
         * Specifies a list of one or more tag keys that you want to remove.
         * </p>
         * 
         * @param tagKeys
         *        Specifies a list of one or more tag keys that you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(String... tagKeys);

        /**
         * <p>
         * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Name (ARN)</a> of the managed permission that you want to remove tags from. You must specify either
         * <code>resourceArn</code>, or <code>resourceShareArn</code>, but not both.
         * </p>
         * 
         * @param resourceArn
         *        Specifies the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of the managed permission that you want to remove tags from. You must specify either
         *        <code>resourceArn</code>, or <code>resourceShareArn</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String resourceShareArn;

        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourceRequest model) {
            super(model);
            resourceShareArn(model.resourceShareArn);
            tagKeys(model.tagKeys);
            resourceArn(model.resourceArn);
        }

        public final String getResourceShareArn() {
            return resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final Collection<String> getTagKeys() {
            if (tagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return tagKeys;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String... tagKeys) {
            tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UntagResourceRequest build() {
            return new UntagResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
