/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rbin.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Recycle Bin retention rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleSummary implements SdkPojo, Serializable, ToCopyableBuilder<RuleSummary.Builder, RuleSummary> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(RuleSummary::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RuleSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("RetentionPeriod")
            .getter(getter(RuleSummary::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            DESCRIPTION_FIELD, RETENTION_PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String description;

    private final RetentionPeriod retentionPeriod;

    private RuleSummary(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.description = builder.description;
        this.retentionPeriod = builder.retentionPeriod;
    }

    /**
     * <p>
     * The unique ID of the retention rule.
     * </p>
     * 
     * @return The unique ID of the retention rule.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The description for the retention rule.
     * </p>
     * 
     * @return The description for the retention rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the retention period for which the retention rule retains resources
     * </p>
     * 
     * @return Information about the retention period for which the retention rule retains resources
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleSummary)) {
            return false;
        }
        RuleSummary other = (RuleSummary) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(description(), other.description())
                && Objects.equals(retentionPeriod(), other.retentionPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleSummary").add("Identifier", identifier()).add("Description", description())
                .add("RetentionPeriod", retentionPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleSummary, T> g) {
        return obj -> g.apply((RuleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleSummary> {
        /**
         * <p>
         * The unique ID of the retention rule.
         * </p>
         * 
         * @param identifier
         *        The unique ID of the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The description for the retention rule.
         * </p>
         * 
         * @param description
         *        The description for the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the retention period for which the retention rule retains resources
         * </p>
         * 
         * @param retentionPeriod
         *        Information about the retention period for which the retention rule retains resources
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * Information about the retention period for which the retention rule retains resources
         * </p>
         * This is a convenience that creates an instance of the {@link RetentionPeriod.Builder} avoiding the need to
         * create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String description;

        private RetentionPeriod retentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleSummary model) {
            identifier(model.identifier);
            description(model.description);
            retentionPeriod(model.retentionPeriod);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        @Transient
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        @Transient
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        @Override
        public RuleSummary build() {
            return new RuleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
