/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rbin.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the retention period for which the retention rule is to retain resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetentionPeriod implements SdkPojo, Serializable, ToCopyableBuilder<RetentionPeriod.Builder, RetentionPeriod> {
    private static final SdkField<Integer> RETENTION_PERIOD_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionPeriodValue").getter(getter(RetentionPeriod::retentionPeriodValue))
            .setter(setter(Builder::retentionPeriodValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodValue").build())
            .build();

    private static final SdkField<String> RETENTION_PERIOD_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetentionPeriodUnit").getter(getter(RetentionPeriod::retentionPeriodUnitAsString))
            .setter(setter(Builder::retentionPeriodUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodUnit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_PERIOD_VALUE_FIELD,
            RETENTION_PERIOD_UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer retentionPeriodValue;

    private final String retentionPeriodUnit;

    private RetentionPeriod(BuilderImpl builder) {
        this.retentionPeriodValue = builder.retentionPeriodValue;
        this.retentionPeriodUnit = builder.retentionPeriodUnit;
    }

    /**
     * <p>
     * The period value for which the retention rule is to retain resources. The period is measured using the unit
     * specified for <b>RetentionPeriodUnit</b>.
     * </p>
     * 
     * @return The period value for which the retention rule is to retain resources. The period is measured using the
     *         unit specified for <b>RetentionPeriodUnit</b>.
     */
    public final Integer retentionPeriodValue() {
        return retentionPeriodValue;
    }

    /**
     * <p>
     * The unit of time in which the retention period is measured. Currently, only <code>DAYS</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #retentionPeriodUnit} will return {@link RetentionPeriodUnit#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #retentionPeriodUnitAsString}.
     * </p>
     * 
     * @return The unit of time in which the retention period is measured. Currently, only <code>DAYS</code> is
     *         supported.
     * @see RetentionPeriodUnit
     */
    public final RetentionPeriodUnit retentionPeriodUnit() {
        return RetentionPeriodUnit.fromValue(retentionPeriodUnit);
    }

    /**
     * <p>
     * The unit of time in which the retention period is measured. Currently, only <code>DAYS</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #retentionPeriodUnit} will return {@link RetentionPeriodUnit#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #retentionPeriodUnitAsString}.
     * </p>
     * 
     * @return The unit of time in which the retention period is measured. Currently, only <code>DAYS</code> is
     *         supported.
     * @see RetentionPeriodUnit
     */
    public final String retentionPeriodUnitAsString() {
        return retentionPeriodUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodValue());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionPeriod)) {
            return false;
        }
        RetentionPeriod other = (RetentionPeriod) obj;
        return Objects.equals(retentionPeriodValue(), other.retentionPeriodValue())
                && Objects.equals(retentionPeriodUnitAsString(), other.retentionPeriodUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetentionPeriod").add("RetentionPeriodValue", retentionPeriodValue())
                .add("RetentionPeriodUnit", retentionPeriodUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionPeriodValue":
            return Optional.ofNullable(clazz.cast(retentionPeriodValue()));
        case "RetentionPeriodUnit":
            return Optional.ofNullable(clazz.cast(retentionPeriodUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetentionPeriod, T> g) {
        return obj -> g.apply((RetentionPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetentionPeriod> {
        /**
         * <p>
         * The period value for which the retention rule is to retain resources. The period is measured using the unit
         * specified for <b>RetentionPeriodUnit</b>.
         * </p>
         * 
         * @param retentionPeriodValue
         *        The period value for which the retention rule is to retain resources. The period is measured using the
         *        unit specified for <b>RetentionPeriodUnit</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodValue(Integer retentionPeriodValue);

        /**
         * <p>
         * The unit of time in which the retention period is measured. Currently, only <code>DAYS</code> is supported.
         * </p>
         * 
         * @param retentionPeriodUnit
         *        The unit of time in which the retention period is measured. Currently, only <code>DAYS</code> is
         *        supported.
         * @see RetentionPeriodUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionPeriodUnit
         */
        Builder retentionPeriodUnit(String retentionPeriodUnit);

        /**
         * <p>
         * The unit of time in which the retention period is measured. Currently, only <code>DAYS</code> is supported.
         * </p>
         * 
         * @param retentionPeriodUnit
         *        The unit of time in which the retention period is measured. Currently, only <code>DAYS</code> is
         *        supported.
         * @see RetentionPeriodUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionPeriodUnit
         */
        Builder retentionPeriodUnit(RetentionPeriodUnit retentionPeriodUnit);
    }

    static final class BuilderImpl implements Builder {
        private Integer retentionPeriodValue;

        private String retentionPeriodUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionPeriod model) {
            retentionPeriodValue(model.retentionPeriodValue);
            retentionPeriodUnit(model.retentionPeriodUnit);
        }

        public final Integer getRetentionPeriodValue() {
            return retentionPeriodValue;
        }

        public final void setRetentionPeriodValue(Integer retentionPeriodValue) {
            this.retentionPeriodValue = retentionPeriodValue;
        }

        @Override
        @Transient
        public final Builder retentionPeriodValue(Integer retentionPeriodValue) {
            this.retentionPeriodValue = retentionPeriodValue;
            return this;
        }

        public final String getRetentionPeriodUnit() {
            return retentionPeriodUnit;
        }

        public final void setRetentionPeriodUnit(String retentionPeriodUnit) {
            this.retentionPeriodUnit = retentionPeriodUnit;
        }

        @Override
        @Transient
        public final Builder retentionPeriodUnit(String retentionPeriodUnit) {
            this.retentionPeriodUnit = retentionPeriodUnit;
            return this;
        }

        @Override
        @Transient
        public final Builder retentionPeriodUnit(RetentionPeriodUnit retentionPeriodUnit) {
            this.retentionPeriodUnit(retentionPeriodUnit == null ? null : retentionPeriodUnit.toString());
            return this;
        }

        @Override
        public RetentionPeriod build() {
            return new RetentionPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
