/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rbin;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rbin.DefaultRbinAsyncClient;
import software.amazon.awssdk.services.rbin.DefaultRbinBaseClientBuilder;
import software.amazon.awssdk.services.rbin.RbinAsyncClient;
import software.amazon.awssdk.services.rbin.RbinAsyncClientBuilder;
import software.amazon.awssdk.services.rbin.RbinServiceClientConfiguration;
import software.amazon.awssdk.services.rbin.endpoints.RbinEndpointProvider;

@SdkInternalApi
final class DefaultRbinAsyncClientBuilder
extends DefaultRbinBaseClientBuilder<RbinAsyncClientBuilder, RbinAsyncClient>
implements RbinAsyncClientBuilder {
    DefaultRbinAsyncClientBuilder() {
    }

    @Override
    public DefaultRbinAsyncClientBuilder endpointProvider(RbinEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RbinAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRbinAsyncClientBuilder.validateClientOptions(clientConfiguration);
        RbinServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRbinAsyncClient client = new DefaultRbinAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RbinServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RbinServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

