/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rbin.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rbin.model.ExcludeResourceTagsCopier;
import software.amazon.awssdk.services.rbin.model.LockConfiguration;
import software.amazon.awssdk.services.rbin.model.LockState;
import software.amazon.awssdk.services.rbin.model.RbinResponse;
import software.amazon.awssdk.services.rbin.model.ResourceTag;
import software.amazon.awssdk.services.rbin.model.ResourceTagsCopier;
import software.amazon.awssdk.services.rbin.model.ResourceType;
import software.amazon.awssdk.services.rbin.model.RetentionPeriod;
import software.amazon.awssdk.services.rbin.model.RuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRuleResponse
extends RbinResponse
implements ToCopyableBuilder<Builder, GetRuleResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(GetRuleResponse.getter(GetRuleResponse::identifier)).setter(GetRuleResponse.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetRuleResponse.getter(GetRuleResponse::description)).setter(GetRuleResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(GetRuleResponse.getter(GetRuleResponse::resourceTypeAsString)).setter(GetRuleResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetentionPeriod").getter(GetRuleResponse.getter(GetRuleResponse::retentionPeriod)).setter(GetRuleResponse.setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(GetRuleResponse.getter(GetRuleResponse::resourceTags)).setter(GetRuleResponse.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetRuleResponse.getter(GetRuleResponse::statusAsString)).setter(GetRuleResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<LockConfiguration> LOCK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LockConfiguration").getter(GetRuleResponse.getter(GetRuleResponse::lockConfiguration)).setter(GetRuleResponse.setter(Builder::lockConfiguration)).constructor(LockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockConfiguration").build()}).build();
    private static final SdkField<String> LOCK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LockState").getter(GetRuleResponse.getter(GetRuleResponse::lockStateAsString)).setter(GetRuleResponse.setter(Builder::lockState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockState").build()}).build();
    private static final SdkField<Instant> LOCK_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LockEndTime").getter(GetRuleResponse.getter(GetRuleResponse::lockEndTime)).setter(GetRuleResponse.setter(Builder::lockEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockEndTime").build()}).build();
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(GetRuleResponse.getter(GetRuleResponse::ruleArn)).setter(GetRuleResponse.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final SdkField<List<ResourceTag>> EXCLUDE_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeResourceTags").getter(GetRuleResponse.getter(GetRuleResponse::excludeResourceTags)).setter(GetRuleResponse.setter(Builder::excludeResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, DESCRIPTION_FIELD, RESOURCE_TYPE_FIELD, RETENTION_PERIOD_FIELD, RESOURCE_TAGS_FIELD, STATUS_FIELD, LOCK_CONFIGURATION_FIELD, LOCK_STATE_FIELD, LOCK_END_TIME_FIELD, RULE_ARN_FIELD, EXCLUDE_RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Identifier", IDENTIFIER_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
            this.put("ResourceTags", RESOURCE_TAGS_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("LockConfiguration", LOCK_CONFIGURATION_FIELD);
            this.put("LockState", LOCK_STATE_FIELD);
            this.put("LockEndTime", LOCK_END_TIME_FIELD);
            this.put("RuleArn", RULE_ARN_FIELD);
            this.put("ExcludeResourceTags", EXCLUDE_RESOURCE_TAGS_FIELD);
        }
    });
    private final String identifier;
    private final String description;
    private final String resourceType;
    private final RetentionPeriod retentionPeriod;
    private final List<ResourceTag> resourceTags;
    private final String status;
    private final LockConfiguration lockConfiguration;
    private final String lockState;
    private final Instant lockEndTime;
    private final String ruleArn;
    private final List<ResourceTag> excludeResourceTags;

    private GetRuleResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.description = builder.description;
        this.resourceType = builder.resourceType;
        this.retentionPeriod = builder.retentionPeriod;
        this.resourceTags = builder.resourceTags;
        this.status = builder.status;
        this.lockConfiguration = builder.lockConfiguration;
        this.lockState = builder.lockState;
        this.lockEndTime = builder.lockEndTime;
        this.ruleArn = builder.ruleArn;
        this.excludeResourceTags = builder.excludeResourceTags;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String description() {
        return this.description;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final RetentionPeriod retentionPeriod() {
        return this.retentionPeriod;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public final RuleStatus status() {
        return RuleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final LockConfiguration lockConfiguration() {
        return this.lockConfiguration;
    }

    public final LockState lockState() {
        return LockState.fromValue(this.lockState);
    }

    public final String lockStateAsString() {
        return this.lockState;
    }

    public final Instant lockEndTime() {
        return this.lockEndTime;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    public final boolean hasExcludeResourceTags() {
        return this.excludeResourceTags != null && !(this.excludeResourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> excludeResourceTags() {
        return this.excludeResourceTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeResourceTags() ? this.excludeResourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRuleResponse)) {
            return false;
        }
        GetRuleResponse other = (GetRuleResponse)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lockConfiguration(), other.lockConfiguration()) && Objects.equals(this.lockStateAsString(), other.lockStateAsString()) && Objects.equals(this.lockEndTime(), other.lockEndTime()) && Objects.equals(this.ruleArn(), other.ruleArn()) && this.hasExcludeResourceTags() == other.hasExcludeResourceTags() && Objects.equals(this.excludeResourceTags(), other.excludeResourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"GetRuleResponse").add("Identifier", (Object)this.identifier()).add("Description", (Object)this.description()).add("ResourceType", (Object)this.resourceTypeAsString()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("Status", (Object)this.statusAsString()).add("LockConfiguration", (Object)this.lockConfiguration()).add("LockState", (Object)this.lockStateAsString()).add("LockEndTime", (Object)this.lockEndTime()).add("RuleArn", (Object)this.ruleArn()).add("ExcludeResourceTags", this.hasExcludeResourceTags() ? this.excludeResourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LockConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lockConfiguration()));
            }
            case "LockState": {
                return Optional.ofNullable(clazz.cast(this.lockStateAsString()));
            }
            case "LockEndTime": {
                return Optional.ofNullable(clazz.cast(this.lockEndTime()));
            }
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "ExcludeResourceTags": {
                return Optional.ofNullable(clazz.cast(this.excludeResourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRuleResponse, T> g) {
        return obj -> g.apply((GetRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RbinResponse.BuilderImpl
    implements Builder {
        private String identifier;
        private String description;
        private String resourceType;
        private RetentionPeriod retentionPeriod;
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private LockConfiguration lockConfiguration;
        private String lockState;
        private Instant lockEndTime;
        private String ruleArn;
        private List<ResourceTag> excludeResourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRuleResponse model) {
            super(model);
            this.identifier(model.identifier);
            this.description(model.description);
            this.resourceType(model.resourceType);
            this.retentionPeriod(model.retentionPeriod);
            this.resourceTags(model.resourceTags);
            this.status(model.status);
            this.lockConfiguration(model.lockConfiguration);
            this.lockState(model.lockState);
            this.lockEndTime(model.lockEndTime);
            this.ruleArn(model.ruleArn);
            this.excludeResourceTags(model.excludeResourceTags);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagsCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final LockConfiguration.Builder getLockConfiguration() {
            return this.lockConfiguration != null ? this.lockConfiguration.toBuilder() : null;
        }

        public final void setLockConfiguration(LockConfiguration.BuilderImpl lockConfiguration) {
            this.lockConfiguration = lockConfiguration != null ? lockConfiguration.build() : null;
        }

        @Override
        public final Builder lockConfiguration(LockConfiguration lockConfiguration) {
            this.lockConfiguration = lockConfiguration;
            return this;
        }

        public final String getLockState() {
            return this.lockState;
        }

        public final void setLockState(String lockState) {
            this.lockState = lockState;
        }

        @Override
        public final Builder lockState(String lockState) {
            this.lockState = lockState;
            return this;
        }

        @Override
        public final Builder lockState(LockState lockState) {
            this.lockState(lockState == null ? null : lockState.toString());
            return this;
        }

        public final Instant getLockEndTime() {
            return this.lockEndTime;
        }

        public final void setLockEndTime(Instant lockEndTime) {
            this.lockEndTime = lockEndTime;
        }

        @Override
        public final Builder lockEndTime(Instant lockEndTime) {
            this.lockEndTime = lockEndTime;
            return this;
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final List<ResourceTag.Builder> getExcludeResourceTags() {
            List<ResourceTag.Builder> result = ExcludeResourceTagsCopier.copyToBuilder(this.excludeResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeResourceTags(Collection<ResourceTag.BuilderImpl> excludeResourceTags) {
            this.excludeResourceTags = ExcludeResourceTagsCopier.copyFromBuilder(excludeResourceTags);
        }

        @Override
        public final Builder excludeResourceTags(Collection<ResourceTag> excludeResourceTags) {
            this.excludeResourceTags = ExcludeResourceTagsCopier.copy(excludeResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeResourceTags(ResourceTag ... excludeResourceTags) {
            this.excludeResourceTags(Arrays.asList(excludeResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeResourceTags(Consumer<ResourceTag.Builder> ... excludeResourceTags) {
            this.excludeResourceTags(Stream.of(excludeResourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRuleResponse build() {
            return new GetRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RbinResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRuleResponse> {
        public Builder identifier(String var1);

        public Builder description(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder retentionPeriod(RetentionPeriod var1);

        default public Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return this.retentionPeriod((RetentionPeriod)((RetentionPeriod.Builder)RetentionPeriod.builder().applyMutation(retentionPeriod)).build());
        }

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(RuleStatus var1);

        public Builder lockConfiguration(LockConfiguration var1);

        default public Builder lockConfiguration(Consumer<LockConfiguration.Builder> lockConfiguration) {
            return this.lockConfiguration((LockConfiguration)((LockConfiguration.Builder)LockConfiguration.builder().applyMutation(lockConfiguration)).build());
        }

        public Builder lockState(String var1);

        public Builder lockState(LockState var1);

        public Builder lockEndTime(Instant var1);

        public Builder ruleArn(String var1);

        public Builder excludeResourceTags(Collection<ResourceTag> var1);

        public Builder excludeResourceTags(ResourceTag ... var1);

        public Builder excludeResourceTags(Consumer<ResourceTag.Builder> ... var1);
    }
}

