/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rbin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a retention rule lock configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LockConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LockConfiguration.Builder, LockConfiguration> {
    private static final SdkField<UnlockDelay> UNLOCK_DELAY_FIELD = SdkField.<UnlockDelay> builder(MarshallingType.SDK_POJO)
            .memberName("UnlockDelay").getter(getter(LockConfiguration::unlockDelay)).setter(setter(Builder::unlockDelay))
            .constructor(UnlockDelay::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnlockDelay").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNLOCK_DELAY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UnlockDelay unlockDelay;

    private LockConfiguration(BuilderImpl builder) {
        this.unlockDelay = builder.unlockDelay;
    }

    /**
     * <p>
     * Information about the retention rule unlock delay.
     * </p>
     * 
     * @return Information about the retention rule unlock delay.
     */
    public final UnlockDelay unlockDelay() {
        return unlockDelay;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unlockDelay());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockConfiguration)) {
            return false;
        }
        LockConfiguration other = (LockConfiguration) obj;
        return Objects.equals(unlockDelay(), other.unlockDelay());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LockConfiguration").add("UnlockDelay", unlockDelay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnlockDelay":
            return Optional.ofNullable(clazz.cast(unlockDelay()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UnlockDelay", UNLOCK_DELAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LockConfiguration, T> g) {
        return obj -> g.apply((LockConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LockConfiguration> {
        /**
         * <p>
         * Information about the retention rule unlock delay.
         * </p>
         * 
         * @param unlockDelay
         *        Information about the retention rule unlock delay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unlockDelay(UnlockDelay unlockDelay);

        /**
         * <p>
         * Information about the retention rule unlock delay.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnlockDelay.Builder} avoiding the need to
         * create one manually via {@link UnlockDelay#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnlockDelay.Builder#build()} is called immediately and its result
         * is passed to {@link #unlockDelay(UnlockDelay)}.
         * 
         * @param unlockDelay
         *        a consumer that will call methods on {@link UnlockDelay.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unlockDelay(UnlockDelay)
         */
        default Builder unlockDelay(Consumer<UnlockDelay.Builder> unlockDelay) {
            return unlockDelay(UnlockDelay.builder().applyMutation(unlockDelay).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UnlockDelay unlockDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(LockConfiguration model) {
            unlockDelay(model.unlockDelay);
        }

        public final UnlockDelay.Builder getUnlockDelay() {
            return unlockDelay != null ? unlockDelay.toBuilder() : null;
        }

        public final void setUnlockDelay(UnlockDelay.BuilderImpl unlockDelay) {
            this.unlockDelay = unlockDelay != null ? unlockDelay.build() : null;
        }

        @Override
        public final Builder unlockDelay(UnlockDelay unlockDelay) {
            this.unlockDelay = unlockDelay;
            return this;
        }

        @Override
        public LockConfiguration build() {
            return new LockConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
