/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rbin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Recycle Bin retention rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleSummary implements SdkPojo, Serializable, ToCopyableBuilder<RuleSummary.Builder, RuleSummary> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(RuleSummary::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RuleSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("RetentionPeriod")
            .getter(getter(RuleSummary::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<String> LOCK_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LockState").getter(getter(RuleSummary::lockStateAsString)).setter(setter(Builder::lockState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockState").build()).build();

    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleArn").getter(getter(RuleSummary::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            DESCRIPTION_FIELD, RETENTION_PERIOD_FIELD, LOCK_STATE_FIELD, RULE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String description;

    private final RetentionPeriod retentionPeriod;

    private final String lockState;

    private final String ruleArn;

    private RuleSummary(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.description = builder.description;
        this.retentionPeriod = builder.retentionPeriod;
        this.lockState = builder.lockState;
        this.ruleArn = builder.ruleArn;
    }

    /**
     * <p>
     * The unique ID of the retention rule.
     * </p>
     * 
     * @return The unique ID of the retention rule.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The retention rule description.
     * </p>
     * 
     * @return The retention rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the retention period for which the retention rule is to retain resources.
     * </p>
     * 
     * @return Information about the retention period for which the retention rule is to retain resources.
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * [Region-level retention rules only] The lock state for the retention rule.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
     * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
     * required permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
     * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition back to
     * <code>null</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return [Region-level retention rules only] The lock state for the retention rule.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
     *         delay period. The retention rule can be modified or deleted only after the unlock delay period has
     *         expired.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with
     *         the required permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it
     *         can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
     *         transition back to <code>null</code>.
     *         </p>
     *         </li>
     * @see LockState
     */
    public final LockState lockState() {
        return LockState.fromValue(lockState);
    }

    /**
     * <p>
     * [Region-level retention rules only] The lock state for the retention rule.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
     * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
     * required permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
     * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition back to
     * <code>null</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return [Region-level retention rules only] The lock state for the retention rule.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
     *         delay period. The retention rule can be modified or deleted only after the unlock delay period has
     *         expired.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with
     *         the required permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it
     *         can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
     *         transition back to <code>null</code>.
     *         </p>
     *         </li>
     * @see LockState
     */
    public final String lockStateAsString() {
        return lockState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the retention rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the retention rule.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(lockStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleSummary)) {
            return false;
        }
        RuleSummary other = (RuleSummary) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(description(), other.description())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(lockStateAsString(), other.lockStateAsString()) && Objects.equals(ruleArn(), other.ruleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleSummary").add("Identifier", identifier()).add("Description", description())
                .add("RetentionPeriod", retentionPeriod()).add("LockState", lockStateAsString()).add("RuleArn", ruleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "LockState":
            return Optional.ofNullable(clazz.cast(lockStateAsString()));
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("LockState", LOCK_STATE_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleSummary, T> g) {
        return obj -> g.apply((RuleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleSummary> {
        /**
         * <p>
         * The unique ID of the retention rule.
         * </p>
         * 
         * @param identifier
         *        The unique ID of the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The retention rule description.
         * </p>
         * 
         * @param description
         *        The retention rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the retention period for which the retention rule is to retain resources.
         * </p>
         * 
         * @param retentionPeriod
         *        Information about the retention period for which the retention rule is to retain resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * Information about the retention period for which the retention rule is to retain resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionPeriod.Builder} avoiding the
         * need to create one manually via {@link RetentionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * [Region-level retention rules only] The lock state for the retention rule.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
         * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
         * required permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
         * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition
         * back to <code>null</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockState
         *        [Region-level retention rules only] The lock state for the retention rule.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
         *        delay period. The retention rule can be modified or deleted only after the unlock delay period has
         *        expired.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user
         *        with the required permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked,
         *        it can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
         *        transition back to <code>null</code>.
         *        </p>
         *        </li>
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(String lockState);

        /**
         * <p>
         * [Region-level retention rules only] The lock state for the retention rule.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
         * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
         * required permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
         * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition
         * back to <code>null</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockState
         *        [Region-level retention rules only] The lock state for the retention rule.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
         *        delay period. The retention rule can be modified or deleted only after the unlock delay period has
         *        expired.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user
         *        with the required permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked,
         *        it can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
         *        transition back to <code>null</code>.
         *        </p>
         *        </li>
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(LockState lockState);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the retention rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) of the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String description;

        private RetentionPeriod retentionPeriod;

        private String lockState;

        private String ruleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleSummary model) {
            identifier(model.identifier);
            description(model.description);
            retentionPeriod(model.retentionPeriod);
            lockState(model.lockState);
            ruleArn(model.ruleArn);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getLockState() {
            return lockState;
        }

        public final void setLockState(String lockState) {
            this.lockState = lockState;
        }

        @Override
        public final Builder lockState(String lockState) {
            this.lockState = lockState;
            return this;
        }

        @Override
        public final Builder lockState(LockState lockState) {
            this.lockState(lockState == null ? null : lockState.toString());
            return this;
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        @Override
        public RuleSummary build() {
            return new RuleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
