/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rbin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleResponse extends RbinResponse implements
        ToCopyableBuilder<CreateRuleResponse.Builder, CreateRuleResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(CreateRuleResponse::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("RetentionPeriod")
            .getter(getter(CreateRuleResponse::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateRuleResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateRuleResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(CreateRuleResponse::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(CreateRuleResponse::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateRuleResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<LockConfiguration> LOCK_CONFIGURATION_FIELD = SdkField
            .<LockConfiguration> builder(MarshallingType.SDK_POJO).memberName("LockConfiguration")
            .getter(getter(CreateRuleResponse::lockConfiguration)).setter(setter(Builder::lockConfiguration))
            .constructor(LockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockConfiguration").build()).build();

    private static final SdkField<String> LOCK_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LockState").getter(getter(CreateRuleResponse::lockStateAsString)).setter(setter(Builder::lockState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockState").build()).build();

    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleArn").getter(getter(CreateRuleResponse::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<List<ResourceTag>> EXCLUDE_RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ExcludeResourceTags")
            .getter(getter(CreateRuleResponse::excludeResourceTags))
            .setter(setter(Builder::excludeResourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            RETENTION_PERIOD_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TAGS_FIELD, STATUS_FIELD,
            LOCK_CONFIGURATION_FIELD, LOCK_STATE_FIELD, RULE_ARN_FIELD, EXCLUDE_RESOURCE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final RetentionPeriod retentionPeriod;

    private final String description;

    private final List<Tag> tags;

    private final String resourceType;

    private final List<ResourceTag> resourceTags;

    private final String status;

    private final LockConfiguration lockConfiguration;

    private final String lockState;

    private final String ruleArn;

    private final List<ResourceTag> excludeResourceTags;

    private CreateRuleResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.retentionPeriod = builder.retentionPeriod;
        this.description = builder.description;
        this.tags = builder.tags;
        this.resourceType = builder.resourceType;
        this.resourceTags = builder.resourceTags;
        this.status = builder.status;
        this.lockConfiguration = builder.lockConfiguration;
        this.lockState = builder.lockState;
        this.ruleArn = builder.ruleArn;
        this.excludeResourceTags = builder.excludeResourceTags;
    }

    /**
     * <p>
     * The unique ID of the retention rule.
     * </p>
     * 
     * @return The unique ID of the retention rule.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * Returns the value of the RetentionPeriod property for this object.
     * 
     * @return The value of the RetentionPeriod property for this object.
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * The retention rule description.
     * </p>
     * 
     * @return The retention rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the tags assigned to the retention rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Information about the tags assigned to the retention rule.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The resource type retained by the retention rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type retained by the retention rule.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type retained by the retention rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type retained by the retention rule.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [Tag-level retention rules only] Information about the resource tags used to identify resources that are retained
     * by the retention rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return [Tag-level retention rules only] Information about the resource tags used to identify resources that are
     *         retained by the retention rule.
     */
    public final List<ResourceTag> resourceTags() {
        return resourceTags;
    }

    /**
     * <p>
     * The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
     * resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
     *         resources.
     * @see RuleStatus
     */
    public final RuleStatus status() {
        return RuleStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
     * resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
     *         resources.
     * @see RuleStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about the retention rule lock configuration.
     * </p>
     * 
     * @return Information about the retention rule lock configuration.
     */
    public final LockConfiguration lockConfiguration() {
        return lockConfiguration;
    }

    /**
     * <p>
     * [Region-level retention rules only] The lock state for the retention rule.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
     * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
     * required permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
     * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition back to
     * <code>null</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return [Region-level retention rules only] The lock state for the retention rule.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
     *         delay period. The retention rule can be modified or deleted only after the unlock delay period has
     *         expired.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with
     *         the required permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it
     *         can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
     *         transition back to <code>null</code>.
     *         </p>
     *         </li>
     * @see LockState
     */
    public final LockState lockState() {
        return LockState.fromValue(lockState);
    }

    /**
     * <p>
     * [Region-level retention rules only] The lock state for the retention rule.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
     * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
     * required permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
     * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition back to
     * <code>null</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return [Region-level retention rules only] The lock state for the retention rule.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>locked</code> - The retention rule is locked and can't be modified or deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
     *         delay period. The retention rule can be modified or deleted only after the unlock delay period has
     *         expired.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with
     *         the required permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it
     *         can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
     *         transition back to <code>null</code>.
     *         </p>
     *         </li>
     * @see LockState
     */
    public final String lockStateAsString() {
        return lockState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the retention rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the retention rule.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeResourceTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeResourceTags() {
        return excludeResourceTags != null && !(excludeResourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [Region-level retention rules only] Information about the exclusion tags used to identify resources that are to
     * be excluded, or ignored, by the retention rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeResourceTags} method.
     * </p>
     * 
     * @return [Region-level retention rules only] Information about the exclusion tags used to identify resources that
     *         are to be excluded, or ignored, by the retention rule.
     */
    public final List<ResourceTag> excludeResourceTags() {
        return excludeResourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lockStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeResourceTags() ? excludeResourceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleResponse)) {
            return false;
        }
        CreateRuleResponse other = (CreateRuleResponse) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lockConfiguration(), other.lockConfiguration())
                && Objects.equals(lockStateAsString(), other.lockStateAsString()) && Objects.equals(ruleArn(), other.ruleArn())
                && hasExcludeResourceTags() == other.hasExcludeResourceTags()
                && Objects.equals(excludeResourceTags(), other.excludeResourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleResponse").add("Identifier", identifier()).add("RetentionPeriod", retentionPeriod())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null)
                .add("ResourceType", resourceTypeAsString()).add("ResourceTags", hasResourceTags() ? resourceTags() : null)
                .add("Status", statusAsString()).add("LockConfiguration", lockConfiguration())
                .add("LockState", lockStateAsString()).add("RuleArn", ruleArn())
                .add("ExcludeResourceTags", hasExcludeResourceTags() ? excludeResourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LockConfiguration":
            return Optional.ofNullable(clazz.cast(lockConfiguration()));
        case "LockState":
            return Optional.ofNullable(clazz.cast(lockStateAsString()));
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "ExcludeResourceTags":
            return Optional.ofNullable(clazz.cast(excludeResourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LockConfiguration", LOCK_CONFIGURATION_FIELD);
        map.put("LockState", LOCK_STATE_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("ExcludeResourceTags", EXCLUDE_RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleResponse, T> g) {
        return obj -> g.apply((CreateRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RbinResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleResponse> {
        /**
         * <p>
         * The unique ID of the retention rule.
         * </p>
         * 
         * @param identifier
         *        The unique ID of the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * Sets the value of the RetentionPeriod property for this object.
         *
         * @param retentionPeriod
         *        The new value for the RetentionPeriod property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * Sets the value of the RetentionPeriod property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RetentionPeriod.Builder} avoiding the
         * need to create one manually via {@link RetentionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * The retention rule description.
         * </p>
         * 
         * @param description
         *        The retention rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the tags assigned to the retention rule.
         * </p>
         * 
         * @param tags
         *        Information about the tags assigned to the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Information about the tags assigned to the retention rule.
         * </p>
         * 
         * @param tags
         *        Information about the tags assigned to the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Information about the tags assigned to the retention rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rbin.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rbin.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rbin.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rbin.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The resource type retained by the retention rule.
         * </p>
         * 
         * @param resourceType
         *        The resource type retained by the retention rule.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type retained by the retention rule.
         * </p>
         * 
         * @param resourceType
         *        The resource type retained by the retention rule.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * [Tag-level retention rules only] Information about the resource tags used to identify resources that are
         * retained by the retention rule.
         * </p>
         * 
         * @param resourceTags
         *        [Tag-level retention rules only] Information about the resource tags used to identify resources that
         *        are retained by the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<ResourceTag> resourceTags);

        /**
         * <p>
         * [Tag-level retention rules only] Information about the resource tags used to identify resources that are
         * retained by the retention rule.
         * </p>
         * 
         * @param resourceTags
         *        [Tag-level retention rules only] Information about the resource tags used to identify resources that
         *        are retained by the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(ResourceTag... resourceTags);

        /**
         * <p>
         * [Tag-level retention rules only] Information about the resource tags used to identify resources that are
         * retained by the retention rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rbin.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceTags(List<ResourceTag>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(java.util.Collection<ResourceTag>)
         */
        Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags);

        /**
         * <p>
         * The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
         * resources.
         * </p>
         * 
         * @param status
         *        The state of the retention rule. Only retention rules that are in the <code>available</code> state
         *        retain resources.
         * @see RuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the retention rule. Only retention rules that are in the <code>available</code> state retain
         * resources.
         * </p>
         * 
         * @param status
         *        The state of the retention rule. Only retention rules that are in the <code>available</code> state
         *        retain resources.
         * @see RuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleStatus
         */
        Builder status(RuleStatus status);

        /**
         * <p>
         * Information about the retention rule lock configuration.
         * </p>
         * 
         * @param lockConfiguration
         *        Information about the retention rule lock configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockConfiguration(LockConfiguration lockConfiguration);

        /**
         * <p>
         * Information about the retention rule lock configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LockConfiguration.Builder} avoiding the
         * need to create one manually via {@link LockConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LockConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #lockConfiguration(LockConfiguration)}.
         * 
         * @param lockConfiguration
         *        a consumer that will call methods on {@link LockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lockConfiguration(LockConfiguration)
         */
        default Builder lockConfiguration(Consumer<LockConfiguration.Builder> lockConfiguration) {
            return lockConfiguration(LockConfiguration.builder().applyMutation(lockConfiguration).build());
        }

        /**
         * <p>
         * [Region-level retention rules only] The lock state for the retention rule.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
         * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
         * required permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
         * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition
         * back to <code>null</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockState
         *        [Region-level retention rules only] The lock state for the retention rule.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
         *        delay period. The retention rule can be modified or deleted only after the unlock delay period has
         *        expired.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user
         *        with the required permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked,
         *        it can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
         *        transition back to <code>null</code>.
         *        </p>
         *        </li>
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(String lockState);

        /**
         * <p>
         * [Region-level retention rules only] The lock state for the retention rule.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock delay
         * period. The retention rule can be modified or deleted only after the unlock delay period has expired.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user with the
         * required permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked, it can
         * transition between the <code>locked</code> and <code>unlocked</code> states only; it can never transition
         * back to <code>null</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockState
         *        [Region-level retention rules only] The lock state for the retention rule.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>locked</code> - The retention rule is locked and can't be modified or deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending_unlock</code> - The retention rule has been unlocked but it is still within the unlock
         *        delay period. The retention rule can be modified or deleted only after the unlock delay period has
         *        expired.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unlocked</code> - The retention rule is unlocked and it can be modified or deleted by any user
         *        with the required permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>null</code> - The retention rule has never been locked. Once a retention rule has been locked,
         *        it can transition between the <code>locked</code> and <code>unlocked</code> states only; it can never
         *        transition back to <code>null</code>.
         *        </p>
         *        </li>
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(LockState lockState);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the retention rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) of the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * [Region-level retention rules only] Information about the exclusion tags used to identify resources that are
         * to be excluded, or ignored, by the retention rule.
         * </p>
         * 
         * @param excludeResourceTags
         *        [Region-level retention rules only] Information about the exclusion tags used to identify resources
         *        that are to be excluded, or ignored, by the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeResourceTags(Collection<ResourceTag> excludeResourceTags);

        /**
         * <p>
         * [Region-level retention rules only] Information about the exclusion tags used to identify resources that are
         * to be excluded, or ignored, by the retention rule.
         * </p>
         * 
         * @param excludeResourceTags
         *        [Region-level retention rules only] Information about the exclusion tags used to identify resources
         *        that are to be excluded, or ignored, by the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeResourceTags(ResourceTag... excludeResourceTags);

        /**
         * <p>
         * [Region-level retention rules only] Information about the exclusion tags used to identify resources that are
         * to be excluded, or ignored, by the retention rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rbin.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder#build()} is called immediately and its
         * result is passed to {@link #excludeResourceTags(List<ResourceTag>)}.
         * 
         * @param excludeResourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludeResourceTags(java.util.Collection<ResourceTag>)
         */
        Builder excludeResourceTags(Consumer<ResourceTag.Builder>... excludeResourceTags);
    }

    static final class BuilderImpl extends RbinResponse.BuilderImpl implements Builder {
        private String identifier;

        private RetentionPeriod retentionPeriod;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String resourceType;

        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private LockConfiguration lockConfiguration;

        private String lockState;

        private String ruleArn;

        private List<ResourceTag> excludeResourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleResponse model) {
            super(model);
            identifier(model.identifier);
            retentionPeriod(model.retentionPeriod);
            description(model.description);
            tags(model.tags);
            resourceType(model.resourceType);
            resourceTags(model.resourceTags);
            status(model.status);
            lockConfiguration(model.lockConfiguration);
            lockState(model.lockState);
            ruleArn(model.ruleArn);
            excludeResourceTags(model.excludeResourceTags);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagsCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final LockConfiguration.Builder getLockConfiguration() {
            return lockConfiguration != null ? lockConfiguration.toBuilder() : null;
        }

        public final void setLockConfiguration(LockConfiguration.BuilderImpl lockConfiguration) {
            this.lockConfiguration = lockConfiguration != null ? lockConfiguration.build() : null;
        }

        @Override
        public final Builder lockConfiguration(LockConfiguration lockConfiguration) {
            this.lockConfiguration = lockConfiguration;
            return this;
        }

        public final String getLockState() {
            return lockState;
        }

        public final void setLockState(String lockState) {
            this.lockState = lockState;
        }

        @Override
        public final Builder lockState(String lockState) {
            this.lockState = lockState;
            return this;
        }

        @Override
        public final Builder lockState(LockState lockState) {
            this.lockState(lockState == null ? null : lockState.toString());
            return this;
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final List<ResourceTag.Builder> getExcludeResourceTags() {
            List<ResourceTag.Builder> result = ExcludeResourceTagsCopier.copyToBuilder(this.excludeResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeResourceTags(Collection<ResourceTag.BuilderImpl> excludeResourceTags) {
            this.excludeResourceTags = ExcludeResourceTagsCopier.copyFromBuilder(excludeResourceTags);
        }

        @Override
        public final Builder excludeResourceTags(Collection<ResourceTag> excludeResourceTags) {
            this.excludeResourceTags = ExcludeResourceTagsCopier.copy(excludeResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeResourceTags(ResourceTag... excludeResourceTags) {
            excludeResourceTags(Arrays.asList(excludeResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeResourceTags(Consumer<ResourceTag.Builder>... excludeResourceTags) {
            excludeResourceTags(Stream.of(excludeResourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateRuleResponse build() {
            return new CreateRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
