/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rbin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the retention rule unlock delay. The unlock delay is the period after which a retention rule can be
 * modified or edited after it has been unlocked by a user with the required permissions. The retention rule can't be
 * modified or deleted during the unlock delay.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnlockDelay implements SdkPojo, Serializable, ToCopyableBuilder<UnlockDelay.Builder, UnlockDelay> {
    private static final SdkField<Integer> UNLOCK_DELAY_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UnlockDelayValue").getter(getter(UnlockDelay::unlockDelayValue))
            .setter(setter(Builder::unlockDelayValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnlockDelayValue").build()).build();

    private static final SdkField<String> UNLOCK_DELAY_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnlockDelayUnit").getter(getter(UnlockDelay::unlockDelayUnitAsString))
            .setter(setter(Builder::unlockDelayUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnlockDelayUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNLOCK_DELAY_VALUE_FIELD,
            UNLOCK_DELAY_UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer unlockDelayValue;

    private final String unlockDelayUnit;

    private UnlockDelay(BuilderImpl builder) {
        this.unlockDelayValue = builder.unlockDelayValue;
        this.unlockDelayUnit = builder.unlockDelayUnit;
    }

    /**
     * <p>
     * The unlock delay period, measured in the unit specified for <b> UnlockDelayUnit</b>.
     * </p>
     * 
     * @return The unlock delay period, measured in the unit specified for <b> UnlockDelayUnit</b>.
     */
    public final Integer unlockDelayValue() {
        return unlockDelayValue;
    }

    /**
     * <p>
     * The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in days.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unlockDelayUnit}
     * will return {@link UnlockDelayUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #unlockDelayUnitAsString}.
     * </p>
     * 
     * @return The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in
     *         days.
     * @see UnlockDelayUnit
     */
    public final UnlockDelayUnit unlockDelayUnit() {
        return UnlockDelayUnit.fromValue(unlockDelayUnit);
    }

    /**
     * <p>
     * The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in days.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unlockDelayUnit}
     * will return {@link UnlockDelayUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #unlockDelayUnitAsString}.
     * </p>
     * 
     * @return The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in
     *         days.
     * @see UnlockDelayUnit
     */
    public final String unlockDelayUnitAsString() {
        return unlockDelayUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unlockDelayValue());
        hashCode = 31 * hashCode + Objects.hashCode(unlockDelayUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlockDelay)) {
            return false;
        }
        UnlockDelay other = (UnlockDelay) obj;
        return Objects.equals(unlockDelayValue(), other.unlockDelayValue())
                && Objects.equals(unlockDelayUnitAsString(), other.unlockDelayUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnlockDelay").add("UnlockDelayValue", unlockDelayValue())
                .add("UnlockDelayUnit", unlockDelayUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnlockDelayValue":
            return Optional.ofNullable(clazz.cast(unlockDelayValue()));
        case "UnlockDelayUnit":
            return Optional.ofNullable(clazz.cast(unlockDelayUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UnlockDelayValue", UNLOCK_DELAY_VALUE_FIELD);
        map.put("UnlockDelayUnit", UNLOCK_DELAY_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnlockDelay, T> g) {
        return obj -> g.apply((UnlockDelay) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnlockDelay> {
        /**
         * <p>
         * The unlock delay period, measured in the unit specified for <b> UnlockDelayUnit</b>.
         * </p>
         * 
         * @param unlockDelayValue
         *        The unlock delay period, measured in the unit specified for <b> UnlockDelayUnit</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unlockDelayValue(Integer unlockDelayValue);

        /**
         * <p>
         * The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in
         * days.
         * </p>
         * 
         * @param unlockDelayUnit
         *        The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only
         *        in days.
         * @see UnlockDelayUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlockDelayUnit
         */
        Builder unlockDelayUnit(String unlockDelayUnit);

        /**
         * <p>
         * The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in
         * days.
         * </p>
         * 
         * @param unlockDelayUnit
         *        The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only
         *        in days.
         * @see UnlockDelayUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlockDelayUnit
         */
        Builder unlockDelayUnit(UnlockDelayUnit unlockDelayUnit);
    }

    static final class BuilderImpl implements Builder {
        private Integer unlockDelayValue;

        private String unlockDelayUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(UnlockDelay model) {
            unlockDelayValue(model.unlockDelayValue);
            unlockDelayUnit(model.unlockDelayUnit);
        }

        public final Integer getUnlockDelayValue() {
            return unlockDelayValue;
        }

        public final void setUnlockDelayValue(Integer unlockDelayValue) {
            this.unlockDelayValue = unlockDelayValue;
        }

        @Override
        public final Builder unlockDelayValue(Integer unlockDelayValue) {
            this.unlockDelayValue = unlockDelayValue;
            return this;
        }

        public final String getUnlockDelayUnit() {
            return unlockDelayUnit;
        }

        public final void setUnlockDelayUnit(String unlockDelayUnit) {
            this.unlockDelayUnit = unlockDelayUnit;
        }

        @Override
        public final Builder unlockDelayUnit(String unlockDelayUnit) {
            this.unlockDelayUnit = unlockDelayUnit;
            return this;
        }

        @Override
        public final Builder unlockDelayUnit(UnlockDelayUnit unlockDelayUnit) {
            this.unlockDelayUnit(unlockDelayUnit == null ? null : unlockDelayUnit.toString());
            return this;
        }

        @Override
        public UnlockDelay build() {
            return new UnlockDelay(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
