/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rbin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRuleRequest extends RbinRequest implements
        ToCopyableBuilder<UpdateRuleRequest.Builder, UpdateRuleRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateRuleRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("RetentionPeriod")
            .getter(getter(UpdateRuleRequest::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateRuleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(UpdateRuleRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(UpdateRuleRequest::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceTag>> EXCLUDE_RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ExcludeResourceTags")
            .getter(getter(UpdateRuleRequest::excludeResourceTags))
            .setter(setter(Builder::excludeResourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            RETENTION_PERIOD_FIELD, DESCRIPTION_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TAGS_FIELD, EXCLUDE_RESOURCE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final RetentionPeriod retentionPeriod;

    private final String description;

    private final String resourceType;

    private final List<ResourceTag> resourceTags;

    private final List<ResourceTag> excludeResourceTags;

    private UpdateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.retentionPeriod = builder.retentionPeriod;
        this.description = builder.description;
        this.resourceType = builder.resourceType;
        this.resourceTags = builder.resourceTags;
        this.excludeResourceTags = builder.excludeResourceTags;
    }

    /**
     * <p>
     * The unique ID of the retention rule.
     * </p>
     * 
     * @return The unique ID of the retention rule.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Information about the retention period for which the retention rule is to retain resources.
     * </p>
     * 
     * @return Information about the retention period for which the retention rule is to retain resources.
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * The retention rule description.
     * </p>
     * 
     * @return The retention rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * <note>
     * <p>
     * This parameter is currently not supported. You can't update a retention rule's resource type after creation.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         This parameter is currently not supported. You can't update a retention rule's resource type after
     *         creation.
     *         </p>
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <note>
     * <p>
     * This parameter is currently not supported. You can't update a retention rule's resource type after creation.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         This parameter is currently not supported. You can't update a retention rule's resource type after
     *         creation.
     *         </p>
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [Tag-level retention rules only] Specifies the resource tags to use to identify resources that are to be retained
     * by a tag-level retention rule. For tag-level retention rules, only deleted resources, of the specified resource
     * type, that have one or more of the specified tag key and value pairs are retained. If a resource is deleted, but
     * it does not have any of the specified tag key and value pairs, it is immediately deleted without being retained
     * by the retention rule.
     * </p>
     * <p>
     * You can add the same tag key and value pair to a maximum or five retention rules.
     * </p>
     * <p>
     * To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not have any
     * resource tags specified. It retains all deleted resources of the specified resource type in the Region in which
     * the rule is created, even if the resources are not tagged.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return [Tag-level retention rules only] Specifies the resource tags to use to identify resources that are to be
     *         retained by a tag-level retention rule. For tag-level retention rules, only deleted resources, of the
     *         specified resource type, that have one or more of the specified tag key and value pairs are retained. If
     *         a resource is deleted, but it does not have any of the specified tag key and value pairs, it is
     *         immediately deleted without being retained by the retention rule.</p>
     *         <p>
     *         You can add the same tag key and value pair to a maximum or five retention rules.
     *         </p>
     *         <p>
     *         To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not have
     *         any resource tags specified. It retains all deleted resources of the specified resource type in the
     *         Region in which the rule is created, even if the resources are not tagged.
     */
    public final List<ResourceTag> resourceTags() {
        return resourceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeResourceTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeResourceTags() {
        return excludeResourceTags != null && !(excludeResourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [Region-level retention rules only] Specifies the exclusion tags to use to identify resources that are to be
     * excluded, or ignored, by a Region-level retention rule. Resources that have any of these tags are not retained by
     * the retention rule upon deletion.
     * </p>
     * <p>
     * You can't specify exclusion tags for tag-level retention rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeResourceTags} method.
     * </p>
     * 
     * @return [Region-level retention rules only] Specifies the exclusion tags to use to identify resources that are to
     *         be excluded, or ignored, by a Region-level retention rule. Resources that have any of these tags are not
     *         retained by the retention rule upon deletion.</p>
     *         <p>
     *         You can't specify exclusion tags for tag-level retention rules.
     */
    public final List<ResourceTag> excludeResourceTags() {
        return excludeResourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeResourceTags() ? excludeResourceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleRequest)) {
            return false;
        }
        UpdateRuleRequest other = (UpdateRuleRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(description(), other.description())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags())
                && hasExcludeResourceTags() == other.hasExcludeResourceTags()
                && Objects.equals(excludeResourceTags(), other.excludeResourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRuleRequest").add("Identifier", identifier()).add("RetentionPeriod", retentionPeriod())
                .add("Description", description()).add("ResourceType", resourceTypeAsString())
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null)
                .add("ExcludeResourceTags", hasExcludeResourceTags() ? excludeResourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "ExcludeResourceTags":
            return Optional.ofNullable(clazz.cast(excludeResourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("ExcludeResourceTags", EXCLUDE_RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleRequest, T> g) {
        return obj -> g.apply((UpdateRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RbinRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRuleRequest> {
        /**
         * <p>
         * The unique ID of the retention rule.
         * </p>
         * 
         * @param identifier
         *        The unique ID of the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Information about the retention period for which the retention rule is to retain resources.
         * </p>
         * 
         * @param retentionPeriod
         *        Information about the retention period for which the retention rule is to retain resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * Information about the retention period for which the retention rule is to retain resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionPeriod.Builder} avoiding the
         * need to create one manually via {@link RetentionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * The retention rule description.
         * </p>
         * 
         * @param description
         *        The retention rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <note>
         * <p>
         * This parameter is currently not supported. You can't update a retention rule's resource type after creation.
         * </p>
         * </note>
         * 
         * @param resourceType
         *        <p>
         *        This parameter is currently not supported. You can't update a retention rule's resource type after
         *        creation.
         *        </p>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <note>
         * <p>
         * This parameter is currently not supported. You can't update a retention rule's resource type after creation.
         * </p>
         * </note>
         * 
         * @param resourceType
         *        <p>
         *        This parameter is currently not supported. You can't update a retention rule's resource type after
         *        creation.
         *        </p>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * [Tag-level retention rules only] Specifies the resource tags to use to identify resources that are to be
         * retained by a tag-level retention rule. For tag-level retention rules, only deleted resources, of the
         * specified resource type, that have one or more of the specified tag key and value pairs are retained. If a
         * resource is deleted, but it does not have any of the specified tag key and value pairs, it is immediately
         * deleted without being retained by the retention rule.
         * </p>
         * <p>
         * You can add the same tag key and value pair to a maximum or five retention rules.
         * </p>
         * <p>
         * To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not have any
         * resource tags specified. It retains all deleted resources of the specified resource type in the Region in
         * which the rule is created, even if the resources are not tagged.
         * </p>
         * 
         * @param resourceTags
         *        [Tag-level retention rules only] Specifies the resource tags to use to identify resources that are to
         *        be retained by a tag-level retention rule. For tag-level retention rules, only deleted resources, of
         *        the specified resource type, that have one or more of the specified tag key and value pairs are
         *        retained. If a resource is deleted, but it does not have any of the specified tag key and value pairs,
         *        it is immediately deleted without being retained by the retention rule.</p>
         *        <p>
         *        You can add the same tag key and value pair to a maximum or five retention rules.
         *        </p>
         *        <p>
         *        To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not
         *        have any resource tags specified. It retains all deleted resources of the specified resource type in
         *        the Region in which the rule is created, even if the resources are not tagged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<ResourceTag> resourceTags);

        /**
         * <p>
         * [Tag-level retention rules only] Specifies the resource tags to use to identify resources that are to be
         * retained by a tag-level retention rule. For tag-level retention rules, only deleted resources, of the
         * specified resource type, that have one or more of the specified tag key and value pairs are retained. If a
         * resource is deleted, but it does not have any of the specified tag key and value pairs, it is immediately
         * deleted without being retained by the retention rule.
         * </p>
         * <p>
         * You can add the same tag key and value pair to a maximum or five retention rules.
         * </p>
         * <p>
         * To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not have any
         * resource tags specified. It retains all deleted resources of the specified resource type in the Region in
         * which the rule is created, even if the resources are not tagged.
         * </p>
         * 
         * @param resourceTags
         *        [Tag-level retention rules only] Specifies the resource tags to use to identify resources that are to
         *        be retained by a tag-level retention rule. For tag-level retention rules, only deleted resources, of
         *        the specified resource type, that have one or more of the specified tag key and value pairs are
         *        retained. If a resource is deleted, but it does not have any of the specified tag key and value pairs,
         *        it is immediately deleted without being retained by the retention rule.</p>
         *        <p>
         *        You can add the same tag key and value pair to a maximum or five retention rules.
         *        </p>
         *        <p>
         *        To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not
         *        have any resource tags specified. It retains all deleted resources of the specified resource type in
         *        the Region in which the rule is created, even if the resources are not tagged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(ResourceTag... resourceTags);

        /**
         * <p>
         * [Tag-level retention rules only] Specifies the resource tags to use to identify resources that are to be
         * retained by a tag-level retention rule. For tag-level retention rules, only deleted resources, of the
         * specified resource type, that have one or more of the specified tag key and value pairs are retained. If a
         * resource is deleted, but it does not have any of the specified tag key and value pairs, it is immediately
         * deleted without being retained by the retention rule.
         * </p>
         * <p>
         * You can add the same tag key and value pair to a maximum or five retention rules.
         * </p>
         * <p>
         * To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not have any
         * resource tags specified. It retains all deleted resources of the specified resource type in the Region in
         * which the rule is created, even if the resources are not tagged.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rbin.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceTags(List<ResourceTag>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(java.util.Collection<ResourceTag>)
         */
        Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags);

        /**
         * <p>
         * [Region-level retention rules only] Specifies the exclusion tags to use to identify resources that are to be
         * excluded, or ignored, by a Region-level retention rule. Resources that have any of these tags are not
         * retained by the retention rule upon deletion.
         * </p>
         * <p>
         * You can't specify exclusion tags for tag-level retention rules.
         * </p>
         * 
         * @param excludeResourceTags
         *        [Region-level retention rules only] Specifies the exclusion tags to use to identify resources that are
         *        to be excluded, or ignored, by a Region-level retention rule. Resources that have any of these tags
         *        are not retained by the retention rule upon deletion.</p>
         *        <p>
         *        You can't specify exclusion tags for tag-level retention rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeResourceTags(Collection<ResourceTag> excludeResourceTags);

        /**
         * <p>
         * [Region-level retention rules only] Specifies the exclusion tags to use to identify resources that are to be
         * excluded, or ignored, by a Region-level retention rule. Resources that have any of these tags are not
         * retained by the retention rule upon deletion.
         * </p>
         * <p>
         * You can't specify exclusion tags for tag-level retention rules.
         * </p>
         * 
         * @param excludeResourceTags
         *        [Region-level retention rules only] Specifies the exclusion tags to use to identify resources that are
         *        to be excluded, or ignored, by a Region-level retention rule. Resources that have any of these tags
         *        are not retained by the retention rule upon deletion.</p>
         *        <p>
         *        You can't specify exclusion tags for tag-level retention rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeResourceTags(ResourceTag... excludeResourceTags);

        /**
         * <p>
         * [Region-level retention rules only] Specifies the exclusion tags to use to identify resources that are to be
         * excluded, or ignored, by a Region-level retention rule. Resources that have any of these tags are not
         * retained by the retention rule upon deletion.
         * </p>
         * <p>
         * You can't specify exclusion tags for tag-level retention rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rbin.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder#build()} is called immediately and its
         * result is passed to {@link #excludeResourceTags(List<ResourceTag>)}.
         * 
         * @param excludeResourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludeResourceTags(java.util.Collection<ResourceTag>)
         */
        Builder excludeResourceTags(Consumer<ResourceTag.Builder>... excludeResourceTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RbinRequest.BuilderImpl implements Builder {
        private String identifier;

        private RetentionPeriod retentionPeriod;

        private String description;

        private String resourceType;

        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceTag> excludeResourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleRequest model) {
            super(model);
            identifier(model.identifier);
            retentionPeriod(model.retentionPeriod);
            description(model.description);
            resourceType(model.resourceType);
            resourceTags(model.resourceTags);
            excludeResourceTags(model.excludeResourceTags);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagsCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceTag.Builder> getExcludeResourceTags() {
            List<ResourceTag.Builder> result = ExcludeResourceTagsCopier.copyToBuilder(this.excludeResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeResourceTags(Collection<ResourceTag.BuilderImpl> excludeResourceTags) {
            this.excludeResourceTags = ExcludeResourceTagsCopier.copyFromBuilder(excludeResourceTags);
        }

        @Override
        public final Builder excludeResourceTags(Collection<ResourceTag> excludeResourceTags) {
            this.excludeResourceTags = ExcludeResourceTagsCopier.copy(excludeResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeResourceTags(ResourceTag... excludeResourceTags) {
            excludeResourceTags(Arrays.asList(excludeResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeResourceTags(Consumer<ResourceTag.Builder>... excludeResourceTags) {
            excludeResourceTags(Stream.of(excludeResourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleRequest build() {
            return new UpdateRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
