/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyDBClusterSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CopyDBClusterSnapshotRequest> {
    private final String sourceDBClusterSnapshotIdentifier;
    private final String targetDBClusterSnapshotIdentifier;
    private final String kmsKeyId;
    private final String preSignedUrl;
    private final Boolean copyTags;
    private final List<Tag> tags;

    private CopyDBClusterSnapshotRequest(BuilderImpl builder) {
        this.sourceDBClusterSnapshotIdentifier = builder.sourceDBClusterSnapshotIdentifier;
        this.targetDBClusterSnapshotIdentifier = builder.targetDBClusterSnapshotIdentifier;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.copyTags = builder.copyTags;
        this.tags = builder.tags;
    }

    public String sourceDBClusterSnapshotIdentifier() {
        return this.sourceDBClusterSnapshotIdentifier;
    }

    public String targetDBClusterSnapshotIdentifier() {
        return this.targetDBClusterSnapshotIdentifier;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String preSignedUrl() {
        return this.preSignedUrl;
    }

    public Boolean copyTags() {
        return this.copyTags;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceDBClusterSnapshotIdentifier() == null ? 0 : this.sourceDBClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.targetDBClusterSnapshotIdentifier() == null ? 0 : this.targetDBClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.preSignedUrl() == null ? 0 : this.preSignedUrl().hashCode());
        hashCode = 31 * hashCode + (this.copyTags() == null ? 0 : this.copyTags().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBClusterSnapshotRequest)) {
            return false;
        }
        CopyDBClusterSnapshotRequest other = (CopyDBClusterSnapshotRequest)((Object)obj);
        if (other.sourceDBClusterSnapshotIdentifier() == null ^ this.sourceDBClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.sourceDBClusterSnapshotIdentifier() != null && !other.sourceDBClusterSnapshotIdentifier().equals(this.sourceDBClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.targetDBClusterSnapshotIdentifier() == null ^ this.targetDBClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.targetDBClusterSnapshotIdentifier() != null && !other.targetDBClusterSnapshotIdentifier().equals(this.targetDBClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.preSignedUrl() == null ^ this.preSignedUrl() == null) {
            return false;
        }
        if (other.preSignedUrl() != null && !other.preSignedUrl().equals(this.preSignedUrl())) {
            return false;
        }
        if (other.copyTags() == null ^ this.copyTags() == null) {
            return false;
        }
        if (other.copyTags() != null && !other.copyTags().equals(this.copyTags())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceDBClusterSnapshotIdentifier() != null) {
            sb.append("SourceDBClusterSnapshotIdentifier: ").append(this.sourceDBClusterSnapshotIdentifier()).append(",");
        }
        if (this.targetDBClusterSnapshotIdentifier() != null) {
            sb.append("TargetDBClusterSnapshotIdentifier: ").append(this.targetDBClusterSnapshotIdentifier()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.preSignedUrl() != null) {
            sb.append("PreSignedUrl: ").append(this.preSignedUrl()).append(",");
        }
        if (this.copyTags() != null) {
            sb.append("CopyTags: ").append(this.copyTags()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourceDBClusterSnapshotIdentifier;
        private String targetDBClusterSnapshotIdentifier;
        private String kmsKeyId;
        private String preSignedUrl;
        private Boolean copyTags;
        private List<Tag> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDBClusterSnapshotRequest model) {
            this.setSourceDBClusterSnapshotIdentifier(model.sourceDBClusterSnapshotIdentifier);
            this.setTargetDBClusterSnapshotIdentifier(model.targetDBClusterSnapshotIdentifier);
            this.setKmsKeyId(model.kmsKeyId);
            this.setPreSignedUrl(model.preSignedUrl);
            this.setCopyTags(model.copyTags);
            this.setTags(model.tags);
        }

        public final String getSourceDBClusterSnapshotIdentifier() {
            return this.sourceDBClusterSnapshotIdentifier;
        }

        @Override
        public final Builder sourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
            this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
            return this;
        }

        public final void setSourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
            this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
        }

        public final String getTargetDBClusterSnapshotIdentifier() {
            return this.targetDBClusterSnapshotIdentifier;
        }

        @Override
        public final Builder targetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
            this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
            return this;
        }

        public final void setTargetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
            this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public CopyDBClusterSnapshotRequest build() {
            return new CopyDBClusterSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopyDBClusterSnapshotRequest> {
        public Builder sourceDBClusterSnapshotIdentifier(String var1);

        public Builder targetDBClusterSnapshotIdentifier(String var1);

        public Builder kmsKeyId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder copyTags(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

