/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo;
import software.amazon.awssdk.services.rds.model.DBInstanceStatusInfoListCopier;
import software.amazon.awssdk.services.rds.model.DBParameterGroupStatus;
import software.amazon.awssdk.services.rds.model.DBParameterGroupStatusListCopier;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.rds.model.DBSubnetGroup;
import software.amazon.awssdk.services.rds.model.DomainMembership;
import software.amazon.awssdk.services.rds.model.DomainMembershipListCopier;
import software.amazon.awssdk.services.rds.model.Endpoint;
import software.amazon.awssdk.services.rds.model.OptionGroupMembership;
import software.amazon.awssdk.services.rds.model.OptionGroupMembershipListCopier;
import software.amazon.awssdk.services.rds.model.PendingModifiedValues;
import software.amazon.awssdk.services.rds.model.ReadReplicaDBClusterIdentifierListCopier;
import software.amazon.awssdk.services.rds.model.ReadReplicaDBInstanceIdentifierListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBInstance
implements ToCopyableBuilder<Builder, DBInstance> {
    private final String dbInstanceIdentifier;
    private final String dbInstanceClass;
    private final String engine;
    private final String dbInstanceStatus;
    private final String masterUsername;
    private final String dbName;
    private final Endpoint endpoint;
    private final Integer allocatedStorage;
    private final Date instanceCreateTime;
    private final String preferredBackupWindow;
    private final Integer backupRetentionPeriod;
    private final List<DBSecurityGroupMembership> dbSecurityGroups;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final List<DBParameterGroupStatus> dbParameterGroups;
    private final String availabilityZone;
    private final DBSubnetGroup dbSubnetGroup;
    private final String preferredMaintenanceWindow;
    private final PendingModifiedValues pendingModifiedValues;
    private final Date latestRestorableTime;
    private final Boolean multiAZ;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final String readReplicaSourceDBInstanceIdentifier;
    private final List<String> readReplicaDBInstanceIdentifiers;
    private final List<String> readReplicaDBClusterIdentifiers;
    private final String licenseModel;
    private final Integer iops;
    private final List<OptionGroupMembership> optionGroupMemberships;
    private final String characterSetName;
    private final String secondaryAvailabilityZone;
    private final Boolean publiclyAccessible;
    private final List<DBInstanceStatusInfo> statusInfos;
    private final String storageType;
    private final String tdeCredentialArn;
    private final Integer dbInstancePort;
    private final String dbClusterIdentifier;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbiResourceId;
    private final String caCertificateIdentifier;
    private final List<DomainMembership> domainMemberships;
    private final Boolean copyTagsToSnapshot;
    private final Integer monitoringInterval;
    private final String enhancedMonitoringResourceArn;
    private final String monitoringRoleArn;
    private final Integer promotionTier;
    private final String dbInstanceArn;
    private final String timezone;
    private final Boolean iamDatabaseAuthenticationEnabled;

    private DBInstance(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.engine = builder.engine;
        this.dbInstanceStatus = builder.dbInstanceStatus;
        this.masterUsername = builder.masterUsername;
        this.dbName = builder.dbName;
        this.endpoint = builder.endpoint;
        this.allocatedStorage = builder.allocatedStorage;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.dbParameterGroups = builder.dbParameterGroups;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.readReplicaSourceDBInstanceIdentifier = builder.readReplicaSourceDBInstanceIdentifier;
        this.readReplicaDBInstanceIdentifiers = builder.readReplicaDBInstanceIdentifiers;
        this.readReplicaDBClusterIdentifiers = builder.readReplicaDBClusterIdentifiers;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupMemberships = builder.optionGroupMemberships;
        this.characterSetName = builder.characterSetName;
        this.secondaryAvailabilityZone = builder.secondaryAvailabilityZone;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.statusInfos = builder.statusInfos;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.dbInstancePort = builder.dbInstancePort;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbiResourceId = builder.dbiResourceId;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.domainMemberships = builder.domainMemberships;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.enhancedMonitoringResourceArn = builder.enhancedMonitoringResourceArn;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.promotionTier = builder.promotionTier;
        this.dbInstanceArn = builder.dbInstanceArn;
        this.timezone = builder.timezone;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String engine() {
        return this.engine;
    }

    public String dbInstanceStatus() {
        return this.dbInstanceStatus;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String dbName() {
        return this.dbName;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public Date instanceCreateTime() {
        return this.instanceCreateTime;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public List<DBSecurityGroupMembership> dbSecurityGroups() {
        return this.dbSecurityGroups;
    }

    public List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public List<DBParameterGroupStatus> dbParameterGroups() {
        return this.dbParameterGroups;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public DBSubnetGroup dbSubnetGroup() {
        return this.dbSubnetGroup;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public PendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public Date latestRestorableTime() {
        return this.latestRestorableTime;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String readReplicaSourceDBInstanceIdentifier() {
        return this.readReplicaSourceDBInstanceIdentifier;
    }

    public List<String> readReplicaDBInstanceIdentifiers() {
        return this.readReplicaDBInstanceIdentifiers;
    }

    public List<String> readReplicaDBClusterIdentifiers() {
        return this.readReplicaDBClusterIdentifiers;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public Integer iops() {
        return this.iops;
    }

    public List<OptionGroupMembership> optionGroupMemberships() {
        return this.optionGroupMemberships;
    }

    public String characterSetName() {
        return this.characterSetName;
    }

    public String secondaryAvailabilityZone() {
        return this.secondaryAvailabilityZone;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<DBInstanceStatusInfo> statusInfos() {
        return this.statusInfos;
    }

    public String storageType() {
        return this.storageType;
    }

    public String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public Integer dbInstancePort() {
        return this.dbInstancePort;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String dbiResourceId() {
        return this.dbiResourceId;
    }

    public String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public List<DomainMembership> domainMemberships() {
        return this.domainMemberships;
    }

    public Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public String enhancedMonitoringResourceArn() {
        return this.enhancedMonitoringResourceArn;
    }

    public String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public Integer promotionTier() {
        return this.promotionTier;
    }

    public String dbInstanceArn() {
        return this.dbInstanceArn;
    }

    public String timezone() {
        return this.timezone;
    }

    public Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbInstanceIdentifier() == null ? 0 : this.dbInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceClass() == null ? 0 : this.dbInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceStatus() == null ? 0 : this.dbInstanceStatus().hashCode());
        hashCode = 31 * hashCode + (this.masterUsername() == null ? 0 : this.masterUsername().hashCode());
        hashCode = 31 * hashCode + (this.dbName() == null ? 0 : this.dbName().hashCode());
        hashCode = 31 * hashCode + (this.endpoint() == null ? 0 : this.endpoint().hashCode());
        hashCode = 31 * hashCode + (this.allocatedStorage() == null ? 0 : this.allocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.instanceCreateTime() == null ? 0 : this.instanceCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.preferredBackupWindow() == null ? 0 : this.preferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.backupRetentionPeriod() == null ? 0 : this.backupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.dbSecurityGroups() == null ? 0 : this.dbSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroups() == null ? 0 : this.vpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.dbParameterGroups() == null ? 0 : this.dbParameterGroups().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroup() == null ? 0 : this.dbSubnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.pendingModifiedValues() == null ? 0 : this.pendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.latestRestorableTime() == null ? 0 : this.latestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.multiAZ() == null ? 0 : this.multiAZ().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.autoMinorVersionUpgrade() == null ? 0 : this.autoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.readReplicaSourceDBInstanceIdentifier() == null ? 0 : this.readReplicaSourceDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.readReplicaDBInstanceIdentifiers() == null ? 0 : this.readReplicaDBInstanceIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.readReplicaDBClusterIdentifiers() == null ? 0 : this.readReplicaDBClusterIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.licenseModel() == null ? 0 : this.licenseModel().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupMemberships() == null ? 0 : this.optionGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.characterSetName() == null ? 0 : this.characterSetName().hashCode());
        hashCode = 31 * hashCode + (this.secondaryAvailabilityZone() == null ? 0 : this.secondaryAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.publiclyAccessible() == null ? 0 : this.publiclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.statusInfos() == null ? 0 : this.statusInfos().hashCode());
        hashCode = 31 * hashCode + (this.storageType() == null ? 0 : this.storageType().hashCode());
        hashCode = 31 * hashCode + (this.tdeCredentialArn() == null ? 0 : this.tdeCredentialArn().hashCode());
        hashCode = 31 * hashCode + (this.dbInstancePort() == null ? 0 : this.dbInstancePort().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterIdentifier() == null ? 0 : this.dbClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.storageEncrypted() == null ? 0 : this.storageEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.dbiResourceId() == null ? 0 : this.dbiResourceId().hashCode());
        hashCode = 31 * hashCode + (this.caCertificateIdentifier() == null ? 0 : this.caCertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.domainMemberships() == null ? 0 : this.domainMemberships().hashCode());
        hashCode = 31 * hashCode + (this.copyTagsToSnapshot() == null ? 0 : this.copyTagsToSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.monitoringInterval() == null ? 0 : this.monitoringInterval().hashCode());
        hashCode = 31 * hashCode + (this.enhancedMonitoringResourceArn() == null ? 0 : this.enhancedMonitoringResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.monitoringRoleArn() == null ? 0 : this.monitoringRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.promotionTier() == null ? 0 : this.promotionTier().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceArn() == null ? 0 : this.dbInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.timezone() == null ? 0 : this.timezone().hashCode());
        hashCode = 31 * hashCode + (this.iamDatabaseAuthenticationEnabled() == null ? 0 : this.iamDatabaseAuthenticationEnabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstance)) {
            return false;
        }
        DBInstance other = (DBInstance)obj;
        if (other.dbInstanceIdentifier() == null ^ this.dbInstanceIdentifier() == null) {
            return false;
        }
        if (other.dbInstanceIdentifier() != null && !other.dbInstanceIdentifier().equals(this.dbInstanceIdentifier())) {
            return false;
        }
        if (other.dbInstanceClass() == null ^ this.dbInstanceClass() == null) {
            return false;
        }
        if (other.dbInstanceClass() != null && !other.dbInstanceClass().equals(this.dbInstanceClass())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.dbInstanceStatus() == null ^ this.dbInstanceStatus() == null) {
            return false;
        }
        if (other.dbInstanceStatus() != null && !other.dbInstanceStatus().equals(this.dbInstanceStatus())) {
            return false;
        }
        if (other.masterUsername() == null ^ this.masterUsername() == null) {
            return false;
        }
        if (other.masterUsername() != null && !other.masterUsername().equals(this.masterUsername())) {
            return false;
        }
        if (other.dbName() == null ^ this.dbName() == null) {
            return false;
        }
        if (other.dbName() != null && !other.dbName().equals(this.dbName())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        if (other.allocatedStorage() == null ^ this.allocatedStorage() == null) {
            return false;
        }
        if (other.allocatedStorage() != null && !other.allocatedStorage().equals(this.allocatedStorage())) {
            return false;
        }
        if (other.instanceCreateTime() == null ^ this.instanceCreateTime() == null) {
            return false;
        }
        if (other.instanceCreateTime() != null && !other.instanceCreateTime().equals(this.instanceCreateTime())) {
            return false;
        }
        if (other.preferredBackupWindow() == null ^ this.preferredBackupWindow() == null) {
            return false;
        }
        if (other.preferredBackupWindow() != null && !other.preferredBackupWindow().equals(this.preferredBackupWindow())) {
            return false;
        }
        if (other.backupRetentionPeriod() == null ^ this.backupRetentionPeriod() == null) {
            return false;
        }
        if (other.backupRetentionPeriod() != null && !other.backupRetentionPeriod().equals(this.backupRetentionPeriod())) {
            return false;
        }
        if (other.dbSecurityGroups() == null ^ this.dbSecurityGroups() == null) {
            return false;
        }
        if (other.dbSecurityGroups() != null && !other.dbSecurityGroups().equals(this.dbSecurityGroups())) {
            return false;
        }
        if (other.vpcSecurityGroups() == null ^ this.vpcSecurityGroups() == null) {
            return false;
        }
        if (other.vpcSecurityGroups() != null && !other.vpcSecurityGroups().equals(this.vpcSecurityGroups())) {
            return false;
        }
        if (other.dbParameterGroups() == null ^ this.dbParameterGroups() == null) {
            return false;
        }
        if (other.dbParameterGroups() != null && !other.dbParameterGroups().equals(this.dbParameterGroups())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.dbSubnetGroup() == null ^ this.dbSubnetGroup() == null) {
            return false;
        }
        if (other.dbSubnetGroup() != null && !other.dbSubnetGroup().equals(this.dbSubnetGroup())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.pendingModifiedValues() == null ^ this.pendingModifiedValues() == null) {
            return false;
        }
        if (other.pendingModifiedValues() != null && !other.pendingModifiedValues().equals(this.pendingModifiedValues())) {
            return false;
        }
        if (other.latestRestorableTime() == null ^ this.latestRestorableTime() == null) {
            return false;
        }
        if (other.latestRestorableTime() != null && !other.latestRestorableTime().equals(this.latestRestorableTime())) {
            return false;
        }
        if (other.multiAZ() == null ^ this.multiAZ() == null) {
            return false;
        }
        if (other.multiAZ() != null && !other.multiAZ().equals(this.multiAZ())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() == null ^ this.autoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() != null && !other.autoMinorVersionUpgrade().equals(this.autoMinorVersionUpgrade())) {
            return false;
        }
        if (other.readReplicaSourceDBInstanceIdentifier() == null ^ this.readReplicaSourceDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.readReplicaSourceDBInstanceIdentifier() != null && !other.readReplicaSourceDBInstanceIdentifier().equals(this.readReplicaSourceDBInstanceIdentifier())) {
            return false;
        }
        if (other.readReplicaDBInstanceIdentifiers() == null ^ this.readReplicaDBInstanceIdentifiers() == null) {
            return false;
        }
        if (other.readReplicaDBInstanceIdentifiers() != null && !other.readReplicaDBInstanceIdentifiers().equals(this.readReplicaDBInstanceIdentifiers())) {
            return false;
        }
        if (other.readReplicaDBClusterIdentifiers() == null ^ this.readReplicaDBClusterIdentifiers() == null) {
            return false;
        }
        if (other.readReplicaDBClusterIdentifiers() != null && !other.readReplicaDBClusterIdentifiers().equals(this.readReplicaDBClusterIdentifiers())) {
            return false;
        }
        if (other.licenseModel() == null ^ this.licenseModel() == null) {
            return false;
        }
        if (other.licenseModel() != null && !other.licenseModel().equals(this.licenseModel())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.optionGroupMemberships() == null ^ this.optionGroupMemberships() == null) {
            return false;
        }
        if (other.optionGroupMemberships() != null && !other.optionGroupMemberships().equals(this.optionGroupMemberships())) {
            return false;
        }
        if (other.characterSetName() == null ^ this.characterSetName() == null) {
            return false;
        }
        if (other.characterSetName() != null && !other.characterSetName().equals(this.characterSetName())) {
            return false;
        }
        if (other.secondaryAvailabilityZone() == null ^ this.secondaryAvailabilityZone() == null) {
            return false;
        }
        if (other.secondaryAvailabilityZone() != null && !other.secondaryAvailabilityZone().equals(this.secondaryAvailabilityZone())) {
            return false;
        }
        if (other.publiclyAccessible() == null ^ this.publiclyAccessible() == null) {
            return false;
        }
        if (other.publiclyAccessible() != null && !other.publiclyAccessible().equals(this.publiclyAccessible())) {
            return false;
        }
        if (other.statusInfos() == null ^ this.statusInfos() == null) {
            return false;
        }
        if (other.statusInfos() != null && !other.statusInfos().equals(this.statusInfos())) {
            return false;
        }
        if (other.storageType() == null ^ this.storageType() == null) {
            return false;
        }
        if (other.storageType() != null && !other.storageType().equals(this.storageType())) {
            return false;
        }
        if (other.tdeCredentialArn() == null ^ this.tdeCredentialArn() == null) {
            return false;
        }
        if (other.tdeCredentialArn() != null && !other.tdeCredentialArn().equals(this.tdeCredentialArn())) {
            return false;
        }
        if (other.dbInstancePort() == null ^ this.dbInstancePort() == null) {
            return false;
        }
        if (other.dbInstancePort() != null && !other.dbInstancePort().equals(this.dbInstancePort())) {
            return false;
        }
        if (other.dbClusterIdentifier() == null ^ this.dbClusterIdentifier() == null) {
            return false;
        }
        if (other.dbClusterIdentifier() != null && !other.dbClusterIdentifier().equals(this.dbClusterIdentifier())) {
            return false;
        }
        if (other.storageEncrypted() == null ^ this.storageEncrypted() == null) {
            return false;
        }
        if (other.storageEncrypted() != null && !other.storageEncrypted().equals(this.storageEncrypted())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.dbiResourceId() == null ^ this.dbiResourceId() == null) {
            return false;
        }
        if (other.dbiResourceId() != null && !other.dbiResourceId().equals(this.dbiResourceId())) {
            return false;
        }
        if (other.caCertificateIdentifier() == null ^ this.caCertificateIdentifier() == null) {
            return false;
        }
        if (other.caCertificateIdentifier() != null && !other.caCertificateIdentifier().equals(this.caCertificateIdentifier())) {
            return false;
        }
        if (other.domainMemberships() == null ^ this.domainMemberships() == null) {
            return false;
        }
        if (other.domainMemberships() != null && !other.domainMemberships().equals(this.domainMemberships())) {
            return false;
        }
        if (other.copyTagsToSnapshot() == null ^ this.copyTagsToSnapshot() == null) {
            return false;
        }
        if (other.copyTagsToSnapshot() != null && !other.copyTagsToSnapshot().equals(this.copyTagsToSnapshot())) {
            return false;
        }
        if (other.monitoringInterval() == null ^ this.monitoringInterval() == null) {
            return false;
        }
        if (other.monitoringInterval() != null && !other.monitoringInterval().equals(this.monitoringInterval())) {
            return false;
        }
        if (other.enhancedMonitoringResourceArn() == null ^ this.enhancedMonitoringResourceArn() == null) {
            return false;
        }
        if (other.enhancedMonitoringResourceArn() != null && !other.enhancedMonitoringResourceArn().equals(this.enhancedMonitoringResourceArn())) {
            return false;
        }
        if (other.monitoringRoleArn() == null ^ this.monitoringRoleArn() == null) {
            return false;
        }
        if (other.monitoringRoleArn() != null && !other.monitoringRoleArn().equals(this.monitoringRoleArn())) {
            return false;
        }
        if (other.promotionTier() == null ^ this.promotionTier() == null) {
            return false;
        }
        if (other.promotionTier() != null && !other.promotionTier().equals(this.promotionTier())) {
            return false;
        }
        if (other.dbInstanceArn() == null ^ this.dbInstanceArn() == null) {
            return false;
        }
        if (other.dbInstanceArn() != null && !other.dbInstanceArn().equals(this.dbInstanceArn())) {
            return false;
        }
        if (other.timezone() == null ^ this.timezone() == null) {
            return false;
        }
        if (other.timezone() != null && !other.timezone().equals(this.timezone())) {
            return false;
        }
        if (other.iamDatabaseAuthenticationEnabled() == null ^ this.iamDatabaseAuthenticationEnabled() == null) {
            return false;
        }
        return other.iamDatabaseAuthenticationEnabled() == null || other.iamDatabaseAuthenticationEnabled().equals(this.iamDatabaseAuthenticationEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.dbInstanceClass() != null) {
            sb.append("DBInstanceClass: ").append(this.dbInstanceClass()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.dbInstanceStatus() != null) {
            sb.append("DBInstanceStatus: ").append(this.dbInstanceStatus()).append(",");
        }
        if (this.masterUsername() != null) {
            sb.append("MasterUsername: ").append(this.masterUsername()).append(",");
        }
        if (this.dbName() != null) {
            sb.append("DBName: ").append(this.dbName()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.allocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.allocatedStorage()).append(",");
        }
        if (this.instanceCreateTime() != null) {
            sb.append("InstanceCreateTime: ").append(this.instanceCreateTime()).append(",");
        }
        if (this.preferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.preferredBackupWindow()).append(",");
        }
        if (this.backupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: ").append(this.backupRetentionPeriod()).append(",");
        }
        if (this.dbSecurityGroups() != null) {
            sb.append("DBSecurityGroups: ").append(this.dbSecurityGroups()).append(",");
        }
        if (this.vpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: ").append(this.vpcSecurityGroups()).append(",");
        }
        if (this.dbParameterGroups() != null) {
            sb.append("DBParameterGroups: ").append(this.dbParameterGroups()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.dbSubnetGroup() != null) {
            sb.append("DBSubnetGroup: ").append(this.dbSubnetGroup()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.pendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.pendingModifiedValues()).append(",");
        }
        if (this.latestRestorableTime() != null) {
            sb.append("LatestRestorableTime: ").append(this.latestRestorableTime()).append(",");
        }
        if (this.multiAZ() != null) {
            sb.append("MultiAZ: ").append(this.multiAZ()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.autoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.autoMinorVersionUpgrade()).append(",");
        }
        if (this.readReplicaSourceDBInstanceIdentifier() != null) {
            sb.append("ReadReplicaSourceDBInstanceIdentifier: ").append(this.readReplicaSourceDBInstanceIdentifier()).append(",");
        }
        if (this.readReplicaDBInstanceIdentifiers() != null) {
            sb.append("ReadReplicaDBInstanceIdentifiers: ").append(this.readReplicaDBInstanceIdentifiers()).append(",");
        }
        if (this.readReplicaDBClusterIdentifiers() != null) {
            sb.append("ReadReplicaDBClusterIdentifiers: ").append(this.readReplicaDBClusterIdentifiers()).append(",");
        }
        if (this.licenseModel() != null) {
            sb.append("LicenseModel: ").append(this.licenseModel()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.optionGroupMemberships() != null) {
            sb.append("OptionGroupMemberships: ").append(this.optionGroupMemberships()).append(",");
        }
        if (this.characterSetName() != null) {
            sb.append("CharacterSetName: ").append(this.characterSetName()).append(",");
        }
        if (this.secondaryAvailabilityZone() != null) {
            sb.append("SecondaryAvailabilityZone: ").append(this.secondaryAvailabilityZone()).append(",");
        }
        if (this.publiclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.publiclyAccessible()).append(",");
        }
        if (this.statusInfos() != null) {
            sb.append("StatusInfos: ").append(this.statusInfos()).append(",");
        }
        if (this.storageType() != null) {
            sb.append("StorageType: ").append(this.storageType()).append(",");
        }
        if (this.tdeCredentialArn() != null) {
            sb.append("TdeCredentialArn: ").append(this.tdeCredentialArn()).append(",");
        }
        if (this.dbInstancePort() != null) {
            sb.append("DbInstancePort: ").append(this.dbInstancePort()).append(",");
        }
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.storageEncrypted() != null) {
            sb.append("StorageEncrypted: ").append(this.storageEncrypted()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.dbiResourceId() != null) {
            sb.append("DbiResourceId: ").append(this.dbiResourceId()).append(",");
        }
        if (this.caCertificateIdentifier() != null) {
            sb.append("CACertificateIdentifier: ").append(this.caCertificateIdentifier()).append(",");
        }
        if (this.domainMemberships() != null) {
            sb.append("DomainMemberships: ").append(this.domainMemberships()).append(",");
        }
        if (this.copyTagsToSnapshot() != null) {
            sb.append("CopyTagsToSnapshot: ").append(this.copyTagsToSnapshot()).append(",");
        }
        if (this.monitoringInterval() != null) {
            sb.append("MonitoringInterval: ").append(this.monitoringInterval()).append(",");
        }
        if (this.enhancedMonitoringResourceArn() != null) {
            sb.append("EnhancedMonitoringResourceArn: ").append(this.enhancedMonitoringResourceArn()).append(",");
        }
        if (this.monitoringRoleArn() != null) {
            sb.append("MonitoringRoleArn: ").append(this.monitoringRoleArn()).append(",");
        }
        if (this.promotionTier() != null) {
            sb.append("PromotionTier: ").append(this.promotionTier()).append(",");
        }
        if (this.dbInstanceArn() != null) {
            sb.append("DBInstanceArn: ").append(this.dbInstanceArn()).append(",");
        }
        if (this.timezone() != null) {
            sb.append("Timezone: ").append(this.timezone()).append(",");
        }
        if (this.iamDatabaseAuthenticationEnabled() != null) {
            sb.append("IAMDatabaseAuthenticationEnabled: ").append(this.iamDatabaseAuthenticationEnabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String dbInstanceClass;
        private String engine;
        private String dbInstanceStatus;
        private String masterUsername;
        private String dbName;
        private Endpoint endpoint;
        private Integer allocatedStorage;
        private Date instanceCreateTime;
        private String preferredBackupWindow;
        private Integer backupRetentionPeriod;
        private List<DBSecurityGroupMembership> dbSecurityGroups = new SdkInternalList();
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = new SdkInternalList();
        private List<DBParameterGroupStatus> dbParameterGroups = new SdkInternalList();
        private String availabilityZone;
        private DBSubnetGroup dbSubnetGroup;
        private String preferredMaintenanceWindow;
        private PendingModifiedValues pendingModifiedValues;
        private Date latestRestorableTime;
        private Boolean multiAZ;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private String readReplicaSourceDBInstanceIdentifier;
        private List<String> readReplicaDBInstanceIdentifiers = new SdkInternalList();
        private List<String> readReplicaDBClusterIdentifiers = new SdkInternalList();
        private String licenseModel;
        private Integer iops;
        private List<OptionGroupMembership> optionGroupMemberships = new SdkInternalList();
        private String characterSetName;
        private String secondaryAvailabilityZone;
        private Boolean publiclyAccessible;
        private List<DBInstanceStatusInfo> statusInfos = new SdkInternalList();
        private String storageType;
        private String tdeCredentialArn;
        private Integer dbInstancePort;
        private String dbClusterIdentifier;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbiResourceId;
        private String caCertificateIdentifier;
        private List<DomainMembership> domainMemberships = new SdkInternalList();
        private Boolean copyTagsToSnapshot;
        private Integer monitoringInterval;
        private String enhancedMonitoringResourceArn;
        private String monitoringRoleArn;
        private Integer promotionTier;
        private String dbInstanceArn;
        private String timezone;
        private Boolean iamDatabaseAuthenticationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DBInstance model) {
            this.setDBInstanceIdentifier(model.dbInstanceIdentifier);
            this.setDBInstanceClass(model.dbInstanceClass);
            this.setEngine(model.engine);
            this.setDBInstanceStatus(model.dbInstanceStatus);
            this.setMasterUsername(model.masterUsername);
            this.setDBName(model.dbName);
            this.setEndpoint(model.endpoint);
            this.setAllocatedStorage(model.allocatedStorage);
            this.setInstanceCreateTime(model.instanceCreateTime);
            this.setPreferredBackupWindow(model.preferredBackupWindow);
            this.setBackupRetentionPeriod(model.backupRetentionPeriod);
            this.setDBSecurityGroups(model.dbSecurityGroups);
            this.setVpcSecurityGroups(model.vpcSecurityGroups);
            this.setDBParameterGroups(model.dbParameterGroups);
            this.setAvailabilityZone(model.availabilityZone);
            this.setDBSubnetGroup(model.dbSubnetGroup);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setPendingModifiedValues(model.pendingModifiedValues);
            this.setLatestRestorableTime(model.latestRestorableTime);
            this.setMultiAZ(model.multiAZ);
            this.setEngineVersion(model.engineVersion);
            this.setAutoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.setReadReplicaSourceDBInstanceIdentifier(model.readReplicaSourceDBInstanceIdentifier);
            this.setReadReplicaDBInstanceIdentifiers(model.readReplicaDBInstanceIdentifiers);
            this.setReadReplicaDBClusterIdentifiers(model.readReplicaDBClusterIdentifiers);
            this.setLicenseModel(model.licenseModel);
            this.setIops(model.iops);
            this.setOptionGroupMemberships(model.optionGroupMemberships);
            this.setCharacterSetName(model.characterSetName);
            this.setSecondaryAvailabilityZone(model.secondaryAvailabilityZone);
            this.setPubliclyAccessible(model.publiclyAccessible);
            this.setStatusInfos(model.statusInfos);
            this.setStorageType(model.storageType);
            this.setTdeCredentialArn(model.tdeCredentialArn);
            this.setDbInstancePort(model.dbInstancePort);
            this.setDBClusterIdentifier(model.dbClusterIdentifier);
            this.setStorageEncrypted(model.storageEncrypted);
            this.setKmsKeyId(model.kmsKeyId);
            this.setDbiResourceId(model.dbiResourceId);
            this.setCACertificateIdentifier(model.caCertificateIdentifier);
            this.setDomainMemberships(model.domainMemberships);
            this.setCopyTagsToSnapshot(model.copyTagsToSnapshot);
            this.setMonitoringInterval(model.monitoringInterval);
            this.setEnhancedMonitoringResourceArn(model.enhancedMonitoringResourceArn);
            this.setMonitoringRoleArn(model.monitoringRoleArn);
            this.setPromotionTier(model.promotionTier);
            this.setDBInstanceArn(model.dbInstanceArn);
            this.setTimezone(model.timezone);
            this.setIAMDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getDBInstanceStatus() {
            return this.dbInstanceStatus;
        }

        @Override
        public final Builder dbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
            return this;
        }

        public final void setDBInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getDBName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDBName(String dbName) {
            this.dbName = dbName;
        }

        public final Endpoint getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final Date getInstanceCreateTime() {
            return this.instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(Date instanceCreateTime) {
            this.instanceCreateTime = StandardMemberCopier.copy((Date)instanceCreateTime);
            return this;
        }

        public final void setInstanceCreateTime(Date instanceCreateTime) {
            this.instanceCreateTime = StandardMemberCopier.copy((Date)instanceCreateTime);
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final Collection<DBSecurityGroupMembership> getDBSecurityGroups() {
            return this.dbSecurityGroups;
        }

        @Override
        public final Builder dbSecurityGroups(Collection<DBSecurityGroupMembership> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupMembershipListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(DBSecurityGroupMembership ... dbSecurityGroups) {
            if (this.dbSecurityGroups == null) {
                this.dbSecurityGroups = new SdkInternalList(dbSecurityGroups.length);
            }
            for (DBSecurityGroupMembership e : dbSecurityGroups) {
                this.dbSecurityGroups.add(e);
            }
            return this;
        }

        public final void setDBSecurityGroups(Collection<DBSecurityGroupMembership> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupMembershipListCopier.copy(dbSecurityGroups);
        }

        @SafeVarargs
        public final void setDBSecurityGroups(DBSecurityGroupMembership ... dbSecurityGroups) {
            if (this.dbSecurityGroups == null) {
                this.dbSecurityGroups = new SdkInternalList(dbSecurityGroups.length);
            }
            for (DBSecurityGroupMembership e : dbSecurityGroups) {
                this.dbSecurityGroups.add(e);
            }
        }

        public final Collection<VpcSecurityGroupMembership> getVpcSecurityGroups() {
            return this.vpcSecurityGroups;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            if (this.vpcSecurityGroups == null) {
                this.vpcSecurityGroups = new SdkInternalList(vpcSecurityGroups.length);
            }
            for (VpcSecurityGroupMembership e : vpcSecurityGroups) {
                this.vpcSecurityGroups.add(e);
            }
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
        }

        @SafeVarargs
        public final void setVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            if (this.vpcSecurityGroups == null) {
                this.vpcSecurityGroups = new SdkInternalList(vpcSecurityGroups.length);
            }
            for (VpcSecurityGroupMembership e : vpcSecurityGroups) {
                this.vpcSecurityGroups.add(e);
            }
        }

        public final Collection<DBParameterGroupStatus> getDBParameterGroups() {
            return this.dbParameterGroups;
        }

        @Override
        public final Builder dbParameterGroups(Collection<DBParameterGroupStatus> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupStatusListCopier.copy(dbParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(DBParameterGroupStatus ... dbParameterGroups) {
            if (this.dbParameterGroups == null) {
                this.dbParameterGroups = new SdkInternalList(dbParameterGroups.length);
            }
            for (DBParameterGroupStatus e : dbParameterGroups) {
                this.dbParameterGroups.add(e);
            }
            return this;
        }

        public final void setDBParameterGroups(Collection<DBParameterGroupStatus> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupStatusListCopier.copy(dbParameterGroups);
        }

        @SafeVarargs
        public final void setDBParameterGroups(DBParameterGroupStatus ... dbParameterGroups) {
            if (this.dbParameterGroups == null) {
                this.dbParameterGroups = new SdkInternalList(dbParameterGroups.length);
            }
            for (DBParameterGroupStatus e : dbParameterGroups) {
                this.dbParameterGroups.add(e);
            }
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final DBSubnetGroup getDBSubnetGroup() {
            return this.dbSubnetGroup;
        }

        @Override
        public final Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final void setDBSubnetGroup(DBSubnetGroup dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final PendingModifiedValues getPendingModifiedValues() {
            return this.pendingModifiedValues;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
        }

        public final Date getLatestRestorableTime() {
            return this.latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(Date latestRestorableTime) {
            this.latestRestorableTime = StandardMemberCopier.copy((Date)latestRestorableTime);
            return this;
        }

        public final void setLatestRestorableTime(Date latestRestorableTime) {
            this.latestRestorableTime = StandardMemberCopier.copy((Date)latestRestorableTime);
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getReadReplicaSourceDBInstanceIdentifier() {
            return this.readReplicaSourceDBInstanceIdentifier;
        }

        @Override
        public final Builder readReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
            this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
            return this;
        }

        public final void setReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
            this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
        }

        public final Collection<String> getReadReplicaDBInstanceIdentifiers() {
            return this.readReplicaDBInstanceIdentifiers;
        }

        @Override
        public final Builder readReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
            this.readReplicaDBInstanceIdentifiers = ReadReplicaDBInstanceIdentifierListCopier.copy(readReplicaDBInstanceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaDBInstanceIdentifiers(String ... readReplicaDBInstanceIdentifiers) {
            if (this.readReplicaDBInstanceIdentifiers == null) {
                this.readReplicaDBInstanceIdentifiers = new SdkInternalList(readReplicaDBInstanceIdentifiers.length);
            }
            for (String e : readReplicaDBInstanceIdentifiers) {
                this.readReplicaDBInstanceIdentifiers.add(e);
            }
            return this;
        }

        public final void setReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
            this.readReplicaDBInstanceIdentifiers = ReadReplicaDBInstanceIdentifierListCopier.copy(readReplicaDBInstanceIdentifiers);
        }

        @SafeVarargs
        public final void setReadReplicaDBInstanceIdentifiers(String ... readReplicaDBInstanceIdentifiers) {
            if (this.readReplicaDBInstanceIdentifiers == null) {
                this.readReplicaDBInstanceIdentifiers = new SdkInternalList(readReplicaDBInstanceIdentifiers.length);
            }
            for (String e : readReplicaDBInstanceIdentifiers) {
                this.readReplicaDBInstanceIdentifiers.add(e);
            }
        }

        public final Collection<String> getReadReplicaDBClusterIdentifiers() {
            return this.readReplicaDBClusterIdentifiers;
        }

        @Override
        public final Builder readReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
            this.readReplicaDBClusterIdentifiers = ReadReplicaDBClusterIdentifierListCopier.copy(readReplicaDBClusterIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaDBClusterIdentifiers(String ... readReplicaDBClusterIdentifiers) {
            if (this.readReplicaDBClusterIdentifiers == null) {
                this.readReplicaDBClusterIdentifiers = new SdkInternalList(readReplicaDBClusterIdentifiers.length);
            }
            for (String e : readReplicaDBClusterIdentifiers) {
                this.readReplicaDBClusterIdentifiers.add(e);
            }
            return this;
        }

        public final void setReadReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
            this.readReplicaDBClusterIdentifiers = ReadReplicaDBClusterIdentifierListCopier.copy(readReplicaDBClusterIdentifiers);
        }

        @SafeVarargs
        public final void setReadReplicaDBClusterIdentifiers(String ... readReplicaDBClusterIdentifiers) {
            if (this.readReplicaDBClusterIdentifiers == null) {
                this.readReplicaDBClusterIdentifiers = new SdkInternalList(readReplicaDBClusterIdentifiers.length);
            }
            for (String e : readReplicaDBClusterIdentifiers) {
                this.readReplicaDBClusterIdentifiers.add(e);
            }
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Collection<OptionGroupMembership> getOptionGroupMemberships() {
            return this.optionGroupMemberships;
        }

        @Override
        public final Builder optionGroupMemberships(Collection<OptionGroupMembership> optionGroupMemberships) {
            this.optionGroupMemberships = OptionGroupMembershipListCopier.copy(optionGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupMemberships(OptionGroupMembership ... optionGroupMemberships) {
            if (this.optionGroupMemberships == null) {
                this.optionGroupMemberships = new SdkInternalList(optionGroupMemberships.length);
            }
            for (OptionGroupMembership e : optionGroupMemberships) {
                this.optionGroupMemberships.add(e);
            }
            return this;
        }

        public final void setOptionGroupMemberships(Collection<OptionGroupMembership> optionGroupMemberships) {
            this.optionGroupMemberships = OptionGroupMembershipListCopier.copy(optionGroupMemberships);
        }

        @SafeVarargs
        public final void setOptionGroupMemberships(OptionGroupMembership ... optionGroupMemberships) {
            if (this.optionGroupMemberships == null) {
                this.optionGroupMemberships = new SdkInternalList(optionGroupMemberships.length);
            }
            for (OptionGroupMembership e : optionGroupMemberships) {
                this.optionGroupMemberships.add(e);
            }
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getSecondaryAvailabilityZone() {
            return this.secondaryAvailabilityZone;
        }

        @Override
        public final Builder secondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
            return this;
        }

        public final void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<DBInstanceStatusInfo> getStatusInfos() {
            return this.statusInfos;
        }

        @Override
        public final Builder statusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
            this.statusInfos = DBInstanceStatusInfoListCopier.copy(statusInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusInfos(DBInstanceStatusInfo ... statusInfos) {
            if (this.statusInfos == null) {
                this.statusInfos = new SdkInternalList(statusInfos.length);
            }
            for (DBInstanceStatusInfo e : statusInfos) {
                this.statusInfos.add(e);
            }
            return this;
        }

        public final void setStatusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
            this.statusInfos = DBInstanceStatusInfoListCopier.copy(statusInfos);
        }

        @SafeVarargs
        public final void setStatusInfos(DBInstanceStatusInfo ... statusInfos) {
            if (this.statusInfos == null) {
                this.statusInfos = new SdkInternalList(statusInfos.length);
            }
            for (DBInstanceStatusInfo e : statusInfos) {
                this.statusInfos.add(e);
            }
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final Integer getDbInstancePort() {
            return this.dbInstancePort;
        }

        @Override
        public final Builder dbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
            return this;
        }

        public final void setDbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        public final String getCACertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCACertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public final Collection<DomainMembership> getDomainMemberships() {
            return this.domainMemberships;
        }

        @Override
        public final Builder domainMemberships(Collection<DomainMembership> domainMemberships) {
            this.domainMemberships = DomainMembershipListCopier.copy(domainMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(DomainMembership ... domainMemberships) {
            if (this.domainMemberships == null) {
                this.domainMemberships = new SdkInternalList(domainMemberships.length);
            }
            for (DomainMembership e : domainMemberships) {
                this.domainMemberships.add(e);
            }
            return this;
        }

        public final void setDomainMemberships(Collection<DomainMembership> domainMemberships) {
            this.domainMemberships = DomainMembershipListCopier.copy(domainMemberships);
        }

        @SafeVarargs
        public final void setDomainMemberships(DomainMembership ... domainMemberships) {
            if (this.domainMemberships == null) {
                this.domainMemberships = new SdkInternalList(domainMemberships.length);
            }
            for (DomainMembership e : domainMemberships) {
                this.domainMemberships.add(e);
            }
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        public final String getEnhancedMonitoringResourceArn() {
            return this.enhancedMonitoringResourceArn;
        }

        @Override
        public final Builder enhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
            this.enhancedMonitoringResourceArn = enhancedMonitoringResourceArn;
            return this;
        }

        public final void setEnhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
            this.enhancedMonitoringResourceArn = enhancedMonitoringResourceArn;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        public final Integer getPromotionTier() {
            return this.promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        public final String getDBInstanceArn() {
            return this.dbInstanceArn;
        }

        @Override
        public final Builder dbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
            return this;
        }

        public final void setDBInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final Boolean getIAMDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIAMDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public DBInstance build() {
            return new DBInstance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBInstance> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder engine(String var1);

        public Builder dbInstanceStatus(String var1);

        public Builder masterUsername(String var1);

        public Builder dbName(String var1);

        public Builder endpoint(Endpoint var1);

        public Builder allocatedStorage(Integer var1);

        public Builder instanceCreateTime(Date var1);

        public Builder preferredBackupWindow(String var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder dbSecurityGroups(Collection<DBSecurityGroupMembership> var1);

        public Builder dbSecurityGroups(DBSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder dbParameterGroups(Collection<DBParameterGroupStatus> var1);

        public Builder dbParameterGroups(DBParameterGroupStatus ... var1);

        public Builder availabilityZone(String var1);

        public Builder dbSubnetGroup(DBSubnetGroup var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder pendingModifiedValues(PendingModifiedValues var1);

        public Builder latestRestorableTime(Date var1);

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder readReplicaSourceDBInstanceIdentifier(String var1);

        public Builder readReplicaDBInstanceIdentifiers(Collection<String> var1);

        public Builder readReplicaDBInstanceIdentifiers(String ... var1);

        public Builder readReplicaDBClusterIdentifiers(Collection<String> var1);

        public Builder readReplicaDBClusterIdentifiers(String ... var1);

        public Builder licenseModel(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupMemberships(Collection<OptionGroupMembership> var1);

        public Builder optionGroupMemberships(OptionGroupMembership ... var1);

        public Builder characterSetName(String var1);

        public Builder secondaryAvailabilityZone(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder statusInfos(Collection<DBInstanceStatusInfo> var1);

        public Builder statusInfos(DBInstanceStatusInfo ... var1);

        public Builder storageType(String var1);

        public Builder tdeCredentialArn(String var1);

        public Builder dbInstancePort(Integer var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbiResourceId(String var1);

        public Builder caCertificateIdentifier(String var1);

        public Builder domainMemberships(Collection<DomainMembership> var1);

        public Builder domainMemberships(DomainMembership ... var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder enhancedMonitoringResourceArn(String var1);

        public Builder monitoringRoleArn(String var1);

        public Builder promotionTier(Integer var1);

        public Builder dbInstanceArn(String var1);

        public Builder timezone(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);
    }
}

