/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.rds.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyDBSubnetGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyDBSubnetGroupRequest> {
    private final String dbSubnetGroupName;
    private final String dbSubnetGroupDescription;
    private final List<String> subnetIds;

    private ModifyDBSubnetGroupRequest(BuilderImpl builder) {
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSubnetGroupDescription = builder.dbSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String dbSubnetGroupDescription() {
        return this.dbSubnetGroupDescription;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbSubnetGroupName() == null ? 0 : this.dbSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroupDescription() == null ? 0 : this.dbSubnetGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.subnetIds() == null ? 0 : this.subnetIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBSubnetGroupRequest)) {
            return false;
        }
        ModifyDBSubnetGroupRequest other = (ModifyDBSubnetGroupRequest)((Object)obj);
        if (other.dbSubnetGroupName() == null ^ this.dbSubnetGroupName() == null) {
            return false;
        }
        if (other.dbSubnetGroupName() != null && !other.dbSubnetGroupName().equals(this.dbSubnetGroupName())) {
            return false;
        }
        if (other.dbSubnetGroupDescription() == null ^ this.dbSubnetGroupDescription() == null) {
            return false;
        }
        if (other.dbSubnetGroupDescription() != null && !other.dbSubnetGroupDescription().equals(this.dbSubnetGroupDescription())) {
            return false;
        }
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        return other.subnetIds() == null || other.subnetIds().equals(this.subnetIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: ").append(this.dbSubnetGroupName()).append(",");
        }
        if (this.dbSubnetGroupDescription() != null) {
            sb.append("DBSubnetGroupDescription: ").append(this.dbSubnetGroupDescription()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbSubnetGroupName;
        private String dbSubnetGroupDescription;
        private List<String> subnetIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDBSubnetGroupRequest model) {
            this.setDBSubnetGroupName(model.dbSubnetGroupName);
            this.setDBSubnetGroupDescription(model.dbSubnetGroupDescription);
            this.setSubnetIds(model.subnetIds);
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getDBSubnetGroupDescription() {
            return this.dbSubnetGroupDescription;
        }

        @Override
        public final Builder dbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
            return this;
        }

        public final void setDBSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            if (this.subnetIds == null) {
                this.subnetIds = new SdkInternalList(subnetIds.length);
            }
            for (String e : subnetIds) {
                this.subnetIds.add(e);
            }
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @SafeVarargs
        public final void setSubnetIds(String ... subnetIds) {
            if (this.subnetIds == null) {
                this.subnetIds = new SdkInternalList(subnetIds.length);
            }
            for (String e : subnetIds) {
                this.subnetIds.add(e);
            }
        }

        public ModifyDBSubnetGroupRequest build() {
            return new ModifyDBSubnetGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyDBSubnetGroupRequest> {
        public Builder dbSubnetGroupName(String var1);

        public Builder dbSubnetGroupDescription(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);
    }
}

