/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.rds.model.OptionSetting;
import software.amazon.awssdk.services.rds.model.OptionSettingConfigurationListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Option
implements ToCopyableBuilder<Builder, Option> {
    private final String optionName;
    private final String optionDescription;
    private final Boolean persistent;
    private final Boolean permanent;
    private final Integer port;
    private final String optionVersion;
    private final List<OptionSetting> optionSettings;
    private final List<DBSecurityGroupMembership> dbSecurityGroupMemberships;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships;

    private Option(BuilderImpl builder) {
        this.optionName = builder.optionName;
        this.optionDescription = builder.optionDescription;
        this.persistent = builder.persistent;
        this.permanent = builder.permanent;
        this.port = builder.port;
        this.optionVersion = builder.optionVersion;
        this.optionSettings = builder.optionSettings;
        this.dbSecurityGroupMemberships = builder.dbSecurityGroupMemberships;
        this.vpcSecurityGroupMemberships = builder.vpcSecurityGroupMemberships;
    }

    public String optionName() {
        return this.optionName;
    }

    public String optionDescription() {
        return this.optionDescription;
    }

    public Boolean persistent() {
        return this.persistent;
    }

    public Boolean permanent() {
        return this.permanent;
    }

    public Integer port() {
        return this.port;
    }

    public String optionVersion() {
        return this.optionVersion;
    }

    public List<OptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public List<DBSecurityGroupMembership> dbSecurityGroupMemberships() {
        return this.dbSecurityGroupMemberships;
    }

    public List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships() {
        return this.vpcSecurityGroupMemberships;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.optionName() == null ? 0 : this.optionName().hashCode());
        hashCode = 31 * hashCode + (this.optionDescription() == null ? 0 : this.optionDescription().hashCode());
        hashCode = 31 * hashCode + (this.persistent() == null ? 0 : this.persistent().hashCode());
        hashCode = 31 * hashCode + (this.permanent() == null ? 0 : this.permanent().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.optionVersion() == null ? 0 : this.optionVersion().hashCode());
        hashCode = 31 * hashCode + (this.optionSettings() == null ? 0 : this.optionSettings().hashCode());
        hashCode = 31 * hashCode + (this.dbSecurityGroupMemberships() == null ? 0 : this.dbSecurityGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroupMemberships() == null ? 0 : this.vpcSecurityGroupMemberships().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option other = (Option)obj;
        if (other.optionName() == null ^ this.optionName() == null) {
            return false;
        }
        if (other.optionName() != null && !other.optionName().equals(this.optionName())) {
            return false;
        }
        if (other.optionDescription() == null ^ this.optionDescription() == null) {
            return false;
        }
        if (other.optionDescription() != null && !other.optionDescription().equals(this.optionDescription())) {
            return false;
        }
        if (other.persistent() == null ^ this.persistent() == null) {
            return false;
        }
        if (other.persistent() != null && !other.persistent().equals(this.persistent())) {
            return false;
        }
        if (other.permanent() == null ^ this.permanent() == null) {
            return false;
        }
        if (other.permanent() != null && !other.permanent().equals(this.permanent())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.optionVersion() == null ^ this.optionVersion() == null) {
            return false;
        }
        if (other.optionVersion() != null && !other.optionVersion().equals(this.optionVersion())) {
            return false;
        }
        if (other.optionSettings() == null ^ this.optionSettings() == null) {
            return false;
        }
        if (other.optionSettings() != null && !other.optionSettings().equals(this.optionSettings())) {
            return false;
        }
        if (other.dbSecurityGroupMemberships() == null ^ this.dbSecurityGroupMemberships() == null) {
            return false;
        }
        if (other.dbSecurityGroupMemberships() != null && !other.dbSecurityGroupMemberships().equals(this.dbSecurityGroupMemberships())) {
            return false;
        }
        if (other.vpcSecurityGroupMemberships() == null ^ this.vpcSecurityGroupMemberships() == null) {
            return false;
        }
        return other.vpcSecurityGroupMemberships() == null || other.vpcSecurityGroupMemberships().equals(this.vpcSecurityGroupMemberships());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.optionName() != null) {
            sb.append("OptionName: ").append(this.optionName()).append(",");
        }
        if (this.optionDescription() != null) {
            sb.append("OptionDescription: ").append(this.optionDescription()).append(",");
        }
        if (this.persistent() != null) {
            sb.append("Persistent: ").append(this.persistent()).append(",");
        }
        if (this.permanent() != null) {
            sb.append("Permanent: ").append(this.permanent()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.optionVersion() != null) {
            sb.append("OptionVersion: ").append(this.optionVersion()).append(",");
        }
        if (this.optionSettings() != null) {
            sb.append("OptionSettings: ").append(this.optionSettings()).append(",");
        }
        if (this.dbSecurityGroupMemberships() != null) {
            sb.append("DBSecurityGroupMemberships: ").append(this.dbSecurityGroupMemberships()).append(",");
        }
        if (this.vpcSecurityGroupMemberships() != null) {
            sb.append("VpcSecurityGroupMemberships: ").append(this.vpcSecurityGroupMemberships()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String optionName;
        private String optionDescription;
        private Boolean persistent;
        private Boolean permanent;
        private Integer port;
        private String optionVersion;
        private List<OptionSetting> optionSettings = new SdkInternalList();
        private List<DBSecurityGroupMembership> dbSecurityGroupMemberships = new SdkInternalList();
        private List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(Option model) {
            this.setOptionName(model.optionName);
            this.setOptionDescription(model.optionDescription);
            this.setPersistent(model.persistent);
            this.setPermanent(model.permanent);
            this.setPort(model.port);
            this.setOptionVersion(model.optionVersion);
            this.setOptionSettings(model.optionSettings);
            this.setDBSecurityGroupMemberships(model.dbSecurityGroupMemberships);
            this.setVpcSecurityGroupMemberships(model.vpcSecurityGroupMemberships);
        }

        public final String getOptionName() {
            return this.optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        public final String getOptionDescription() {
            return this.optionDescription;
        }

        @Override
        public final Builder optionDescription(String optionDescription) {
            this.optionDescription = optionDescription;
            return this;
        }

        public final void setOptionDescription(String optionDescription) {
            this.optionDescription = optionDescription;
        }

        public final Boolean getPersistent() {
            return this.persistent;
        }

        @Override
        public final Builder persistent(Boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public final void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        public final Boolean getPermanent() {
            return this.permanent;
        }

        @Override
        public final Builder permanent(Boolean permanent) {
            this.permanent = permanent;
            return this;
        }

        public final void setPermanent(Boolean permanent) {
            this.permanent = permanent;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getOptionVersion() {
            return this.optionVersion;
        }

        @Override
        public final Builder optionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
            return this;
        }

        public final void setOptionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
        }

        public final Collection<OptionSetting> getOptionSettings() {
            return this.optionSettings;
        }

        @Override
        public final Builder optionSettings(Collection<OptionSetting> optionSettings) {
            this.optionSettings = OptionSettingConfigurationListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(OptionSetting ... optionSettings) {
            if (this.optionSettings == null) {
                this.optionSettings = new SdkInternalList(optionSettings.length);
            }
            for (OptionSetting e : optionSettings) {
                this.optionSettings.add(e);
            }
            return this;
        }

        public final void setOptionSettings(Collection<OptionSetting> optionSettings) {
            this.optionSettings = OptionSettingConfigurationListCopier.copy(optionSettings);
        }

        @SafeVarargs
        public final void setOptionSettings(OptionSetting ... optionSettings) {
            if (this.optionSettings == null) {
                this.optionSettings = new SdkInternalList(optionSettings.length);
            }
            for (OptionSetting e : optionSettings) {
                this.optionSettings.add(e);
            }
        }

        public final Collection<DBSecurityGroupMembership> getDBSecurityGroupMemberships() {
            return this.dbSecurityGroupMemberships;
        }

        @Override
        public final Builder dbSecurityGroupMemberships(Collection<DBSecurityGroupMembership> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupMembershipListCopier.copy(dbSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroupMemberships(DBSecurityGroupMembership ... dbSecurityGroupMemberships) {
            if (this.dbSecurityGroupMemberships == null) {
                this.dbSecurityGroupMemberships = new SdkInternalList(dbSecurityGroupMemberships.length);
            }
            for (DBSecurityGroupMembership e : dbSecurityGroupMemberships) {
                this.dbSecurityGroupMemberships.add(e);
            }
            return this;
        }

        public final void setDBSecurityGroupMemberships(Collection<DBSecurityGroupMembership> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupMembershipListCopier.copy(dbSecurityGroupMemberships);
        }

        @SafeVarargs
        public final void setDBSecurityGroupMemberships(DBSecurityGroupMembership ... dbSecurityGroupMemberships) {
            if (this.dbSecurityGroupMemberships == null) {
                this.dbSecurityGroupMemberships = new SdkInternalList(dbSecurityGroupMemberships.length);
            }
            for (DBSecurityGroupMembership e : dbSecurityGroupMemberships) {
                this.dbSecurityGroupMemberships.add(e);
            }
        }

        public final Collection<VpcSecurityGroupMembership> getVpcSecurityGroupMemberships() {
            return this.vpcSecurityGroupMemberships;
        }

        @Override
        public final Builder vpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupMemberships(VpcSecurityGroupMembership ... vpcSecurityGroupMemberships) {
            if (this.vpcSecurityGroupMemberships == null) {
                this.vpcSecurityGroupMemberships = new SdkInternalList(vpcSecurityGroupMemberships.length);
            }
            for (VpcSecurityGroupMembership e : vpcSecurityGroupMemberships) {
                this.vpcSecurityGroupMemberships.add(e);
            }
            return this;
        }

        public final void setVpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroupMemberships);
        }

        @SafeVarargs
        public final void setVpcSecurityGroupMemberships(VpcSecurityGroupMembership ... vpcSecurityGroupMemberships) {
            if (this.vpcSecurityGroupMemberships == null) {
                this.vpcSecurityGroupMemberships = new SdkInternalList(vpcSecurityGroupMemberships.length);
            }
            for (VpcSecurityGroupMembership e : vpcSecurityGroupMemberships) {
                this.vpcSecurityGroupMemberships.add(e);
            }
        }

        public Option build() {
            return new Option(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Option> {
        public Builder optionName(String var1);

        public Builder optionDescription(String var1);

        public Builder persistent(Boolean var1);

        public Builder permanent(Boolean var1);

        public Builder port(Integer var1);

        public Builder optionVersion(String var1);

        public Builder optionSettings(Collection<OptionSetting> var1);

        public Builder optionSettings(OptionSetting ... var1);

        public Builder dbSecurityGroupMemberships(Collection<DBSecurityGroupMembership> var1);

        public Builder dbSecurityGroupMemberships(DBSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroupMemberships(VpcSecurityGroupMembership ... var1);
    }
}

