/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.CreateDBClusterRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateDBClusterRequestMarshaller
implements Marshaller<Request<CreateDBClusterRequest>, CreateDBClusterRequest> {
    public Request<CreateDBClusterRequest> marshall(CreateDBClusterRequest createDBClusterRequest) {
        SdkInternalList tagsList;
        SdkInternalList vpcSecurityGroupIdsList;
        if (createDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBClusterRequest, "RDSClient");
        request.addParameter("Action", "CreateDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList availabilityZonesList = (SdkInternalList)createDBClusterRequest.availabilityZones();
        if (!availabilityZonesList.isEmpty() || !availabilityZonesList.isAutoConstruct()) {
            int availabilityZonesListIndex = 1;
            for (Object availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (createDBClusterRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)createDBClusterRequest.backupRetentionPeriod()));
        }
        if (createDBClusterRequest.characterSetName() != null) {
            request.addParameter("CharacterSetName", StringUtils.fromString((String)createDBClusterRequest.characterSetName()));
        }
        if (createDBClusterRequest.databaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)createDBClusterRequest.databaseName()));
        }
        if (createDBClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)createDBClusterRequest.dbClusterIdentifier()));
        }
        if (createDBClusterRequest.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)createDBClusterRequest.dbClusterParameterGroupName()));
        }
        if (!(vpcSecurityGroupIdsList = (SdkInternalList)createDBClusterRequest.vpcSecurityGroupIds()).isEmpty() || !vpcSecurityGroupIdsList.isAutoConstruct()) {
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDBClusterRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)createDBClusterRequest.dbSubnetGroupName()));
        }
        if (createDBClusterRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createDBClusterRequest.engine()));
        }
        if (createDBClusterRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createDBClusterRequest.engineVersion()));
        }
        if (createDBClusterRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createDBClusterRequest.port()));
        }
        if (createDBClusterRequest.masterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)createDBClusterRequest.masterUsername()));
        }
        if (createDBClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)createDBClusterRequest.masterUserPassword()));
        }
        if (createDBClusterRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)createDBClusterRequest.optionGroupName()));
        }
        if (createDBClusterRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)createDBClusterRequest.preferredBackupWindow()));
        }
        if (createDBClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createDBClusterRequest.preferredMaintenanceWindow()));
        }
        if (createDBClusterRequest.replicationSourceIdentifier() != null) {
            request.addParameter("ReplicationSourceIdentifier", StringUtils.fromString((String)createDBClusterRequest.replicationSourceIdentifier()));
        }
        if (!(tagsList = (SdkInternalList)createDBClusterRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createDBClusterRequest.storageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean((Boolean)createDBClusterRequest.storageEncrypted()));
        }
        if (createDBClusterRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createDBClusterRequest.kmsKeyId()));
        }
        if (createDBClusterRequest.preSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString((String)createDBClusterRequest.preSignedUrl()));
        }
        if (createDBClusterRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)createDBClusterRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

