/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBCluster;
import software.amazon.awssdk.services.rds.model.DBClusterMember;
import software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus;
import software.amazon.awssdk.services.rds.model.DBClusterRole;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.transform.DBClusterMemberUnmarshaller;
import software.amazon.awssdk.services.rds.transform.DBClusterOptionGroupStatusUnmarshaller;
import software.amazon.awssdk.services.rds.transform.DBClusterRoleUnmarshaller;
import software.amazon.awssdk.services.rds.transform.VpcSecurityGroupMembershipUnmarshaller;

public class DBClusterUnmarshaller
implements Unmarshaller<DBCluster, StaxUnmarshallerContext> {
    private static DBClusterUnmarshaller INSTANCE;

    public DBCluster unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DBCluster.Builder dbCluster = DBCluster.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AllocatedStorage", targetDepth)) {
                    dbCluster.allocatedStorage(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AvailabilityZones", targetDepth)) {
                    dbCluster.availabilityZones(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("AvailabilityZones/AvailabilityZone", targetDepth)) {
                    dbCluster.availabilityZones(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BackupRetentionPeriod", targetDepth)) {
                    dbCluster.backupRetentionPeriod(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CharacterSetName", targetDepth)) {
                    dbCluster.characterSetName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DatabaseName", targetDepth)) {
                    dbCluster.databaseName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBClusterIdentifier", targetDepth)) {
                    dbCluster.dbClusterIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBClusterParameterGroup", targetDepth)) {
                    dbCluster.dbClusterParameterGroup(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBSubnetGroup", targetDepth)) {
                    dbCluster.dbSubnetGroup(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    dbCluster.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PercentProgress", targetDepth)) {
                    dbCluster.percentProgress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EarliestRestorableTime", targetDepth)) {
                    dbCluster.earliestRestorableTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    dbCluster.endpoint(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReaderEndpoint", targetDepth)) {
                    dbCluster.readerEndpoint(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MultiAZ", targetDepth)) {
                    dbCluster.multiAZ(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Engine", targetDepth)) {
                    dbCluster.engine(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    dbCluster.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LatestRestorableTime", targetDepth)) {
                    dbCluster.latestRestorableTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    dbCluster.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MasterUsername", targetDepth)) {
                    dbCluster.masterUsername(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBClusterOptionGroupMemberships", targetDepth)) {
                    dbCluster.dbClusterOptionGroupMemberships(new ArrayList<DBClusterOptionGroupStatus>());
                    continue;
                }
                if (context.testExpression("DBClusterOptionGroupMemberships/DBClusterOptionGroup", targetDepth)) {
                    dbCluster.dbClusterOptionGroupMemberships(DBClusterOptionGroupStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredBackupWindow", targetDepth)) {
                    dbCluster.preferredBackupWindow(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredMaintenanceWindow", targetDepth)) {
                    dbCluster.preferredMaintenanceWindow(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicationSourceIdentifier", targetDepth)) {
                    dbCluster.replicationSourceIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReadReplicaIdentifiers", targetDepth)) {
                    dbCluster.readReplicaIdentifiers(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ReadReplicaIdentifiers/ReadReplicaIdentifier", targetDepth)) {
                    dbCluster.readReplicaIdentifiers(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBClusterMembers", targetDepth)) {
                    dbCluster.dbClusterMembers(new ArrayList<DBClusterMember>());
                    continue;
                }
                if (context.testExpression("DBClusterMembers/DBClusterMember", targetDepth)) {
                    dbCluster.dbClusterMembers(DBClusterMemberUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcSecurityGroups", targetDepth)) {
                    dbCluster.vpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("VpcSecurityGroups/VpcSecurityGroupMembership", targetDepth)) {
                    dbCluster.vpcSecurityGroups(VpcSecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HostedZoneId", targetDepth)) {
                    dbCluster.hostedZoneId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageEncrypted", targetDepth)) {
                    dbCluster.storageEncrypted(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    dbCluster.kmsKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DbClusterResourceId", targetDepth)) {
                    dbCluster.dbClusterResourceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBClusterArn", targetDepth)) {
                    dbCluster.dbClusterArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AssociatedRoles", targetDepth)) {
                    dbCluster.associatedRoles(new ArrayList<DBClusterRole>());
                    continue;
                }
                if (context.testExpression("AssociatedRoles/DBClusterRole", targetDepth)) {
                    dbCluster.associatedRoles(DBClusterRoleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IAMDatabaseAuthenticationEnabled", targetDepth)) {
                    dbCluster.iamDatabaseAuthenticationEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CloneGroupId", targetDepth)) {
                    dbCluster.cloneGroupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ClusterCreateTime", targetDepth)) continue;
                dbCluster.clusterCreateTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DBCluster)dbCluster.build();
    }

    public static DBClusterUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DBClusterUnmarshaller();
        }
        return INSTANCE;
    }
}

