/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.CharacterSet;
import software.amazon.awssdk.services.rds.model.DBEngineVersion;
import software.amazon.awssdk.services.rds.model.Timezone;
import software.amazon.awssdk.services.rds.model.UpgradeTarget;
import software.amazon.awssdk.services.rds.transform.CharacterSetUnmarshaller;
import software.amazon.awssdk.services.rds.transform.TimezoneUnmarshaller;
import software.amazon.awssdk.services.rds.transform.UpgradeTargetUnmarshaller;

public class DBEngineVersionUnmarshaller
implements Unmarshaller<DBEngineVersion, StaxUnmarshallerContext> {
    private static DBEngineVersionUnmarshaller INSTANCE;

    public DBEngineVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DBEngineVersion.Builder dbEngineVersion = DBEngineVersion.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Engine", targetDepth)) {
                    dbEngineVersion.engine(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    dbEngineVersion.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBParameterGroupFamily", targetDepth)) {
                    dbEngineVersion.dbParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineDescription", targetDepth)) {
                    dbEngineVersion.dbEngineDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineVersionDescription", targetDepth)) {
                    dbEngineVersion.dbEngineVersionDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultCharacterSet", targetDepth)) {
                    dbEngineVersion.defaultCharacterSet(CharacterSetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedCharacterSets", targetDepth)) {
                    dbEngineVersion.supportedCharacterSets(new ArrayList<CharacterSet>());
                    continue;
                }
                if (context.testExpression("SupportedCharacterSets/CharacterSet", targetDepth)) {
                    dbEngineVersion.supportedCharacterSets(CharacterSetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ValidUpgradeTarget", targetDepth)) {
                    dbEngineVersion.validUpgradeTarget(new ArrayList<UpgradeTarget>());
                    continue;
                }
                if (context.testExpression("ValidUpgradeTarget/UpgradeTarget", targetDepth)) {
                    dbEngineVersion.validUpgradeTarget(UpgradeTargetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedTimezones", targetDepth)) {
                    dbEngineVersion.supportedTimezones(new ArrayList<Timezone>());
                    continue;
                }
                if (!context.testExpression("SupportedTimezones/Timezone", targetDepth)) continue;
                dbEngineVersion.supportedTimezones(TimezoneUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DBEngineVersion)dbEngineVersion.build();
    }

    public static DBEngineVersionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DBEngineVersionUnmarshaller();
        }
        return INSTANCE;
    }
}

