/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.DescribeEventsRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeEventsRequestMarshaller
implements Marshaller<Request<DescribeEventsRequest>, DescribeEventsRequest> {
    public Request<DescribeEventsRequest> marshall(DescribeEventsRequest describeEventsRequest) {
        SdkInternalList filtersList;
        SdkInternalList eventCategoriesList;
        if (describeEventsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEventsRequest, "RDSClient");
        request.addParameter("Action", "DescribeEvents");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventsRequest.sourceIdentifier() != null) {
            request.addParameter("SourceIdentifier", StringUtils.fromString((String)describeEventsRequest.sourceIdentifier()));
        }
        if (describeEventsRequest.sourceType() != null) {
            request.addParameter("SourceType", StringUtils.fromString((String)describeEventsRequest.sourceType()));
        }
        if (describeEventsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)describeEventsRequest.startTime()));
        }
        if (describeEventsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)describeEventsRequest.endTime()));
        }
        if (describeEventsRequest.duration() != null) {
            request.addParameter("Duration", StringUtils.fromInteger((Integer)describeEventsRequest.duration()));
        }
        if (!(eventCategoriesList = (SdkInternalList)describeEventsRequest.eventCategories()).isEmpty() || !eventCategoriesList.isAutoConstruct()) {
            int eventCategoriesListIndex = 1;
            for (String eventCategoriesListValue : eventCategoriesList) {
                if (eventCategoriesListValue != null) {
                    request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringUtils.fromString((String)eventCategoriesListValue));
                }
                ++eventCategoriesListIndex;
            }
        }
        if (!(filtersList = (SdkInternalList)describeEventsRequest.filters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.values()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeEventsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeEventsRequest.maxRecords()));
        }
        if (describeEventsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeEventsRequest.marker()));
        }
        return request;
    }
}

