/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeOrderableDBInstanceOptionsRequestMarshaller
implements Marshaller<Request<DescribeOrderableDBInstanceOptionsRequest>, DescribeOrderableDBInstanceOptionsRequest> {
    public Request<DescribeOrderableDBInstanceOptionsRequest> marshall(DescribeOrderableDBInstanceOptionsRequest describeOrderableDBInstanceOptionsRequest) {
        SdkInternalList filtersList;
        if (describeOrderableDBInstanceOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeOrderableDBInstanceOptionsRequest, "RDSClient");
        request.addParameter("Action", "DescribeOrderableDBInstanceOptions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOrderableDBInstanceOptionsRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.engine()));
        }
        if (describeOrderableDBInstanceOptionsRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.engineVersion()));
        }
        if (describeOrderableDBInstanceOptionsRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.dbInstanceClass()));
        }
        if (describeOrderableDBInstanceOptionsRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.licenseModel()));
        }
        if (describeOrderableDBInstanceOptionsRequest.vpc() != null) {
            request.addParameter("Vpc", StringUtils.fromBoolean((Boolean)describeOrderableDBInstanceOptionsRequest.vpc()));
        }
        if (!(filtersList = (SdkInternalList)describeOrderableDBInstanceOptionsRequest.filters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.values()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeOrderableDBInstanceOptionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeOrderableDBInstanceOptionsRequest.maxRecords()));
        }
        if (describeOrderableDBInstanceOptionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.marker()));
        }
        return request;
    }
}

