/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSourceRegionsRequestMarshaller
implements Marshaller<Request<DescribeSourceRegionsRequest>, DescribeSourceRegionsRequest> {
    public Request<DescribeSourceRegionsRequest> marshall(DescribeSourceRegionsRequest describeSourceRegionsRequest) {
        SdkInternalList filtersList;
        if (describeSourceRegionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSourceRegionsRequest, "RDSClient");
        request.addParameter("Action", "DescribeSourceRegions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSourceRegionsRequest.regionName() != null) {
            request.addParameter("RegionName", StringUtils.fromString((String)describeSourceRegionsRequest.regionName()));
        }
        if (describeSourceRegionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeSourceRegionsRequest.maxRecords()));
        }
        if (describeSourceRegionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeSourceRegionsRequest.marker()));
        }
        if (!(filtersList = (SdkInternalList)describeSourceRegionsRequest.filters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.values()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

