/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DomainMembership;

public class DomainMembershipUnmarshaller
implements Unmarshaller<DomainMembership, StaxUnmarshallerContext> {
    private static DomainMembershipUnmarshaller INSTANCE;

    public DomainMembership unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DomainMembership.Builder domainMembership = DomainMembership.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Domain", targetDepth)) {
                    domainMembership.domain(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    domainMembership.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FQDN", targetDepth)) {
                    domainMembership.fqdn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IAMRoleName", targetDepth)) continue;
                domainMembership.iamRoleName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DomainMembership)domainMembership.build();
    }

    public static DomainMembershipUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DomainMembershipUnmarshaller();
        }
        return INSTANCE;
    }
}

