/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.PendingModifiedValues;

public class PendingModifiedValuesUnmarshaller
implements Unmarshaller<PendingModifiedValues, StaxUnmarshallerContext> {
    private static PendingModifiedValuesUnmarshaller INSTANCE;

    public PendingModifiedValues unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PendingModifiedValues.Builder pendingModifiedValues = PendingModifiedValues.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DBInstanceClass", targetDepth)) {
                    pendingModifiedValues.dbInstanceClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllocatedStorage", targetDepth)) {
                    pendingModifiedValues.allocatedStorage(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MasterUserPassword", targetDepth)) {
                    pendingModifiedValues.masterUserPassword(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    pendingModifiedValues.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BackupRetentionPeriod", targetDepth)) {
                    pendingModifiedValues.backupRetentionPeriod(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MultiAZ", targetDepth)) {
                    pendingModifiedValues.multiAZ(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    pendingModifiedValues.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LicenseModel", targetDepth)) {
                    pendingModifiedValues.licenseModel(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Iops", targetDepth)) {
                    pendingModifiedValues.iops(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBInstanceIdentifier", targetDepth)) {
                    pendingModifiedValues.dbInstanceIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageType", targetDepth)) {
                    pendingModifiedValues.storageType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CACertificateIdentifier", targetDepth)) {
                    pendingModifiedValues.caCertificateIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DBSubnetGroupName", targetDepth)) continue;
                pendingModifiedValues.dbSubnetGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PendingModifiedValues)pendingModifiedValues.build();
    }

    public static PendingModifiedValuesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PendingModifiedValuesUnmarshaller();
        }
        return INSTANCE;
    }
}

