/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.RecurringCharge;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;
import software.amazon.awssdk.services.rds.transform.RecurringChargeUnmarshaller;

public class ReservedDBInstanceUnmarshaller
implements Unmarshaller<ReservedDBInstance, StaxUnmarshallerContext> {
    private static ReservedDBInstanceUnmarshaller INSTANCE;

    public ReservedDBInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ReservedDBInstance.Builder reservedDBInstance = ReservedDBInstance.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ReservedDBInstanceId", targetDepth)) {
                    reservedDBInstance.reservedDBInstanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReservedDBInstancesOfferingId", targetDepth)) {
                    reservedDBInstance.reservedDBInstancesOfferingId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBInstanceClass", targetDepth)) {
                    reservedDBInstance.dbInstanceClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StartTime", targetDepth)) {
                    reservedDBInstance.startTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Duration", targetDepth)) {
                    reservedDBInstance.duration(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FixedPrice", targetDepth)) {
                    reservedDBInstance.fixedPrice(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UsagePrice", targetDepth)) {
                    reservedDBInstance.usagePrice(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CurrencyCode", targetDepth)) {
                    reservedDBInstance.currencyCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBInstanceCount", targetDepth)) {
                    reservedDBInstance.dbInstanceCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProductDescription", targetDepth)) {
                    reservedDBInstance.productDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OfferingType", targetDepth)) {
                    reservedDBInstance.offeringType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MultiAZ", targetDepth)) {
                    reservedDBInstance.multiAZ(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("State", targetDepth)) {
                    reservedDBInstance.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RecurringCharges", targetDepth)) {
                    reservedDBInstance.recurringCharges(new ArrayList<RecurringCharge>());
                    continue;
                }
                if (context.testExpression("RecurringCharges/RecurringCharge", targetDepth)) {
                    reservedDBInstance.recurringCharges(RecurringChargeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ReservedDBInstanceArn", targetDepth)) continue;
                reservedDBInstance.reservedDBInstanceArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ReservedDBInstance)reservedDBInstance.build();
    }

    public static ReservedDBInstanceUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ReservedDBInstanceUnmarshaller();
        }
        return INSTANCE;
    }
}

