/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.RestoreDBClusterFromSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class RestoreDBClusterFromSnapshotRequestMarshaller
implements Marshaller<Request<RestoreDBClusterFromSnapshotRequest>, RestoreDBClusterFromSnapshotRequest> {
    public Request<RestoreDBClusterFromSnapshotRequest> marshall(RestoreDBClusterFromSnapshotRequest restoreDBClusterFromSnapshotRequest) {
        SdkInternalList tagsList;
        SdkInternalList vpcSecurityGroupIdsList;
        if (restoreDBClusterFromSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBClusterFromSnapshotRequest, "RDSClient");
        request.addParameter("Action", "RestoreDBClusterFromSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList availabilityZonesList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.availabilityZones();
        if (!availabilityZonesList.isEmpty() || !availabilityZonesList.isAutoConstruct()) {
            int availabilityZonesListIndex = 1;
            for (Object availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (restoreDBClusterFromSnapshotRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.dbClusterIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.snapshotIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.engine()));
        }
        if (restoreDBClusterFromSnapshotRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.engineVersion()));
        }
        if (restoreDBClusterFromSnapshotRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBClusterFromSnapshotRequest.port()));
        }
        if (restoreDBClusterFromSnapshotRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.dbSubnetGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.databaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.databaseName()));
        }
        if (restoreDBClusterFromSnapshotRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.optionGroupName()));
        }
        if (!(vpcSecurityGroupIdsList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.vpcSecurityGroupIds()).isEmpty() || !vpcSecurityGroupIdsList.isAutoConstruct()) {
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (!(tagsList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDBClusterFromSnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.kmsKeyId()));
        }
        if (restoreDBClusterFromSnapshotRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBClusterFromSnapshotRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

